/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.rsapi;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.rsapi.RSAPIEdgeElementPosition;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import java.util.ArrayList;
import java.util.List;

public class ValueSetReplicas {
    private int sourceDataItemOrdinal = -1;
    private int parentRowsetId = -1;
    private String parentName = null;
    List<IValue> groupHeaderContext = null;
    private List<RSAPIEdgeElementPosition> groupHeaders = null;
    List<IValue> groupBodyDataItemRefsContext = null;
    private List<RSAPIEdgeElementPosition> groupBodyDataItemRefs = null;
    List<IValue> groupFooterContext = null;
    private List<RSAPIEdgeElementPosition> groupFooters = null;

    public int getSourceDataItemOrdinal() {
        return this.sourceDataItemOrdinal;
    }

    public void setSourceDataItemOrdinal(int ordinal) {
        this.sourceDataItemOrdinal = ordinal;
    }

    public int getParentRowsetId() {
        return this.parentRowsetId;
    }

    public void setParentRowsetId(int aRowsetId) {
        this.parentRowsetId = aRowsetId;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String name) {
        this.parentName = name;
    }

    public List<IValue> getGroupHeaderContext() {
        return this.groupHeaderContext;
    }

    public void setGroupHeaderContext(List<IValue> aContext) {
        for (int j = 0; j < aContext.size(); ++j) {
            RSAPIEdgeRowset aRowset = (RSAPIEdgeRowset)((ContextBase)((Object)aContext.get(j))).getRowset();
            if (aRowset == null || aRowset.getRowsetId() != this.groupHeaders.get(0).getEdgeRowset().getGroupingRowset().getRowsetId()) continue;
            aContext.remove(j);
        }
        if (aContext.isEmpty()) {
            aContext = null;
        }
        this.groupHeaderContext = aContext;
    }

    public List<RSAPIEdgeElementPosition> getGroupHeaders() {
        return this.groupHeaders;
    }

    public void addGroupHeader(RSAPIEdgeElementPosition aHeader) {
        if (this.groupHeaders == null) {
            this.groupHeaders = new ArrayList<RSAPIEdgeElementPosition>();
        }
        this.addElementPositionToOrderedList(aHeader, this.groupHeaders);
    }

    public List<IValue> getGroupBodyDataItemRefsContext() {
        return this.groupBodyDataItemRefsContext;
    }

    public void setGroupBodyDataItemRefsContext(List<IValue> aContext) {
        if (aContext.isEmpty()) {
            aContext = null;
        }
        this.groupBodyDataItemRefsContext = aContext;
    }

    public List<RSAPIEdgeElementPosition> getGroupBodyDataItemRefs() {
        return this.groupBodyDataItemRefs;
    }

    public void addGroupBodyDataItemRef(RSAPIEdgeElementPosition aDataItemRef) {
        if (this.groupBodyDataItemRefs == null) {
            this.groupBodyDataItemRefs = new ArrayList<RSAPIEdgeElementPosition>();
        }
        this.addElementPositionToOrderedList(aDataItemRef, this.groupBodyDataItemRefs);
    }

    private void addElementPositionToOrderedList(RSAPIEdgeElementPosition elementPosition, List<RSAPIEdgeElementPosition> list) {
        int index;
        for (index = 0; index < list.size(); ++index) {
            RSAPIEdgeElementPosition currGroupBody = list.get(index);
            if (currGroupBody.getDataItemOrdinal() <= elementPosition.getDataItemOrdinal()) continue;
            list.add(index, elementPosition);
            if (currGroupBody.getDataItemOrdinal() <= elementPosition.getDataItemOrdinal()) break;
            list.add(index, elementPosition);
            index = -1;
            break;
        }
        if (index > -1) {
            list.add(elementPosition);
        }
    }

    public List<IValue> getGroupFooterContext() {
        return this.groupFooterContext;
    }

    public void setGroupFooterContext(List<IValue> aContext) {
        for (int j = 0; j < aContext.size(); ++j) {
            boolean singleEdgeGroup;
            RSAPIEdgeRowset aRowset = (RSAPIEdgeRowset)((ContextBase)((Object)aContext.get(j))).getRowset();
            if (aRowset == null) continue;
            boolean bl = singleEdgeGroup = aRowset.getParentRowset() == null && aRowset.getNestedRowset() == null;
            if (singleEdgeGroup || aRowset.getRowsetId() != this.groupFooters.get(0).getEdgeRowset().getGroupingRowset().getRowsetId()) continue;
            aContext.remove(j);
        }
        if (aContext.isEmpty()) {
            aContext = null;
        }
        this.groupFooterContext = aContext;
    }

    public List<RSAPIEdgeElementPosition> getGroupFooters() {
        return this.groupFooters;
    }

    public void addGroupFooter(RSAPIEdgeElementPosition aFooter) {
        if (this.groupFooters == null) {
            this.groupFooters = new ArrayList<RSAPIEdgeElementPosition>();
        }
        this.addElementPositionToOrderedList(aFooter, this.groupFooters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("parentRowsetId=");
        sb.append(this.parentRowsetId);
        sb.append(" parentName=");
        sb.append(this.getParentName());
        sb.append(" groupHeaders=");
        if (this.getGroupHeaders() == null) {
            sb.append(0);
        } else {
            sb.append(this.getGroupHeaders().size());
        }
        sb.append(" groupBody=");
        if (this.getGroupBodyDataItemRefs() == null) {
            sb.append(0);
        } else {
            sb.append(this.getGroupBodyDataItemRefs().size());
        }
        sb.append(" groupFooters=");
        if (this.getGroupFooters() == null) {
            sb.append(0);
        } else {
            sb.append(this.getGroupFooters().size());
        }
        return sb.toString();
    }
}

