/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.runtree.IMemoryAllocator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class MemoryBookKeeper
implements IMemoryAllocator {
    private static final int PERCENTAGE_OF_AVAILABLE_MEMORY = 70;
    private static final long MEMORY_CHUNK_FROM_GLOBAL = 0x200000L;
    private static final double D100 = 100.0;
    public static final long ONE_MB = 0x100000L;
    private static long mMaxAvailableMemoryGlobalHeap = 0L;
    private static long mNumTotalAllocatedGlobalHeap;
    private static boolean initialized;
    private long mMaxAvailableMemoryLocalHeap = 0L;
    private long mNumAllocatedLocalHeap = 0L;
    private static long mChunkSize;

    public static void initialize() {
        XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Memory", LogLevel.TRACE);
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        double managedPercent = (double)configuration.getLongProperty("memory.managedPercent[@value]", 70L) / 100.0;
        long absoluteMaximum = 0x100000L * configuration.getLongProperty("memory.maximum[@value]", 0L);
        mNumTotalAllocatedGlobalHeap = 0L;
        mMaxAvailableMemoryGlobalHeap = MemoryBookKeeper.calculateAvailableMemory(managedPercent, absoluteMaximum);
        mChunkSize = 0x200000L;
        initialized = true;
        Runtime rt = Runtime.getRuntime();
        logger.log(String.format("Memory initialized with available for relational %d MB,maximum available %d MB,used %d MB", mMaxAvailableMemoryGlobalHeap / 0x100000L, rt.maxMemory() / 0x100000L, (rt.totalMemory() - rt.freeMemory()) / 0x100000L));
    }

    public static void initialize(long maxAvailable, long chunkSize) {
        mNumTotalAllocatedGlobalHeap = 0L;
        mMaxAvailableMemoryGlobalHeap = maxAvailable;
        mChunkSize = chunkSize;
        initialized = true;
    }

    @Override
    public boolean allocateMemory(long numBytes, boolean forced) {
        if (this.mNumAllocatedLocalHeap + numBytes <= this.mMaxAvailableMemoryLocalHeap) {
            this.mNumAllocatedLocalHeap += numBytes;
            return true;
        }
        long numAllocatedFromGlobal = this.allocateFromGlobal(numBytes, forced);
        if (numAllocatedFromGlobal >= numBytes) {
            this.mNumAllocatedLocalHeap += numBytes;
            this.mMaxAvailableMemoryLocalHeap += numAllocatedFromGlobal;
            return true;
        }
        if (forced) {
            this.mNumAllocatedLocalHeap += numBytes;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateFromGlobal(long numBytes, boolean forced) {
        Class<MemoryBookKeeper> clazz = MemoryBookKeeper.class;
        synchronized (MemoryBookKeeper.class) {
            long maxChunkSize;
            if (!initialized) {
                MemoryBookKeeper.initialize();
            }
            if (mNumTotalAllocatedGlobalHeap + (maxChunkSize = Math.max(numBytes, mChunkSize)) <= mMaxAvailableMemoryGlobalHeap) {
                mNumTotalAllocatedGlobalHeap += maxChunkSize;
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return maxChunkSize;
            }
            if (mNumTotalAllocatedGlobalHeap + numBytes <= mMaxAvailableMemoryGlobalHeap) {
                long remainingBytes = mMaxAvailableMemoryGlobalHeap - mNumTotalAllocatedGlobalHeap;
                mNumTotalAllocatedGlobalHeap += remainingBytes;
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return remainingBytes;
            }
            if (forced) {
                mNumTotalAllocatedGlobalHeap += numBytes;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return 0L;
        }
    }

    private static long calculateAvailableMemory(double managedPercent, long absoluteMaximum) {
        if (absoluteMaximum > 0L) {
            return absoluteMaximum;
        }
        Runtime rt = Runtime.getRuntime();
        long usedMemory = rt.totalMemory() - rt.freeMemory();
        long availableMemory = rt.maxMemory() - usedMemory;
        return (long)(managedPercent * (double)availableMemory);
    }

    @Override
    public void releaseMemory(long numBytes) {
        if (numBytes >= mChunkSize) {
            long nBytesToRelease = Math.min(numBytes, this.mNumAllocatedLocalHeap);
            this.releaseMemoryToGlobal(nBytesToRelease);
            this.mNumAllocatedLocalHeap -= nBytesToRelease;
            this.mMaxAvailableMemoryLocalHeap -= nBytesToRelease;
            return;
        }
        this.mNumAllocatedLocalHeap -= numBytes;
        if (this.mNumAllocatedLocalHeap <= 0L) {
            this.releaseAllMemory();
            return;
        }
    }

    @Override
    public void releaseAllMemory() {
        this.releaseMemoryToGlobal(this.mMaxAvailableMemoryLocalHeap);
        this.mNumAllocatedLocalHeap = 0L;
        this.mMaxAvailableMemoryLocalHeap = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseMemoryToGlobal(long numBytes) {
        Class<MemoryBookKeeper> clazz = MemoryBookKeeper.class;
        synchronized (MemoryBookKeeper.class) {
            mNumTotalAllocatedGlobalHeap -= numBytes;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getAvailableMemory() {
        Class<MemoryBookKeeper> clazz = MemoryBookKeeper.class;
        synchronized (MemoryBookKeeper.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return mMaxAvailableMemoryGlobalHeap - mNumTotalAllocatedGlobalHeap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUsedMemory() {
        Class<MemoryBookKeeper> clazz = MemoryBookKeeper.class;
        synchronized (MemoryBookKeeper.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return mNumTotalAllocatedGlobalHeap;
        }
    }

    public long getLocallyAvailableMemory() {
        return this.mMaxAvailableMemoryLocalHeap;
    }

    static {
        initialized = false;
        mChunkSize = 0x200000L;
    }
}

