/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultsets.BaseScrollableIterator;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;

public class ScrollableIterator
extends BaseScrollableIterator
implements IScrollableIterator {
    public static final int STARTING_POSITION = -1;
    private ArrayList<Object> valueList = new ArrayList(1024);
    private long position = -1L;
    private IIterator input;
    private boolean bForwardonly = false;
    private Object currentObject = null;

    public ScrollableIterator(XDataContext xDataContext, IIterator tabIt, Integer theNodeId) {
        super(xDataContext, theNodeId);
        this.input = tabIt;
    }

    public ScrollableIterator(XDataContext xDataContext, IIterator tabIt, Integer theNodeId, RSAPIEdge edge) {
        this(xDataContext, tabIt, theNodeId);
        if (edge != null && edge.getDataset() != null) {
            this.bForwardonly = edge.getDataset().getOptimizeForAllRows() && !edge.getDataset().isForOLAPQuery();
        }
    }

    @Override
    public boolean hasPrevious() {
        if (this.valueList.size() == 0) {
            return false;
        }
        return this.position - 1L >= 0L;
    }

    @Override
    public boolean hasNext() {
        if (this.bForwardonly) {
            return this.input.hasNext();
        }
        return false;
    }

    @Override
    public long getIndex() {
        return this.position;
    }

    @Override
    public Object nextImpl() {
        if (this.bForwardonly) {
            IRow inputRow = (IRow)this.input.next();
            if (inputRow == null) {
                return null;
            }
            this.currentObject = inputRow instanceof RowValue ? ((RowValue)inputRow).copy(false) : inputRow.copy();
            ++this.position;
            return this.currentObject;
        }
        if (this.position + 1L >= (long)this.valueList.size()) {
            IRow inputRow = (IRow)this.input.next();
            if (inputRow == null) {
                return null;
            }
            if (inputRow instanceof RowValue) {
                this.valueList.add(((RowValue)inputRow).copy(false));
            } else {
                this.valueList.add(inputRow.copy());
            }
        } else if (this.valueList.size() == 0) {
            return null;
        }
        return this.valueList.get((int)(++this.position));
    }

    @Override
    public Object previousImpl() {
        if (this.bForwardonly) {
            return this.currentObject;
        }
        if (this.position != -1L) {
            --this.position;
        }
        if (this.position == -1L) {
            return null;
        }
        if ((int)this.position <= -1 || (int)this.position >= this.valueList.size()) {
            return null;
        }
        return this.valueList.get((int)this.position);
    }

    @Override
    public Object current() {
        if (this.bForwardonly) {
            if ((int)this.position <= -1) {
                return null;
            }
            return this.currentObject;
        }
        if ((int)this.position <= -1 || (int)this.position >= this.valueList.size()) {
            return null;
        }
        return this.valueList.get((int)this.position);
    }

    @Override
    public boolean absolute(long index) {
        if (index < -1L) {
            return false;
        }
        if (this.bForwardonly) {
            if (index <= this.getIndex()) {
                return false;
            }
        } else {
            if (index < (long)this.valueList.size()) {
                this.position = index;
                return true;
            }
            this.position = this.valueList.size() - 1;
        }
        while (this.getIndex() < index) {
            Object o = this.next();
            if (o != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        if (this.bForwardonly) {
            return;
        }
        this.position = -1L;
    }

    @Override
    public void release() {
        if (this.input != null) {
            this.input.release();
            this.input = null;
        }
    }
}

