/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.xqe.ast.macro.MacroContext;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.cache.CacheEngineFactory;
import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.util.CacheableNameValueBasedArray;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.collators.CollatorPool;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultsets.MemberProxy;
import com.cognos.xqe.runtree.IMemoryAllocator;
import com.cognos.xqe.runtree.MemoryBookKeeper;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.decoration.EdgeOrdinalMapping;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.reference.ReferenceCountedBase;
import com.google.common.hash.BloomFilter;
import com.ibm.icu.text.Collator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public final class XDataContext
extends ReferenceCountedBase
implements ICancelable {
    public static final String USE_THREADS = "useThreads";
    public static final String FORCE_DISK = "forceDisk";
    public static final String FORCE_NEW_CONNECTION = "forceNewConnection";
    public static final String PROFILE_ITERATOR = "profileIterator";
    public static final String IS_FOR_VALIDATE_MUN = "isForValidateMun";
    public static final String USE_COLUMNAR = "useColumnar";
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private final IExecutionEnvironment environment;
    private Integer nodeId = TransformationEngine.DUMMY_NODEID;
    private String modelPath;
    private String queryName;
    private Map<String, BlockingQueue<IRow>> queues;
    private Map<String, IRowsetInfo> rowsetInfoMap;
    private Map<Object, IValue> valueMap;
    private Map<Object, Object> stateObjects;
    private Map<String, BloomFilter<byte[]>> bloomFilters;
    private ICacheEngine memberStorage = null;
    private Map<Integer, ILevel> levelStorage;
    private int memberId;
    private Deque<IRow> rowList = new ArrayDeque<IRow>();
    private Parameters parameters = new Parameters();
    private IMemoryAllocator memoryResourceInfo;
    private Map<String, Object> options;
    private Map<XNode, EdgeOrdinalMapping[]> edgeCoordinateMappings;
    private Object collationKey;
    private Collator collator = null;
    private TimestampValue executionTime = DataValueFactory.createTimestampValue();
    private InterpreterContext interpreterContext;
    private MacroContext macroContext;
    private volatile boolean bCanceled = false;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private XDataContext parent;
    private boolean releaseReferenceOnParent;
    private final List<XDataContext> children = Collections.synchronizedList(new ArrayList());
    private Parameters localparameters = new Parameters();
    private static DataContextConfigOptions dcConfig = null;
    private int maxDop = 1;
    private String rsapiDatasetName = null;
    private boolean variableUsed = false;

    public static XDataContext current() {
        IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == execEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        return execEnv.getDataContext();
    }

    public XDataContext(XDataContext theParent, IExecutionEnvironment theEnvironment) {
        this.parent = theParent;
        this.releaseReferenceOnParent = false;
        if (null != this.parent) {
            this.parent.attachChild(this);
        }
        this.environment = theEnvironment;
        this.environment.getCancelManager().addCancelHandler(this);
        this.options = new HashMap<String, Object>();
        if (dcConfig == null) {
            XDataContext.createAndLoadDataContextConfig();
        }
        this.options.put(FORCE_DISK, XDataContext.dcConfig.executionOption);
        if (!XDataContext.dcConfig.rootExecution) {
            this.options.put(PROFILE_ITERATOR, XDataContext.dcConfig.rootExecution);
        } else {
            this.options.put(PROFILE_ITERATOR, XDataContext.dcConfig.iteratorProfiling);
        }
        this.options.put(USE_THREADS, XDataContext.dcConfig.parallelismEnabled);
        if (XDataContext.dcConfig.parallelismEnabled) {
            this.maxDop = XDataContext.dcConfig.maxDop;
            if (this.maxDop == 0) {
                this.maxDop = Runtime.getRuntime().availableProcessors();
            }
        }
        this.options.put(USE_COLUMNAR, false);
        this.executionTime.set(System.currentTimeMillis());
    }

    private static synchronized void createAndLoadDataContextConfig() {
        if (dcConfig != null) {
            return;
        }
        dcConfig = new DataContextConfigOptions();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        XDataContext.dcConfig.executionOption = configuration.getBooleanProperty("queryExecution.force2disk[@value]", false);
        XDataContext.dcConfig.rootExecution = configuration.getBooleanProperty("queryExecution[@traceEnabled]", false);
        XDataContext.dcConfig.iteratorProfiling = configuration.getBooleanProperty("queryExecution.iteratorProfiling[@enabled]", true);
        XDataContext.dcConfig.parallelismEnabled = configuration.getBooleanProperty("queryExecution.parallelism[@enabled]", false);
        XDataContext.dcConfig.maxDop = configuration.getIntProperty("queryExecution.parallelism.maxDop[@value]", 1);
    }

    public XDataContext getParent() {
        return this.parent;
    }

    public void attachToParentAndTakeReference(XDataContext newParent) {
        if (null != this.parent) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null != parent");
        }
        if (null == newParent) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null == newParent");
        }
        this.parent = newParent;
        this.parent.attachChild(this);
        this.parent.incrementRefCount();
        this.releaseReferenceOnParent = true;
    }

    public XDataContext[] getChildren() {
        return this.children.toArray(new XDataContext[0]);
    }

    protected void attachChild(XDataContext child) {
        this.children.add(child);
    }

    protected void detachChild(XDataContext child) {
        this.children.remove(child);
    }

    public void setNodeId(Integer id) {
        this.assertNotReleased();
        this.nodeId = id;
    }

    public Integer getNodeId() {
        this.assertNotReleased();
        return this.nodeId;
    }

    public Collator getLocalCollator() {
        this.assertNotReleased();
        if (this.collator == null) {
            try {
                this.collationKey = this.environment.getLocalCollationSequenceKey();
                this.collator = CollatorPool.borrowCollator(this.collationKey);
            }
            catch (Exception e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_LocalCollationUnknown, (Throwable)e);
            }
        }
        return this.collator;
    }

    public IExecutionEnvironment getEnvironment() {
        this.assertNotReleased();
        return this.environment;
    }

    public DateTimeValue getExecutionTime() {
        this.assertNotReleased();
        return this.executionTime;
    }

    public void setModelPath(String path) {
        this.assertNotReleased();
        this.modelPath = path;
    }

    public String getModelPath() {
        this.assertNotReleased();
        return this.modelPath;
    }

    public void setQueryName(String theQueryName) {
        this.queryName = theQueryName;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public BlockingQueue<IRow> getQueue(String queueName) {
        BlockingQueue<IRow> queue;
        this.assertNotReleased();
        if (this.queues == null) {
            this.queues = new HashMap<String, BlockingQueue<IRow>>();
        }
        if ((queue = this.queues.get(queueName)) == null) {
            queue = new LinkedBlockingQueue<IRow>();
            this.queues.put(queueName, queue);
        }
        return queue;
    }

    public void pushRow(int contextNo, IRow row) {
        this.assertNotReleased();
        this.rowList.push(row);
    }

    public IRow popRow() {
        this.assertNotReleased();
        return this.rowList.pop();
    }

    public IRow getCurrentRow() {
        this.assertNotReleased();
        return this.rowList.peek();
    }

    public void setRowsetInfo(String queueName, IRowsetInfo theRowsetInfo) {
        this.assertNotReleased();
        if (this.rowsetInfoMap == null) {
            this.rowsetInfoMap = new HashMap<String, IRowsetInfo>();
        }
        this.rowsetInfoMap.put(queueName, theRowsetInfo);
    }

    public IRowsetInfo getRowsetInfo(String queueName) {
        this.assertNotReleased();
        if (this.rowsetInfoMap == null) {
            return null;
        }
        return this.rowsetInfoMap.get(queueName);
    }

    public void setParameter(String name, Parameter parameter) {
        this.assertNotReleased();
        this.parameters.put(name, parameter);
    }

    public Parameter getParameter(String name) {
        this.assertNotReleased();
        Parameter parameter = (Parameter)this.parameters.get(name);
        if (parameter == null) {
            MultiRequestContext multiRequestContext = this.environment.getMultiRequestContext();
            Parameters userParameters = multiRequestContext.getRequestParameters().getParameters();
            parameter = (Parameter)userParameters.get(name);
        }
        return parameter;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters theParameters) {
        this.parameters = theParameters;
    }

    public IValue[] getParameterValues(String name) {
        this.assertNotReleased();
        return this.getParameter(name).getParameterValues();
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> theOptions) {
        this.options = theOptions;
    }

    public IValue setValue(Object object, IValue value) {
        this.assertNotReleased();
        if (this.valueMap == null) {
            this.valueMap = new HashMap<Object, IValue>();
        }
        this.valueMap.put(object, value);
        return value;
    }

    public IValue getValue(Object object) {
        this.assertNotReleased();
        if (this.valueMap == null) {
            return null;
        }
        return this.valueMap.get(object);
    }

    public IValue getValue(Object object, IDataType dataType) {
        this.assertNotReleased();
        IValue value = this.getValue(object);
        if (value == null) {
            value = this.setValue(object, dataType.createValue(this.getLocalCollator()));
        }
        return value;
    }

    public void removeValue(Object object) {
        this.assertNotReleased();
        if (this.valueMap != null) {
            this.valueMap.remove(object);
        }
    }

    public Object getStateObject(XNode object) {
        this.assertNotReleased();
        if (this.stateObjects == null) {
            return null;
        }
        return this.stateObjects.get(object);
    }

    public void setStateObject(XNode object, Object value) {
        this.assertNotReleased();
        if (this.stateObjects == null) {
            this.stateObjects = new Hashtable<Object, Object>();
        }
        this.stateObjects.put(object, value);
    }

    public void removeStateObject(Object object) {
        this.assertNotReleased();
        this.stateObjects.remove(object);
    }

    public BloomFilter<byte[]> getBloomFilter(String name) {
        this.assertNotReleased();
        if (this.bloomFilters == null) {
            return null;
        }
        return this.bloomFilters.get(name);
    }

    public void setBloomFilter(String name, BloomFilter<byte[]> bf) {
        this.assertNotReleased();
        if (this.bloomFilters == null) {
            this.bloomFilters = new Hashtable<String, BloomFilter<byte[]>>();
        }
        this.bloomFilters.put(name, bf);
    }

    public IMemoryAllocator getMemoryManager() {
        this.assertNotReleased();
        if (this.memoryResourceInfo == null) {
            this.memoryResourceInfo = new MemoryBookKeeper();
        }
        return this.memoryResourceInfo;
    }

    public void setProperty(String property, Object value) {
        this.assertNotReleased();
        this.options.put(property, value);
    }

    public Object getProperty(String property) {
        this.assertNotReleased();
        return this.options.get(property);
    }

    public boolean useThreads() {
        this.assertNotReleased();
        return this.evaluateOption(USE_THREADS);
    }

    public boolean force2Disk() {
        this.assertNotReleased();
        return this.evaluateOption(FORCE_DISK);
    }

    public boolean profileIterators() {
        this.assertNotReleased();
        return this.evaluateOption(PROFILE_ITERATOR);
    }

    public boolean isForValidateMUN() {
        this.assertNotReleased();
        return this.evaluateOption(IS_FOR_VALIDATE_MUN);
    }

    public void flagIsForValidateMUN() {
        this.assertNotReleased();
        this.setProperty(IS_FOR_VALIDATE_MUN, Boolean.TRUE);
    }

    private boolean evaluateOption(String optionKey) {
        this.assertNotReleased();
        Boolean value = (Boolean)this.options.get(optionKey);
        if (value == null) {
            return false;
        }
        return value;
    }

    public void setCoordinateMappings(XNode node, int edgeNumber, EdgeOrdinalMapping value) {
        this.assertNotReleased();
        if (this.edgeCoordinateMappings == null) {
            this.edgeCoordinateMappings = new HashMap<XNode, EdgeOrdinalMapping[]>();
        }
        EdgeOrdinalMapping[] mappings = this.edgeCoordinateMappings.get(node);
        mappings = this.ensureLength(mappings, edgeNumber + 1);
        this.edgeCoordinateMappings.put(node, mappings);
        mappings[edgeNumber] = value;
    }

    private EdgeOrdinalMapping[] ensureLength(EdgeOrdinalMapping[] oldMapping, int size) {
        int newSize;
        this.assertNotReleased();
        if (oldMapping == null) {
            newSize = size;
        } else {
            if (oldMapping.length >= size) {
                return oldMapping;
            }
            newSize = oldMapping.length;
            if (newSize == 0) {
                newSize = 1;
            }
            while (newSize < size) {
                newSize *= 2;
            }
        }
        EdgeOrdinalMapping[] newMapping = new EdgeOrdinalMapping[newSize];
        if (oldMapping != null) {
            System.arraycopy(oldMapping, 0, newMapping, 0, oldMapping.length);
        }
        return newMapping;
    }

    public EdgeOrdinalMapping getCoordinateMappings(XNode node, int edgeNumber) {
        EdgeOrdinalMapping mapping;
        this.assertNotReleased();
        if (this.edgeCoordinateMappings == null) {
            return null;
        }
        EdgeOrdinalMapping[] mappings = null;
        if (node != null) {
            mappings = this.edgeCoordinateMappings.get(node);
        } else {
            Set<XNode> keySet = this.edgeCoordinateMappings.keySet();
            if (keySet.size() == 1) {
                mappings = this.edgeCoordinateMappings.get(keySet.iterator().next());
            }
        }
        if (mappings == null) {
            return null;
        }
        if (mappings.length > edgeNumber && (mapping = mappings[edgeNumber]) != null) {
            return mapping;
        }
        XNode childNode = null;
        if (node != null) {
            childNode = (XNode)node.getChild(0);
        }
        if (node == null || childNode == null || !childNode.isDecorationNode()) {
            return null;
        }
        return this.getCoordinateMappings(childNode, edgeNumber);
    }

    public InterpreterContext getInterpreterContext() {
        this.assertNotReleased();
        return this.interpreterContext;
    }

    public void setInterpreterContext(InterpreterContext context) {
        this.assertNotReleased();
        this.interpreterContext = context;
    }

    public MacroContext getMacroContext() {
        this.assertNotReleased();
        return this.macroContext;
    }

    public void setMacroContext(MacroContext context) {
        this.assertNotReleased();
        this.macroContext = context;
    }

    public MetadataCacheKey cacheMember(IMember member, String propertyName) {
        Value bk;
        this.assertNotReleased();
        if (this.memberStorage == null) {
            this.memberStorage = CacheEngineFactory.createStaticCache();
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("MEMBER_NAME", member.getName());
        props.put("MEMBER_CAPTION", member.getCaptionValue().getString());
        props.put("MEMBER_UNIQUE_NAME", member.getUniqueName());
        props.put("PARENT_UNIQUE_NAME", member.getParentUniqueName());
        if (propertyName != null) {
            props.put(propertyName, member.getProperty(propertyName));
        }
        if ((bk = member.getBusinessKeyValue()) != null && !(member instanceof MemberProxy)) {
            ArrayList<String> parts = new ArrayList<String>();
            for (IMember current = member; current != null; current = current.getParent()) {
                bk = current.getBusinessKeyValue();
                if (bk == null) {
                    parts.add(0, "");
                    continue;
                }
                parts.add(0, bk.toString());
            }
            String[] nameParts = new String[parts.size()];
            parts.toArray(nameParts);
            bk = DataValueFactory.createStringValue();
            bk.set(UniqueNameGenerator.createUniqueName(nameParts));
        }
        if (bk != null) {
            props.put("BK", bk);
        }
        IDimension dimension = member.getDimension();
        ICube cube = dimension.getCube();
        MetadataCacheKey memKey = new MetadataCacheKey(cube.getDimensionIndex(dimension), this.memberId++);
        CacheableNameValueBasedArray cachedMemberContent = new CacheableNameValueBasedArray(memKey, props);
        try {
            this.memberStorage.cacheObject(cachedMemberContent);
        }
        catch (CacheException e) {
            throw new XQERuntimeException(e);
        }
        return memKey;
    }

    public int cacheLevel(ILevel level) {
        this.assertNotReleased();
        if (this.levelStorage == null) {
            this.levelStorage = new Hashtable<Integer, ILevel>();
        }
        int index = 0;
        if (!this.levelStorage.containsValue(level)) {
            index = this.levelStorage.size();
            this.levelStorage.put(index, level);
        } else {
            Set<Map.Entry<Integer, ILevel>> levelSet = this.levelStorage.entrySet();
            for (Map.Entry<Integer, ILevel> entry : levelSet) {
                if (entry.getValue() != level) continue;
                index = entry.getKey();
                break;
            }
        }
        return index;
    }

    public Map<String, Object> getCachedMemberProperties(ICacheKey key) throws CacheException {
        this.assertNotReleased();
        ICacheableNameValueBasedContent cachedMemberContent = (ICacheableNameValueBasedContent)this.memberStorage.get(key);
        return cachedMemberContent.getContent();
    }

    public ILevel getLevel(int levelIndex) {
        this.assertNotReleased();
        return this.levelStorage.get(levelIndex);
    }

    public boolean isCanceled() {
        return this.bCanceled;
    }

    public void setCanceled(boolean cancelled) {
        this.bCanceled = cancelled;
    }

    @Override
    public void cancel() {
        this.setCanceled(true);
    }

    @Override
    public void cancel(CancelRequestSourceEnum cancelSource) {
        throw new CancelUnsuccessfulException();
    }

    public CancelRequestSourceEnum getCancelSource() {
        CancelRequestSourceEnum cancelSource = null;
        CancelManager cancelManager = this.environment.getCancelManager();
        if (cancelManager != null) {
            cancelSource = cancelManager.getCancelSource();
        }
        return cancelSource;
    }

    public XQETrace getTrace() {
        this.assertNotReleased();
        return this.environment.getTrace();
    }

    public int getMaxDop() {
        return this.maxDop;
    }

    private void release() {
        if (this.getRefCount() == 0 && this.released.compareAndSet(false, true)) {
            try {
                XDataContext[] allChildren;
                for (XDataContext child : allChildren = this.children.toArray(new XDataContext[0])) {
                    child.release();
                }
                this.children.clear();
                if (null != this.collator) {
                    CollatorPool.returnCollator(this.collationKey, this.collator);
                }
                if (null != this.edgeCoordinateMappings) {
                    this.edgeCoordinateMappings.clear();
                    this.edgeCoordinateMappings = null;
                }
                if (null != this.levelStorage) {
                    this.levelStorage.clear();
                    this.levelStorage = null;
                }
                if (null != this.queues) {
                    this.queues.clear();
                    this.queues = null;
                }
                if (null != this.rowsetInfoMap) {
                    this.rowsetInfoMap.clear();
                    this.rowsetInfoMap = null;
                }
                if (null != this.stateObjects) {
                    this.stateObjects.clear();
                    this.stateObjects = null;
                }
                if (null != this.valueMap) {
                    this.valueMap.clear();
                    this.valueMap = null;
                }
                if (null != this.macroContext) {
                    this.macroContext.release();
                    this.macroContext = null;
                }
                this.environment.getCancelManager().removeCancelHandler(this);
                if (this.memoryResourceInfo != null) {
                    this.memoryResourceInfo.releaseAllMemory();
                    this.memoryResourceInfo = null;
                }
                if (null != this.parent) {
                    this.parent.detachChild(this);
                    if (this.releaseReferenceOnParent) {
                        this.parent.decrementRefCount();
                        this.releaseReferenceOnParent = false;
                    }
                    this.parent = null;
                }
            }
            catch (Exception ex) {
                ERROR_LOGGER.log(ex);
            }
        }
    }

    public XDataContext createSubContext(IExecutionEnvironment execEnv) {
        this.assertNotReleased();
        XDataContext ctx = new XDataContext(this, execEnv);
        ctx.nodeId = this.nodeId;
        ctx.executionTime = this.executionTime;
        ctx.modelPath = this.modelPath;
        ctx.options = new HashMap<String, Object>(this.options);
        ctx.parameters = this.parameters;
        return ctx;
    }

    @Override
    public void onDecrementRefCount(int newRefCount) {
        if (0 == newRefCount) {
            this.release();
        }
    }

    @Override
    public void onIncrementRefCount(int newRefCount) {
        this.assertNotReleased();
    }

    protected void assertNotReleased() {
        if (this.released.get()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ResourceWasReleased);
        }
    }

    public void setLocalParameter(String name, Parameter parameter) {
        this.assertNotReleased();
        this.localparameters.put(name, parameter);
    }

    public Parameters getLocalParameters() {
        return this.localparameters;
    }

    public boolean isColumnar() {
        return (Boolean)this.getProperty(USE_COLUMNAR);
    }

    public boolean getVariableUsed() {
        return this.variableUsed;
    }

    public void setVariableUsed(boolean value) {
        this.variableUsed = value;
    }

    public String getRsapiDatasetName() {
        if (this.rsapiDatasetName == null && this.getParent() != null) {
            return this.getParent().getRsapiDatasetName();
        }
        return this.rsapiDatasetName;
    }

    public void setRsapiDatasetName(String datasetName) {
        this.rsapiDatasetName = datasetName;
    }

    private static class DataContextConfigOptions {
        boolean executionOption = false;
        boolean rootExecution = false;
        boolean parallelismEnabled = false;
        int maxDop = 0;
        boolean iteratorProfiling = false;

        private DataContextConfigOptions() {
        }
    }
}

