/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.runtree.MaxRowsLimitExceededException;
import com.cognos.xqe.runtree.MaxRowsLocalProcessingLimitExceededException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;

public abstract class XTabularIterator
extends XIterator
implements ITabularIterator {
    public static final String IBMCOGNOS_FLINTMAXROWSRETRIEVED = "ibmcognos.flint.maxRowsRetrieved";
    protected int nRows;
    protected long maxRowsRetrievedLimit = 0L;
    protected long maxRowsLocalProcessing = 0L;

    public XTabularIterator(XDataContext theContext, Integer id) {
        super(theContext, id);
    }

    public long getRowCount() {
        return this.nRows;
    }

    public ITabularIterator getTabularIterator() {
        return this;
    }

    public IScrollableIterator getScrollableTabularIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object nextBatch() {
        throw new UnsupportedOperationException();
    }

    public Object getVectorizationContext() {
        return null;
    }

    public void throwExceptionIfMaxRowsLimitReached() {
        if (this.maxRowsRetrievedLimit > 0L && (long)this.nRows >= this.maxRowsRetrievedLimit) {
            throw new MaxRowsLimitExceededException(this.maxRowsRetrievedLimit);
        }
    }

    public void setMaxRowsRetrievedLimit(long limit) {
        this.maxRowsRetrievedLimit = limit;
    }

    public void throwExceptionIfMaxRowsLocalProcessingLimitReached() {
        if (this.maxRowsLocalProcessing > 0L && this.context.getEnvironment().incrementAndGetMaxRowsLocalProcessing() > this.maxRowsLocalProcessing) {
            throw new MaxRowsLocalProcessingLimitExceededException(this.maxRowsLocalProcessing);
        }
    }

    public void setMaxRowsLocalProcessing(long limit) {
        this.maxRowsLocalProcessing = limit;
    }
}

