/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.runtree.IXExpression;
import com.cognos.xqe.runtree.IXRunnableTree;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XTree
extends XNode
implements IXRunnableTree,
IXExpression {
    private static final long serialVersionUID = 23472835723L;
    private static final String ATTRIBUTE_CONTEXTNO = "contextNo";
    private static final String ATTRIBUTE_MODELPATH = "modelPath";
    private String modelPath;

    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        return ((IExecutable)((Object)this.getChild(0))).execute(context);
    }

    @Override
    public void close(XDataContext context) {
    }

    @Override
    public boolean hasDQPostProcessing() {
        IXQEQueryNode child = this.getChild(0);
        while (child.getType() == 501043) {
            child = child.getChild(0);
        }
        return child.getType() != 501013;
    }

    @Override
    public IValue getJDBCTabularResultSet(XDataContext context) {
        IXQEQueryNode child = this.getChild(0);
        while (child.getType() == 501043) {
            child = child.getChild(0);
        }
        if (child.getType() == 501013) {
            return ((XSql)child).getJDBCTabularResultSet(context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RSAPIResultSet execute(XDataContext context, RSAPIDataset dataset) throws XQERuntimeException {
        RSAPIResultSet result = null;
        boolean needToRemoveCubeName = false;
        try {
            needToRemoveCubeName = ROLAPContext.setCurrentCubeName(this.getPlanningEnvironment());
            IHybridResultSet hResult = (IHybridResultSet)this.execute(context);
            if (hResult != null) {
                result = new RSAPIResultSet(dataset, context, hResult);
            }
            RSAPIResultSet rSAPIResultSet = result;
            return rSAPIResultSet;
        }
        finally {
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
        }
    }

    @Override
    public int getContextNo() {
        return this.contextNo;
    }

    @Override
    public void setContextNo(int theContextNo) {
        this.contextNo = theContextNo;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String theModelPath) {
        this.modelPath = theModelPath;
    }

    @Override
    public int getType() {
        return 501021;
    }

    @Override
    public IDataType getDataType() {
        return DataTypeFactory.getMultisetType();
    }

    @Override
    public IDataType getDataType(IRowsetInfo rowsetInfo, int index) {
        return DataTypeFactory.getMultisetType(rowsetInfo.getDataType());
    }

    @Override
    public String getName(IRowsetInfo rowsetInfo, int index) {
        return "Multiset" + index;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_MODELPATH, this.modelPath);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        Attribute contextNo = inputNode.attribute(ATTRIBUTE_CONTEXTNO);
        if (contextNo != null) {
            this.setContextNo(Integer.valueOf(contextNo.getValue()));
        }
        this.modelPath = inputNode.attributeValue(ATTRIBUTE_MODELPATH);
        ((RequestEnvironment)env.getRequestEnvironment()).setModelPath(this.modelPath);
        if (env.getMetadataConnection() == null && this.modelPath != null) {
            env.setMetdataConnection(MetadataService.getInstance().getConnection("MFW4J", this.modelPath, (IExecutionEnvironment)env.getExecutionEnvironment(), true));
        }
        super.capture(env, inputNode);
    }

    @Override
    public long getTotalElapsedTime() {
        return ((XNode)this.getChild(0)).getTotalElapsedTime();
    }

    @Override
    public long getOwnElapsedTime() {
        return 0L;
    }

    @Override
    public long getTotalCPUTime() {
        return ((XNode)this.getChild(0)).getTotalCPUTime();
    }

    @Override
    public long getOwnCPUTime() {
        return 0L;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_MODELPATH, this.modelPath);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_MODELPATH)) {
            Object val = ctx.attributeValue(att);
            this.modelPath = (String)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }
}

