/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.ma;

import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.ma4j.utilities.MADOMResponseBuilder;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.ma.XMANode;
import com.cognos.xqe.runtree.olap.OLAPXNodeRuntimeException;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import org.dom4j.Element;

public class XMAAction
extends XMANode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_CATALOG = "catalog";
    private String catalog;
    private IRestrictions restrictions = null;

    @Override
    public int getType() {
        return 501107;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue executeImpl(XDataContext context) {
        if (this.restrictions == null) {
            XMAAction validateNode = this;
            int nodeID = ((XQEBaseQueryNode)validateNode).isValidPlannedQuery();
            throw new XQERuntimeException(XQEMessageKeys.PLN_MAQueryFailed, Integer.toString(nodeID));
        }
        ExecutionEnvironment exeEnvironment = (ExecutionEnvironment)context.getEnvironment();
        context.setNodeId(this.getId());
        MADOMResponseBuilder mIdDOMResponseBuilder = new MADOMResponseBuilder();
        mIdDOMResponseBuilder.buildResponseDOM();
        mIdDOMResponseBuilder.buildResponseHeader();
        Element responseRootElem = mIdDOMResponseBuilder.getResponseRoot();
        this.setResponseElement(responseRootElem);
        MetadataQueryArguments arguments = new MetadataQueryArguments(this.getDataSource(), exeEnvironment, null);
        IOLAPDataProvider provider = ProviderManager.getInstance().getOLAPProvider(this.getDataSource().getType());
        if (provider == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, this.getDataSource().getType());
        }
        List<ActionRecord> actions = null;
        IOLAPMetadataProvider metadataProvider = provider.getMetadataProvider(arguments);
        try {
            actions = metadataProvider.getActions(this.restrictions);
        }
        finally {
            metadataProvider.release();
        }
        return this.constructResponse(actions);
    }

    public IValue constructResponse(List<ActionRecord> actions) {
        XmlValue xmlResult = DataValueFactory.createXmlValue();
        xmlResult.setNull();
        Element responseElem = this.getResponseElement().getDocument().getRootElement();
        this.toMAResponse(actions);
        xmlResult.set(responseElem.asXML());
        return xmlResult;
    }

    public void toMAResponse(List<ActionRecord> actions) {
        Element responseElem = this.getResponseElement();
        for (ActionRecord action : actions) {
            Element entityElem = responseElem.addElement("entity");
            entityElem.addAttribute(MAActionPropertiesEnum.NAME.getPropertyName(), action.getName());
            entityElem.addAttribute(MAActionPropertiesEnum.COMMAND_TYPE.getPropertyName(), action.getCommandType().toMDDSType());
            entityElem.addAttribute(MAActionPropertiesEnum.COMMAND.getPropertyName(), action.getCommand());
            entityElem.addAttribute(MAActionPropertiesEnum.DESCRIPTION.getPropertyName(), action.getDescription());
            entityElem.addAttribute(MAActionPropertiesEnum.COORDINATE_TYPE.getPropertyName(), action.getCoordinateType().toMDDSType());
        }
    }

    public void capture(PlanningEnvironment env, Element inputNode, ICube theCube, MetadataRestriction memberRestrictions) {
        this.catalog = inputNode.attributeValue(ATTRIBUTE_CATALOG);
        String dataSourceName = inputNode.attributeValue("dataSource");
        IDataSource dataSource = ((ExecutionEnvironment)env.getExecutionEnvironment()).getDataSourceByModelName(dataSourceName);
        this.setDataSource(dataSource);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataSource", this.getDataSource().getCMDataSourceName());
        trace.attribute(ATTRIBUTE_CATALOG, this.catalog);
        trace.attribute("dataSourceType", this.getDataSource().getType());
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String theCatalog) {
        this.catalog = theCatalog;
    }

    public IRestrictions getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(IRestrictions theRestrictions) {
        this.restrictions = theRestrictions;
    }

    public static enum MAActionPropertiesEnum {
        NAME("Name"),
        COMMAND_TYPE("CommandType"),
        COMMAND("Command"),
        DESCRIPTION("Description"),
        COORDINATE_TYPE("CoordinateType"),
        COORDINATE_VALUE("CoordinateValue");

        private String propertyString;

        private MAActionPropertiesEnum() {
            this("");
        }

        private MAActionPropertiesEnum(String propertyName) {
            this.propertyString = propertyName;
        }

        public String getPropertyName() {
            return this.propertyString;
        }
    }
}

