/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.XmlValue;
import com.cognos.xqe.ma4j.framework.MAXQEBridge;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.ma.XMANode;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class XMAQuery
extends XMANode {
    private static final long serialVersionUID = 1L;
    private String authoringLocale = "en";
    private String member = "member";
    private int depth = 0;
    private String startAt = "";
    private String startAtRef = "";
    private String enumLabels = null;
    private String generateV5 = null;
    private String hasMultiPaths = "false";
    public static final String QUERYHINT_PROPERTIES_SET = "queryHintProperties";
    public static final String INTERNAL_PROPERTIES_SET = "internalProperties";

    @Override
    public int getType() {
        return 501119;
    }

    public void setAuthoringLocale(String anauthoringLocale) {
        this.authoringLocale = anauthoringLocale;
    }

    public String getAuthoringLocale() {
        return this.authoringLocale;
    }

    public void setDepth(int querydepth) {
        this.depth = querydepth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setStartAt(String queryStartsAt) {
        this.startAt = queryStartsAt;
    }

    public String getStartAt() {
        return this.startAt;
    }

    public String getStartAtRef() {
        return this.startAtRef;
    }

    public void setStartAtRef(String startAtReference) {
        this.startAtRef = startAtReference;
    }

    public String getEnumLabels() {
        return this.enumLabels;
    }

    public void setEnumLabels(String enumLabs) {
        this.enumLabels = enumLabs;
    }

    public String getGenerateV5() {
        return this.generateV5;
    }

    public void setGenerateV5(String attrGenerateV5) {
        this.generateV5 = attrGenerateV5;
    }

    public String getMultiplePathsFlag() {
        return this.hasMultiPaths;
    }

    public void setMultiplePathsFlag(String hasPaths) {
        this.hasMultiPaths = hasPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IValue executeImpl(XDataContext context) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQExecuteRuntree", this.getNodeTypeName(), ZipiContext.getQRDName());
        try {
            IValue iValue = this.tryToExecute(context);
            return iValue;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    private IValue tryToExecute(XDataContext context) {
        boolean processMembers;
        Element responseRootElement;
        XmlValue result = DataValueFactory.createXmlValue();
        result.setNull();
        MAXQEBridge maBridge = new MAXQEBridge(this, context);
        Document responseDoc = maBridge.processQuery();
        Element startingElement = null;
        Element responseElem = responseDoc.getRootElement();
        if (responseElem != null && (responseRootElement = responseElem.element("ResponseRoot")) != null) {
            String startingPoint = maBridge.getStartAtRef();
            if (startingPoint == null) {
                if (this.getType() != 501118) {
                    startingElement = responseRootElement.addElement("folder");
                    this.setResponseElement(startingElement);
                }
            } else {
                List elements = responseRootElement.elements();
                Iterator it = elements.iterator();
                if (it.hasNext()) {
                    startingElement = (Element)it.next();
                    this.setResponseElement(startingElement);
                } else {
                    this.setResponseElement(responseRootElement);
                }
            }
        }
        if (processMembers = this.skipMemberProcessing(maBridge)) {
            ArrayList<IValue> responses = new ArrayList<IValue>();
            IXQEQueryNode[] children = this.getChildren();
            for (IXQEQueryNode child : children) {
                IValue response = ((XNode)child).execute(context);
                responses.add(response);
            }
            String startAtPath = maBridge.getStartAtRef();
            if (startAtPath != null) {
                if (startingElement == null) {
                    Element responseRootElement2;
                    startingElement = responseRootElement2 = responseElem.element("ResponseRoot");
                }
                this.processMemberNode(startingElement);
            }
        }
        result.set((Node)responseDoc.getRootElement());
        return result;
    }

    private void processMemberNode(Element node) {
        List membersElements = node.elements(this.member);
        for (Element memberElement : membersElements) {
            String memberUName = memberElement.attributeValue("memberUniqueName");
            if (memberUName != null && memberUName.length() > 0) {
                memberElement.addAttribute("_ref", memberUName);
                int index = memberUName.lastIndexOf("->");
                if (index > 0) {
                    memberElement.addAttribute("_path", memberUName);
                }
            }
            this.processMemberNode(memberElement);
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("authoringLocale", this.getAuthoringLocale());
        trace.attribute("Depth", this.getDepth());
        trace.attribute("start_at", this.getStartAt());
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        String attrValue = inputNode.attributeValue("authoringLocale");
        if (attrValue != null) {
            this.authoringLocale = attrValue;
        }
        if ((attrValue = inputNode.attributeValue("Depth")) != null && attrValue.length() > 0) {
            this.depth = Integer.parseInt(attrValue);
        }
        if ((attrValue = inputNode.attributeValue("start_at")) != null) {
            this.startAt = attrValue;
        }
        if ((attrValue = inputNode.attributeValue("start_atRef")) != null) {
            this.startAtRef = attrValue;
        }
        if ((attrValue = inputNode.attributeValue("_enumLabels")) != null) {
            this.enumLabels = attrValue;
        }
        if ((attrValue = inputNode.attributeValue("GenerateV5")) != null) {
            this.generateV5 = attrValue;
        }
        super.capture(env, inputNode);
    }

    public void addQueryHintProperty(String name) {
        HashSet<String> queryHints = (HashSet<String>)this.getPropertyValue(QUERYHINT_PROPERTIES_SET);
        if (null == queryHints) {
            queryHints = new HashSet<String>();
            this.setPropertyValue(QUERYHINT_PROPERTIES_SET, queryHints);
        }
        queryHints.add(name);
    }

    public Set<String> getQueryHintProperties() {
        return (Set)this.getPropertyValue(QUERYHINT_PROPERTIES_SET);
    }

    public void addInternalProperty(String name) {
        HashSet<String> internalProperties = (HashSet<String>)this.getPropertyValue(INTERNAL_PROPERTIES_SET);
        if (null == internalProperties) {
            internalProperties = new HashSet<String>();
            this.setPropertyValue(INTERNAL_PROPERTIES_SET, internalProperties);
        }
        internalProperties.add(name);
    }

    public Set<String> getInternalProperties() {
        return (Set)this.getPropertyValue(INTERNAL_PROPERTIES_SET);
    }

    private boolean skipMemberProcessing(MAXQEBridge maBridge) {
        String startElementType = maBridge.getStartingElementType();
        if (startElementType != null) {
            return startElementType.equals("dimension") || startElementType.equals("hierarchy") || startElementType.equals("level");
        }
        return true;
    }
}

