/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.ma.member.response;

import com.cognos.xqe.ast.ma.MARequestedPropertiesEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.IVirtualDimension;
import com.cognos.xqe.runtree.ma.member.response.XMAGenerateMemberResponse;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.Set;
import org.dom4j.Element;

public class XMASAPVariableResponse
extends XMAGenerateMemberResponse {
    private static final long serialVersionUID = 1L;
    public static final String PROP_IS_SAP_VARIABLE = "sapVariable";
    public static final String PROP_SAP_VARIABLE_NAME = "variableName";
    public static final String PROP_SAVED_HIERARCHY_MUN = "hierMUN";
    public static final String PROP_IS_SAP_HIERARCHY_VARIABLE = "sapHierarchyVariable";
    private Boolean showKeyAndCaption = null;

    @Override
    protected Element toMAResponse(Element parentElement, IMember member) {
        Element memberElement = null;
        if (((Boolean)this.getPropertyValue(PROP_IS_SAP_HIERARCHY_VARIABLE)).booleanValue()) {
            String savedHierMun = (String)this.getPropertyValue(PROP_SAVED_HIERARCHY_MUN);
            memberElement = this.toHierarchyVariableResponse(parentElement, member, savedHierMun);
        } else {
            memberElement = super.toMAResponse(parentElement, member);
            if (memberElement.attributeValue(MARequestedPropertiesEnum.CAPTION.getPropertyName()) != null && this.shouldShowKeyAndCaption()) {
                String key = UniqueNameGenerator.getSAPBusinessKeyFromMUN(member.getUniqueName());
                StringBuilder builder = new StringBuilder(member.getCaption());
                builder.append(" (");
                builder.append(key);
                builder.append(")");
                memberElement.addAttribute(MARequestedPropertiesEnum.CAPTION.getPropertyName(), builder.toString());
            }
            if (((Boolean)this.getPropertyValue(PROP_IS_SAP_VARIABLE)).booleanValue() && memberElement.attributeValue(MARequestedPropertiesEnum.MEMBER_UNIQUE_NAME.getPropertyName()) != null) {
                String mun = null;
                IDimension dimension = member.getDimension();
                mun = dimension != null && dimension instanceof IVirtualDimension ? member.getUniqueName() : (member.getLevel() != null ? UniqueNameGenerator.createMemberV5UniqueName(member.getLevel(), member.getUniqueName()) : UniqueNameGenerator.createMemberV5UniqueName(member.getHierarchy(), member.getUniqueName()));
                if (mun != null) {
                    memberElement.addAttribute(MARequestedPropertiesEnum.MEMBER_UNIQUE_NAME.getPropertyName(), mun);
                }
            }
        }
        return memberElement;
    }

    private boolean shouldShowKeyAndCaption() {
        if (this.showKeyAndCaption == null) {
            ICube theCube;
            this.showKeyAndCaption = false;
            String variableName = (String)this.getPropertyValue(PROP_SAP_VARIABLE_NAME);
            if (variableName == null || variableName.length() == 0) {
                return false;
            }
            int index = variableName.lastIndexOf(".");
            if (index > -1) {
                variableName = variableName.substring(index + 1);
            }
            if ((theCube = this.getCube()) == null) {
                return false;
            }
            for (IVariable variable : theCube.getVariables()) {
                if (!variable.getUniqueName().equals(variableName)) continue;
                this.showKeyAndCaption = variable.showKeyAndCaption();
                break;
            }
        }
        return this.showKeyAndCaption;
    }

    @Override
    protected String getMUN(IMember member) {
        if (((Boolean)this.getPropertyValue(PROP_IS_SAP_VARIABLE)).booleanValue()) {
            return UniqueNameGenerator.createMemberV5UniqueName(member.getHierarchy(), member.getUniqueName());
        }
        return super.getMUN(member);
    }

    @Override
    public int getType() {
        return 501147;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(PROP_IS_SAP_VARIABLE, this.getPropertyValue(PROP_IS_SAP_VARIABLE));
        trace.attribute(PROP_SAP_VARIABLE_NAME, this.getPropertyValue(PROP_SAP_VARIABLE_NAME));
        trace.attribute("keyDate", this.getPropertyValue("keyDate"));
    }

    protected Element toHierarchyVariableResponse(Element parentElement, IMember member, String savedHierMun) {
        String hierMun;
        IHierarchy hierarchy;
        Set<MARequestedPropertiesEnum> memberProperties;
        Element element = parentElement.addElement(MARequestedPropertiesEnum.MEMBER.getPropertyName());
        String dimensionUName = member.getParentUniqueName();
        IDimension dimension = this.getDimension(dimensionUName);
        if (dimension != null) {
            element.addAttribute(MARequestedPropertiesEnum.DIMENSION_UNIQUE_NAME.getPropertyName(), dimension.getV5UniqueName());
        }
        if ((memberProperties = this.getMemberProperties()).contains((Object)MARequestedPropertiesEnum.CAPTION)) {
            element.addAttribute(MARequestedPropertiesEnum.CAPTION.getPropertyName(), member.getCaption());
        }
        if (memberProperties.contains((Object)MARequestedPropertiesEnum.MEMBER_UNIQUE_NAME) && (hierarchy = this.getHierarchy(dimensionUName, hierMun = member.getUniqueName())) != null) {
            element.addAttribute(MARequestedPropertiesEnum.MEMBER_UNIQUE_NAME.getPropertyName(), hierarchy.getV5UniqueName());
            if (savedHierMun != null && savedHierMun.equals(hierMun)) {
                element.addAttribute(MARequestedPropertiesEnum.IS_SAVED_HIERARCHY.getPropertyName(), "true");
            }
        }
        if (memberProperties.contains((Object)MARequestedPropertiesEnum.MEMBER_NAME)) {
            element.addAttribute(MARequestedPropertiesEnum.MEMBER_NAME.getPropertyName(), member.getName());
        }
        return element;
    }
}

