/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.decoration;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.checksum.ICheckSum;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIDatasetContext;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.decoration.INestable;
import com.cognos.xqe.runtree.olap.decoration.OLAPDecorationRuleCheckSum;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.io.StringWriter;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class AbstractOLAPDecorationRules
implements INestable,
IXQEPersist {
    private static String openingParenthesis = "(";
    private static String closingParenthesis = ")";
    Integer id;
    private RSAPIEdgeRowset mRowset;
    private int mDataItemIndex = -1;
    protected IHierarchy hierarchy;
    private XNode owner = null;
    boolean isNestingSameHierEmptySet;

    public RSAPIEdgeRowset getRowset() {
        return this.mRowset;
    }

    public void setRowset(RSAPIEdgeRowset rowset) {
        this.mRowset = rowset;
    }

    public void setDataItemIndex(int index) {
        this.mDataItemIndex = index;
    }

    public void setRowset(RSAPIEdgeRowset rowset, RSAPIDataItem dataItem) {
        this.setRowset(rowset);
        this.mDataItemIndex = this.mRowset.getDataItemOrdinal(dataItem);
    }

    public int getDataItemIndex() {
        return this.mDataItemIndex;
    }

    public void capture(PlanningEnvironment env, Element inputNode, int edgeOrdinal) {
        Attribute attribute = inputNode.attribute("ruleId");
        if (attribute != null) {
            this.id = Integer.parseInt(attribute.getValue());
        }
        int rowsetEdgeOrdinal = edgeOrdinal;
        attribute = inputNode.attribute("rowsetEdgeOrdinal");
        if (attribute != null) {
            rowsetEdgeOrdinal = Integer.parseInt(attribute.getValue());
        }
        if ((attribute = inputNode.attribute("rowsetId")) != null) {
            RSAPIEdgeRowset rowset = AbstractOLAPDecorationRules.getRowset(attribute.getStringValue(), rowsetEdgeOrdinal);
            this.setRowset(rowset);
        }
        if ((attribute = inputNode.attribute("dataItemIndex")) != null) {
            this.setDataItemIndex(Integer.parseInt(attribute.getValue()));
        }
        List childList = inputNode.elements();
        for (int i = 0; i < childList.size(); ++i) {
            Element child = (Element)childList.get(i);
            if (!"OLAPAssociatedDataItem".equals(child.getName()) || (attribute = child.attribute("rowsetId")) == null) continue;
            int n = Integer.parseInt(attribute.getValue());
        }
    }

    protected static RSAPIEdgeRowset getRowset(String rowsetId, int edgeOrdinal) {
        RSAPIEdgeRowset rowset;
        Integer rowsetIdAsInteger = new Integer(rowsetId);
        RSAPIDataset dataset = RSAPIDatasetContext.getDataset();
        if (dataset == null) {
            rowset = new RSAPIEdgeRowset();
            rowset.setRowsetId(rowsetIdAsInteger);
        } else {
            RSAPIEdge edge = dataset.getEdge(edgeOrdinal);
            rowset = edge.getRowset(rowsetIdAsInteger);
        }
        return rowset;
    }

    protected RSAPIEdgeRowset getRowsetOnSameEdge(int rowsetId) {
        RSAPIEdgeRowset rowset = null;
        if (this.mRowset != null) {
            RSAPIEdge edge = this.mRowset.getEdge();
            rowset = edge.getRowset(rowsetId);
        }
        return rowset;
    }

    protected String getName() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    @Override
    public void dump(XQETrace trace) {
        trace.beginElement(this.getName(), -1);
        if (this.getId() == null) {
            throw new XQERuntimeException();
        }
        trace.attribute("ruleId", this.getId());
        RSAPIEdgeRowset rowSet = this.getRowset();
        if (rowSet != null) {
            trace.attribute("rowsetId", rowSet.getRowsetId());
            trace.attribute("rowsetName", rowSet.getName());
            trace.attribute("rowsetEdgeOrdinal", ((RSAPIRowset)rowSet).getEdge().getPositionalOrdinal());
        }
        if (this.getDataItemIndex() != -1) {
            trace.attribute("dataItemIndex", this.getDataItemIndex());
        }
        String dataItemName = null;
        if (rowSet != null) {
            if (this.getDataItemIndex() == -1 && rowSet.getRefDataItem() != null) {
                dataItemName = rowSet.getRefDataItem().getName();
            } else if (this.getDataItemIndex() > -1 && rowSet.getDataItem(this.getDataItemIndex()) != null) {
                dataItemName = rowSet.getDataItem(this.getDataItemIndex()).getName();
            }
        }
        if (dataItemName != null) {
            trace.attribute("dataItemName", dataItemName);
        }
        if (this.hierarchy != null) {
            trace.attribute("hierarchy", this.hierarchy.getV5UniqueName());
        }
        this.dumpAdditionalAttributes(trace);
        this.dumpAdditionalElements(trace);
        trace.endElement();
    }

    protected void dumpAdditionalAttributes(XQETrace trace) {
    }

    protected void dumpAdditionalElements(XQETrace trace) {
    }

    @Override
    public boolean applies(ITuple aTuple, int aMemberPosition) {
        IMember aMember = aTuple.getMember(aMemberPosition);
        return this.applies(aMember);
    }

    public boolean applies(IMember aMember) {
        return false;
    }

    public boolean applies(ITuple aTuple, int aMemberPosition, ContextMember outerContext) {
        return this.applies(aTuple, aMemberPosition);
    }

    public boolean applies(IMember aMember, ContextMember outerContext) {
        return this.applies(aMember);
    }

    @Override
    public boolean isNesting() {
        return false;
    }

    public String generateKey() {
        String key = null;
        key = this.generateRuleKey();
        return key;
    }

    protected String generateRuleKey() {
        int rowSetId = -1;
        StringBuilder keyBuffer = null;
        RSAPIEdgeRowset rowset = this.getRowset();
        if (rowset != null) {
            rowSetId = rowset.getRowsetId();
            keyBuffer = new StringBuilder(openingParenthesis);
            keyBuffer.append(XQEIntegerPool.getInteger(rowSetId).toString());
            keyBuffer.append(", ");
            keyBuffer.append(XQEIntegerPool.getInteger(this.getDataItemIndex()).toString());
            keyBuffer.append(closingParenthesis);
            return keyBuffer.toString();
        }
        keyBuffer = new StringBuilder(this.getClass().getSimpleName());
        keyBuffer.append(openingParenthesis);
        keyBuffer.append(this.getId());
        keyBuffer.append(closingParenthesis);
        return keyBuffer.toString();
    }

    public IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(IHierarchy aHierarchy) {
        this.hierarchy = aHierarchy;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer ruleId) {
        this.id = ruleId;
    }

    public XNode getOwner() {
        return this.owner;
    }

    public void setOwner(XNode aOwner) {
        this.owner = aOwner;
    }

    public String dumpToString() {
        XQETrace trace = new XQETrace();
        trace.setNodeIDGenerator(new XQEIDGenerator());
        trace.setTraceLevelAll();
        trace.setIndentString(" ");
        StringWriter stringWriter = new StringWriter();
        trace.addStream(stringWriter);
        this.dump(trace);
        return stringWriter.toString();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        RSAPIEdgeRowset rowSet = this.getRowset();
        if (rowSet != null) {
            String rowsetEdgeOrdinal = XQEIntegerPool.getInteger(((RSAPIRowset)rowSet).getEdge().getPositionalOrdinal()).toString();
            propertiesMap.put("rowsetEdgeOrdinal", rowsetEdgeOrdinal);
        }
        return propertiesMap;
    }

    @Override
    public void computeCheckSum(ICheckSum checkSum) {
        OLAPDecorationRuleCheckSum ruleCheckSum = (OLAPDecorationRuleCheckSum)checkSum;
        ruleCheckSum.compute(this);
    }

    @Override
    public ICheckSum getCheckSum() {
        OLAPDecorationRuleCheckSum ruleCheckSum = new OLAPDecorationRuleCheckSum();
        this.computeCheckSum(ruleCheckSum);
        return ruleCheckSum;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistProperties(XQEPersistContext ctx) {
        this.persistAttributeProperties(ctx);
        this.persistElementProperties(ctx);
    }

    public void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property("ruleId", this.getId());
        RSAPIEdgeRowset rowSet = this.getRowset();
        if (rowSet != null) {
            ctx.property("rowsetId", rowSet.getRowsetId());
            ctx.property("rowsetName", rowSet.getName());
            ctx.property("rowsetEdgeOrdinal", ((RSAPIRowset)rowSet).getEdge().getPositionalOrdinal());
        }
        if (this.getDataItemIndex() != -1) {
            ctx.property("dataItemIndex", this.getDataItemIndex());
        }
        if (this.hierarchy != null) {
            ctx.property("hierarchy", this.hierarchy.getV5UniqueName());
        }
    }

    public void persistElementProperties(XQEPersistContext ctx) {
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals("ruleId")) {
            Object value = ctx.attributeValue(att);
            this.id = (int)((Integer)value);
        } else if (attname.equals("rowsetId")) {
            int edgeOrdinal;
            RSAPIEdge edge;
            Object value = ctx.attributeValue(att);
            Attribute edgeOrdinalAttr = inputNode.attribute("rowsetEdgeOrdinal");
            RSAPIDataset ds = ctx.getDataset();
            if (ds != null && edgeOrdinalAttr != null && (edge = ds.getEdge(edgeOrdinal = ((Integer)ctx.attributeValue(edgeOrdinalAttr)).intValue())) != null) {
                RSAPIEdgeRowset rowset = edge.getRowset((Integer)value);
                this.setRowset(rowset);
            }
        } else if (attname.equals("dataItemIndex")) {
            Object value = ctx.attributeValue(att);
            this.setDataItemIndex((Integer)value);
        } else if (attname.equals("hierarchy")) {
            Object value = ctx.attributeValue(att);
            this.hierarchy = (IHierarchy)value;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        PlanningEnvironment env = ctx.getPlanningEnvironment();
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            this.restoreElementProperty(ctx, child, node);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
    }
}

