/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.decoration;

import com.cognos.xqe.util.FastLongBigArray;

public class EdgeOrdinalMapping {
    private FastLongBigArray ordinalMap = new FastLongBigArray();
    private EdgeOrdinalMapping childMap;
    private boolean hasMapping = false;

    EdgeOrdinalMapping() {
    }

    EdgeOrdinalMapping(EdgeOrdinalMapping child) {
        this.childMap = child;
    }

    public void map(long ordinal, long childEdgeOrdinal) {
        Long oldValue;
        if (this.childMap != null && (oldValue = Long.valueOf(this.childMap.lookup(childEdgeOrdinal))) != null) {
            childEdgeOrdinal = oldValue;
        }
        if (ordinal != childEdgeOrdinal) {
            this.hasMapping = true;
        }
        this.ordinalMap.put(ordinal, childEdgeOrdinal);
    }

    public long lookup(long ordinal) {
        long value = this.ordinalMap.get(ordinal);
        if (value == -1L) {
            return ordinal;
        }
        return value;
    }

    public boolean isEmpty() {
        return this.ordinalMap.size() == 0L;
    }

    public boolean hasMapping() {
        return this.hasMapping;
    }

    public EdgeOrdinalMapping createReverseMapping() {
        EdgeOrdinalMapping reversedMapping = new EdgeOrdinalMapping();
        for (long fromOrdinal = 0L; fromOrdinal < this.ordinalMap.size(); ++fromOrdinal) {
            long toOrdinal = this.ordinalMap.get(fromOrdinal);
            if (toOrdinal == -1L) continue;
            reversedMapping.map(toOrdinal, fromOrdinal);
        }
        return reversedMapping;
    }
}

