/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.decoration;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.decoration.DecorationResultSet;
import com.cognos.xqe.runtree.olap.decoration.EdgeOrdinalMapping;
import com.cognos.xqe.runtree.olap.decoration.XOLAPEdgeDecoration;

public abstract class OLAPDecorationAxisIterator
extends XIterator {
    protected long sourceTupleCount = 0L;
    protected XOLAPEdgeDecoration parentXNode;
    protected DecorationResultSet parentResultSet;
    protected EdgeOrdinalMapping coordinateMap;
    protected long oldCoordinate = -1L;
    protected long newCoordinate = -1L;
    protected XIterator sourceIterator;

    protected OLAPDecorationAxisIterator(int axisOrdinal, XOLAPEdgeDecoration parent, DecorationResultSet resultSet, Integer nodeId) {
        super(resultSet.getDataContext(), nodeId);
        this.parentXNode = parent;
        this.parentResultSet = resultSet;
        this.coordinateMap = resultSet.getOrdinalMap();
        this.sourceIterator = resultSet.getBaseResultSet().getAxisIterator(axisOrdinal);
        this.setEdgeNumber(axisOrdinal);
    }

    public DecorationResultSet getDecorationResultSet() {
        return this.parentResultSet;
    }

    public static int containsCalculation(ITuple aTuple) {
        int tupleSize = aTuple.size();
        for (int i = 0; i < tupleSize; ++i) {
            ContextMember aContextMember;
            IMember aMember = aTuple.getMember(i);
            if (!aMember.isContextMember() || !(aContextMember = (ContextMember)aMember).isQueryCalculation()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void release() {
        if (this.sourceIterator != null) {
            try {
                this.sourceIterator.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.sourceIterator = null;
            }
        }
    }
}

