/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.decoration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.CubeHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.olap.decoration.AbstractOLAPDecorationRules;
import com.cognos.xqe.runtree.olap.decoration.DecorationResultSet;
import com.cognos.xqe.runtree.olap.decoration.INestable;
import com.cognos.xqe.runtree.olap.decoration.XOLAPEmptyValueSetDecoration;
import com.cognos.xqe.runtree.olap.decoration.exceptions_and_warnings.OLAPDecorationException;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class XOLAPEdgeDecoration
extends XNode {
    private static final long serialVersionUID = 1L;
    private static final String STRING_EDGE_ORDINAL = "edgeOrdinal";
    private static final String STRING_EDGE_NAME = "edgeName";
    private static final String STRING_TUPLE_POSITION = "tuplePosition";
    private static final String STRING_DECORATION_RULES = "decorationRules";
    private static final String STRING_ROWSET_DECORATION_RULES = "rowsetDecorationRules";
    private static final String STRING_AXIS_TUPLE_COUNT = "axisTupleCount";
    private int mEdgeOrdinal = -1;
    private String edgeName = null;
    private int mTuplePosition = -1;
    private List<AbstractOLAPDecorationRules> mDecorationRules = new ArrayList<AbstractOLAPDecorationRules>();
    private HashMap<Integer, List<AbstractOLAPDecorationRules>> mRowsetDecorationRules = new HashMap();
    private long axisTupleCount = -1L;

    public void setEdgeOrdinal(int edgeOrdinal) {
        this.mEdgeOrdinal = edgeOrdinal;
    }

    public int getEdgeOrdinal() {
        if (this.mEdgeOrdinal == -1) {
            throw new IllegalStateException();
        }
        return this.mEdgeOrdinal;
    }

    public void setEdgeName(String anEdgeName) {
        this.edgeName = anEdgeName;
    }

    public String getEdgeName() {
        return this.edgeName;
    }

    public void setTuplePosition(int tuplePosition) {
        if (tuplePosition < 0) {
            throw new OLAPDecorationException(XQEMessageKeys.DEC_InvalidTupleArgument);
        }
        this.mTuplePosition = tuplePosition;
    }

    public int getTuplePosition() {
        return this.mTuplePosition;
    }

    public void addDecorationRules(AbstractOLAPDecorationRules rules) {
        this.mDecorationRules.add(rules);
    }

    public void insertDecorationRules(int pos, AbstractOLAPDecorationRules rules) {
        this.mDecorationRules.add(pos, rules);
    }

    public List<AbstractOLAPDecorationRules> getDecorationRules() {
        return this.mDecorationRules;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        Attribute attribute = inputNode.attribute(STRING_EDGE_ORDINAL);
        Integer edgeOrdinal = new Integer(attribute.getStringValue());
        this.setEdgeOrdinal(edgeOrdinal);
        attribute = inputNode.attribute(STRING_TUPLE_POSITION);
        Integer tuplePosition = new Integer(attribute.getStringValue());
        this.setTuplePosition(tuplePosition);
        Attribute nodeIdAttribute = inputNode.attribute("id");
        if (nodeIdAttribute != null) {
            this.setNodeId(XQEIntegerPool.getInteger(Integer.parseInt(nodeIdAttribute.getValue())));
        }
        List childList = inputNode.elements();
        ListIterator listIterator = childList.listIterator();
        XNodeFactory nodeFactory = (XNodeFactory)env.getNodeFactory();
        while (listIterator.hasNext()) {
            Element anElement = (Element)listIterator.next();
            XNode xNode = (XNode)nodeFactory.createNodeByName(anElement.getName());
            if (xNode == null) continue;
            xNode.capture(env, anElement);
            this.addChild(xNode);
        }
    }

    @Override
    public void dump(XQETrace trace, boolean includeRuntimeSpecifics) {
        Integer nodeID = -1;
        if (includeRuntimeSpecifics) {
            nodeID = this.getId();
        }
        trace.beginElement(this.getNodeTypeName(), nodeID);
        this.dumpExtraInfo(trace, includeRuntimeSpecifics);
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            this.getChild(i).dump(trace, includeRuntimeSpecifics);
        }
        trace.endElement();
    }

    protected void dumpDecorationRules(XQETrace trace) {
        for (AbstractOLAPDecorationRules rules : this.getDecorationRules()) {
            rules.dump(trace);
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.attribute(STRING_EDGE_ORDINAL, this.getEdgeOrdinal());
        if (this.getType() != 501144) {
            trace.attribute(STRING_TUPLE_POSITION, this.getTuplePosition());
        }
        this.dumpDecorationRules(trace);
    }

    @Override
    protected final IValue executeImpl(XDataContext context) {
        XNode childNode = (XNode)this.getChild(0);
        ICubeResultSet cubeResult = (ICubeResultSet)childNode.execute(context);
        CubeHybridResultSet resultSet = new CubeHybridResultSet(context, this.executeImpl(context, cubeResult), this.getId(), this.getCacheHints());
        return resultSet;
    }

    protected abstract CacheHints getCacheHints();

    protected abstract DecorationResultSet executeImpl(XDataContext var1, ICubeResultSet var2);

    protected void setSourceTupleCount(long tupleCount) {
        this.axisTupleCount = tupleCount;
    }

    protected long getSourceTupleCount(int edgeOrdinal) {
        XOLAPEdgeDecoration decorationNode;
        long tupleCount;
        IXQEQueryNode childNode = this.getChild(0);
        if (childNode instanceof XOLAPEdgeDecoration && (tupleCount = (decorationNode = (XOLAPEdgeDecoration)childNode).getSourceTupleCount(edgeOrdinal)) != -1L) {
            return tupleCount;
        }
        if (edgeOrdinal == this.getEdgeOrdinal()) {
            return this.axisTupleCount;
        }
        return -1L;
    }

    @Override
    public boolean isDecorationNode() {
        return true;
    }

    public void release() {
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        propertiesMap.put(STRING_EDGE_ORDINAL, XQEIntegerPool.getInteger(this.getEdgeOrdinal()).toString());
        propertiesMap.put(STRING_TUPLE_POSITION, XQEIntegerPool.getInteger(this.getTuplePosition()).toString());
        return propertiesMap;
    }

    public List<INestable> getNestablesForCheckSum() {
        ArrayList<INestable> nestables = new ArrayList<INestable>();
        if (this.getType() == 501085) {
            nestables.addAll(((XOLAPEmptyValueSetDecoration)this).getDecorationRules());
        }
        return nestables;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(STRING_EDGE_ORDINAL, this.getEdgeOrdinal());
        ctx.property(STRING_EDGE_NAME, this.edgeName);
        if (this.getType() != 501144) {
            ctx.property(STRING_TUPLE_POSITION, this.getTuplePosition());
        }
        ctx.property(STRING_AXIS_TUPLE_COUNT, this.axisTupleCount);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        ctx.elementProperty(STRING_DECORATION_RULES, this.getDecorationRules());
        ctx.elementProperty(STRING_ROWSET_DECORATION_RULES, this.mRowsetDecorationRules);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(STRING_EDGE_ORDINAL)) {
            Object value = ctx.attributeValue(att);
            this.setEdgeOrdinal((Integer)value);
        } else if (attname.equals(STRING_TUPLE_POSITION)) {
            Object value = ctx.attributeValue(att);
            this.setTuplePosition((Integer)value);
        } else if (attname.equals(STRING_EDGE_NAME)) {
            Object value = ctx.attributeValue(att);
            this.edgeName = (String)value;
        } else if (attname.equals(STRING_AXIS_TUPLE_COUNT)) {
            Object value = ctx.attributeValue(att);
            this.axisTupleCount = (Long)value;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(STRING_DECORATION_RULES)) {
            Object value = ctx.elementValue(node);
            this.mDecorationRules = (List)value;
        } else if (pname.equals(STRING_ROWSET_DECORATION_RULES)) {
            Object value = ctx.elementValue(node);
            this.mRowsetDecorationRules = (HashMap)value;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    @Override
    public int getType() {
        return 0;
    }
}

