/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.decoration;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.decoration.AbstractOLAPDecorationRules;
import com.cognos.xqe.runtree.olap.decoration.DecorationResultSet;
import com.cognos.xqe.runtree.olap.decoration.OLAPDecorationAxisIterator;
import com.cognos.xqe.runtree.olap.decoration.OLAPEmptyRowDecorationRules;
import com.cognos.xqe.runtree.olap.decoration.XOLAPEdgeDecoration;
import com.cognos.xqe.runtree.olap.decoration.exceptions_and_warnings.OLAPDecorationException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;

public class XOLAPEmptyValueSetDecoration
extends XOLAPEdgeDecoration {
    private static final long serialVersionUID = 6755321249372568371L;

    @Override
    public int getType() {
        return 501085;
    }

    @Override
    protected DecorationResultSet executeImpl(XDataContext context, ICubeResultSet cubeResult) {
        return new EmptyValueSetResult(context, cubeResult, this);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        List childList = inputNode.elements();
        ListIterator listIterator = childList.listIterator();
        while (listIterator.hasNext()) {
            Element anElement = (Element)listIterator.next();
            String elementName = anElement.getName();
            if (!"OLAPEmptyRowDecorationRules".equals(elementName)) continue;
            OLAPEmptyRowDecorationRules aRule = (OLAPEmptyRowDecorationRules)env.getRuleFactory().createRule(3);
            aRule.capture(env, anElement, this.getEdgeOrdinal());
            this.addDecorationRules(aRule);
        }
    }

    @Override
    protected CacheHints getCacheHints() {
        return CacheHints.cacheOneAxisNoCells(this.getEdgeOrdinal());
    }

    public List<AbstractOLAPDecorationRules> getDecorationRules(ITuple aTuple, int tuplePosition) {
        List<AbstractOLAPDecorationRules> decoRules = this.getDecorationRules();
        ArrayList<AbstractOLAPDecorationRules> rowsetDecoRules = new ArrayList<AbstractOLAPDecorationRules>();
        IMember aMember = aTuple.getMember(tuplePosition);
        if (aMember.isContextMember()) {
            ContextMember aContextMember = (ContextMember)aMember;
            if (aContextMember.getRowset() != null) {
                RSAPIEdgeRowset parentRowset = (RSAPIEdgeRowset)aContextMember.getRowset();
                int parentRowsetId = parentRowset.getRowsetId();
                if (parentRowset.isHeaderRowset() || parentRowset.isFooterRowset()) {
                    parentRowsetId = parentRowset.getParentRowset() == null ? -1 : parentRowset.getParentRowset().getRowsetId();
                }
                for (OLAPEmptyRowDecorationRules oLAPEmptyRowDecorationRules : decoRules) {
                    RSAPIEdgeRowset emptyRowset = (RSAPIEdgeRowset)oLAPEmptyRowDecorationRules.getEmptyRowset();
                    if (emptyRowset.getParentRowset().getRowsetId() != parentRowsetId) continue;
                    rowsetDecoRules.add(oLAPEmptyRowDecorationRules);
                }
            }
        } else {
            rowsetDecoRules.addAll(decoRules);
        }
        return rowsetDecoRules;
    }

    private final class EmptyValueSetAxisIterator
    extends OLAPDecorationAxisIterator {
        private List<ITuple> tupleBuffer;
        int idRowsetTriggerLastCreation;

        private EmptyValueSetAxisIterator(int axisOrdinal, XOLAPEdgeDecoration parent, DecorationResultSet resultSet) {
            super(axisOrdinal, parent, resultSet, XOLAPEmptyValueSetDecoration.this.getId());
            this.tupleBuffer = new ArrayList<ITuple>();
            this.idRowsetTriggerLastCreation = -1;
        }

        @Override
        public Object nextImpl() {
            this.openIteratorTrace(this.parentXNode, this.parentXNode.getEdgeOrdinal(), this.parentXNode.getEdgeName(), true);
            this.openNextImplTrace(++this.callId);
            int decorateTuplePosition = this.parentXNode.getTuplePosition();
            if (!this.tupleBuffer.isEmpty()) {
                ITuple aTuple = this.tupleBuffer.remove(0);
                this.coordinateMap.map(++this.newCoordinate, this.oldCoordinate);
                this.traceOutTuple(aTuple, this.oldCoordinate, this.newCoordinate);
                this.closeNextImplTrace();
                return aTuple;
            }
            ITuple aTuple = (ITuple)this.sourceIterator.next();
            this.traceInTuple(aTuple, this.oldCoordinate);
            ++this.oldCoordinate;
            if (aTuple == null) {
                XOLAPEmptyValueSetDecoration.this.setSourceTupleCount(this.oldCoordinate);
                this.traceOutTuple(null, this.oldCoordinate, this.newCoordinate);
                this.closeNextImplTrace();
                this.closeIteratorTrace();
                return null;
            }
            if (decorateTuplePosition >= aTuple.size()) {
                throw new OLAPDecorationException(XQEMessageKeys.DEC_InvalidTupleArgument);
            }
            RSAPIEdgeRowset aRowset = null;
            if (aTuple.getMember(this.parentXNode.getTuplePosition()).isContextMember()) {
                ContextMember aMember = (ContextMember)aTuple.getMember(this.parentXNode.getTuplePosition());
                aRowset = (RSAPIEdgeRowset)aMember.getRowset();
                if (aRowset == null) {
                    this.traceOutTuple(aTuple, this.oldCoordinate, this.newCoordinate);
                    this.closeNextImplTrace();
                    return aTuple;
                }
                if (aRowset.isHeaderRowset() && aMember.getDataItemIndex() != aRowset.getNumDataItems() - 1) {
                    this.coordinateMap.map(++this.newCoordinate, this.oldCoordinate);
                    this.traceOutTuple(aTuple, this.oldCoordinate, this.newCoordinate);
                    this.closeNextImplTrace();
                    return aTuple;
                }
                if (aRowset.isFooterRowset() && aMember.getDataItemIndex() != 0) {
                    this.coordinateMap.map(++this.newCoordinate, this.oldCoordinate);
                    this.traceOutTuple(aTuple, this.oldCoordinate, this.newCoordinate);
                    this.closeNextImplTrace();
                    return aTuple;
                }
            }
            List<AbstractOLAPDecorationRules> rules = XOLAPEmptyValueSetDecoration.this.getDecorationRules(aTuple, decorateTuplePosition);
            boolean getTupleFromBuffer = false;
            for (AbstractOLAPDecorationRules rule : rules) {
                if (aRowset != null && this.hasRowBeenCreatedAlready((OLAPEmptyRowDecorationRules)rule, aRowset)) continue;
                ITuple newTuple = this.createEmptyRow(aTuple, (OLAPEmptyRowDecorationRules)rule);
                if (aRowset != null) {
                    this.idRowsetTriggerLastCreation = aRowset.getRowsetId();
                }
                this.tupleBuffer.add(newTuple);
                RSAPIEdgeRowset newRowset = (RSAPIEdgeRowset)((OLAPEmptyRowDecorationRules)rule).getEmptyRowset();
                if (aRowset == null || !aRowset.isFooterRowset() || newRowset.getFooterRowset() == null || !newRowset.getFooterRowset().equals(aRowset)) continue;
                this.tupleBuffer.add(aTuple);
                getTupleFromBuffer = true;
            }
            if (getTupleFromBuffer) {
                aTuple = this.tupleBuffer.remove(0);
            }
            this.coordinateMap.map(++this.newCoordinate, this.oldCoordinate);
            this.traceOutTuple(aTuple, this.oldCoordinate, this.newCoordinate);
            this.closeNextImplTrace();
            return aTuple;
        }

        private boolean hasRowBeenCreatedAlready(OLAPEmptyRowDecorationRules rule, RSAPIEdgeRowset aRowset) {
            if (this.idRowsetTriggerLastCreation == -1) {
                return false;
            }
            RSAPIEdgeRowset newRowset = (RSAPIEdgeRowset)rule.getEmptyRowset();
            if (newRowset.getFooterRowset() == null) {
                return false;
            }
            if (newRowset.getHeaderRowset() == null) {
                return false;
            }
            if (newRowset.getFooterRowset().getRowsetId() != this.idRowsetTriggerLastCreation && newRowset.getHeaderRowset().getRowsetId() != this.idRowsetTriggerLastCreation) {
                return false;
            }
            return aRowset.getRowsetId() != this.idRowsetTriggerLastCreation;
        }

        private ITuple createEmptyRow(ITuple currentTuple, OLAPEmptyRowDecorationRules rule) {
            ITuple aTuple = (ITuple)currentTuple.copy();
            int tuplePosition = this.parentXNode.getTuplePosition();
            RSAPIEdgeRowset emptyRowset = (RSAPIEdgeRowset)rule.getEmptyRowset();
            ContextMember aMember = null;
            IMember tupleMember = aTuple.getMember(tuplePosition);
            if (tupleMember.isContextMember()) {
                ContextMember ancestorMember;
                aMember = ancestorMember = (ContextMember)tupleMember;
                if (emptyRowset.getParentRowset() == (RSAPIEdgeRowset)ancestorMember.getRowset()) {
                    aMember = new ContextMember();
                    aMember.setMember(ancestorMember.getMember());
                    aMember.setContextMember(ancestorMember);
                }
            } else {
                aMember = new ContextMember();
                aMember.setMember(tupleMember);
            }
            aMember.setRowset(emptyRowset);
            aMember.setDataItemIndex(-2);
            aTuple.getMembers()[tuplePosition] = aMember;
            return aTuple;
        }
    }

    private final class EmptyValueSetResult
    extends DecorationResultSet {
        private EmptyValueSetResult(XDataContext context, ICubeResultSet result, XOLAPEdgeDecoration owner) {
            super(context, result, owner);
        }

        @Override
        public XIterator getAxisIterator(int axisNumber) {
            if (axisNumber == XOLAPEmptyValueSetDecoration.this.getEdgeOrdinal()) {
                return new EmptyValueSetAxisIterator(axisNumber, this.parentNode, this);
            }
            return this.getBaseResultSet().getAxisIterator(axisNumber);
        }
    }
}

