/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.decoration.rulesfactory;

import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.runtree.olap.decoration.AbstractOLAPDecorationRules;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OLAPDecorationRulesIndex {
    public static final int QUERYTREE_UNLIMITED_DEPTH = 0;
    private Map<Integer, AbstractOLAPDecorationRules> mIdMap = new HashMap<Integer, AbstractOLAPDecorationRules>();
    private Lock readLock;
    private Lock writeLock;

    public OLAPDecorationRulesIndex() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public void removeRule(AbstractOLAPDecorationRules rule) {
        Integer ruleId = rule.getId();
        try {
            this.writeLock.lockInterruptibly();
            try {
                this.mIdMap.remove(ruleId);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }

    public void addRule(AbstractOLAPDecorationRules rule) {
        Integer ruleId = rule.getId();
        try {
            this.writeLock.lockInterruptibly();
            try {
                this.mIdMap.put(ruleId, rule);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }

    public AbstractOLAPDecorationRules getRuleByID(Integer ruelId) {
        try {
            this.readLock.lockInterruptibly();
            AbstractOLAPDecorationRules aNode = null;
            try {
                aNode = this.mIdMap.get(ruelId);
            }
            finally {
                this.readLock.unlock();
            }
            return aNode;
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }

    public boolean validateRuleIsIndex(AbstractOLAPDecorationRules rule) {
        boolean hasKey = false;
        try {
            this.readLock.lockInterruptibly();
            try {
                hasKey = this.mIdMap.containsKey(rule.getId());
            }
            finally {
                this.readLock.unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
        return hasKey;
    }
}

