/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ActionFactory;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ActionTypeEnum;
import com.cognos.xqe.runtree.olap.edgemapping.actions.AddGroupbodyMeasureValue;
import com.cognos.xqe.runtree.olap.edgemapping.actions.GenerateContext;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.LinkSuppression;
import com.cognos.xqe.runtree.olap.edgemapping.actions.LockContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.actions.RelocateNestedLevelCalculation;
import com.cognos.xqe.runtree.olap.edgemapping.actions.Remove;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ResetIsCalculation;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class AbstractOLAPEdgeElement
implements IXQEPersist {
    public static final String ATTRIBUTE_EDGE_ELEMENT_ID = "edgeElementId";
    public static final String ATTRIBUTE_ST_DONE = "stDone";
    public static final String ELEMENT_ACTIONS = "actions";
    public static final String ELEMENT_PARENT_ROW = "parentRow";
    Integer edgeElementId;
    protected List<IEdgeElementMappingAction> actions = new ArrayList<IEdgeElementMappingAction>(1);
    protected AbstractOLAPRow parentRow = null;
    protected boolean stDone = false;
    private XOLAPEdgeMapping.OLAPEdgeMappingIterator iterator = null;

    public String getEdgeElementName() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return name;
    }

    public Integer getId() {
        return this.edgeElementId;
    }

    public void setId(Integer ruleId) {
        this.edgeElementId = ruleId;
    }

    public AbstractOLAPRow getParentRow() {
        return this.parentRow;
    }

    public void setParentRow(AbstractOLAPRow aParentRow) {
        this.parentRow = aParentRow;
    }

    public void addAction(IEdgeElementMappingAction action) {
        this.actions.add(action);
        action.setOwner(this);
    }

    public void removeAction(IEdgeElementMappingAction action) {
        this.actions.remove(action);
    }

    public void capture(PlanningEnvironment env, Element inputEdgeElement, int edgeOrdinal) {
        Attribute attribute = inputEdgeElement.attribute("elementId");
        if (attribute == null) {
            throw new IllegalStateException();
        }
        this.edgeElementId = Integer.parseInt(attribute.getValue());
        List childList = inputEdgeElement.elements();
        ListIterator listIterator = childList.listIterator();
        while (listIterator.hasNext()) {
            Element anElement = (Element)listIterator.next();
            String elementName = anElement.getName();
            if (!elementName.equals(ELEMENT_ACTIONS)) continue;
            if (!this.actions.isEmpty()) {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "!actions.isEmpty()");
            }
            this.captureActions(env, anElement, edgeOrdinal);
        }
    }

    private void captureActions(PlanningEnvironment env, Element inputActions, int edgeOrdinal) {
        List childList = inputActions.elements();
        ListIterator listIterator = childList.listIterator();
        EdgeElementFactory edgeElementFactory = env.getEdgeElementFactory();
        ActionFactory actionFactory = edgeElementFactory.getActionFactory();
        while (listIterator.hasNext()) {
            Element anElement = (Element)listIterator.next();
            String actionName = anElement.getName();
            IEdgeElementMappingAction action = actionFactory.createActionByName(actionName);
            if (action == null) continue;
            action.capture(env, anElement, edgeOrdinal);
            this.actions.add(action);
        }
    }

    public void dump(XQETrace trace) {
        if (this.getId() == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "this.getId() == null");
        }
        trace.beginElement(this.getEdgeElementName(), -1);
        trace.attribute("elementId", this.getId());
        if (this.isDone()) {
            trace.attribute("isDone", this.isDone());
        }
        this.dumpExtraAttibutes(trace);
        if (!this.actions.isEmpty()) {
            trace.beginElement(ELEMENT_ACTIONS, -1);
            for (IEdgeElementMappingAction action : this.actions) {
                action.dump(trace);
            }
            trace.endElement();
        }
        this.dumpExtraElements(trace);
        trace.endElement();
    }

    public void dumpExtraAttibutes(XQETrace trace) {
    }

    public void dumpExtraElements(XQETrace trace) {
    }

    public boolean isRow() {
        return false;
    }

    public boolean isColumn() {
        return false;
    }

    public boolean isDone() {
        return this.stDone;
    }

    public void setDone(boolean done) {
        this.stDone = done;
    }

    public void resetDone() {
        this.stDone = false;
    }

    public abstract boolean accept(ITuple var1, boolean var2);

    public abstract boolean map(ITuple var1);

    protected AbstractOLAPColumn findColumnById(Integer targetId, AbstractOLAPRow startRow, List<Integer> visited) {
        AbstractOLAPColumn targetColumn = null;
        while (startRow != null && (targetColumn = startRow.findColumnById(targetId, visited)) == null) {
            startRow = startRow.getParentRow();
        }
        return targetColumn;
    }

    protected AbstractOLAPColumn findColumnById(Integer targetId) {
        return null;
    }

    protected AbstractOLAPRow findRowById(Integer targetId, AbstractOLAPRow startRow, List<Integer> visited, Integer boundary) {
        AbstractOLAPRow targetRow = null;
        while (startRow != null) {
            targetRow = startRow.findRowById(targetId, visited, boundary);
            if (targetRow != null) {
                return targetRow;
            }
            startRow = startRow.getParentRow();
        }
        return targetRow;
    }

    protected List<Integer> applyActions(int minPrecendence, int maxPrecedence) {
        ArrayList<Integer> actionResults = new ArrayList<Integer>();
        if (minPrecendence < ActionTypeEnum.PRECEDENCE_VALUES[0] || maxPrecedence > ActionTypeEnum.PRECEDENCE_VALUES[ActionTypeEnum.PRECEDENCE_VALUES.length - 1]) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "minPrecendence < MIN || maxPrecedence > MAX");
        }
        boolean stop = false;
        for (int currPrecedence = minPrecendence; currPrecedence < maxPrecedence + 1; ++currPrecedence) {
            for (IEdgeElementMappingAction action : this.actions) {
                if (action.getPrecedence() != currPrecedence) continue;
                int actionResult = this.applyAction(action);
                actionResults.add(XQEIntegerPool.getInteger(actionResult));
                if (actionResult != 0) continue;
                stop = true;
                break;
            }
            if (stop) break;
        }
        return actionResults;
    }

    public boolean hasActions() {
        return !this.actions.isEmpty();
    }

    public boolean doesActionTypeApplies(int actionType) {
        for (IEdgeElementMappingAction action : this.actions) {
            if (action.getType() != actionType) continue;
            return true;
        }
        return false;
    }

    public IEdgeElementMappingAction getActionOfTypeForMUN(int actionType, IMember aMember) {
        IEdgeElementMappingAction defaultAction = null;
        for (IEdgeElementMappingAction action : this.actions) {
            if (action.getType() != actionType) continue;
            String mun = null;
            if (aMember != null) {
                mun = aMember.getUniqueName();
            }
            if (action.getTargetUniqueName() == null && mun == null) {
                return action;
            }
            if (action.getTargetUniqueName() == null && mun != null) {
                if (defaultAction != null) {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "defaultAction!");
                }
                defaultAction = action;
                continue;
            }
            if (!action.getTargetUniqueName().equals(mun)) continue;
            return action;
        }
        return defaultAction;
    }

    public List<IEdgeElementMappingAction> getActionsForMUN(String mun) {
        ArrayList<IEdgeElementMappingAction> actionsForMUN = null;
        if (mun == null || mun.length() == 0) {
            return actionsForMUN;
        }
        for (IEdgeElementMappingAction action : this.actions) {
            if (action.getTargetUniqueName() == null || action.getTargetUniqueName().length() <= 0 || !action.getTargetUniqueName().equals(mun)) continue;
            if (actionsForMUN == null) {
                actionsForMUN = new ArrayList<IEdgeElementMappingAction>();
            }
            actionsForMUN.add(action);
        }
        return actionsForMUN;
    }

    protected int applyAction(IEdgeElementMappingAction action) {
        int actionType = action.getType();
        switch (actionType) {
            case 6: {
                if (this.isRow()) {
                    this.throwInvalidTargetForEdgeMappingAction(action);
                }
                OLAPRow parentOLAPRow = (OLAPRow)this.getParentRow();
                OLAPRowCycle parentCycle = (OLAPRowCycle)parentOLAPRow.getParentRow();
                RelocateNestedLevelCalculation relocateNLC = (RelocateNestedLevelCalculation)action;
                relocateNLC.validate();
                ITuple aMappedTuple = parentOLAPRow.getMappedTuple();
                if (parentCycle != parentOLAPRow.getRootRowCycle()) {
                    aMappedTuple = parentCycle.getMappedTuple();
                }
                ITuple newMappedTuple = relocateNLC.relocatedNestedLevelCalculationMember(aMappedTuple);
                parentOLAPRow.setMappedTuple(newMappedTuple);
                if (parentCycle != parentOLAPRow.getRootRowCycle()) {
                    parentCycle.setMappedTuple(newMappedTuple);
                }
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "ActionTypeEnum.RENAME_V5_TYPE!");
            }
            case 9: {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "ActionTypeEnum.RENAME_MUN_TYPE!");
            }
            case 3: {
                if (this.isColumn()) {
                    this.throwInvalidTargetForEdgeMappingAction(action);
                }
                AbstractOLAPRow thisRow = (AbstractOLAPRow)this;
                LinkSuppression linkSuppression = (LinkSuppression)action;
                linkSuppression.validate();
                if (thisRow.linkedRowWasRendered()) {
                    return 3;
                }
                return 4;
            }
            case 5: {
                int pos;
                if (this.isColumn() || ((AbstractOLAPRow)this).isCycle()) {
                    this.throwInvalidTargetForEdgeMappingAction(action);
                }
                AbstractOLAPRow thisRow = (AbstractOLAPRow)this;
                LockContextColumn lockContextColumn = (LockContextColumn)action;
                Integer targetId = lockContextColumn.getTargetId();
                OLAPRowCycle rowCycle = (OLAPRowCycle)thisRow.getParentRow();
                OLAPRowCycle targetRowCycle = (OLAPRowCycle)rowCycle.getRow((pos = rowCycle.indexOf(thisRow)) + 1);
                if (!((OLAPContextColumn)targetRowCycle.getFirstColumn()).getId().equals(targetId)) {
                    this.throwInvalidTargetForEdgeMappingAction(action);
                }
                ((OLAPContextColumn)targetRowCycle.getFirstColumn()).setLocked(0);
                ((OLAPContextColumn)targetRowCycle.getFirstColumn()).setRendered(false);
                return 5;
            }
            case 2: {
                AbstractOLAPColumn thisColumn;
                if (this.isRow()) {
                    this.throwInvalidTargetForEdgeMappingAction(action);
                }
                if ((thisColumn = (AbstractOLAPColumn)this).getCurrentMember() == null) {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "thisColumn.getCurrentMember() == null");
                }
                GenerateContext generateContext = (GenerateContext)action;
                ContextMember aContextMember = generateContext.createContextMember((ContextMember)thisColumn.getCurrentMember());
                if (aContextMember == null) {
                    return 0;
                }
                thisColumn.setCurrentMember(aContextMember);
                return 2;
            }
            case 10: {
                if (this.isRow() || ((AbstractOLAPColumn)this).isContext()) {
                    this.throwInvalidTargetForEdgeMappingAction(action);
                }
                AddGroupbodyMeasureValue addValue = (AddGroupbodyMeasureValue)action;
                addValue.createContextValue((OLAPColumn)this);
                return 10;
            }
            case 11: {
                if (this.isRow()) {
                    this.throwInvalidTargetForEdgeMappingAction(action);
                }
                ResetIsCalculation resetIsCalculation = (ResetIsCalculation)action;
                AbstractOLAPColumn thisColumn = (AbstractOLAPColumn)this;
                resetIsCalculation.resetIsCalculation((ContextMember)thisColumn.getCurrentMember());
                return 11;
            }
            case 12: {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "COPY_CONTEXT_TYPE!");
            }
            case 13: {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "INSERT_CROSSTAB_SPACER_TYPE!");
            }
        }
        return 0;
    }

    private void throwInvalidTargetForEdgeMappingAction(IEdgeElementMappingAction action) {
        StringBuilder strinIdOfThis = EdgeMappingUtils.createNodeIdString(this.getEdgeElementName(), this.getId());
        throw new XQERuntimeException(XQEMessageKeys.DEC_InvalidTargetForEdgeMappingAction, action.getName(), strinIdOfThis.toString());
    }

    protected abstract void getTabularMeasures(Set<RSAPIDataItem> var1);

    protected abstract void getDataItemIdexesForSummary(int var1, List<Integer> var2);

    public void reset() {
        this.setDone(false);
        for (IEdgeElementMappingAction action : this.actions) {
            action.reset();
        }
    }

    public void partialReset() {
        this.setDone(false);
        for (IEdgeElementMappingAction action : this.actions) {
            action.reset();
        }
    }

    public String dumpToString() {
        XQETrace trace = new XQETrace();
        trace.setNodeIDGenerator(null);
        trace.setTraceLevelAll();
        trace.setIndentString(" ");
        StringWriter stringWriter = new StringWriter();
        trace.addStream(stringWriter);
        this.dump(trace);
        return stringWriter.toString();
    }

    public AbstractOLAPEdgeElement copy(EdgeElementFactory edgeElementFactory, boolean setAbstractMDXSetProp) {
        AbstractOLAPEdgeElement abstractOLAPEdgeElement = edgeElementFactory.createEdgeElementByName(this.getEdgeElementName());
        this.copyActions(edgeElementFactory, abstractOLAPEdgeElement);
        abstractOLAPEdgeElement.setIterator(this.getIterator());
        return abstractOLAPEdgeElement;
    }

    public AbstractOLAPEdgeElement exactCopy(EdgeElementFactory edgeElementFactory) {
        AbstractOLAPEdgeElement abstractOLAPEdgeElement = edgeElementFactory.createEdgeElementByName(this.getEdgeElementName());
        this.copyActions(edgeElementFactory, abstractOLAPEdgeElement);
        abstractOLAPEdgeElement.setIterator(this.getIterator());
        abstractOLAPEdgeElement.setId(this.getId());
        abstractOLAPEdgeElement.setIterator(this.getIterator());
        return abstractOLAPEdgeElement;
    }

    public void copyActions(EdgeElementFactory edgeElementFactory, AbstractOLAPEdgeElement abstractOLAPEdgeElement) {
        for (IEdgeElementMappingAction action : this.actions) {
            abstractOLAPEdgeElement.addAction(action.copy(edgeElementFactory));
        }
    }

    public void exactCopyActions(EdgeElementFactory edgeElementFactory, AbstractOLAPEdgeElement abstractOLAPEdgeElement) {
        for (IEdgeElementMappingAction action : this.actions) {
            abstractOLAPEdgeElement.addAction(action.exactCopy(edgeElementFactory));
        }
    }

    public void updateMissingAbstractMDXSetProp(AbstractOLAPEdgeElement abstractOLAPEdgeElement) {
    }

    public String toString() {
        return EdgeMappingUtils.createNodeIdString(this.getEdgeElementName(), this.getId()).toString();
    }

    public XOLAPEdgeMapping.OLAPEdgeMappingIterator getIterator() {
        return this.iterator;
    }

    public void setIterator(XOLAPEdgeMapping.OLAPEdgeMappingIterator anIterator) {
        this.iterator = anIterator;
    }

    public void addRemoveAction(EdgeElementFactory edgeElementFactory) {
        ActionFactory actionFactory = edgeElementFactory.getActionFactory();
        if (!this.doesActionTypeApplies(7)) {
            Remove remove = (Remove)actionFactory.createActionByType(7);
            this.addAction(remove);
        }
    }

    public SortedMap<String, String> getCheckSumPropertiesMap() {
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        StringBuilder sb = new StringBuilder();
        if (this.actions != null && !this.actions.isEmpty()) {
            for (IEdgeElementMappingAction action : this.actions) {
                sb.append(action.getClass().getSimpleName());
                sb.append(action.getCheckSumPropertiesMap().toString());
            }
            propertiesMap.put(ELEMENT_ACTIONS, sb.toString());
        }
        return propertiesMap;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            this.persistElementProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ATTRIBUTE_EDGE_ELEMENT_ID, this.edgeElementId);
        ctx.property(ATTRIBUTE_ST_DONE, this.stDone);
    }

    public void persistElementProperties(XQEPersistContext ctx) {
        if (this.actions != null) {
            ctx.elementProperty(ELEMENT_ACTIONS, this.actions);
        }
        if (this.parentRow != null) {
            ctx.elementProperty(ELEMENT_PARENT_ROW, this.parentRow);
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_EDGE_ELEMENT_ID)) {
            Object val = ctx.attributeValue(att);
            this.edgeElementId = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_ST_DONE)) {
            Object val = ctx.attributeValue(att);
            this.stDone = (Boolean)val;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            if (child.getNamespace().getURI().isEmpty()) continue;
            this.restoreElementProperty(ctx, child, node);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_ACTIONS)) {
            Object val = ctx.elementValue(node);
            this.actions = (List)val;
        } else if (pname.equals(ELEMENT_PARENT_ROW)) {
            Object val = ctx.elementValue(node);
            this.parentRow = (AbstractOLAPRow)val;
        }
    }
}

