/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPEdgeElement;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingRules;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ActionFactory;
import com.cognos.xqe.runtree.olap.edgemapping.actions.GenerateContext;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class AbstractOLAPRow
extends AbstractOLAPEdgeElement {
    private static final String ATTRIBUTE_HAS_RAGGED_COMPENSATION = "hasRaggedCompensation";
    private static final String ATTRIBUTE_HAS_UNBALANCED_COMPENSATION = "hasUnbalancedCompensation";
    private static final String TWO_COLUMNS_WITH_SAME_HIER = "column.getHierarchy().equals(aColumn.getHierarchy())";
    protected List<AbstractOLAPColumn> columns = new ArrayList<AbstractOLAPColumn>();
    private ITuple stMappedTuple = null;
    private boolean isMultiHierarchy = false;
    private boolean isTag = false;
    public static final int IS_FILLER_TAG_ROW = 1;
    public static final int IS_NOT_FILLER_TAG_ROW = 0;
    public static final int IS_FILLER_TAG_ROW_REPLACEMENT = -1;
    private int isFillerTagRow = 0;
    private boolean hasRaggedCompensation = false;
    private boolean hasUnbalancedCompensation = false;
    OLAPRowCycle rootRowCycle = null;
    private boolean stSuppressed = false;
    private boolean stRemoved = false;
    protected List<Integer> rowsLinkedToThis = null;
    private boolean stLinkedRowRendered = false;

    @Override
    public void reset() {
        super.reset();
        this.setMappedTuple(null);
        for (AbstractOLAPColumn column : this.columns) {
            column.reset();
        }
        this.setSuppressed(false);
        this.setRemoved(false);
    }

    @Override
    public void partialReset() {
        super.partialReset();
        this.setMappedTuple(null);
        for (AbstractOLAPColumn column : this.columns) {
            column.partialReset();
        }
        this.setSuppressed(false);
        this.setRemoved(false);
    }

    @Override
    public boolean isRow() {
        return true;
    }

    public boolean isCycle() {
        return false;
    }

    public int indexOf(AbstractOLAPColumn column) {
        return this.columns.indexOf(column);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputRow, int edgeOrdinal) {
        super.capture(env, inputRow, edgeOrdinal);
        Attribute attribute = inputRow.attribute("isTag");
        if (attribute != null) {
            this.setTag(true);
        }
        if ((attribute = inputRow.attribute("isFillerTagRow")) != null) {
            this.setFillerTagRow(Integer.parseInt(attribute.getValue()));
        }
        if ((attribute = inputRow.attribute("isMultiHierarchy")) != null) {
            this.setMultiHierarchy(true);
        }
        List<AbstractOLAPColumn> columnList = AbstractOLAPRow.captureColumns(env, inputRow, edgeOrdinal);
        for (AbstractOLAPColumn column : columnList) {
            this.addColumn(column, true);
            column.setParentRow(this);
        }
    }

    public void addColumn(AbstractOLAPColumn aColumn, boolean toTheEnd) {
        for (AbstractOLAPColumn column : this.columns) {
            if (!column.getHierarchy().equals(aColumn.getHierarchy())) continue;
            if (column.getRulesType() == aColumn.getRulesType() && aColumn.getRulesType() == 4 && aColumn.isUnbalanced() && aColumn.isUnbalancedCompensation()) {
                this.columns.set(this.columns.indexOf(column), aColumn);
                continue;
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, TWO_COLUMNS_WITH_SAME_HIER);
        }
        if (!this.columns.isEmpty()) {
            this.setMultiHierarchy(true);
        }
        aColumn.setParentRow(this);
        if (aColumn.isRaggedCompensation()) {
            this.setHasRaggedCompensation(true);
        }
        if (aColumn.isUnbalancedCompensation()) {
            this.setHasUnbalancedCompensation(true);
        }
        if (this.columns.indexOf(aColumn) > -1) {
            return;
        }
        if (this.columns.isEmpty() || toTheEnd) {
            this.columns.add(aColumn);
            return;
        }
        if (aColumn.getRowset() == null) {
            this.columns.add(0, aColumn);
            return;
        }
        int tuplePostion = aColumn.getTuplePosition();
        for (int i = 0; i < this.columns.size(); ++i) {
            AbstractOLAPColumn currColumn = this.columns.get(i);
            int currtuplePostion = currColumn.getTuplePosition();
            if (currtuplePostion <= tuplePostion) continue;
            this.columns.add(i, aColumn);
            return;
        }
        this.columns.add(0, aColumn);
    }

    public void insertColumn(AbstractOLAPColumn aColumn, int tuplePostion) {
        AbstractOLAPColumn columnToReplace = null;
        for (int i = 0; i < this.columns.size(); ++i) {
            AbstractOLAPColumn currColumn = this.columns.get(i);
            int currtuplePostion = currColumn.getTuplePosition();
            if (currtuplePostion != tuplePostion) continue;
            columnToReplace = currColumn;
            break;
        }
        if (columnToReplace != null) {
            this.columns.remove(columnToReplace);
        }
        this.addColumn(aColumn, false);
    }

    public int getNumberOfColumns() {
        return this.columns.size();
    }

    public AbstractOLAPColumn getColumn(int pos) {
        return this.columns.get(pos);
    }

    public static List<AbstractOLAPColumn> captureColumns(PlanningEnvironment env, Element inputElement, int edgeOrdinal) {
        ArrayList<AbstractOLAPColumn> columnList = new ArrayList<AbstractOLAPColumn>();
        List childList = inputElement.elements();
        ListIterator listIterator = childList.listIterator();
        EdgeElementFactory edgeElementFactory = env.getEdgeElementFactory();
        while (listIterator.hasNext()) {
            Element anElement = (Element)listIterator.next();
            String elementName = anElement.getName();
            AbstractOLAPEdgeElement column = edgeElementFactory.createEdgeElementByName(elementName);
            if (column == null) continue;
            if (column.isRow()) break;
            column.capture(env, anElement, edgeOrdinal);
            columnList.add((AbstractOLAPColumn)column);
        }
        return columnList;
    }

    @Override
    public void dumpExtraAttibutes(XQETrace trace) {
        if (this.isTag()) {
            trace.attribute("isTag", this.isTag());
        }
        if (this.isFillerTagRow() != 0) {
            trace.attribute("isFillerTagRow", this.isFillerTagRow());
        }
        if (this.isMultiHierarchy()) {
            trace.attribute("isMultiHierarchy", this.isMultiHierarchy());
        }
        if (this.getMappedTuple() != null) {
            trace.attribute("tuple", EdgeMappingUtils.tupleToString(this.getMappedTuple()));
        }
        if (this.wasSuppressed()) {
            trace.attribute("suppressed", this.wasSuppressed());
        }
        if (this.wasRemoved()) {
            trace.attribute("removed", this.wasRemoved());
        }
        if (this.getRowsLinkedToThis() != null) {
            trace.attribute("rowsLinkedToThis", this.getRowsLinkedToThis().toString());
        }
        if (this.linkedRowWasRendered()) {
            trace.attribute("linkedRowWasRendered", this.linkedRowWasRendered());
        }
    }

    @Override
    public void dumpExtraElements(XQETrace trace) {
        for (AbstractOLAPColumn column : this.columns) {
            column.dump(trace);
        }
    }

    protected void resetMapping() {
        this.setMappedTuple(null);
    }

    public AbstractOLAPColumn getFirstColumn() {
        if (this.columns.isEmpty()) {
            return null;
        }
        return this.columns.get(0);
    }

    public RSAPIEdgeRowset getFirstRowset() {
        if (this.columns.isEmpty()) {
            return null;
        }
        for (AbstractOLAPColumn column : this.columns) {
            if (column.isContextMember() || column.getRowset() == null) continue;
            return column.getRowset();
        }
        return null;
    }

    public int getFirstDataItemIndex() {
        if (this.columns.isEmpty()) {
            return -1;
        }
        for (AbstractOLAPColumn column : this.columns) {
            if (column.isContextMember() || column.getRowset() == null) continue;
            return column.getDataItemIndex();
        }
        return -1;
    }

    public int getFirstPositionWithinEdge() {
        if (this.columns.isEmpty()) {
            return -1;
        }
        for (AbstractOLAPColumn column : this.columns) {
            if (column.isContextMember() || column.getCogMDXGroup() == null || !column.getCogMDXGroup().isOfCategory(1027)) continue;
            return ((CogMDXGroup)column.getCogMDXGroup()).getPositionWhitinMDXEdge();
        }
        return -1;
    }

    public RSAPIEdgeRowset getLastRowset() {
        if (this.columns.isEmpty()) {
            return null;
        }
        for (int i = this.columns.size() - 1; i >= 0; --i) {
            AbstractOLAPColumn column = this.columns.get(i);
            if (column.isContextMember() || column.getRowset() == null) continue;
            return column.getRowset();
        }
        return null;
    }

    public ITuple getMappedTuple() {
        return this.stMappedTuple;
    }

    protected void setMappedTuple(ITuple aTuple) {
        this.stMappedTuple = aTuple;
        if (aTuple != null) {
            this.setSuppressed(false);
            this.setRemoved(false);
        }
    }

    public AbstractOLAPColumn findColumnById(Integer targetId, List<Integer> visited) {
        visited.add(this.getId());
        for (AbstractOLAPColumn column : this.columns) {
            Integer id = column.getId();
            if (visited.contains(id)) {
                return null;
            }
            visited.add(id);
            if (!id.equals(targetId)) continue;
            return column;
        }
        return null;
    }

    public AbstractOLAPRow findRowById(Integer targetId, List<Integer> visited, Integer boundary) {
        visited.add(this.getId());
        if (this.getId().equals(targetId)) {
            return this;
        }
        if (this.getId().equals(boundary)) {
            return this;
        }
        return null;
    }

    @Override
    protected void getTabularMeasures(Set<RSAPIDataItem> tabularMeasures) {
        for (AbstractOLAPColumn column : this.columns) {
            column.getTabularMeasures(tabularMeasures);
        }
    }

    @Override
    public void getDataItemIdexesForSummary(int rowsetId, List<Integer> dataItemIdexes) {
        for (AbstractOLAPColumn column : this.columns) {
            column.getDataItemIdexesForSummary(rowsetId, dataItemIdexes);
        }
    }

    public boolean isSummaryRow() {
        for (AbstractOLAPColumn currColumn : this.columns) {
            if (!currColumn.isSummaryColumn()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resetDone() {
        super.resetDone();
        for (AbstractOLAPColumn column : this.columns) {
            column.resetDone();
        }
    }

    public List<Integer> flagRenderedColumns(List<Integer> ids) {
        ArrayList<Integer> pendingIds = new ArrayList<Integer>();
        pendingIds.addAll(ids);
        if (this.getParentRow() == null) {
            return pendingIds;
        }
        for (AbstractOLAPColumn column : this.columns) {
            boolean flagTheContext;
            boolean bl = flagTheContext = column.getRulesType() == 4 || column.getRulesType() == 7;
            if (flagTheContext && column.getParentRow().getParentRow() != column.getParentRow().getRootRowCycle()) {
                AbstractOLAPColumn contextColumn = column.getParentRow().getParentRow().getFirstColumn();
                contextColumn.setRendered(true);
                contextColumn.getParentRow().setRemoved(false);
            }
            if (pendingIds.contains(column.getId())) {
                column.setRendered(true);
                column.getParentRow().setRemoved(false);
                pendingIds.remove(column.getId());
            }
            if (!pendingIds.isEmpty()) continue;
            break;
        }
        return pendingIds;
    }

    @Override
    public AbstractOLAPColumn findColumnById(Integer targetId) {
        for (AbstractOLAPColumn column : this.columns) {
            if (column.findColumnById(targetId) == null) continue;
            return column;
        }
        return null;
    }

    public AbstractOLAPColumn findColumnOfTuplePosition(int tuplePosition) {
        for (AbstractOLAPColumn column : this.columns) {
            if (column.getTuplePosition() != tuplePosition) continue;
            return column;
        }
        return null;
    }

    public boolean wasRendered() {
        if (!this.isCycle()) {
            for (AbstractOLAPColumn column : this.columns) {
                if (column.getRulesType() == 4 && column.isContextMember() || !column.wasRendered() || !column.wasRendered()) continue;
                return true;
            }
        } else {
            return ((OLAPRowCycle)this).wasEverRendered();
        }
        return false;
    }

    public boolean isMultiHierarchy() {
        return this.isMultiHierarchy;
    }

    protected void setMultiHierarchy(boolean value) {
        this.isMultiHierarchy = value;
    }

    public boolean isTag() {
        return this.isTag;
    }

    public void setTag(boolean value) {
        this.isTag = value;
    }

    @Override
    public AbstractOLAPEdgeElement copy(EdgeElementFactory edgeElementFactory, boolean setAbstractMDXSetProp) {
        AbstractOLAPRow newAbstractOLAPRow = (AbstractOLAPRow)super.copy(edgeElementFactory, setAbstractMDXSetProp);
        for (AbstractOLAPColumn column : this.columns) {
            AbstractOLAPColumn newAbstractOLAColumn = (AbstractOLAPColumn)column.copy(edgeElementFactory, setAbstractMDXSetProp);
            newAbstractOLAPRow.addColumn(newAbstractOLAColumn, true);
            if (!setAbstractMDXSetProp || newAbstractOLAColumn.getCogMDXGroup() == null) continue;
            newAbstractOLAColumn.getCogMDXGroup().setAbstractOLAPRow(newAbstractOLAPRow);
        }
        newAbstractOLAPRow.setMultiHierarchy(this.isMultiHierarchy());
        newAbstractOLAPRow.setFillerTagRow(this.isFillerTagRow());
        newAbstractOLAPRow.setHasRaggedCompensation(this.hasRaggedCompensation());
        newAbstractOLAPRow.setHasUnbalancedCompensation(this.hasUnbalancedCompensation());
        newAbstractOLAPRow.setTag(this.isTag());
        newAbstractOLAPRow.setRowsLinkedToThis(this.getRowsLinkedToThis());
        return newAbstractOLAPRow;
    }

    @Override
    public AbstractOLAPEdgeElement exactCopy(EdgeElementFactory edgeElementFactory) {
        AbstractOLAPRow newAbstractOLAPRow = (AbstractOLAPRow)super.exactCopy(edgeElementFactory);
        for (AbstractOLAPColumn column : this.columns) {
            AbstractOLAPColumn newAbstractOLAColumn = (AbstractOLAPColumn)column.exactCopy(edgeElementFactory);
            newAbstractOLAPRow.addColumn(newAbstractOLAColumn, true);
            if (newAbstractOLAColumn.getCogMDXGroup() == null) continue;
            newAbstractOLAColumn.getCogMDXGroup().setAbstractOLAPRow(newAbstractOLAPRow);
        }
        newAbstractOLAPRow.setMultiHierarchy(this.isMultiHierarchy());
        newAbstractOLAPRow.setFillerTagRow(this.isFillerTagRow());
        newAbstractOLAPRow.setHasRaggedCompensation(this.hasRaggedCompensation());
        newAbstractOLAPRow.setHasUnbalancedCompensation(this.hasUnbalancedCompensation());
        newAbstractOLAPRow.setTag(this.isTag());
        newAbstractOLAPRow.setRowsLinkedToThis(this.getRowsLinkedToThis());
        return newAbstractOLAPRow;
    }

    @Override
    public void updateMissingAbstractMDXSetProp(AbstractOLAPEdgeElement abstractOLAPEdgeElement) {
        if (abstractOLAPEdgeElement.isRow()) {
            int columnIndex = -1;
            for (AbstractOLAPColumn column : this.columns) {
                column.updateMissingAbstractMDXSetProp(((AbstractOLAPRow)abstractOLAPEdgeElement).getColumn(++columnIndex));
            }
        }
    }

    public void rebuildMUNRules(EdgeElementFactory edgeElementFactory) {
        for (AbstractOLAPColumn column : this.columns) {
            column.rebuildMUNRules(this.getRootRowCycle(), edgeElementFactory);
        }
    }

    public void rebuildMUNRulesForPowerCubeRootAliases() {
        for (AbstractOLAPColumn column : this.columns) {
            column.rebuildMUNRulesForPowerCubeRootAliases();
        }
    }

    public void rebuildMUNRulesForNoMember() {
        for (AbstractOLAPColumn column : this.columns) {
            column.rebuildMUNRulesForNoMember();
        }
    }

    public void rebuildMUNRulesForReplacedRootMember(BaseMember replacedRootMember, AbstractMDXMember replacement, ActionFactory actionFactory) {
        for (AbstractOLAPColumn column : this.columns) {
            column.rebuildMUNRulesForReplacedRootMember(replacedRootMember, replacement, actionFactory);
        }
    }

    public void cleanDeletedMemberDescriptors() {
        for (AbstractOLAPColumn column : this.columns) {
            column.cleanDeletedMemberDescriptors();
        }
    }

    public List<Integer> applyRowActions(int minPrecendence, int maxPrecedence) {
        if (this.isCycle() || !((OLAPRow)this).isHierarchyNormalization()) {
            for (AbstractOLAPColumn currColumn : this.columns) {
                currColumn.applyActions(minPrecendence, maxPrecedence);
            }
        }
        return this.applyActions(minPrecendence, maxPrecedence);
    }

    public boolean isAncestorsQueryRequired() {
        for (AbstractOLAPColumn currColumn : this.columns) {
            if (!currColumn.doesActionTypeApplies(2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setIterator(XOLAPEdgeMapping.OLAPEdgeMappingIterator anIterator) {
        super.setIterator(anIterator);
        for (AbstractOLAPColumn currColumn : this.columns) {
            currColumn.setIterator(anIterator);
            GenerateContext generateContext = (GenerateContext)currColumn.getActionOfTypeForMUN(2, null);
            if (generateContext == null) continue;
            generateContext.setIterator(anIterator);
        }
    }

    public int isFillerTagRow() {
        return this.isFillerTagRow;
    }

    public void setFillerTagRow(int value) {
        this.isFillerTagRow = value;
    }

    public void setHierarchyNormalization(boolean value) {
        for (AbstractOLAPColumn currColumn : this.columns) {
            if (currColumn.isContextMember()) continue;
            currColumn.setHierarchyNormalization(value);
        }
    }

    public OLAPRowCycle getRootRowCycle() {
        return this.rootRowCycle;
    }

    public void setRootRowCycle(OLAPRowCycle aRootRowCycle) {
        this.rootRowCycle = aRootRowCycle;
    }

    public int getMeasuresFinalTuplePosition() {
        return -1;
    }

    public void replaceColumn(AbstractOLAPColumn oldColumn, AbstractOLAPColumn newColumn) {
        if (oldColumn.getTuplePosition() != newColumn.getTuplePosition()) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "oldColumn.getTuplePosition() != newColumn.getTuplePosition()?");
        }
        this.removeColumn(oldColumn);
        this.insertColumn(newColumn, newColumn.getTuplePosition());
    }

    public void removeColumn(AbstractOLAPColumn oldColumn) {
        this.columns.remove(oldColumn);
    }

    public boolean acceptSkippingCMRules(ITuple aTuple) {
        for (AbstractOLAPColumn column : this.columns) {
            if (column.getRules().getType() == 4 || column.getRules().getType() == 7 || column.accept(aTuple, false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(ITuple aTuple, boolean modifyState) {
        for (AbstractOLAPColumn column : this.columns) {
            if (column.accept(aTuple, modifyState)) continue;
            return false;
        }
        return true;
    }

    public boolean hasRaggedCompensation() {
        return this.hasRaggedCompensation;
    }

    public void setHasRaggedCompensation(boolean value) {
        this.hasRaggedCompensation = value;
    }

    public boolean hasUnbalancedCompensation() {
        return this.hasUnbalancedCompensation;
    }

    public void setHasUnbalancedCompensation(boolean value) {
        this.hasUnbalancedCompensation = value;
    }

    public boolean wasSuppressed() {
        return this.stSuppressed;
    }

    public void setSuppressed(boolean value) {
        this.stSuppressed = value;
    }

    public boolean wasRemoved() {
        return this.stRemoved;
    }

    public void setRemoved(boolean value) {
        this.stRemoved = value;
    }

    public void resetNextMemberListIndexes() {
        for (AbstractOLAPColumn column : this.columns) {
            column.resetNextMemberListIndex();
        }
    }

    public void colleactMUNDescriptors(List<EdgeMappingRules.MemberDescriptor> munDescriptorList) {
        for (AbstractOLAPColumn column : this.columns) {
            if (column.getRules().getType() == 0 && column.getRules().getMemberDescriptorList() == null && column.getParentRow().doesActionTypeApplies(5)) {
                return;
            }
            for (EdgeMappingRules.MemberDescriptor descriptor : column.getRules().getMemberDescriptorList()) {
                if (descriptor.isCalculation() || descriptor.getMUN() == null) continue;
                munDescriptorList.add(descriptor);
            }
        }
    }

    public void removeCogMDXGroupFromAbstractOLAPColumns() {
        for (AbstractOLAPColumn column : this.columns) {
            column.setCogMDXGroup(null);
        }
    }

    public void clearCurrentMembers() {
        for (int k = 0; k < this.getNumberOfColumns(); ++k) {
            this.getColumn(k).setCurrentMember(null);
        }
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        if (this.isTag()) {
            propertiesMap.put("isTag", Boolean.TRUE.toString());
        }
        if (this.isFillerTagRow() != 0) {
            propertiesMap.put("isFillerTagRow", XQEIntegerPool.getInteger(this.isFillerTagRow()).toString());
        }
        if (this.isMultiHierarchy()) {
            propertiesMap.put("isMultiHierarchy", Boolean.TRUE.toString());
        }
        if (this.columns != null && !this.columns.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (AbstractOLAPColumn column : this.columns) {
                sb.append(column.getClass().getSimpleName());
                sb.append(column.getCheckSumPropertiesMap().toString());
            }
            propertiesMap.put("columns", sb.toString());
        }
        return propertiesMap;
    }

    public List<Integer> getRowsLinkedToThis() {
        return this.rowsLinkedToThis;
    }

    public void setRowsLinkedToThis(List<Integer> aRowsLinkedToThis) {
        if (aRowsLinkedToThis != null && this.rowsLinkedToThis == null) {
            this.rowsLinkedToThis = new ArrayList<Integer>();
            this.rowsLinkedToThis.addAll(aRowsLinkedToThis);
        }
    }

    public void addRowLinkedToThis(AbstractOLAPRow aRowLinkedToThis) {
        if (aRowLinkedToThis == null) {
            return;
        }
        if (this.rowsLinkedToThis == null) {
            this.rowsLinkedToThis = new ArrayList<Integer>();
        }
        this.rowsLinkedToThis.add(aRowLinkedToThis.getId());
    }

    public boolean linkedRowWasRendered() {
        return this.stLinkedRowRendered;
    }

    public void setLinkedRowRendered(boolean aLinkedRowRendered) {
        this.stLinkedRowRendered = aLinkedRowRendered;
    }

    protected void setLinkedRowRendered() {
        List<Integer> linkedToThis = this.getRowsLinkedToThis();
        if (linkedToThis != null) {
            AbstractOLAPRow aParentRow = this.getParentRow();
            if (this.isCycle() && aParentRow != this.getRootRowCycle()) {
                aParentRow = aParentRow.getParentRow();
            }
            ArrayList<Integer> visited = new ArrayList<Integer>();
            for (Integer targetId : linkedToThis) {
                AbstractOLAPRow targetRow = this.findRowById(targetId, aParentRow, visited, targetId);
                if (targetRow == null) {
                    targetRow = this.findRowById(targetId, this.getRootRowCycle(), visited, null);
                }
                if (targetRow != null) {
                    targetRow.setLinkedRowRendered(true);
                }
                visited.clear();
            }
        }
    }

    @Override
    public void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property("isMultiHierarchy", this.isMultiHierarchy);
        ctx.property("isTag", this.isTag);
        ctx.property("isFillerTagRow", this.isFillerTagRow);
        ctx.property(ATTRIBUTE_HAS_RAGGED_COMPENSATION, this.hasRaggedCompensation);
        ctx.property(ATTRIBUTE_HAS_UNBALANCED_COMPENSATION, this.hasUnbalancedCompensation);
        ctx.property("suppressed", this.stSuppressed);
        ctx.property("removed", this.stRemoved);
        ctx.property("linkedRowWasRendered", this.stLinkedRowRendered);
    }

    @Override
    public void persistElementProperties(XQEPersistContext ctx) {
        if (this.stMappedTuple != null) {
            ctx.elementProperty("tuple", this.stMappedTuple);
        }
        if (this.columns != null) {
            ctx.elementProperty("columns", this.columns);
        }
        if (this.rowsLinkedToThis != null) {
            ctx.elementProperty("rowsLinkedToThis", this.rowsLinkedToThis);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals("isMultiHierarchy")) {
            Object val = ctx.attributeValue(att);
            this.isMultiHierarchy = (Boolean)val;
        } else if (attName.equals("isTag")) {
            Object val = ctx.attributeValue(att);
            this.isTag = (Boolean)val;
        } else if (attName.equals("isFillerTagRow")) {
            Object val = ctx.attributeValue(att);
            this.isFillerTagRow = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_HAS_RAGGED_COMPENSATION)) {
            Object val = ctx.attributeValue(att);
            this.hasRaggedCompensation = (Boolean)val;
        } else if (attName.equals(ATTRIBUTE_HAS_UNBALANCED_COMPENSATION)) {
            Object val = ctx.attributeValue(att);
            this.hasUnbalancedCompensation = (Boolean)val;
        } else if (attName.equals("suppressed")) {
            Object val = ctx.attributeValue(att);
            this.stSuppressed = (Boolean)val;
        } else if (attName.equals("removed")) {
            Object val = ctx.attributeValue(att);
            this.stRemoved = (Boolean)val;
        } else if (attName.equals("linkedRowWasRendered")) {
            Object val = ctx.attributeValue(att);
            this.stLinkedRowRendered = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, node);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals("columns")) {
            Object val = ctx.elementValue(node);
            this.columns = (List)val;
        } else if (pname.equals("rowsLinkedToThis")) {
            Object val = ctx.elementValue(node);
            this.rowsLinkedToThis = (List)val;
        } else if (pname.equals("tuple")) {
            Object val = ctx.elementValue(node);
            this.stMappedTuple = (ITuple)val;
        }
    }
}

