/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping;

import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ActionFactory;
import com.cognos.xqe.runtree.olap.edgemapping.actions.CopyContext;
import com.cognos.xqe.runtree.olap.edgemapping.actions.GenerateContext;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.RenameV5;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ResetIsCalculation;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class EdgeMappingRules {
    public static final String NOMEMBER_NAME = ".[NOMEMBER]";
    private static final String UNKNOWN_TYPE = "aType?";
    public static final int HUN_TYPE = 0;
    public static final int LUN_TYPE = 1;
    public static final int MUN_TYPE = 2;
    public static final int DM_TYPE = 3;
    public static final int CM_TYPE = 4;
    public static final int MUN_AND_LUN_TYPE = 5;
    public static final int MUN_AND_HUN_TYPE = 6;
    public static final int NLC_REPLACEMENT_TYPE = 7;
    private int type;
    private int tuplePosition = -1;
    private List<MemberDescriptor> memberDescriptorList = null;
    private List<MemberDescriptor> calculatedMemberList = null;
    private Map<String, AbstractMDXMember> memberMapByName = null;
    protected boolean stDone = false;
    AbstractOLAPColumn owner = null;
    boolean ignoreMemberListIndex = false;
    int stNextMemberListIndex = 0;
    private Boolean isReportHierarchy = null;
    public static final int NO = -1;
    public static final int YES_IN_PART = 0;
    public static final int YES_IN_FULL = 1;
    private int stSucessfullyUsed = -1;

    public int wasSucessfullyUsed() {
        if (this.stSucessfullyUsed != 1) {
            int usedCount = 0;
            int total = 0;
            for (MemberDescriptor descriptor : this.getMemberDescriptorList()) {
                if (this.getType() == 2 && descriptor.getMUN() != null) {
                    ++total;
                } else {
                    if (this.getType() == 2 && descriptor.getMUN() == null) continue;
                    ++total;
                }
                if (!descriptor.wasSucessfullyUsed() && this.stSucessfullyUsed == 0) {
                    return 0;
                }
                if (descriptor.wasSucessfullyUsed() && this.stSucessfullyUsed == 0) {
                    ++usedCount;
                }
                if (!descriptor.wasSucessfullyUsed() || this.stSucessfullyUsed != -1) continue;
                this.stSucessfullyUsed = 0;
                ++usedCount;
            }
            if (usedCount == total) {
                this.stSucessfullyUsed = 1;
            }
        }
        return this.stSucessfullyUsed;
    }

    public AbstractOLAPColumn getOwner() {
        return this.owner;
    }

    public void setOwner(AbstractOLAPColumn anOwner) {
        this.owner = anOwner;
    }

    private void setType(int aType) {
        this.validateRuleType(aType);
        this.type = aType;
    }

    private void validateRuleType(int aType) {
        switch (aType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, UNKNOWN_TYPE);
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public static int nameToType(String ruleName) {
        int aType = -1;
        if ("CM".equals(ruleName)) {
            aType = 4;
        } else if ("DM".equals(ruleName)) {
            aType = 3;
        } else if ("HUN".equals(ruleName)) {
            aType = 0;
        } else if ("LUN".equals(ruleName)) {
            aType = 1;
        } else if ("MUN".equals(ruleName)) {
            aType = 2;
        } else if ("MUN_AND_HUN".equals(ruleName)) {
            aType = 6;
        } else if ("MUN_AND_LUN".equals(ruleName)) {
            aType = 5;
        } else if ("NLC_REPLACEMENT".equals(ruleName)) {
            aType = 7;
        } else {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "ruleName?");
        }
        return aType;
    }

    private String typeToString() {
        switch (this.type) {
            case 4: {
                return "CM";
            }
            case 3: {
                return "DM";
            }
            case 0: {
                return "HUN";
            }
            case 1: {
                return "LUN";
            }
            case 2: {
                return "MUN";
            }
            case 6: {
                return "MUN_AND_HUN";
            }
            case 5: {
                return "MUN_AND_LUN";
            }
            case 7: {
                return "NLC_REPLACEMENT";
            }
        }
        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "type?");
    }

    public int getTuplePosition() {
        return this.tuplePosition;
    }

    public void setTuplePosition(int aTuplePosition) {
        this.tuplePosition = aTuplePosition;
    }

    public boolean applies(boolean modifyState, IMember aMember) {
        return this.applies(aMember, modifyState) != null;
    }

    public AbstractOLAPColumn applies(IMember aMember, boolean modifyState) {
        AbstractOLAPColumn column = null;
        boolean isCalculatedMember = aMember.isCalculatedMember() || aMember.isDataBaseCalculation();
        boolean isCalculation = false;
        String aMUN = aMember.getUniqueName();
        if (isCalculatedMember || !isCalculatedMember && aMember.getLevel().getIndex() == 0) {
            isCalculation = this.isKnownCalculation(aMUN);
        }
        switch (this.getType()) {
            case 4: 
            case 7: {
                if (!this.getHierarchy().getUniqueName().equals(aMember.getHierarchy().getUniqueName())) {
                    return null;
                }
                AbstractOLAPRow parentRow = this.getOwner().getParentRow();
                if (parentRow == null && this.getOwner().isContext()) {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "parentRow == null && this.getOwner().isContext()");
                }
                if (parentRow == null) {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "parentRow == null");
                }
                if (parentRow.getParentRow() != null && parentRow.getParentRow().isCycle()) {
                    OLAPContextColumn contexColumn = (OLAPContextColumn)parentRow.getParentRow().findColumnOfTuplePosition(this.getTuplePosition());
                    if (contexColumn != null) {
                        IMember contexMember = contexColumn.getCurrentMember();
                        if (contexMember == null) {
                            return null;
                        }
                        String uniqueName = null;
                        uniqueName = contexMember.isContextMember() ? ((ContextMember)contexMember).getMember().getUniqueName() : contexMember.getUniqueName();
                        if (uniqueName.equals(aMUN)) {
                            if (modifyState) {
                                this.stDone = true;
                            }
                            this.getMemberDescriptorList().get(0).setSucessfullyUsed(true);
                            return contexColumn;
                        }
                    } else {
                        if (parentRow.getParentRow() == parentRow.getRootRowCycle()) {
                            this.getMemberDescriptorList().get(0).setSucessfullyUsed(true);
                            return this.getOwner();
                        }
                        if (parentRow.getNumberOfColumns() > parentRow.indexOf(this.getOwner()) + 1) {
                            AbstractOLAPColumn nextColumn = parentRow.getColumn(parentRow.indexOf(this.getOwner()) + 1);
                            CopyContext copyContext = (CopyContext)nextColumn.getActionOfTypeForMUN(12, null);
                            if (copyContext != null) {
                                return this.getContextProviderFromCopyContext(aMember, parentRow, copyContext);
                            }
                            copyContext = (CopyContext)this.getOwner().getActionOfTypeForMUN(12, null);
                            if (copyContext != null) {
                                this.getMemberDescriptorList().get(0).setSucessfullyUsed(true);
                                AbstractOLAPColumn contextProvider = this.getContextProviderFromCopyContext(aMember, parentRow, copyContext);
                                return contextProvider;
                            }
                        }
                    }
                } else {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "parentRow.getParentRow() == null || !parentRow.getParentRow().isCycle()");
                }
                return null;
            }
            case 3: {
                if (isCalculation) {
                    return null;
                }
                if (this.getHierarchy().equals(aMember.getHierarchy())) {
                    if (modifyState) {
                        this.stDone = true;
                    }
                    this.getMemberDescriptorList().get(0).setSucessfullyUsed(true);
                    return this.getOwner();
                }
                return null;
            }
            case 0: {
                if (this.getHierarchy().equals(aMember.getHierarchy())) {
                    this.getMemberDescriptorList().get(0).setSucessfullyUsed(true);
                    return this.getOwner();
                }
                return null;
            }
            case 1: {
                if (isCalculation) {
                    return null;
                }
                if (!this.getHierarchy().getUniqueName().equals(aMember.getHierarchy().getUniqueName())) {
                    return null;
                }
                for (MemberDescriptor descriptor : this.getMemberDescriptorList()) {
                    GenerateContext genContext;
                    if (descriptor.getMUN() != null || !descriptor.getLevel().getUniqueName().equals(aMember.getLevel().getUniqueName())) continue;
                    descriptor.setSucessfullyUsed(true);
                    if (this.getOwner() != null && !this.getOwner().isContext() && this.getOwner().doesActionTypeApplies(2) && this.getOwner().getParentRow() != null && !this.getOwner().getParentRow().isCycle() && this.getOwner().getParentRow().getParentRow() != null && this.getOwner().getParentRow().getParentRow() == this.getOwner().getParentRow().getRootRowCycle() && (genContext = (GenerateContext)this.getOwner().getActionOfTypeForMUN(2, null)).getNumberOfContextColumns() == 1 && genContext.getContextColumn(0).getRules().getType() == 1 && genContext.getContextColumn(0).getRules().sameAs(this)) {
                        this.stDone = true;
                    }
                    return this.getOwner();
                }
                return null;
            }
            case 2: {
                column = this.appliesForMUNType(aMember, modifyState);
                if (column != null) {
                    return column;
                }
                boolean retry = false;
                if (this.wasSucessfullyUsed() != 1) {
                    for (MemberDescriptor descriptor : this.getMemberDescriptorList()) {
                        if (descriptor.wasSucessfullyUsed() || descriptor.isCalculation() || descriptor.isNoMember() || descriptor.getMUN() == null || descriptor.getLevel() == null || descriptor.getLevel().getIndex() != aMember.getLevel().getIndex() || descriptor.isCalculation()) continue;
                        XOLAPEdgeMapping.OLAPEdgeMappingIterator edgeMappingIterator = this.getOwner().getIterator();
                        if (edgeMappingIterator == null) {
                            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "edgeMappingIterator == null");
                        }
                        retry = edgeMappingIterator.fixMUNDescriptors(this.getMemberDescriptorList());
                        break;
                    }
                }
                if (retry) {
                    column = this.appliesForMUNType(aMember, modifyState);
                }
                return column;
            }
            case 6: {
                this.setType(2);
                column = this.applies(aMember, modifyState);
                if (column != null) {
                    this.setType(6);
                    return column;
                }
                if (isCalculation) {
                    this.setType(6);
                    return null;
                }
                this.setType(0);
                this.stSucessfullyUsed = -1;
                column = this.applies(aMember, modifyState);
                if (column != null) {
                    this.setType(6);
                    return column;
                }
                this.setType(6);
                return null;
            }
            case 5: {
                if (this.getNextMemberListIndex() == 0) {
                    for (MemberDescriptor currMD : this.getMemberDescriptorList()) {
                        if (currMD.getMUN() != null) break;
                        if (!currMD.getLevel().equals(aMember.getLevel())) continue;
                        this.setType(1);
                        this.stSucessfullyUsed = -1;
                        column = this.applies(aMember, modifyState);
                        if (column == null) continue;
                        this.setType(5);
                        return column;
                    }
                }
                this.setType(2);
                column = this.applies(aMember, modifyState);
                if (column != null) {
                    this.setType(5);
                    return column;
                }
                if (isCalculation) {
                    this.setType(5);
                    return null;
                }
                this.setType(1);
                this.stSucessfullyUsed = -1;
                column = this.applies(aMember, modifyState);
                if (column != null) {
                    this.setType(5);
                    return column;
                }
                this.setType(5);
                return null;
            }
        }
        this.validateRuleType(this.getType());
        return null;
    }

    private AbstractOLAPColumn appliesForMUNType(IMember aMember, boolean modifyState) {
        boolean isSingleMUNRule;
        String aMUN = aMember.getUniqueName();
        boolean bl = isSingleMUNRule = this.getMemberDescriptorList().size() == 1 && this.getMemberDescriptorList().get(0).getMUN().equals(aMUN);
        if (isSingleMUNRule) {
            if (modifyState) {
                this.stDone = true;
                this.incrementNextMemberListIndex();
            }
            this.getMemberDescriptorList().get(0).setSucessfullyUsed(true);
            return this.getOwner();
        }
        int orgNexMemberListIndex = this.getNextMemberListIndex();
        for (int index = this.getNextMemberListIndex(); index < this.getMemberDescriptorList().size(); ++index) {
            String currUniqueName = this.getMemberDescriptorList().get(index).getMUN();
            if (currUniqueName == null || !aMUN.equals(currUniqueName)) continue;
            if (this.getType() == 2 && modifyState) {
                if (this.getOwner().getParentRow() != null && !this.getOwner().getParentRow().isMultiHierarchy()) {
                    this.incrementNextMemberListIndex();
                } else {
                    this.setNextMemberListIndex(index);
                }
                if (index == this.memberDescriptorList.size() - 1) {
                    this.stDone = true;
                }
            }
            if (!modifyState) {
                this.setNextMemberListIndex(orgNexMemberListIndex);
            }
            this.getMemberDescriptorList().get(index).setSucessfullyUsed(true);
            return this.getOwner();
        }
        if (!modifyState) {
            this.setNextMemberListIndex(orgNexMemberListIndex);
        }
        return null;
    }

    private AbstractOLAPColumn getContextProviderFromCopyContext(IMember aMember, AbstractOLAPRow parentRow, CopyContext copyContext) {
        List<CopyContext.ContextSourceCoordidates> froms = copyContext.getFrom();
        for (CopyContext.ContextSourceCoordidates currFrom : froms) {
            AbstractOLAPColumn contextProvider = parentRow.getParentRow().findColumnById(currFrom.getElementId());
            GenerateContext generateContext = (GenerateContext)contextProvider.getActionOfTypeForMUN(2, null);
            if (generateContext == null || generateContext.findApplicableContextColumn(aMember) == null) continue;
            return contextProvider;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.memberDescriptorList == null;
    }

    public void capture(Element inputRules) {
        Attribute attribute = inputRules.attribute("tuplePosition");
        if (attribute == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "attribute == null");
        }
        String sTuplePosition = attribute.getValue();
        if (sTuplePosition == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "sTuplePosition == null");
        }
        this.setTuplePosition(Integer.parseInt(sTuplePosition));
        attribute = inputRules.attribute("isReportHierarchy");
        if (attribute != null) {
            boolean value = attribute.getStringValue().equals("true");
            this.setReportHierarchy(value);
        }
    }

    public void dump(XQETrace trace) {
        trace.beginElement("rules", -1);
        if (this.getTuplePosition() == -1) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "tuplePosition == -1");
        }
        trace.attribute("tuplePosition", this.getTuplePosition());
        trace.attribute("type", this.typeToString());
        if (this.getIsReportHierarchy() != null && this.isReportHierarchy() == Boolean.FALSE.booleanValue()) {
            trace.attribute("isReportHierarchy", this.isReportHierarchy());
        }
        if (this.ignoreMemberListIndex()) {
            trace.attribute("ignoreMemberListIndex", this.ignoreMemberListIndex());
        }
        if (this.memberDescriptorList != null) {
            for (MemberDescriptor descriptor : this.memberDescriptorList) {
                descriptor.dump(trace);
            }
        }
        trace.endElement();
        if (this.calculatedMemberList != null) {
            trace.beginElement("calculatedMUNs", -1);
            for (MemberDescriptor calculatedMember : this.calculatedMemberList) {
                calculatedMember.dump(trace);
            }
            trace.endElement();
        }
    }

    public boolean isDone() {
        return this.stDone;
    }

    public boolean hasSingleMUN() {
        return this.getType() == 2 && this.getMemberDescriptorList().size() == 1;
    }

    public String dumpToString() {
        XQETrace trace = new XQETrace();
        trace.setNodeIDGenerator(null);
        trace.setTraceLevelAll();
        trace.setIndentString(" ");
        StringWriter stringWriter = new StringWriter();
        trace.addStream(stringWriter);
        this.dump(trace);
        return stringWriter.toString();
    }

    public void reset() {
        this.stDone = false;
        this.resetNextMemberListIndex();
    }

    public EdgeMappingRules copy(EdgeMappingRules newRules) {
        newRules.setTuplePosition(this.getTuplePosition());
        newRules.setType(this.getType());
        if (this.getType() == 2 || this.getType() == 5 || this.getType() == 6) {
            newRules.setCalculatedMemberList(this.getCalculatedMemberList());
        }
        if (this.getMemberDescriptorList() != null) {
            newRules.memberDescriptorList = new ArrayList<MemberDescriptor>();
            for (MemberDescriptor currMemberDescriptor : this.memberDescriptorList) {
                newRules.memberDescriptorList.add(currMemberDescriptor.copy());
            }
        }
        if (this.memberMapByName != null) {
            for (String mun : this.memberMapByName.keySet()) {
                newRules.mapMemberByName(this.memberMapByName.get(mun));
            }
        }
        newRules.setReportHierarchy(this.isReportHierarchy());
        newRules.setIgnoreMemberListIndex(this.ignoreMemberListIndex());
        return newRules;
    }

    private void mapMemberByName(AbstractMDXMember abstractMDXMember) {
        if (this.memberMapByName == null) {
            this.memberMapByName = new HashMap<String, AbstractMDXMember>();
        }
        this.memberMapByName.put(EdgeMappingUtils.getMemberUniqueName(abstractMDXMember), abstractMDXMember);
    }

    public void rebuildMUNRules(OLAPRowCycle rootRowCycle, EdgeElementFactory edgeElementFactory) {
        List<AbstractMDXMember> replacements;
        if (this.getType() != 2 && this.getType() != 5) {
            return;
        }
        if (this.memberMapByName == null) {
            return;
        }
        if (this.memberMapByName.isEmpty()) {
            return;
        }
        ArrayList<MemberDescriptor> newMemberDescriptorListForDuplication = new ArrayList<MemberDescriptor>();
        ArrayList<MemberDescriptor> orgMemberDescriptorListForDuplication = new ArrayList<MemberDescriptor>();
        ArrayList<MemberDescriptor> newMemberDescriptorList = new ArrayList<MemberDescriptor>();
        ArrayList<MemberDescriptor> newCalculatedMemberList = new ArrayList<MemberDescriptor>();
        for (MemberDescriptor descriptor : this.getMemberDescriptorList()) {
            AbstractMDXMember abstractMDXMember = this.memberMapByName.get(descriptor.getMUN());
            if (abstractMDXMember == null) {
                newMemberDescriptorList.add(descriptor);
                if (!descriptor.isCalculation()) continue;
                newCalculatedMemberList.add(descriptor);
                rootRowCycle.addCalculatedMemberMUN(descriptor.getMUN());
                continue;
            }
            if (descriptor.isCalculation()) {
                MDXEdge mdxEdge = null;
                replacements = abstractMDXMember.getReplacementMemberListForTransf("replacementsForOptimizeGenerateOnSingleMember");
                if (replacements != null && !replacements.isEmpty()) {
                    if (this.getOwner().isContext()) {
                        this.memberMapByName.remove(EdgeMappingUtils.getMemberUniqueName(abstractMDXMember));
                        abstractMDXMember = replacements.get(0);
                        this.mapMemberByName(abstractMDXMember);
                        OLAPRowCycle parentRowCycle = (OLAPRowCycle)this.getOwner().getParentRow();
                        int numOfQualifiedCols = this.getNumOfQualifiedCols(parentRowCycle);
                        int replacementIndex = 0;
                        int numOfSkippedColumns = 0;
                        for (int i = 0; i < parentRowCycle.getNumberOfRows(); ++i) {
                            AbstractOLAPRow currRow = parentRowCycle.getRow(i);
                            for (int j = 0; j < currRow.getNumberOfColumns(); ++j) {
                                AbstractOLAPColumn currColumn = currRow.getColumn(j);
                                int currColumnTuplePosition = currColumn.getTuplePosition();
                                if (currColumnTuplePosition != this.getOwner().getTuplePosition() || currColumn.getRulesType() != 4 || currColumn.isContextMember()) continue;
                                if (numOfQualifiedCols - numOfSkippedColumns >= replacements.size()) {
                                    ++numOfSkippedColumns;
                                    continue;
                                }
                                currColumn.setRules(null);
                                MDXCalculatedMemberReference currReplacement = (MDXCalculatedMemberReference)replacements.get(++replacementIndex);
                                if (mdxEdge == null) {
                                    mdxEdge = (MDXEdge)currReplacement.getAncestorOfType(1006);
                                }
                                while (!mdxEdge.isProjectedDescendant(currReplacement)) {
                                    if (replacementIndex == replacements.size()) {
                                        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "replacementIndex == replacements.size()");
                                    }
                                    currReplacement = (MDXCalculatedMemberReference)replacements.get(++replacementIndex);
                                }
                                currColumn.addRule(currReplacement);
                                currColumn.setTuplePosition(currColumnTuplePosition);
                                rootRowCycle.addCalculatedMemberMUN(EdgeMappingUtils.getMemberUniqueName(currReplacement));
                                this.getOwner().copyActions(edgeElementFactory, currColumn);
                                if (!currColumn.doesActionTypeApplies(8) && !currColumn.doesActionTypeApplies(9)) continue;
                                currColumn.rebuildMUNForRename(descriptor.getMUN(), EdgeMappingUtils.getMemberUniqueName(currReplacement));
                            }
                        }
                    } else {
                        ArrayList<AbstractMDXMember> toRemove = null;
                        if (replacements.size() > 1) {
                            toRemove = new ArrayList<AbstractMDXMember>();
                        }
                        for (AbstractMDXMember replacement : replacements) {
                            if (mdxEdge == null) {
                                mdxEdge = (MDXEdge)replacement.getAncestorOfType(1006);
                            }
                            if (mdxEdge.isProjectedDescendant(replacement)) {
                                this.memberMapByName.remove(EdgeMappingUtils.getMemberUniqueName(abstractMDXMember));
                                abstractMDXMember = replacement;
                                this.mapMemberByName(replacement);
                                if (toRemove == null) break;
                                toRemove.add(replacement);
                                break;
                            }
                            if (toRemove == null) continue;
                            toRemove.add(replacement);
                        }
                        if (toRemove != null) {
                            for (AbstractMDXMember replacement : toRemove) {
                                replacements.remove(replacement);
                            }
                        }
                    }
                }
            }
            MemberDescriptor newDescriptor = new MemberDescriptor(abstractMDXMember);
            newMemberDescriptorList.add(newDescriptor);
            if (!descriptor.isCalculation()) continue;
            MDXCalculatedMemberReference calc = (MDXCalculatedMemberReference)abstractMDXMember;
            List<AbstractMDXMember> replacements2 = calc.getReplacementMemberListForTransf("replacementsForBreakApartUnionForCogMDXGroup");
            if (replacements2 != null && !replacements2.isEmpty()) {
                orgMemberDescriptorListForDuplication.add(descriptor);
                newMemberDescriptorListForDuplication.add(newDescriptor);
            }
            newCalculatedMemberList.add(newDescriptor);
            rootRowCycle.addCalculatedMemberMUN(newDescriptor.getMUN());
            if (!this.getOwner().doesActionTypeApplies(8) && !this.getOwner().doesActionTypeApplies(9)) continue;
            this.getOwner().rebuildMUNForRename(descriptor.getMUN(), newDescriptor.getMUN());
        }
        for (int i = 0; i < newMemberDescriptorListForDuplication.size(); ++i) {
            MemberDescriptor newDescriptor = (MemberDescriptor)newMemberDescriptorListForDuplication.get(i);
            MemberDescriptor orgDescriptor = (MemberDescriptor)orgMemberDescriptorListForDuplication.get(i);
            MDXCalculatedMemberReference orgCalc = (MDXCalculatedMemberReference)this.memberMapByName.get(orgDescriptor.getMUN());
            replacements = orgCalc.getReplacementMemberListForTransf("replacementsForBreakApartUnionForCogMDXGroup");
            for (AbstractMDXMember replacement : replacements) {
                this.mapMemberByName(replacement);
                MemberDescriptor duplicateOfDescriptor = new MemberDescriptor(replacement);
                int index = newMemberDescriptorList.indexOf(newDescriptor);
                newMemberDescriptorList.add(index, duplicateOfDescriptor);
                newCalculatedMemberList.add(duplicateOfDescriptor);
                rootRowCycle.addCalculatedMemberMUN(duplicateOfDescriptor.getMUN());
                if (!this.getOwner().hasActions()) continue;
                List<IEdgeElementMappingAction> orgActions = this.getOwner().getActionsForMUN(orgDescriptor.getMUN());
                for (IEdgeElementMappingAction orgAction : orgActions) {
                    IEdgeElementMappingAction duplicateAction = orgAction.copy(edgeElementFactory);
                    duplicateAction.setTargetUniqueName(duplicateOfDescriptor.getMUN());
                    this.getOwner().addAction(duplicateAction);
                }
            }
        }
        this.setMemberDescriptorList(newMemberDescriptorList);
        this.setCalculatedMemberList(newCalculatedMemberList);
    }

    public void rebuildMUNRulesForPowerCubeRootAliases() {
        if (this.getType() != 2 && this.getType() != 5) {
            return;
        }
        if (this.memberMapByName == null) {
            return;
        }
        if (this.memberMapByName.isEmpty()) {
            return;
        }
        for (MemberDescriptor descriptor : this.getMemberDescriptorList()) {
            AbstractMDXMember abstractMDXMember = this.memberMapByName.get(descriptor.getMUN());
            if (abstractMDXMember == null || !descriptor.getMUN().endsWith(".[*]")) continue;
            String rootMemberMUN = abstractMDXMember.getHierarchy().getRootMember().getUniqueName();
            descriptor.setMUN(rootMemberMUN);
        }
    }

    public void rebuildMUNRulesForNoMember() {
        if (this.getType() != 2 && this.getType() != 5) {
            return;
        }
        if (this.memberMapByName == null) {
            return;
        }
        if (this.memberMapByName.isEmpty()) {
            return;
        }
        if (!this.getOwner().isHierarchyNormalization()) {
            return;
        }
        for (MemberDescriptor descriptor : this.getMemberDescriptorList()) {
            AbstractMDXMember abstractMDXMember = this.memberMapByName.get(descriptor.getMUN());
            if (abstractMDXMember == null || abstractMDXMember.getType() != 1077 || !EdgeMappingRules.setNoMemberUniqueName(abstractMDXMember, null)) continue;
            String defaultMemberMUN = abstractMDXMember.getHierarchy().getUniqueName() + NOMEMBER_NAME;
            descriptor.setMUN(defaultMemberMUN);
        }
    }

    public static boolean setNoMemberUniqueName(AbstractMDXMember member, StringBuilder msgStr) {
        if (!((MDXDefaultMember)member).getPropertyIsNoMember()) {
            if (msgStr != null) {
                msgStr.append("Default Member is not NoMember.");
            }
            return false;
        }
        IHierarchy hierarchy = member.getHierarchy();
        if (hierarchy.equals(hierarchy.getDimension().getDefaultHierarchy())) {
            if (msgStr != null) {
                msgStr.append("Default Member is from default hierarchy.");
            }
            return false;
        }
        return true;
    }

    public void rebuildMUNRulesForReplacedRootMember(BaseMember replacedRootMember, AbstractMDXMember replacement, ActionFactory actionFactory) {
        boolean isReplacedRootMember;
        if (this.getType() != 2 && this.getType() != 5) {
            return;
        }
        if (this.memberMapByName == null) {
            return;
        }
        if (this.memberMapByName.isEmpty()) {
            return;
        }
        String replacedRootMemberMUN = EdgeMappingUtils.getMemberUniqueName(replacedRootMember);
        if (!this.memberMapByName.containsKey(replacedRootMemberMUN)) {
            return;
        }
        AbstractMDXMember mappedMember = this.memberMapByName.get(replacedRootMemberMUN);
        boolean bl = isReplacedRootMember = mappedMember == replacedRootMember;
        if (!isReplacedRootMember) {
            Object currReplacement;
            Iterator<AbstractMDXMember> iterator;
            List<AbstractMDXMember> replacements = mappedMember.getReplacementMemberListForTransf("replacementsForOptimizeGenerateOnSingleMember");
            if (replacements != null && !replacements.isEmpty()) {
                iterator = replacements.iterator();
                while (iterator.hasNext() && !(isReplacedRootMember = (currReplacement = iterator.next()) == replacedRootMember)) {
                }
            }
            if (!isReplacedRootMember) {
                replacements = mappedMember.getReplacementMemberListForTransf("replacementsForBreakApartUnionForCogMDXGroup");
                if (replacements != null && !replacements.isEmpty()) {
                    iterator = replacements.iterator();
                    while (iterator.hasNext() && !(isReplacedRootMember = (currReplacement = iterator.next()) == replacedRootMember)) {
                    }
                }
                if (!isReplacedRootMember) {
                    return;
                }
            }
        }
        this.mapMemberByName(replacement);
        int descriptorIndex = -1;
        MemberDescriptor oldMemberDescriptor = null;
        for (MemberDescriptor descriptor : this.getMemberDescriptorList()) {
            ++descriptorIndex;
            if (!descriptor.getMUN().equals(replacedRootMemberMUN)) continue;
            oldMemberDescriptor = descriptor;
            break;
        }
        if (oldMemberDescriptor == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "oldMemberDescriptor == null");
        }
        MemberDescriptor newMemberDescriptor = new MemberDescriptor(replacement);
        this.memberDescriptorList.add(descriptorIndex, newMemberDescriptor);
        if (isReplacedRootMember) {
            oldMemberDescriptor.setDelete(true);
        }
        RenameV5 renameV5 = (RenameV5)actionFactory.createActionByType(8);
        String v5MUN = UniqueNameGenerator.createMemberV5UniqueName(replacedRootMember.getHierarchy().getLevel(0), replacedRootMember.getExternalName());
        renameV5.setV5Name(v5MUN);
        renameV5.setV5Caption(replacedRootMember.getHierarchy().getRootMember().getCaptionValue().getString());
        renameV5.setTargetUniqueName(EdgeMappingUtils.getMemberUniqueName(replacement));
        this.getOwner().addAction(renameV5);
        ResetIsCalculation resetIsCalculation = (ResetIsCalculation)actionFactory.createActionByType(11);
        resetIsCalculation.setCalculation(false);
        this.getOwner().addAction(resetIsCalculation);
    }

    public void cleanDeletedMemberDescriptors() {
        if (this.getType() == 0 && this.getMemberDescriptorList() == null && this.getOwner().getParentRow().doesActionTypeApplies(5)) {
            return;
        }
        ArrayList<MemberDescriptor> copyOfMemberDescriptorList = new ArrayList<MemberDescriptor>();
        copyOfMemberDescriptorList.addAll(this.getMemberDescriptorList());
        for (MemberDescriptor descriptor : copyOfMemberDescriptorList) {
            if (!descriptor.isDelete()) continue;
            this.memberMapByName.remove(descriptor.getMUN());
            this.getMemberDescriptorList().remove(descriptor);
        }
    }

    public boolean isKnownCalculation(String calcUniqueName) {
        if (this.getOwner().getParentRow() == null || this.getCalculatedMemberMUNList() == null || this.getCalculatedMemberMUNList().isEmpty()) {
            return false;
        }
        return this.getCalculatedMemberMUNList().contains(calcUniqueName);
    }

    public boolean isRulesForCalculations() {
        boolean noCalculatedMemberList;
        boolean bl = noCalculatedMemberList = this.calculatedMemberList == null || this.calculatedMemberList.isEmpty() || this.getType() != 2;
        if (noCalculatedMemberList) {
            return false;
        }
        return this.calculatedMemberList.size() == this.memberDescriptorList.size();
    }

    public IHierarchy getHierarchy() {
        IHierarchy hierarchyOfOwner = this.getOwner().getHierarchy();
        if (hierarchyOfOwner != null) {
            return hierarchyOfOwner;
        }
        if (this.memberDescriptorList == null || this.memberDescriptorList.isEmpty()) {
            return null;
        }
        return this.memberDescriptorList.get(0).getHierarchy();
    }

    public void addHierarchy(IHierarchy aHierarchy) {
        if (this.getMemberDescriptorList() == null) {
            this.memberDescriptorList = new ArrayList<MemberDescriptor>();
        }
        if (!this.memberDescriptorList.isEmpty()) {
            ArrayList<MemberDescriptor> temp = new ArrayList<MemberDescriptor>();
            temp.addAll(this.memberDescriptorList);
            for (MemberDescriptor descriptor : temp) {
                if (descriptor.getMUN() != null) continue;
                this.memberDescriptorList.remove(descriptor);
            }
        }
        if (this.memberDescriptorList.isEmpty()) {
            this.setType(0);
        } else {
            this.setType(6);
        }
        this.memberDescriptorList.add(new MemberDescriptor(aHierarchy));
    }

    public void addLevel(ILevel aLevel) {
        int newType = this.mergeRuleType(1, false);
        if (newType == 1 || newType == 5) {
            if (this.memberDescriptorList == null) {
                this.memberDescriptorList = new ArrayList<MemberDescriptor>();
            }
            if (!this.contains(aLevel)) {
                this.getMemberDescriptorList().add(new MemberDescriptor(aLevel));
            }
        }
    }

    public void replaceMUNRulesWithLUNRules() {
        this.setType(1);
        ArrayList<MemberDescriptor> descriptorsToRemove = new ArrayList<MemberDescriptor>();
        for (MemberDescriptor descriptor : this.getMemberDescriptorList()) {
            if (descriptor.getMUN() == null) continue;
            ILevel memberLevel = descriptor.getLevel();
            if (!this.contains(memberLevel)) {
                descriptor.setMUN(null);
                continue;
            }
            descriptorsToRemove.add(descriptor);
        }
        this.memberDescriptorList.removeAll(descriptorsToRemove);
    }

    public void replaceWithHUNRules() {
        this.setType(0);
        ArrayList<MemberDescriptor> descriptorsToRemove = new ArrayList<MemberDescriptor>();
        boolean firstTime = true;
        IHierarchy hierarchy = null;
        for (MemberDescriptor descriptor : this.getMemberDescriptorList()) {
            if (descriptor.getHierarchy() != null && hierarchy == null) {
                hierarchy = descriptor.getHierarchy();
            }
            if (firstTime) {
                firstTime = false;
                if (descriptor.getMUN() != null) {
                    descriptor.setMUN(null);
                }
                if (descriptor.getLevel() == null) continue;
                descriptor.setLevel(null);
                continue;
            }
            descriptorsToRemove.add(descriptor);
        }
        this.memberDescriptorList.removeAll(descriptorsToRemove);
        if (this.memberDescriptorList.isEmpty()) {
            this.memberDescriptorList.add(new MemberDescriptor(hierarchy));
        }
    }

    public void addMember(AbstractMDXMember aMember) {
        MemberDescriptor descriptor = new MemberDescriptor(aMember);
        int newType = this.mergeRuleType(2, descriptor.isCalculation());
        if (newType == 2 || newType == 5 || newType == 6) {
            if (this.getMemberDescriptorList() == null) {
                this.memberDescriptorList = new ArrayList<MemberDescriptor>();
            }
            if (descriptor.isCalculation()) {
                if (this.calculatedMemberList == null) {
                    this.calculatedMemberList = new ArrayList<MemberDescriptor>();
                }
                this.calculatedMemberList.add(descriptor);
            }
            this.getMemberDescriptorList().add(descriptor);
            this.mapMemberByName(aMember);
            if (aMember.getType() == 1013) {
                ((MDXCalculatedMemberReference)aMember).addEdgeMappingColumn(this.getOwner().getId());
            }
        }
    }

    public List<MemberDescriptor> getMemberDescriptorList() {
        return this.memberDescriptorList;
    }

    public void setMemberDescriptorList(List<MemberDescriptor> aMemberDescriptorList) {
        this.memberDescriptorList = aMemberDescriptorList;
    }

    public List<MemberDescriptor> getCalculatedMemberList() {
        return this.calculatedMemberList;
    }

    public void setCalculatedMemberList(List<MemberDescriptor> aCalculatedMemberList) {
        this.calculatedMemberList = aCalculatedMemberList;
    }

    public List<String> getCalculatedMemberMUNList() {
        return this.getOwner().getParentRow().getRootRowCycle().getCalculatedMemberMUNList();
    }

    public int mergeRuleType(int newRuleType, boolean forCalculation) {
        if (this.isEmpty()) {
            this.setType(newRuleType);
            return this.getType();
        }
        if (this.getType() == newRuleType) {
            return this.getType();
        }
        String errorMsg = "this.getType()?";
        IHierarchy hierarchy = this.getHierarchy();
        block0 : switch (newRuleType) {
            case 3: 
            case 4: 
            case 7: {
                this.setType(newRuleType);
                return this.getType();
            }
            case 1: {
                switch (this.getType()) {
                    case 2: {
                        this.setType(5);
                        break block0;
                    }
                    case 0: 
                    case 5: 
                    case 6: {
                        break block0;
                    }
                }
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "this.getType()?");
            }
            case 2: {
                switch (this.getType()) {
                    case 1: {
                        this.setType(5);
                        break block0;
                    }
                    case 0: {
                        if (!forCalculation) break block0;
                        this.setType(6);
                        break block0;
                    }
                    case 5: 
                    case 6: {
                        break block0;
                    }
                    default: {
                        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "this.getType()?");
                    }
                }
            }
            case 0: {
                switch (this.getType()) {
                    case 1: {
                        this.setType(0);
                        this.memberDescriptorList.clear();
                        this.memberDescriptorList.add(new MemberDescriptor(hierarchy));
                        break block0;
                    }
                    case 2: {
                        if (this.calculatedMemberList != null) {
                            this.setType(6);
                            this.memberDescriptorList.clear();
                            this.memberDescriptorList.addAll(this.calculatedMemberList);
                            break block0;
                        }
                        this.setType(0);
                        this.memberDescriptorList.clear();
                        this.memberDescriptorList.add(new MemberDescriptor(hierarchy));
                        break block0;
                    }
                    case 5: {
                        this.setType(6);
                        boolean hierFirst = this.memberDescriptorList.get(0) instanceof ILevel;
                        this.memberDescriptorList.clear();
                        if (hierFirst) {
                            this.memberDescriptorList.add(new MemberDescriptor(hierarchy));
                        }
                        if (this.calculatedMemberList != null) {
                            this.memberDescriptorList.clear();
                            this.memberDescriptorList.addAll(this.calculatedMemberList);
                        }
                        if (hierFirst) break block0;
                        this.memberDescriptorList.add(new MemberDescriptor(hierarchy));
                        break block0;
                    }
                    case 6: {
                        break block0;
                    }
                    default: {
                        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "this.getType()?");
                    }
                }
            }
            case 5: {
                switch (this.getType()) {
                    case 1: 
                    case 2: {
                        this.setType(5);
                        break block0;
                    }
                    case 0: {
                        this.setType(6);
                        break block0;
                    }
                }
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "this.getType()?");
            }
            case 6: {
                switch (this.getType()) {
                    case 1: {
                        this.setType(6);
                        this.memberDescriptorList.clear();
                        this.memberDescriptorList.add(new MemberDescriptor(hierarchy));
                        break block0;
                    }
                    case 0: 
                    case 2: {
                        this.setType(6);
                        break block0;
                    }
                    case 5: {
                        this.setType(6);
                        boolean hierFirst = this.memberDescriptorList.get(0) instanceof ILevel;
                        this.memberDescriptorList.clear();
                        if (hierFirst) {
                            this.memberDescriptorList.add(new MemberDescriptor(hierarchy));
                        }
                        if (this.calculatedMemberList != null) {
                            this.memberDescriptorList.addAll(this.calculatedMemberList);
                        }
                        if (hierFirst) break block0;
                        this.memberDescriptorList.add(new MemberDescriptor(hierarchy));
                        break block0;
                    }
                    case 6: {
                        break block0;
                    }
                    default: {
                        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "this.getType()?");
                    }
                }
            }
            default: {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "ruleType?");
            }
        }
        return this.getType();
    }

    private boolean contains(ILevel aLevel) {
        String aLUN = aLevel.getUniqueName();
        for (MemberDescriptor descriptor : this.memberDescriptorList) {
            if (descriptor.getMUN() != null || descriptor.getLevel() == null || !descriptor.getLevel().getUniqueName().equals(aLUN)) continue;
            return true;
        }
        return false;
    }

    public boolean sameAs(EdgeMappingRules aRule) {
        IHierarchy hierarchyOfThis = this.getHierarchy();
        IHierarchy hierarchyOfaRule = aRule.getHierarchy();
        if (hierarchyOfThis == null || hierarchyOfaRule == null) {
            return false;
        }
        if (!hierarchyOfThis.equals(hierarchyOfaRule)) {
            return false;
        }
        if (aRule.getMemberDescriptorList().size() != aRule.getMemberDescriptorList().size()) {
            return false;
        }
        int descriptorIdx = -1;
        block6: for (MemberDescriptor descriptor : this.getMemberDescriptorList()) {
            MemberDescriptor aDescriptor = aRule.getMemberDescriptorList().get(++descriptorIdx);
            switch (this.getType()) {
                case 0: 
                case 3: 
                case 4: 
                case 7: {
                    continue block6;
                }
                case 1: {
                    if (descriptor.getLevel() == null || descriptor.getLevel().equals(aDescriptor.getLevel())) continue block6;
                    return false;
                }
                case 2: {
                    if (descriptor.getMUN() == null || descriptor.getMUN().equals(aDescriptor.getMUN())) continue block6;
                    return false;
                }
                case 5: 
                case 6: {
                    if (!(descriptor.getMUN() == null ? (descriptor.getLevel() != null || this.getType() != 6) && descriptor.getLevel() != null && !descriptor.getLevel().equals(aDescriptor.getLevel()) : !descriptor.getMUN().equals(aDescriptor.getMUN()))) continue block6;
                    return false;
                }
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, UNKNOWN_TYPE);
        }
        return true;
    }

    public boolean overlaps(EdgeMappingRules aRule) {
        boolean bl;
        boolean bl2;
        boolean onlyOneIsCurrentMember;
        boolean oneIsCurrentMemberAnotherIsHierarchy;
        boolean areBothCurrentMember;
        boolean oneMatchesAHierarchyOtherMatchesALevel;
        IHierarchy hierarchyOfThis = this.getHierarchy();
        IHierarchy hierarchyOfaRule = aRule.getHierarchy();
        if (hierarchyOfThis == null || hierarchyOfaRule == null) {
            return false;
        }
        if (!hierarchyOfThis.equals(hierarchyOfaRule)) {
            return false;
        }
        if (!(this.getType() != 0 && this.getType() != 3 && this.getType() != 6 || aRule.getType() != 0 && aRule.getType() != 3 && aRule.getType() != 6)) {
            return true;
        }
        boolean bl3 = oneMatchesAHierarchyOtherMatchesALevel = !((this.getType() != 0 && this.getType() != 3 && this.getType() != 6 || aRule.getType() != 1 && aRule.getType() != 5) && (aRule.getType() != 0 && aRule.getType() != 3 && aRule.getType() != 6 || this.getType() != 1 && this.getType() != 5));
        if (oneMatchesAHierarchyOtherMatchesALevel) {
            return true;
        }
        boolean bl4 = areBothCurrentMember = this.getType() == 4 && aRule.getType() == 4 || this.getType() == 7 && aRule.getType() == 7 || this.getType() == 4 && aRule.getType() == 7 || this.getType() == 7 && aRule.getType() == 4;
        if (areBothCurrentMember) {
            return true;
        }
        boolean bl5 = oneIsCurrentMemberAnotherIsHierarchy = this.getType() == 4 && aRule.getType() == 0 || this.getType() == 0 && aRule.getType() == 4;
        if (oneIsCurrentMemberAnotherIsHierarchy) {
            List<MemberDescriptor> membersOfThis = this.getMemberDescriptorList();
            List<MemberDescriptor> membersOfARule = aRule.getMemberDescriptorList();
            for (MemberDescriptor memberDescriptor : membersOfThis) {
                for (MemberDescriptor memberDescriptor2 : membersOfARule) {
                    if (!memberDescriptor.sameHierarchy(memberDescriptor2)) continue;
                    return true;
                }
            }
        }
        boolean bl6 = onlyOneIsCurrentMember = (this.getType() == 4 || this.getType() == 7) && aRule.getType() != 4 && aRule.getType() != 7 || this.getType() != 4 && this.getType() != 7 && (aRule.getType() == 4 || aRule.getType() == 7);
        if (onlyOneIsCurrentMember) {
            return false;
        }
        List<MemberDescriptor> membersOfThis = this.getMemberDescriptorList();
        if (membersOfThis == null) {
            if (this.getType() == 0 && this.getOwner().getParentRow().doesActionTypeApplies(5)) {
                return false;
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "membersOfThis == null");
        }
        List<MemberDescriptor> membersOfARule = aRule.getMemberDescriptorList();
        if (membersOfARule == null) {
            if (aRule.getType() == 0 && aRule.getOwner().getParentRow().doesActionTypeApplies(5)) {
                return false;
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "membersOfARule == null");
        }
        if (this.getType() == 2 && aRule.getType() == 2) {
            for (MemberDescriptor memberDescriptor : membersOfThis) {
                for (MemberDescriptor memberDescriptor3 : membersOfARule) {
                    if (!memberDescriptor.sameMUN(memberDescriptor3)) continue;
                    return true;
                }
            }
        }
        if (this.getType() == 1 && aRule.getType() == 1) {
            for (MemberDescriptor memberDescriptor : membersOfThis) {
                for (MemberDescriptor memberDescriptor4 : membersOfARule) {
                    if (!memberDescriptor.sameLevel(memberDescriptor4)) continue;
                    return true;
                }
            }
        }
        if (this.getType() == 1 && aRule.getType() == 5 || this.getType() == 5 && aRule.getType() == 1) {
            for (MemberDescriptor memberDescriptor : membersOfThis) {
                for (MemberDescriptor memberDescriptor5 : membersOfARule) {
                    if (!memberDescriptor.sameLevel(memberDescriptor5)) continue;
                    return true;
                }
            }
        }
        boolean bl7 = bl2 = this.getType() == 2 && aRule.getType() == 0 || this.getType() == 0 && aRule.getType() == 2;
        if (bl2) {
            if (this.getType() == 2 && this.isRulesForCalculations()) {
                return false;
            }
            if (aRule.getType() == 2 && aRule.isRulesForCalculations()) {
                return false;
            }
            for (MemberDescriptor memberDescriptor : membersOfThis) {
                Iterator<MemberDescriptor> iterator = membersOfARule.iterator();
                if (!iterator.hasNext()) continue;
                MemberDescriptor memberOfARule2 = iterator.next();
                return memberDescriptor.sameHierarchy(memberOfARule2);
            }
        }
        boolean bl8 = bl = this.getType() == 2 && aRule.getType() == 1 || this.getType() == 1 && aRule.getType() == 2;
        if (bl) {
            if (this.getType() == 2 && this.isRulesForCalculations()) {
                return false;
            }
            if (aRule.getType() == 2 && aRule.isRulesForCalculations()) {
                return false;
            }
            for (MemberDescriptor memberDescriptor : membersOfThis) {
                for (MemberDescriptor memberOfARule : membersOfARule) {
                    if (!memberDescriptor.sameLevel(memberOfARule)) continue;
                    return true;
                }
            }
        }
        if (this.getType() == 2 && aRule.getType() == 5 || this.getType() == 5 && aRule.getType() == 2) {
            for (MemberDescriptor memberDescriptor : membersOfThis) {
                for (MemberDescriptor memberOfARule : membersOfARule) {
                    if (!(memberDescriptor.getMUN() != null && memberOfARule.getMUN() != null ? memberDescriptor.getMUN().equals(memberOfARule.getMUN()) : memberDescriptor.sameLevel(memberOfARule))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFillerTag() {
        StringBuilder fillerTagPrefix = new StringBuilder("XQE");
        fillerTagPrefix.append("_FT");
        return this.getType() == 2 && this.getMemberDescriptorList().size() == 1 && this.getMemberDescriptorList().get(0).getMUN().contains(fillerTagPrefix.toString());
    }

    public Boolean getIsReportHierarchy() {
        return this.isReportHierarchy;
    }

    public boolean isReportHierarchy() {
        if (this.isReportHierarchy == null) {
            return false;
        }
        return this.isReportHierarchy;
    }

    public void setReportHierarchy(boolean value) {
        this.isReportHierarchy = value ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isMUNTypeAndAllRulesHaveBeenApplied() {
        return this.getType() == 2 && this.getNextMemberListIndex() >= this.getMemberDescriptorList().size();
    }

    public void setIgnoreMemberListIndex(boolean value) {
        this.ignoreMemberListIndex = value;
    }

    public boolean ignoreMemberListIndex() {
        return this.ignoreMemberListIndex;
    }

    public int getNextMemberListIndex() {
        if (this.ignoreMemberListIndex()) {
            return 0;
        }
        return this.stNextMemberListIndex;
    }

    public void setNextMemberListIndex(int value) {
        if (!this.ignoreMemberListIndex()) {
            this.stNextMemberListIndex = value;
        }
    }

    public void incrementNextMemberListIndex() {
        if (!this.ignoreMemberListIndex()) {
            ++this.stNextMemberListIndex;
        }
    }

    public void resetNextMemberListIndex() {
        this.stNextMemberListIndex = 0;
    }

    public SortedMap<String, String> getCheckSumPropertiesMap() {
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        propertiesMap.put("type", this.typeToString());
        propertiesMap.put("tuplePosition", XQEIntegerPool.getInteger(this.getTuplePosition()).toString());
        if (this.isReportHierarchy()) {
            propertiesMap.put("isReportHierarchy", Boolean.TRUE.toString());
        }
        if (this.ignoreMemberListIndex()) {
            propertiesMap.put("ignoreMemberListIndex", Boolean.TRUE.toString());
        }
        StringBuilder sb = new StringBuilder();
        if (this.memberDescriptorList != null) {
            for (MemberDescriptor descriptor : this.memberDescriptorList) {
                sb.append(descriptor.getCheckSumPropertiesAsString(true));
            }
        }
        propertiesMap.put("memberDescriptors", sb.toString());
        return propertiesMap;
    }

    private int getNumOfQualifiedCols(OLAPRowCycle parentRowCycle) {
        int numOfQualifedCols = 0;
        for (int i = 0; i < parentRowCycle.getNumberOfRows(); ++i) {
            AbstractOLAPRow currRow = parentRowCycle.getRow(i);
            for (int j = 0; j < currRow.getNumberOfColumns(); ++j) {
                AbstractOLAPColumn currColumn = currRow.getColumn(j);
                int currColumnTuplePosition = currColumn.getTuplePosition();
                if (currColumnTuplePosition != this.getOwner().getTuplePosition() || currColumn.getRulesType() != 4 || currColumn.isContextMember()) continue;
                ++numOfQualifedCols;
            }
        }
        return numOfQualifedCols;
    }

    public class MemberDescriptor {
        private IHierarchy hierarchy = null;
        private ILevel level = null;
        private String mun = null;
        private boolean isCalculation = false;
        private boolean isNoMember = false;
        private boolean isRootMember = false;
        private boolean delete = false;
        private boolean stSucessfullyUsed = false;
        private boolean isFixed = false;

        protected MemberDescriptor(IHierarchy aHierarchy) {
            this.setHierarchy(aHierarchy);
        }

        protected MemberDescriptor(ILevel aLevel) {
            this.setHierarchy(aLevel.getHierarchy());
            this.level = aLevel;
        }

        protected MemberDescriptor(AbstractMDXMember aMember) {
            BaseMember baseMember;
            MDXQuery mdxQuery;
            this.setHierarchy(aMember.getHierarchy());
            if (!this.isMeasure()) {
                this.setLevel(aMember.getLowestReferencedLevel(this.hierarchy));
            }
            if (aMember.getType() == 1013) {
                this.setCalculation(true);
                this.setLevel(this.getHierarchy().getLevel(0));
            }
            if (aMember.getType() == 1077 && (mdxQuery = (MDXQuery)aMember.getAncestorOfType(1002)) != null) {
                this.isNoMember = mdxQuery.dataSourceRequiresNoMemberDefaultMember();
            }
            if (aMember.getType() == 1067 && (baseMember = (BaseMember)aMember).getLevel().isRootLevel() && baseMember.getHierarchy().getRootMember() != null) {
                String rootMUN = baseMember.getHierarchy().getRootMember().getUniqueName();
                if (baseMember.getExternalName().equals(rootMUN)) {
                    this.isRootMember = true;
                }
            }
            this.mun = EdgeMappingUtils.getMemberUniqueName(aMember);
        }

        public IHierarchy getHierarchy() {
            return this.hierarchy;
        }

        public void setHierarchy(IHierarchy aHierarchy) {
            this.hierarchy = aHierarchy;
        }

        public ILevel getLevel() {
            return this.level;
        }

        public void setLevel(ILevel aLevel) {
            this.level = aLevel;
        }

        public String getMUN() {
            return this.mun;
        }

        public void setMUN(String aMun) {
            this.mun = aMun;
        }

        public boolean sameHierarchy(MemberDescriptor descriptor) {
            return this.hierarchy != null && descriptor.getHierarchy() != null && this.hierarchy.getUniqueName().equals(descriptor.getHierarchy().getUniqueName());
        }

        public boolean sameLevel(MemberDescriptor descriptor) {
            return this.level != null && descriptor.getLevel() != null && this.level.getUniqueName().equals(descriptor.getLevel().getUniqueName());
        }

        public boolean sameMUN(MemberDescriptor descriptor) {
            return this.mun != null && descriptor.getMUN() != null && this.mun.equals(descriptor.getMUN());
        }

        public void dump(XQETrace trace) {
            trace.beginElement("memberDescriptor", -1);
            if (this.mun != null) {
                trace.beginElement("member", -1);
                trace.attribute("MUN", this.getMUN());
                if (this.getLevel() != null) {
                    trace.attribute("LUN", this.getLevel().getUniqueName());
                }
                trace.attribute("HUN", this.getHierarchy().getUniqueName());
                if (this.isCalculation()) {
                    trace.attribute("isCalculation", this.isCalculation());
                }
                if (this.isNoMember()) {
                    trace.attribute("isNoMember", this.isNoMember());
                }
                if (this.isFixed()) {
                    trace.attribute("isMunDescriptorFixed", true);
                }
                trace.endElement();
            } else if (this.getLevel() != null) {
                trace.beginElement("level", -1);
                trace.attribute("LUN", this.getLevel().getUniqueName());
                trace.attribute("HUN", this.getHierarchy().getUniqueName());
                trace.endElement();
            } else if (this.getHierarchy() != null) {
                trace.beginElement("hierarchy", -1);
                trace.attribute("HUN", this.getHierarchy().getUniqueName());
                trace.endElement();
            }
            trace.endElement();
        }

        public String dumpToString() {
            XQETrace trace = new XQETrace();
            trace.setNodeIDGenerator(null);
            trace.setTraceLevelAll();
            trace.setIndentString(" ");
            StringWriter stringWriter = new StringWriter();
            trace.addStream(stringWriter);
            this.dump(trace);
            return stringWriter.toString();
        }

        public String toString() {
            return this.getCheckSumPropertiesAsString(false);
        }

        public String getCheckSumPropertiesAsString(boolean mask) {
            StringBuilder sb = new StringBuilder("memberDescriptor");
            sb.append("(");
            if (this.mun != null) {
                sb.append("MUN");
                sb.append("=");
                String munValue = this.getMUN();
                if (mask && this.isCalculation()) {
                    munValue = munValue.replaceAll("_CM([0-9]+)", "_CM#");
                }
                sb.append(munValue);
                if (this.getLevel() != null) {
                    sb.append(",");
                    sb.append(" ");
                    sb.append("LUN");
                    sb.append("=");
                    sb.append(this.getLevel().getUniqueName());
                }
                sb.append(",");
                sb.append(" ");
                sb.append("HUN");
                sb.append("=");
                sb.append(this.getHierarchy().getUniqueName());
                if (this.isCalculation()) {
                    sb.append(",");
                    sb.append(" ");
                    sb.append("isCalculation");
                    sb.append("=");
                    sb.append(Boolean.TRUE.toString());
                }
                if (this.isNoMember()) {
                    sb.append(",");
                    sb.append(" ");
                    sb.append("isNoMember");
                    sb.append("=");
                    sb.append(Boolean.TRUE.toString());
                }
            } else {
                if (this.getLevel() != null) {
                    sb.append("LUN");
                    sb.append("=");
                    sb.append(this.getLevel().getUniqueName());
                    sb.append(",");
                    sb.append(" ");
                }
                sb.append("HUN");
                sb.append("=");
                sb.append(this.getHierarchy().getUniqueName());
            }
            sb.append(")");
            return sb.toString();
        }

        public boolean isMeasure() {
            return this.hierarchy != null && this.hierarchy.getDimension().isMeasuresDimension();
        }

        public boolean isCalculation() {
            return this.isCalculation;
        }

        public void setCalculation(boolean value) {
            this.isCalculation = value;
        }

        public boolean isNoMember() {
            return this.isNoMember;
        }

        public void setNoMember(boolean value) {
            this.isNoMember = value;
        }

        public boolean isRootMember() {
            return this.isRootMember;
        }

        public void setRootMember(boolean value) {
            this.isRootMember = value;
        }

        public MemberDescriptor copy() {
            MemberDescriptor newMemberDescriptor = new MemberDescriptor(this.getHierarchy());
            newMemberDescriptor.setLevel(this.getLevel());
            newMemberDescriptor.setMUN(this.getMUN());
            newMemberDescriptor.setCalculation(this.isCalculation());
            newMemberDescriptor.setNoMember(this.isNoMember());
            newMemberDescriptor.setRootMember(this.isRootMember());
            newMemberDescriptor.setFixed(this.isFixed());
            return newMemberDescriptor;
        }

        public boolean isDelete() {
            return this.delete;
        }

        public void setDelete(boolean value) {
            this.delete = value;
        }

        public boolean wasSucessfullyUsed() {
            return this.stSucessfullyUsed;
        }

        public void setSucessfullyUsed(boolean sucessfullyUsed) {
            this.stSucessfullyUsed = sucessfullyUsed;
        }

        public boolean isFixed() {
            return this.isFixed;
        }

        public void setFixed(boolean fixed) {
            this.isFixed = fixed;
        }
    }
}

