/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping;

import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIDatasetContext;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.RenameMUN;
import com.cognos.xqe.runtree.olap.edgemapping.actions.RenameV5;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Element;

public class EdgeMappingUtils {
    public static final String MEMBER_UNIQUE_NAME = "memberUniqueName";

    public static StringBuilder createNodeIdString(String nodeName, Integer nodeId) {
        StringBuilder buffer = new StringBuilder(nodeName);
        buffer.append("(");
        buffer.append("Id=");
        buffer.append(nodeId.toString());
        buffer.append(")");
        return buffer;
    }

    public static void actionValidationError(IEdgeElementMappingAction action) {
        StringBuilder errorMsg = new StringBuilder("Validation failed for an instance of ");
        errorMsg.append(action.getClass().getName());
        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, errorMsg.toString());
    }

    public static ContextMember createContextMember(ContextMember contextMember, IMember newMember) {
        ContextMember aContextMember = (ContextMember)contextMember.copy();
        aContextMember.setMember(newMember);
        aContextMember.setEdgeOrdinal(contextMember.getEdgeOrdinal());
        if (contextMember.isQueryCalculation()) {
            aContextMember.setQueryCalculation(contextMember.isQueryCalculation());
        }
        if (contextMember.isSummary()) {
            aContextMember.setSummary(contextMember.isSummary());
        }
        if (contextMember.isCalculatedMember()) {
            aContextMember.setCalculatedMember(contextMember.isCalculatedMember());
        }
        if (contextMember.isCalculatedMember()) {
            aContextMember.setCalculatedMemberName(contextMember.getCalculatedMemberName());
            aContextMember.setCalculatedMemberCaption(contextMember.getCalculatedMemberCaption());
        }
        aContextMember.setRowset(contextMember.getRowset());
        aContextMember.setDataItemIndex(contextMember.getDataItemIndex());
        aContextMember.setOlapEdgeMappingColumnId(contextMember.getOlapEdgeMappingColumnId());
        return aContextMember;
    }

    public static ContextMember replicateContextMember(ContextMember contextMember) {
        IMember baseMember = contextMember.getBaseMember();
        if (baseMember.isDMR()) {
            ContextMember aContextMember = EdgeMappingUtils.createContextMember(contextMember, contextMember.getBaseMember());
            return aContextMember;
        }
        Member newMember = EdgeMappingUtils.replicateBaseMember(baseMember);
        ContextMember aContextMember = EdgeMappingUtils.createContextMember(contextMember, newMember);
        return aContextMember;
    }

    public static Member replicateBaseMember(IMember baseMember) {
        Member newMember = new Member();
        newMember.setConnection(baseMember.getConnection());
        newMember.setName(baseMember.getName());
        newMember.setCaption(baseMember.getCaption());
        String baseMUN = baseMember.getUniqueName();
        newMember.setUniqueName(baseMUN);
        newMember.setProperty(MEMBER_UNIQUE_NAME, baseMUN);
        newMember.setLevel(baseMember.getLevel());
        newMember.setParentUniqueName(baseMember.getParentUniqueName());
        newMember.setParentLevelNumber(baseMember.getParentLevelNumber());
        if (baseMember instanceof Metadata && ((Metadata)((Object)baseMember)).getDynamicProperties() != null) {
            newMember.setDynamicProperties(((Metadata)((Object)baseMember)).getDynamicProperties());
        }
        return newMember;
    }

    public static IHierarchy captureHierarchy(PlanningEnvironment env, Element inputNode) {
        String hierarchyName = inputNode.attributeValue("hierarchy");
        if (hierarchyName != null && !"".equals(hierarchyName)) {
            return AbstractOLAPColumn.bindHierarchy(env, hierarchyName);
        }
        return null;
    }

    public static RSAPIEdgeRowset getRowset(String rowsetId, int edgeOrdinal) {
        RSAPIEdgeRowset rowset;
        Integer rowsetIdAsInteger = new Integer(rowsetId);
        RSAPIDataset dataset = RSAPIDatasetContext.getDataset();
        if (dataset == null) {
            rowset = new RSAPIEdgeRowset();
            rowset.setRowsetId(rowsetIdAsInteger);
        } else {
            RSAPIEdge edge = dataset.getEdge(edgeOrdinal);
            rowset = edge.getRowset(rowsetIdAsInteger);
        }
        return rowset;
    }

    public static boolean isCalculatedMemberUniqueName(String uniqueName) {
        return uniqueName.indexOf("XQE") != -1;
    }

    public static boolean isNoMemberUniqueName(String uniqueName) {
        return uniqueName.indexOf(".[NOMEMBER]") != -1;
    }

    public static String getMemberUniqueName(AbstractMDXMember abstractMDXMember) {
        String abstractMDXMemberMUN = null;
        switch (abstractMDXMember.getType()) {
            case 1067: {
                abstractMDXMemberMUN = ((BaseMember)abstractMDXMember).getUniqueName();
                break;
            }
            case 1013: {
                abstractMDXMemberMUN = ((MDXCalculatedMemberReference)abstractMDXMember).getUniqueName();
                break;
            }
            case 1077: {
                abstractMDXMemberMUN = abstractMDXMember.getHierarchy().getDefaultMember().getUniqueName();
                break;
            }
            default: {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "abstractMDXMember.getType()?");
            }
        }
        return abstractMDXMemberMUN;
    }

    public static String tupleToString(ITuple aTuple) {
        StringBuilder sBuffer = new StringBuilder("(");
        IMember[] members = aTuple.getMembers();
        for (int i = 0; i < members.length; ++i) {
            IMember member = members[i];
            if (member != null) {
                sBuffer.append(member.getName());
            } else {
                sBuffer.append("null");
            }
            if (i >= members.length - 1) continue;
            sBuffer.append(",");
        }
        sBuffer.append(")");
        return sBuffer.toString();
    }

    public static String tupleCollectionToString(Collection<ITuple> aTupleCollection) {
        StringBuilder sBuffer = new StringBuilder("{");
        int i = -1;
        for (ITuple aTuple : aTupleCollection) {
            if (aTuple != null) {
                sBuffer.append(EdgeMappingUtils.tupleToString(aTuple));
            } else {
                sBuffer.append("null");
            }
            if (++i >= aTupleCollection.size() - 1) continue;
            sBuffer.append(",");
        }
        sBuffer.append("}");
        return sBuffer.toString();
    }

    public static OLAPContextColumn isNestingANotRenderedContextColumn(OLAPRowCycle currRowCycle) {
        if (currRowCycle.areAllRowsRemoved()) {
            return null;
        }
        boolean notNestingOLAPClycles = true;
        for (int i = 0; i < currRowCycle.getNumberOfRows(); ++i) {
            if (!currRowCycle.getRow(i).isCycle()) continue;
            notNestingOLAPClycles = false;
            break;
        }
        if (notNestingOLAPClycles && currRowCycle.wasRemoved() && currRowCycle.getRow(0).isFillerTagRow() != -1) {
            return null;
        }
        if (currRowCycle.getFirstColumn() != null && currRowCycle.isUsingHierarchize() && currRowCycle.getFirstColumn().isHierarchyNormalization()) {
            return null;
        }
        if (currRowCycle.wasSuppressed()) {
            return null;
        }
        OLAPContextColumn currContextColumn = null;
        int currRowCycleRowNum = currRowCycle.getNumberOfRows();
        for (int i = 0; i < currRowCycleRowNum; ++i) {
            if (!currRowCycle.getRow(i).isCycle() || (currContextColumn = EdgeMappingUtils.isNestingANotRenderedContextColumn((OLAPRowCycle)currRowCycle.getRow(i))) == null || currContextColumn.getRulesType() == 4 && currRowCycle.getFirstColumn().wasRendered()) continue;
            return currContextColumn;
        }
        currContextColumn = (OLAPContextColumn)currRowCycle.getFirstColumn();
        if (currContextColumn != null && currContextColumn.getCurrentMember() != null && !currContextColumn.wasRendered()) {
            boolean isNestingFillerTagRow = EdgeMappingUtils.isNestingFillerTagRow(currRowCycle);
            if (!(currRowCycle.getUnbalancedTuple() == null || isNestingFillerTagRow && currRowCycle.hasUnbalancedCompensation())) {
                return currContextColumn;
            }
            if (currRowCycle.isNestingSameHierarchy() && !currRowCycle.isMultiHierarchy() && (currRowCycle.getFirstColumn().getRulesType() == 6 || currRowCycle.getFirstColumn().getRulesType() == 5) && EdgeMappingUtils.isCalculatedMemberUniqueName(currContextColumn.getCurrentMember().getUniqueName())) {
                return currContextColumn;
            }
        }
        return null;
    }

    protected static boolean isNestingFillerTagRow(OLAPRowCycle targetRowCycle) {
        boolean isNestingFillerTagRow = false;
        if (targetRowCycle.isMultiHierarchy()) {
            for (int index = 0; index < targetRowCycle.getNumberOfRows(); ++index) {
                OLAPRowCycle nestedCycle;
                AbstractOLAPRow nestedRow = targetRowCycle.getRow(index);
                boolean bl = isNestingFillerTagRow = !nestedRow.isCycle() && nestedRow.isFillerTagRow() == 1;
                if (isNestingFillerTagRow || nestedRow.isCycle() && (nestedCycle = (OLAPRowCycle)nestedRow).isMultiHierarchy() && (isNestingFillerTagRow = nestedCycle.isNestingAFillerTag())) break;
            }
        }
        return isNestingFillerTagRow;
    }

    public static ContextMember applyRenamingActions(AbstractOLAPColumn column, ContextMember aContextMember) {
        RenameMUN renameMUN;
        RenameV5 rename = (RenameV5)column.getActionOfTypeForMUN(8, aContextMember);
        if (rename != null) {
            rename.rename(aContextMember);
        }
        if ((renameMUN = (RenameMUN)column.getActionOfTypeForMUN(9, aContextMember)) != null) {
            ILevel level = column.getHierarchy().getLevel(0);
            aContextMember = renameMUN.rename(aContextMember, level);
        }
        return aContextMember;
    }

    public static String integerListToString(List<Integer> ids) {
        StringBuilder buffer = new StringBuilder();
        if (ids.size() > 1) {
            buffer.append("(");
        }
        for (int i = ids.size() - 1; i > -1; --i) {
            buffer.append(ids.get(i));
            if (ids.size() <= 1 || i <= 0) continue;
            buffer.append(", ");
        }
        if (ids.size() > 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static List<Integer> stringToIntegerList(String integerListRepresentation) {
        int beginIndex = integerListRepresentation.indexOf("(");
        int endIndex = integerListRepresentation.indexOf(")");
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        Integer value = null;
        if (beginIndex == -1 && endIndex == -1) {
            value = Integer.parseInt(integerListRepresentation);
            integerList.add(value);
            return integerList;
        }
        integerListRepresentation = integerListRepresentation.substring(beginIndex, endIndex);
        endIndex = 0;
        String intValue = null;
        while (endIndex >= 0) {
            beginIndex = endIndex;
            endIndex = integerListRepresentation.indexOf(", ");
            if (endIndex > 0) {
                intValue = integerListRepresentation.substring(beginIndex, endIndex);
                value = Integer.parseInt(intValue);
                integerList.add(value);
                endIndex += 2;
                continue;
            }
            intValue = integerListRepresentation.substring(beginIndex, endIndex);
            value = Integer.parseInt(intValue);
            integerList.add(value);
        }
        return integerList;
    }

    protected static void setContextMember(ContextMember context, ContextMember member) {
        if (context == null || member == null) {
            return;
        }
        if (member.getOlapEdgeMappingColumnId() == context.getOlapEdgeMappingColumnId()) {
            return;
        }
        while (member.getContextMember() != null) {
            if ((member = member.getContextMember()) == null || member.getOlapEdgeMappingColumnId() != context.getOlapEdgeMappingColumnId()) continue;
            context = null;
            break;
        }
        if (context != null) {
            member.setContextMember(context);
        }
    }
}

