/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping;

import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPEdgeElement;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingRules;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ActionFactory;
import com.cognos.xqe.runtree.olap.edgemapping.actions.CopyContext;
import com.cognos.xqe.runtree.olap.edgemapping.actions.GenerateContext;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.RelocateNestedLevelCalculation;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.CalcMemberReferencePrefixes;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedMap;
import org.dom4j.Element;

public class OLAPRowCycle
extends AbstractOLAPRow {
    private static final String TARGET_MEMBER_COLUMN_EQ_XOLAP_EDGE_MAPPING_UNKNOWN_INT_VALUE = "targetMemberColumn == XOLAPEdgeMapping.UNKNOWN_INT_VALUE";
    private static final int MAP_ROWS_SUCCEDD = 1;
    private static final int MAP_ROWS_FAIL = -1;
    private static final int DO_MAP_ROWS = 0;
    protected List<AbstractOLAPRow> rows = new ArrayList<AbstractOLAPRow>();
    protected int stNextRowIndex = 0;
    protected ITuple stUnbalancedTuple = null;
    protected ITuple stPostponedInputForHandlingPrevUnbalanced = null;
    protected List<ITuple> stCachedInputTuples = null;
    NoMatchRowsForInTuple stNoMatchRowsForInTuple = new NoMatchRowsForInTuple();
    protected boolean stIsCurrentRowForHierNormalization = false;
    protected boolean isNestingSameHierarchy = false;
    protected boolean isUsingHierarchize = false;
    protected boolean stResetCycle = false;
    private List<String> calculatedMemberList = null;
    private boolean stEverRendered = false;
    private boolean rowsAddedBaseOnEdgePosition = false;
    protected XOLAPEdgeMapping parentXNode;
    protected List<AbstractOLAPColumn> columnsWithPendingRelocNLCalc = null;

    public boolean isRowsAddedBaseOnEdgePosition() {
        return this.rowsAddedBaseOnEdgePosition;
    }

    public void setRowsAddedBaseOnEdgePosition(boolean value) {
        this.rowsAddedBaseOnEdgePosition = value;
    }

    public XOLAPEdgeMapping getParentXNode() {
        return this.parentXNode;
    }

    public void setParentXNode(XOLAPEdgeMapping node) {
        this.parentXNode = node;
    }

    public List<AbstractOLAPColumn> getColumnsWithPendingRelocNLCalc() {
        return this.columnsWithPendingRelocNLCalc;
    }

    public void addColumnWithPendingRelocNLCalc(AbstractOLAPColumn column) {
        if (column != null) {
            if (this.columnsWithPendingRelocNLCalc == null) {
                this.columnsWithPendingRelocNLCalc = new ArrayList<AbstractOLAPColumn>();
            }
            this.columnsWithPendingRelocNLCalc.add(column);
        }
    }

    public boolean wasEverRendered() {
        return this.stEverRendered;
    }

    public void setEverRendered(boolean value) {
        this.stEverRendered = value;
    }

    public void addRow(AbstractOLAPRow aRow, boolean toTheEnd) {
        AbstractMDXSet cogMDXGroup;
        aRow.setParentRow(this);
        this.setNestingSameHierarchy(aRow);
        if (this.getFirstColumn() != null && (!this.isNestingSameHierarchy() || aRow.isMultiHierarchy())) {
            this.setMultiHierarchy(true);
        }
        boolean isListReport = false;
        if (this.getRootRowCycle() != null && this.getRootRowCycle().getParentXNode() != null) {
            isListReport = this.getRootRowCycle().getParentXNode().isListReport();
        } else if (this.getParentXNode() != null) {
            isListReport = this.getParentXNode().isListReport();
        }
        if (!this.isRowsAddedBaseOnEdgePosition()) {
            for (int i = 0; i < aRow.getNumberOfColumns(); ++i) {
                cogMDXGroup = aRow.getColumn(i).getCogMDXGroup();
                if (cogMDXGroup == null || cogMDXGroup.getBooleanPropertyValue("nonDetailGroupBodyValue") == null) continue;
                if (!this.rows.isEmpty() || toTheEnd) {
                    if (this.addRowBaseOnEdgePosition(aRow)) {
                        return;
                    }
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "V5GroupBody.PROP_NON_DETAIL_GROUPBODY_VALUE1");
                }
                if (isListReport) continue;
                this.setRowsAddedBaseOnEdgePosition(true);
            }
        }
        RSAPIEdgeRowset rowset = aRow.getFirstRowset();
        if (this.rows.isEmpty() || toTheEnd) {
            this.rows.add(aRow);
            aRow.setRootRowCycle(this.getRootRowCycle());
            if (!aRow.isCycle() && aRow.hasUnbalancedCompensation()) {
                this.setHasUnbalancedCompensation(true);
            }
            if (!aRow.isCycle() && aRow.hasRaggedCompensation()) {
                this.setHasRaggedCompensation(true);
            }
            if (rowset == null && !isListReport) {
                this.setRowsAddedBaseOnEdgePosition(true);
            }
            if (!isListReport && aRow.isCycle() && this.isRowsAddedBaseOnEdgePosition()) {
                this.setRowsAddedBaseOnEdgePosition(true);
            }
            return;
        }
        if (this.isRowsAddedBaseOnEdgePosition() || rowset == null) {
            if (this.addRowBaseOnEdgePosition(aRow)) {
                return;
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "rowsAddedBaseOnEdgePosition || rowset == null");
        }
        cogMDXGroup = aRow.getFirstColumn().getCogMDXGroup();
        if (cogMDXGroup != null && cogMDXGroup.getBooleanPropertyValue("nonDetailGroupBodyValue") != null) {
            if (this.addRowBaseOnEdgePosition(aRow)) {
                return;
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "V5GroupBody.PROP_NON_DETAIL_GROUPBODY_VALUE2");
        }
        boolean resolveByEdgePosition = false;
        int pos = aRow.getFirstPositionWithinEdge();
        for (int i = 0; i < this.rows.size(); ++i) {
            AbstractOLAPRow currRow = this.rows.get(i);
            RSAPIEdgeRowset currRowSet = currRow.getFirstRowset();
            if (currRowSet != null && !isListReport && currRowSet.getRowsetId() == rowset.getRowsetId()) {
                if (aRow.hasUnbalancedCompensation() || aRow.hasRaggedCompensation()) {
                    resolveByEdgePosition = true;
                    int currPos = currRow.getFirstPositionWithinEdge();
                    if (!this.addRow(currPos, pos, i, aRow)) continue;
                    return;
                }
                if (this.addRowBaseOnEdgePosition(aRow)) {
                    return;
                }
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Positional Calculated Members, unable to add decoration row.");
            }
            if (resolveByEdgePosition || currRowSet == null || currRowSet.compareQRDOrderTo(rowset) <= 0) continue;
            this.rows.add(i, aRow);
            aRow.setRootRowCycle(this.getRootRowCycle());
            if (!aRow.isCycle() && aRow.hasUnbalancedCompensation()) {
                this.setHasUnbalancedCompensation(true);
            }
            if (!aRow.isCycle() && aRow.hasRaggedCompensation()) {
                this.setHasRaggedCompensation(true);
            }
            if (!isListReport && aRow.isCycle() && this.isRowsAddedBaseOnEdgePosition()) {
                this.setRowsAddedBaseOnEdgePosition(true);
            }
            return;
        }
        this.rows.add(aRow);
        aRow.setRootRowCycle(this.getRootRowCycle());
        if (!aRow.isCycle() && aRow.hasUnbalancedCompensation()) {
            this.setHasUnbalancedCompensation(true);
        }
        if (!aRow.isCycle() && aRow.hasRaggedCompensation()) {
            this.setHasRaggedCompensation(true);
        }
        if (!isListReport && aRow.isCycle() && this.isRowsAddedBaseOnEdgePosition()) {
            this.setRowsAddedBaseOnEdgePosition(true);
        }
    }

    private boolean addRowBaseOnEdgePosition(AbstractOLAPRow aRow) {
        int pos = aRow.getFirstPositionWithinEdge();
        boolean orgIsRowsAddedBaseOnEdgePosition = this.isRowsAddedBaseOnEdgePosition();
        for (int i = 0; i < this.rows.size(); ++i) {
            AbstractOLAPRow currRow = this.rows.get(i);
            int currPos = currRow.getFirstPositionWithinEdge();
            boolean isListReport = false;
            if (this.getRootRowCycle() != null && this.getRootRowCycle().getParentXNode() != null) {
                isListReport = this.getRootRowCycle().getParentXNode().isListReport();
            } else if (this.getParentXNode() != null) {
                isListReport = this.getParentXNode().isListReport();
            }
            if (!isListReport) {
                this.setRowsAddedBaseOnEdgePosition(true);
            }
            if (!this.addRow(currPos, pos, i, aRow)) continue;
            return true;
        }
        if (!orgIsRowsAddedBaseOnEdgePosition) {
            this.setRowsAddedBaseOnEdgePosition(false);
        }
        return false;
    }

    private boolean addRow(int currRowCoordinate, int newRowCoordinate, int currRowIndex, AbstractOLAPRow aRow) {
        boolean isListReport = false;
        if (this.getRootRowCycle() != null && this.getRootRowCycle().getParentXNode() != null) {
            isListReport = this.getRootRowCycle().getParentXNode().isListReport();
        } else if (this.getParentXNode() != null) {
            isListReport = this.getParentXNode().isListReport();
        }
        if (currRowCoordinate > newRowCoordinate) {
            this.rows.add(currRowIndex, aRow);
            aRow.setRootRowCycle(this.getRootRowCycle());
            if (!aRow.isCycle() && aRow.hasUnbalancedCompensation()) {
                this.setHasUnbalancedCompensation(true);
            }
            if (!aRow.isCycle() && aRow.hasRaggedCompensation()) {
                this.setHasRaggedCompensation(true);
            }
            if (!isListReport && aRow.isCycle() && this.isRowsAddedBaseOnEdgePosition()) {
                this.setRowsAddedBaseOnEdgePosition(true);
            }
            return true;
        }
        if (currRowCoordinate == newRowCoordinate - 1) {
            if (this.rows.size() > currRowIndex) {
                this.rows.add(currRowIndex + 1, aRow);
            } else {
                this.rows.add(aRow);
            }
            if (!aRow.isCycle() && aRow.hasUnbalancedCompensation()) {
                this.setHasUnbalancedCompensation(true);
            }
            aRow.setRootRowCycle(this.getRootRowCycle());
            if (!aRow.isCycle() && aRow.hasRaggedCompensation()) {
                this.setHasRaggedCompensation(true);
            }
            if (!isListReport && aRow.isCycle() && this.isRowsAddedBaseOnEdgePosition()) {
                this.setRowsAddedBaseOnEdgePosition(true);
            }
            return true;
        }
        if (this.rows.size() - 1 == currRowIndex) {
            this.rows.add(aRow);
            aRow.setRootRowCycle(this.getRootRowCycle());
            if (!aRow.isCycle() && aRow.hasUnbalancedCompensation()) {
                this.setHasUnbalancedCompensation(true);
            }
            if (!aRow.isCycle() && aRow.hasRaggedCompensation()) {
                this.setHasRaggedCompensation(true);
            }
            if (!isListReport && aRow.isCycle() && this.isRowsAddedBaseOnEdgePosition()) {
                this.setRowsAddedBaseOnEdgePosition(true);
            }
            return true;
        }
        return false;
    }

    public void insertRow(AbstractOLAPRow aRow, int aPosition) {
        aRow.setParentRow(this);
        this.setNestingSameHierarchy(aRow);
        if (!this.isNestingSameHierarchy()) {
            this.setMultiHierarchy(true);
        } else if (aRow.isMultiHierarchy()) {
            this.setMultiHierarchy(true);
        }
        this.rows.add(aPosition, aRow);
        aRow.setRootRowCycle(this.getRootRowCycle());
        if (!aRow.isCycle() && aRow.hasUnbalancedCompensation()) {
            this.setHasUnbalancedCompensation(true);
        }
        if (!aRow.isCycle() && aRow.hasRaggedCompensation()) {
            this.setHasRaggedCompensation(true);
        }
        boolean isListReport = false;
        if (this.getRootRowCycle() != null && this.getRootRowCycle().getParentXNode() != null) {
            isListReport = this.getRootRowCycle().getParentXNode().isListReport();
        } else if (this.getParentXNode() != null) {
            isListReport = this.getParentXNode().isListReport();
        }
        if (!isListReport && aRow.isCycle() && this.isRowsAddedBaseOnEdgePosition()) {
            this.setRowsAddedBaseOnEdgePosition(true);
        }
    }

    public int replaceRow(AbstractOLAPRow oldRow, AbstractOLAPRow newRow) {
        int index = this.rows.indexOf(oldRow);
        this.insertRow(newRow, index);
        this.rows.remove(oldRow);
        return index;
    }

    public int indexOf(AbstractOLAPRow row) {
        return this.rows.indexOf(row);
    }

    private void setNestingSameHierarchy(AbstractOLAPRow aNestedRow) {
        IHierarchy hierOfRow;
        if (this.getFirstColumn() == null) {
            return;
        }
        if (aNestedRow.getFirstColumn().isContextMember()) {
            return;
        }
        IHierarchy hierOfThis = this.getFirstColumn().getHierarchy();
        if (hierOfThis.equals(hierOfRow = aNestedRow.getFirstColumn().getHierarchy())) {
            this.setNestingSameHierarchy(true);
        }
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputRow, int edgeOrdinal) {
        super.capture(env, inputRow, edgeOrdinal);
        List<AbstractOLAPRow> rowList = this.captureRows(env, inputRow, edgeOrdinal);
        for (AbstractOLAPRow row : rowList) {
            this.addRow(row, true);
        }
    }

    public List<AbstractOLAPRow> captureRows(PlanningEnvironment env, Element inputElement, int edgeOrdinal) {
        ArrayList<AbstractOLAPRow> rowList = new ArrayList<AbstractOLAPRow>();
        List childList = inputElement.elements();
        ListIterator listIterator = childList.listIterator();
        EdgeElementFactory edgeElementFactory = env.getEdgeElementFactory();
        while (listIterator.hasNext()) {
            Element anElement = (Element)listIterator.next();
            String elementName = anElement.getName();
            AbstractOLAPEdgeElement nestedRow = edgeElementFactory.createEdgeElementByName(elementName);
            if (nestedRow == null || nestedRow.isColumn()) continue;
            nestedRow.capture(env, anElement, edgeOrdinal);
            rowList.add((AbstractOLAPRow)nestedRow);
            nestedRow.setParentRow(this);
        }
        return rowList;
    }

    @Override
    public void dumpExtraAttibutes(XQETrace trace) {
        super.dumpExtraAttibutes(trace);
        if (this.isNestingSameHierarchy()) {
            trace.attribute("isNestingSameHierarchy", Boolean.TRUE.toString());
        }
        if (this.isUsingHierarchize()) {
            trace.attribute("isUsingHierarchize", Boolean.TRUE.toString());
        }
        if (this.isRowsAddedBaseOnEdgePosition()) {
            trace.attribute("rowsAddedBaseOnEdgePosition", Boolean.TRUE.toString());
        }
        if (this.getNextRowIndex() != 0) {
            trace.attribute("nextRowIdex", XQEIntegerPool.getInteger(this.getNextRowIndex()).toString());
        }
        if (this.stResetCycle) {
            trace.attribute("resetCycle", Boolean.TRUE.toString());
        }
        if (this.getUnbalancedTuple() != null) {
            trace.attribute("unbalancedTuple", EdgeMappingUtils.tupleToString(this.getUnbalancedTuple()));
        }
        if (this.getstPostponedInputForHandlingPrevUnbalanced() != null) {
            trace.attribute("postponedForUnbalancedHandling", EdgeMappingUtils.tupleToString(this.getstPostponedInputForHandlingPrevUnbalanced()));
        }
    }

    @Override
    public void dumpExtraElements(XQETrace trace) {
        super.dumpExtraElements(trace);
        for (AbstractOLAPRow row : this.rows) {
            row.dump(trace);
        }
        if (this.calculatedMemberList != null) {
            trace.beginElement("calculatedMUNs", -1);
            for (String calculatedMember : this.calculatedMemberList) {
                trace.beginElement("calculatedMember", -1);
                trace.attribute("MUN", calculatedMember);
                trace.endElement();
            }
            trace.endElement();
        }
    }

    @Override
    public boolean map(ITuple aTuple) {
        boolean usesFillerTagRowAndRaggedORUnbalancedCompensation;
        IMember targetMember;
        this.resetMapping();
        if (this.stResetCycle) {
            int lastRowId;
            AbstractOLAPRow lastRow;
            if (this.getFirstColumn() == null && !(lastRow = this.getRow(lastRowId = this.getNumberOfRows() - 1)).isCycle() && lastRow.getFirstColumn().getRulesType() == 4 && lastRow.getFirstColumn().getActionOfTypeForMUN(12, null) != null && lastRow.getNumberOfColumns() > 2) {
                for (int i = 0; i < lastRow.getNumberOfColumns(); ++i) {
                    AbstractOLAPColumn currColumn = lastRow.getColumn(i);
                    int rnlcType = 6;
                    if (currColumn.getActionOfTypeForMUN(6, null) == null || currColumn.getRules().getMemberDescriptorList().size() != 1 || currColumn.getRulesType() != 2 || !currColumn.getRules().getMemberDescriptorList().get(0).getMUN().equals(aTuple.getMember(i).getUniqueName())) continue;
                    this.stResetCycle = false;
                    break;
                }
            }
            if (this.stResetCycle) {
                this.resetCycle();
            }
        }
        boolean contextColumnMapped = false;
        OLAPContextColumn contextColumn = (OLAPContextColumn)this.getFirstColumn();
        if (contextColumn != null && contextColumn.isLocked() == 0 && CalcMemberReferencePrefixes.isTag(targetMember = aTuple.getMember(contextColumn.getTuplePosition()))) {
            return this.mapTupleToNestedRows(aTuple, contextColumnMapped);
        }
        if (contextColumn == null || contextColumn.isLocked() == 1) {
            return this.mapTupleToNestedRows(aTuple, contextColumnMapped);
        }
        boolean usesFillerTagRow = this.isMultiHierarchy() && !this.getRow(0).isCycle() && ((OLAPRow)this.getRow(0)).isFillerTagRow() == 1;
        boolean isFillerTagTuple = aTuple.getMembers().length - 1 > this.getFirstColumn().getTuplePosition() && CalcMemberReferencePrefixes.isFillerTag(aTuple.getMember(this.getFirstColumn().getTuplePosition() + 1));
        boolean bl = usesFillerTagRowAndRaggedORUnbalancedCompensation = usesFillerTagRow && (this.hasUnbalancedCompensation() || this.hasRaggedCompensation());
        if (!usesFillerTagRow || usesFillerTagRow && isFillerTagTuple || usesFillerTagRowAndRaggedORUnbalancedCompensation) {
            contextColumnMapped = contextColumn.map(aTuple);
            if (!contextColumnMapped && !this.isNestingSameHierarchy()) {
                this.setDone(true);
                return false;
            }
            if (!contextColumnMapped && this.isNestingSameHierarchy() && this.getIterator().isRetrySameTupleIn()) {
                return false;
            }
        }
        if (contextColumnMapped) {
            this.getIterator().setIndexOfLastMappedMember(contextColumn.getTuplePosition());
        }
        if (contextColumnMapped && this.getMappedTuple() != null) {
            return true;
        }
        if (!contextColumnMapped) {
            boolean isTagTuple = false;
            if (contextColumn.couldResolveToEmptySet() && aTuple.getMember(0).getHierarchy().equals(contextColumn.getHierarchy())) {
                IMember currMember;
                IMember[] iMemberArray = aTuple.getMembers();
                int n = iMemberArray.length;
                for (int i = 0; i < n && !(isTagTuple = CalcMemberReferencePrefixes.isTag(currMember = iMemberArray[i])); ++i) {
                }
            }
            if (!isTagTuple && contextColumn.getCurrentMember() == null && (!contextColumn.isRagged() || contextColumn.isRagged() && !this.isUsingHierarchize())) {
                this.setDone(true);
                return false;
            }
            return this.mapTupleToNestedRows(aTuple, contextColumnMapped);
        }
        if (contextColumn.isLocked() == 1) {
            return true;
        }
        if (contextColumn.hasMemberChanged()) {
            this.getFirstColumn().setRendered(false);
            this.resetCycle();
        }
        return this.mapTupleToNestedRows(aTuple, contextColumnMapped);
    }

    private boolean mapTupleToNestedRows(ITuple aTuple, boolean contextColumnMapped) {
        this.stNoMatchRowsForInTuple.clear();
        int result = 0;
        while (result == 0) {
            int nextRowIndex = this.getNextRowIndex();
            AbstractOLAPRow nextRow = this.rows.get(nextRowIndex);
            boolean restart = this.foundOLAPRowsWithSameGeneratedContextBeforeUnseenMemberTag(aTuple);
            if (restart) continue;
            if (nextRow.isCycle()) {
                AbstractOLAPRow tagRow;
                IMember targetMember;
                OLAPContextColumn contextColOfNextRow = (OLAPContextColumn)nextRow.getFirstColumn();
                if (this.getIterator().getIndexOfLastMappedMember() == contextColOfNextRow.getTuplePosition() && contextColOfNextRow.isLocked() == 1 && CalcMemberReferencePrefixes.isTag(targetMember = aTuple.getMember(contextColOfNextRow.getTuplePosition())) && (tagRow = this.rows.get(nextRowIndex - 1)).getFirstColumn().accept(aTuple, false)) {
                    contextColOfNextRow.setLocked(-1);
                    this.setNextRowIndex(--nextRowIndex);
                    tagRow.setDone(false);
                    this.resetNextMemberListIndexes(false);
                }
            }
            if (contextColumnMapped && nextRowIndex == 0 && this.getRow(0).isTag() && this.getRow(0).doesActionTypeApplies(5) && this.isNestingSameHierarchy() && !this.isMultiHierarchy()) {
                return true;
            }
            result = this.mapTupleToRows(aTuple, contextColumnMapped, nextRowIndex);
            if (result != 1) continue;
            return true;
        }
        if (contextColumnMapped) {
            this.getIterator().setIndexOfLastMappedMember(this.getFirstColumn().getTuplePosition() - 1);
        }
        return false;
    }

    private boolean foundOLAPRowsWithSameGeneratedContextBeforeUnseenMemberTag(ITuple aTuple) {
        AbstractOLAPColumn nextRowCol;
        boolean restart = false;
        int nextRowIndex = this.getNextRowIndex();
        AbstractOLAPRow nextRow = this.rows.get(nextRowIndex);
        if (!nextRow.isCycle() && nextRow.isTag() && nextRowIndex > 1 && nextRow.getNumberOfColumns() == 1 && (nextRowCol = nextRow.getFirstColumn()).getRules().applies(aTuple.getMember(0), false) == null) {
            AbstractOLAPRow previousRow = this.rows.get(nextRowIndex - 1);
            int[] rowSetList = null;
            if (!previousRow.isCycle() && previousRow.getNumberOfColumns() == 1 && previousRow.getFirstColumn().getActionOfTypeForMUN(2, null) != null) {
                AbstractOLAPRow beforePreviousRow;
                GenerateContext action = (GenerateContext)previousRow.getFirstColumn().getActionOfTypeForMUN(2, null);
                rowSetList = new int[action.getNumberOfContextColumns()];
                for (int j = 0; j < action.getNumberOfContextColumns(); ++j) {
                    rowSetList[j] = action.getContextColumn(j).getRowset().getRowsetId();
                }
                for (int rowIdx = nextRowIndex - 2; rowIdx > -1 && !(beforePreviousRow = this.rows.get(rowIdx)).isCycle() && beforePreviousRow.getNumberOfColumns() == 1 && beforePreviousRow.getFirstColumn().getActionOfTypeForMUN(2, null) != null && (action = (GenerateContext)previousRow.getFirstColumn().getActionOfTypeForMUN(2, null)).getNumberOfContextColumns() == rowSetList.length; --rowIdx) {
                    int j;
                    for (j = 0; j < action.getNumberOfContextColumns() && rowSetList[j] == action.getContextColumn(j).getRowset().getRowsetId(); ++j) {
                    }
                    if (j != action.getNumberOfContextColumns()) continue;
                    if (!restart) {
                        previousRow.setDone(false);
                        restart = true;
                    }
                    this.setNextRowIndex(rowIdx);
                    beforePreviousRow.setDone(false);
                }
            }
        }
        return restart;
    }

    private int mapTupleToRows(ITuple aTuple, boolean contextColumnMapped, int nextRowIndex) {
        AbstractOLAPRow prevRow;
        int tuplePosition;
        OLAPContextColumn contextColOfThis = (OLAPContextColumn)this.getFirstColumn();
        boolean lockerTagNotSeen = false;
        AbstractOLAPRow nextRow = this.rows.get(nextRowIndex);
        AbstractOLAPColumn firstColumnOfThis = this.getFirstColumn();
        if (firstColumnOfThis == null && nextRow.isCycle() && ((OLAPContextColumn)nextRow.getFirstColumn()).isLocked() == 1 && CalcMemberReferencePrefixes.isTag(aTuple.getMember(tuplePosition = nextRow.getFirstColumn().getTuplePosition())) && (prevRow = this.rows.get(nextRowIndex)).getFirstColumn().accept(aTuple, false)) {
            prevRow.resetDone();
            --nextRowIndex;
        }
        for (int rowIndex = nextRowIndex; rowIndex < this.rows.size(); ++rowIndex) {
            OLAPContextColumn currContextColumn;
            boolean isLastRow;
            boolean bl = isLastRow = rowIndex == this.rows.size() - 1;
            if (lockerTagNotSeen) {
                if (isLastRow) {
                    this.stResetCycle = true;
                    this.setDone(true);
                }
                lockerTagNotSeen = false;
                continue;
            }
            AbstractOLAPRow currentRow = this.rows.get(rowIndex);
            if (this.stNoMatchRowsForInTuple.hasRowBeenRejectedForTuple(aTuple, currentRow.getId())) {
                this.setDone(true);
                return -1;
            }
            if (this.getIterator().getIndexOfLastMappedMember() != currentRow.getFirstColumn().getTuplePosition() && this.getIterator().getIndexOfLastMappedMember() != currentRow.getFirstColumn().getTuplePosition() - 1 || !contextColumnMapped && currentRow.isCycle() && ((OLAPRowCycle)currentRow).getFirstColumn() != null && (currContextColumn = (OLAPContextColumn)((OLAPRowCycle)currentRow).getFirstColumn()).isHierarchyNormalization() && !contextColOfThis.getHierarchy().equals(currContextColumn.getHierarchy()) || currentRow.isDone()) continue;
            boolean isTupleMappedToRow = false;
            boolean isNotCMRow = currentRow.getFirstColumn().getRulesType() != 4 && currentRow.getFirstColumn().getRulesType() != 7;
            boolean isNestedCMCycle = contextColumnMapped && currentRow.isCycle() && !isNotCMRow;
            boolean isUnbalancedCompensationAfterFillertag = false;
            if (rowIndex > 0) {
                AbstractOLAPRow previousRow = this.rows.get(rowIndex - 1);
                boolean bl2 = isUnbalancedCompensationAfterFillertag = contextColumnMapped && previousRow.isFillerTagRow() == 1 && previousRow.getFirstColumn().isUnbalanced() && contextColOfThis.isUnbalancedCompensation() && previousRow.getMappedTuple() == null;
            }
            if (!contextColumnMapped || currentRow.getNumberOfColumns() > 1 || isNotCMRow || !contextColOfThis.hasMemberChanged() || isUnbalancedCompensationAfterFillertag || isNestedCMCycle) {
                IMember previouslyAcceptedMember;
                OLAPRowCycle discardedCycle = null;
                OLAPContextColumn notRenderedContextColumn = null;
                if (currentRow.isCycle()) {
                    discardedCycle = (OLAPRowCycle)currentRow;
                    notRenderedContextColumn = EdgeMappingUtils.isNestingANotRenderedContextColumn(discardedCycle);
                }
                isTupleMappedToRow = this.getFirstColumn() != null && !currentRow.isCycle() && contextColumnMapped && this.getFirstColumn().getRulesType() != 4 && this.getFirstColumn().getRulesType() == currentRow.getFirstColumn().getRulesType() && this.getFirstColumn().getRules().sameAs(currentRow.getFirstColumn().getRules()) && this.getFirstColumn().getPreviousMember() != this.getFirstColumn().getCurrentMember() ? false : currentRow.map(aTuple);
                if (currentRow.wasRemoved()) {
                    this.setRemoved(true);
                    if (rowIndex > 0) {
                        for (int prevRowIndex = rowIndex - 1; prevRowIndex > -1; --prevRowIndex) {
                            AbstractOLAPRow prevRow2 = this.rows.get(prevRowIndex);
                            if (prevRow2.wasRendered()) {
                                this.setRemoved(false);
                            } else {
                                if (prevRow2.isCycle() || prevRow2.wasRemoved() || !prevRow2.isDone() || prevRow2.getFirstColumn().getCurrentMember() == null) continue;
                                this.setRemoved(false);
                            }
                            break;
                        }
                    }
                } else {
                    this.setRemoved(false);
                }
                if (currentRow.isCycle() && this.getIterator().isRetrySameTupleIn()) {
                    return -1;
                }
                if (contextColOfThis != null && contextColOfThis.isUnbalanced() && this.isNestingSameHierarchy()) {
                    int numOfTupleMembers;
                    if (!this.isNestingAFillerTag()) {
                        if (!this.isMultiHierarchy()) {
                            if (!(isTupleMappedToRow || !contextColumnMapped || this.isUsingHierarchize() && contextColOfThis.isHierarchyNormalization())) {
                                numOfTupleMembers = aTuple.getMembers().length;
                                this.mapUnbalancedTuple(numOfTupleMembers);
                            }
                            if (!(!isTupleMappedToRow || contextColumnMapped || currentRow.isCycle() && ((OLAPRowCycle)currentRow).getUnbalancedTuple() != null)) {
                                this.setUnbalancedTuple(null);
                            }
                            if (!isTupleMappedToRow && !contextColumnMapped && contextColOfThis.isLocked() == 1) {
                                numOfTupleMembers = aTuple.getMembers().length;
                                this.mapUnbalancedTuple(numOfTupleMembers);
                            }
                        } else {
                            if (isTupleMappedToRow && contextColumnMapped && !currentRow.isCycle() && ((OLAPRow)currentRow).isHierarchyNormalization()) {
                                numOfTupleMembers = aTuple.getMembers().length;
                                ((OLAPRow)currentRow).mapUnbalancedTuple(numOfTupleMembers);
                            }
                            if (!(!isTupleMappedToRow || contextColumnMapped || currentRow.isCycle() && ((OLAPRowCycle)currentRow).getUnbalancedTuple() != null)) {
                                this.setUnbalancedTuple(null);
                            }
                        }
                    } else {
                        if (isTupleMappedToRow && contextColumnMapped && !currentRow.isCycle() && ((OLAPRow)currentRow).isFillerTagRow() == -1 && !this.areAllRowsRemoved()) {
                            numOfTupleMembers = aTuple.getMembers().length;
                            ((OLAPRow)currentRow).mapUnbalancedTuple(numOfTupleMembers);
                        }
                        if (isTupleMappedToRow && contextColumnMapped && !currentRow.isCycle() && ((OLAPRow)currentRow).getColumn(0).isUnbalancedCompensation()) {
                            this.getRootRowCycle().clearUnbalancedTuple();
                        }
                        if (!(!isTupleMappedToRow || contextColumnMapped || currentRow.isCycle() && ((OLAPRowCycle)currentRow).getUnbalancedTuple() != null)) {
                            this.setUnbalancedTuple(null);
                        }
                    }
                }
                if (isTupleMappedToRow && currentRow.isCycle()) {
                    if (((OLAPRowCycle)currentRow).getUnbalancedTuple() != null) {
                        ITuple unbalancedTuple = ((OLAPRowCycle)currentRow).getUnbalancedTuple();
                        if (firstColumnOfThis != null) {
                            ContextMember context = firstColumnOfThis.createContextMember();
                            if (firstColumnOfThis.doesActionTypeApplies(2)) {
                                GenerateContext generateContext = (GenerateContext)firstColumnOfThis.getActionOfTypeForMUN(2, null);
                                context = generateContext.createContextMember(context);
                            }
                            if (currentRow.getFirstColumn().getHierarchy().equals(firstColumnOfThis.getHierarchy())) {
                                ContextMember member = (ContextMember)unbalancedTuple.getMember(firstColumnOfThis.getTuplePosition());
                                EdgeMappingUtils.setContextMember(context, member);
                            } else {
                                IMember[] members = unbalancedTuple.getMembers();
                                members[firstColumnOfThis.getTuplePosition()] = context;
                                unbalancedTuple = new Tuple(members);
                            }
                        }
                        this.setUnbalancedTuple(unbalancedTuple);
                    } else {
                        this.setUnbalancedTuple(null);
                    }
                }
                if (!isTupleMappedToRow && currentRow.isCycle() && notRenderedContextColumn != null && (previouslyAcceptedMember = notRenderedContextColumn.getCurrentMember()) != null) {
                    String notRenderedUniqueName;
                    boolean mixedRuleType;
                    StringBuilder discardingContextMember = new StringBuilder("We are about to discard context member: ");
                    discardingContextMember.append(previouslyAcceptedMember.getUniqueName());
                    discardingContextMember.append(".");
                    if (discardedCycle.getUnbalancedTuple() != null) {
                        AbstractOLAPColumn.handlePendingUnbalancedLeaf(aTuple, discardedCycle, notRenderedContextColumn);
                        ITuple mappedTuple = discardedCycle.getMappedTuple();
                        this.setMappedTuple(mappedTuple);
                        this.setLinkedRowRendered();
                        return 1;
                    }
                    OLAPRowCycle notRenderedCycle = (OLAPRowCycle)notRenderedContextColumn.getParentRow();
                    boolean bl3 = mixedRuleType = notRenderedContextColumn.getRulesType() == 5 || notRenderedContextColumn.getRulesType() == 6;
                    if (notRenderedCycle.isNestingSameHierarchy() && mixedRuleType && EdgeMappingUtils.isCalculatedMemberUniqueName(notRenderedUniqueName = notRenderedContextColumn.getCurrentMember().getUniqueName())) {
                        AbstractOLAPColumn.handleCalculationAddedToLevelSet(aTuple, discardedCycle, notRenderedContextColumn);
                        this.setLinkedRowRendered();
                        return 1;
                    }
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, discardingContextMember.toString());
                }
                if (isTupleMappedToRow && currentRow.getFirstColumn().isUnbalanced() && !currentRow.isCycle() && currentRow.getMappedTuple() != null) {
                    this.getRootRowCycle().clearUnbalancedTuple();
                }
                if (isTupleMappedToRow && !currentRow.isCycle()) {
                    this.getIterator().setIndexOfLastMappedMember(currentRow.getColumn(currentRow.getNumberOfColumns() - 1).getTuplePosition());
                }
                if (!isTupleMappedToRow && currentRow.doesActionTypeApplies(5)) {
                    lockerTagNotSeen = true;
                    continue;
                }
            }
            if (!isTupleMappedToRow) {
                if (contextColumnMapped && contextColOfThis.isUnbalancedCompensation() && currentRow.isFillerTagRow() == 1 && currentRow.getFirstColumn().isUnbalanced()) {
                    this.setNextRowIndex(nextRowIndex + 1);
                    return 0;
                }
                this.stNoMatchRowsForInTuple.addRejectedRowForTuple(aTuple, currentRow.getId());
                if (!isLastRow) continue;
                currentRow.clearCurrentMembers();
                if (contextColumnMapped && this.isNestingSameHierarchy() && !this.isMultiHierarchy()) {
                    this.stResetCycle = true;
                    this.setLinkedRowRendered();
                    return 1;
                }
                if (this.stNoMatchRowsForInTuple.getNumberOfRejectedRows() == this.rows.size()) continue;
                this.partialResetCycle();
                return 0;
            }
            if (!currentRow.isCycle()) {
                ((OLAPRow)currentRow).setHierarchyNomalizationFlag();
            }
            if (this.isCurrentRowForHierNormalization()) {
                if (!currentRow.isCycle() && currentRow.isDone() && this.getNumberOfRows() > rowIndex + 1) {
                    this.setNextRowIndex(rowIndex + 1);
                }
                if (this.getRootRowCycle().getstPostponedInputForHandlingPrevUnbalanced() != null) {
                    ITuple mappedTuple = currentRow.getMappedTuple();
                    ContextMember targetMember = (ContextMember)mappedTuple.getMember(firstColumnOfThis.getTuplePosition());
                    ContextMember context = firstColumnOfThis.createContextMember();
                    if (targetMember != null) {
                        EdgeMappingUtils.setContextMember(context, targetMember);
                    } else {
                        IMember[] mappedMembers = mappedTuple.getMembers();
                        mappedMembers[firstColumnOfThis.getTuplePosition()] = context;
                        mappedTuple = new Tuple(mappedMembers);
                    }
                    this.setMappedTuple(mappedTuple);
                }
                this.setLinkedRowRendered();
                return 1;
            }
            if (currentRow.isCycle() && contextColumnMapped && this.getParentRow().getFirstColumn() != null && this.getParentRow().getFirstColumn().hasMemberChanged()) {
                ((OLAPRowCycle)currentRow).setEverRendered(false);
            }
            if (isLastRow) {
                AbstractOLAPRow previousRow;
                boolean done = currentRow.isDone();
                AbstractOLAPRow currParentRow = this;
                boolean explicitMemberContextIsDone = true;
                while (currParentRow.getFirstColumn() != null) {
                    OLAPContextColumn currContextColumn2 = (OLAPContextColumn)currParentRow.getFirstColumn();
                    done = done && currContextColumn2.isDone();
                    explicitMemberContextIsDone = explicitMemberContextIsDone && currContextColumn2.isMUNTypeAndAllRulesHaveBeenApplied();
                    currParentRow = currParentRow.getParentRow();
                }
                if (currentRow.isDone() && explicitMemberContextIsDone) {
                    this.setDone(true);
                } else {
                    this.setDone(done);
                }
                if (currentRow.isDone() && !this.isDone()) {
                    this.stResetCycle = true;
                }
                if (rowIndex > 0 && !currentRow.isCycle() && ((OLAPRow)currentRow).containsMeasureDetailColumn() && !(previousRow = this.rows.get(rowIndex - 1)).isCycle() && ((OLAPRow)previousRow).containsMeasureDetailColumn()) {
                    this.stResetCycle = true;
                }
            } else if (currentRow.isDone() && this.getNumberOfRows() > rowIndex + 1) {
                this.setNextRowIndex(rowIndex + 1);
            }
            ITuple mappedTuple = currentRow.getMappedTuple();
            if (mappedTuple != null) {
                this.setMappedTuple(mappedTuple);
                if (this.getParentRow() == null) {
                    this.removeTupleMembers(currentRow, mappedTuple);
                    this.setLinkedRowRendered();
                    return 1;
                }
                this.applySameHierarchyContext(currentRow);
                if (this.getColumnsWithPendingRelocNLCalc() != null) {
                    ArrayList<AbstractOLAPColumn> pendingAction = new ArrayList<AbstractOLAPColumn>();
                    pendingAction.addAll(this.getColumnsWithPendingRelocNLCalc());
                    for (AbstractOLAPColumn currColumn : pendingAction) {
                        currColumn.getParentRow().setMappedTuple(this.getMappedTuple());
                        currColumn.applyActions(5, 5);
                        this.setMappedTuple(currColumn.getParentRow().getMappedTuple());
                    }
                }
            }
            if (currentRow.isDone()) {
                currentRow.setLinkedRowRendered(false);
            }
            this.setLinkedRowRendered();
            return 1;
        }
        this.setDone(true);
        return -1;
    }

    public void applySameHierarchyContext(AbstractOLAPRow row) {
        CopyContext copyContext;
        boolean isReusingContextMember;
        ContextMember aContextMember;
        ContextMember targetMember;
        boolean firstColumnOfRowIsCM;
        ITuple mappedTuple = row.getMappedTuple();
        AbstractOLAPColumn firstColumnOfThis = this.getFirstColumn();
        if (firstColumnOfThis.getCurrentMember() == null && firstColumnOfThis.isRagged() && this.isUsingHierarchize()) {
            return;
        }
        AbstractOLAPColumn firstColumnOfRow = row.getFirstColumn();
        boolean bl = firstColumnOfRowIsCM = firstColumnOfRow.getRulesType() == 4;
        if (firstColumnOfRowIsCM && !firstColumnOfRow.isContextMember()) {
            boolean isNLCalcCase = false;
            for (int i = 1; i < row.getNumberOfColumns(); ++i) {
                AbstractOLAPColumn column = row.getColumn(i);
                if (!column.doesActionTypeApplies(6)) continue;
                isNLCalcCase = true;
                break;
            }
            if (isNLCalcCase && firstColumnOfThis.getDataItemIndex() != firstColumnOfRow.getDataItemIndex() && firstColumnOfThis.getDataItemIndex() != -1) {
                if (!row.isCycle()) {
                    ((OLAPRow)row).applyRowActions(5, 5);
                    mappedTuple = row.getMappedTuple();
                    this.removeTupleMembers(row, mappedTuple);
                }
                return;
            }
        }
        boolean isSameHierNestedLevelsCase = row.getFirstColumn().getHierarchy().equals(firstColumnOfThis.getHierarchy());
        if (targetMember != null && this.isTheSameAsContextMemberOfThis(targetMember)) {
            if (!row.isCycle()) {
                ((OLAPRow)row).applyRowActions(5, 5);
            }
            this.removeTupleMembers(row, mappedTuple);
            return;
        }
        for (targetMember = (ContextMember)mappedTuple.getMember(firstColumnOfThis.getTuplePosition()); targetMember != null && targetMember.getContextMember() != null; targetMember = targetMember.getContextMember()) {
            if (!isSameHierNestedLevelsCase) {
                this.removeTupleMembers(row, mappedTuple);
                return;
            }
            ContextMember contextOftargetMember = targetMember.getContextMember();
            int contextOftargetMemberId = contextOftargetMember.getOlapEdgeMappingColumnId();
            if (contextOftargetMemberId == -1) {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, TARGET_MEMBER_COLUMN_EQ_XOLAP_EDGE_MAPPING_UNKNOWN_INT_VALUE);
            }
            AbstractOLAPColumn contextOftargetMemberColumn = this.getRootRowCycle().findColumnById(contextOftargetMemberId);
            if (contextOftargetMemberColumn == null || !this.isTheSameAsContextMemberOfThis(targetMember.getContextMember())) continue;
            if (!row.isCycle()) {
                ((OLAPRow)row).applyRowActions(5, 5);
            }
            this.removeTupleMembers(row, mappedTuple);
            return;
        }
        ContextMember currentMemberOfThis = null;
        if (firstColumnOfThis.getCurrentMember().isContextMember()) {
            currentMemberOfThis = (ContextMember)firstColumnOfThis.getCurrentMember();
        }
        if ((aContextMember = firstColumnOfThis.createContextMember()) == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "aContextMember == null");
        }
        aContextMember = EdgeMappingUtils.applyRenamingActions(firstColumnOfThis, aContextMember);
        boolean bl2 = isReusingContextMember = currentMemberOfThis != null && currentMemberOfThis == aContextMember;
        if (!isReusingContextMember && (copyContext = (CopyContext)firstColumnOfThis.getActionOfTypeForMUN(12, null)) != null) {
            ContextMember contextToSet = copyContext.getContextMember();
            aContextMember.setContextMember(contextToSet);
        }
        if (targetMember != null && targetMember.getRowset() != null) {
            targetMember.setContextMember(aContextMember);
            for (int k = 0; k < row.getNumberOfColumns(); ++k) {
                AbstractOLAPColumn currColumn = row.getColumn(k);
                if (currColumn.getTuplePosition() != firstColumnOfThis.getTuplePosition()) continue;
                if (currColumn.getRulesType() == 4) {
                    if (targetMember.getBaseMember() instanceof Member) {
                        Member basemember = (Member)targetMember.getBaseMember();
                        basemember.setName(aContextMember.getBaseMember().getName());
                        basemember.setCaption(aContextMember.getBaseMember().getCaption());
                    }
                    targetMember.setCalculatedMemberName(aContextMember.getCalculatedMemberName());
                    targetMember.setCalculatedMemberCaption(aContextMember.getCalculatedMemberCaption());
                }
                break;
            }
        } else {
            IMember[] tupleMembers = mappedTuple.getMembers();
            tupleMembers[firstColumnOfThis.getTuplePosition()] = aContextMember;
        }
        if (!isReusingContextMember) {
            this.applyRowActions(3, 4);
        }
        boolean destinationMemberIsNull = false;
        RelocateNestedLevelCalculation rnlcAction = null;
        if (!row.isCycle()) {
            for (int k = 0; k < row.getNumberOfColumns(); ++k) {
                AbstractOLAPColumn currColumn = row.getColumn(k);
                rnlcAction = (RelocateNestedLevelCalculation)currColumn.getActionOfTypeForMUN(6, null);
                if (rnlcAction == null) continue;
                int to = rnlcAction.getTo();
                destinationMemberIsNull = mappedTuple.getMember(to) == null;
                break;
            }
        }
        if (rnlcAction != null && !rnlcAction.isApplied() && !destinationMemberIsNull) {
            ((OLAPRow)row).applyRowActions(5, 5);
            mappedTuple = row.getMappedTuple();
        } else if (row.isCycle()) {
            AbstractOLAPColumn innermostColumn;
            int innermostColumnId;
            IMember[] tupleMembers;
            boolean mappedTupleHasNullMember = false;
            for (IMember currMember : tupleMembers = mappedTuple.getMembers()) {
                if (currMember != null) continue;
                mappedTupleHasNullMember = true;
                break;
            }
            if (!mappedTupleHasNullMember && (innermostColumnId = ((ContextMember)tupleMembers[tupleMembers.length - 1]).getOlapEdgeMappingColumnId()) != -1 && (innermostColumn = this.findColumnById(innermostColumnId)) != null && !innermostColumn.isContext()) {
                OLAPRow innermostRow = (OLAPRow)innermostColumn.getParentRow();
                innermostRow.applyRowActions(5, 5);
                ITuple innermostMappedTuple = innermostRow.getMappedTuple();
                if (innermostMappedTuple.getMembers().length < mappedTuple.getMembers().length) {
                    IMember[] newTupleMembers = new IMember[innermostMappedTuple.getMembers().length];
                    for (int k = 0; k < newTupleMembers.length; ++k) {
                        newTupleMembers[k] = mappedTuple.getMember(k);
                    }
                    Tuple newTuple = new Tuple(newTupleMembers);
                    row.setMappedTuple(newTuple);
                    this.setMappedTuple(newTuple);
                    mappedTuple = newTuple;
                }
            }
        }
        this.removeTupleMembers(row, mappedTuple);
    }

    private boolean isTheSameAsContextMemberOfThis(ContextMember targetMember) {
        AbstractOLAPColumn firstColumnOfThis = this.getFirstColumn();
        int targetMemberId = targetMember.getOlapEdgeMappingColumnId();
        if (targetMemberId == -1) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, TARGET_MEMBER_COLUMN_EQ_XOLAP_EDGE_MAPPING_UNKNOWN_INT_VALUE);
        }
        AbstractOLAPColumn targetMemberColumn = this.getRootRowCycle().findColumnById(targetMemberId);
        if (targetMemberColumn == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "targetMemberColumn == null");
        }
        if (targetMemberColumn.isContextMember() || targetMemberColumn.isHierarchyNormalization() && !targetMemberColumn.isCalculationCM()) {
            targetMemberId = targetMemberColumn.getParentRow().getParentRow().getFirstColumn().getId();
        }
        return targetMemberId == firstColumnOfThis.getId();
    }

    private void removeTupleMembers(AbstractOLAPRow row, ITuple mappedTuple) {
        if (!row.isCycle() && this.getMappedTuple() != null) {
            ITuple newTuple = ((OLAPRow)row).removeTupleMembers(mappedTuple);
            this.setMappedTuple(newTuple);
        }
    }

    @Override
    protected void resetMapping() {
        super.resetMapping();
        for (AbstractOLAPRow row : this.rows) {
            row.resetMapping();
        }
    }

    public AbstractOLAPRow getRow(int index) {
        return this.rows.get(index);
    }

    public int getNumberOfRows() {
        return this.rows.size();
    }

    public int getRowIndex(AbstractOLAPRow row) {
        return this.rows.indexOf(row);
    }

    private void resetNextRowIndex() {
        this.stNextRowIndex = 0;
    }

    public int getNextRowIndex() {
        return this.stNextRowIndex;
    }

    public void setNextRowIndex(int aNextRowIndex) {
        if (aNextRowIndex >= this.rows.size()) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "aNextRowIndex >= this.rows.size()");
        }
        this.stNextRowIndex = aNextRowIndex;
    }

    @Override
    public AbstractOLAPColumn findColumnById(Integer targetId, List<Integer> visited) {
        AbstractOLAPColumn targetColumn = super.findColumnById(targetId, visited);
        if (targetColumn != null) {
            return targetColumn;
        }
        for (AbstractOLAPRow row : this.rows) {
            if (visited.contains(row.getId())) {
                return null;
            }
            targetColumn = row.findColumnById(targetId, visited);
            if (targetColumn == null) continue;
            return targetColumn;
        }
        return null;
    }

    @Override
    public AbstractOLAPRow findRowById(Integer targetId, List<Integer> visited, Integer boundary) {
        AbstractOLAPRow targetRow = null;
        if (this.getId().equals(targetId)) {
            return super.findRowById(targetId, visited, boundary);
        }
        for (AbstractOLAPRow row : this.rows) {
            if (visited.contains(row.getId())) {
                return null;
            }
            targetRow = row.findRowById(targetId, visited, boundary);
            if (targetRow == null) continue;
            return targetRow;
        }
        targetRow = super.findRowById(targetId, visited, boundary);
        if (targetRow != null) {
            return targetRow;
        }
        return null;
    }

    @Override
    protected void getTabularMeasures(Set<RSAPIDataItem> tabularMeasures) {
        super.getTabularMeasures(tabularMeasures);
        for (AbstractOLAPRow row : this.rows) {
            row.getTabularMeasures(tabularMeasures);
        }
    }

    @Override
    public void getDataItemIdexesForSummary(int rowsetId, List<Integer> dataItemIdexes) {
        super.getDataItemIdexesForSummary(rowsetId, dataItemIdexes);
        for (AbstractOLAPRow row : this.rows) {
            row.getDataItemIdexesForSummary(rowsetId, dataItemIdexes);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.resetCycle();
    }

    private void resetCycle() {
        this.partialResetCycle();
        this.stNoMatchRowsForInTuple.clear();
    }

    private void partialResetCycle() {
        for (AbstractOLAPRow row : this.rows) {
            if (row.isCycle()) {
                ((OLAPRowCycle)row).partialResetCycle();
            }
            row.partialReset();
        }
        for (IEdgeElementMappingAction action : this.actions) {
            action.reset();
        }
        this.resetNextRowIndex();
        this.stResetCycle = false;
    }

    public boolean isCurrentRowForHierNormalization() {
        return this.stIsCurrentRowForHierNormalization;
    }

    public void setCurrentRowIsForHierNormalization(boolean isHierNormalization) {
        this.stIsCurrentRowForHierNormalization = isHierNormalization;
    }

    public boolean isNestingSameHierarchy() {
        return this.isNestingSameHierarchy;
    }

    public void setNestingSameHierarchy(boolean value) {
        this.isNestingSameHierarchy = value;
    }

    public boolean isUsingHierarchize() {
        return this.isUsingHierarchize;
    }

    public void setUsingHierarchize(IHierarchy hierarchy, boolean value) {
        if (this.getFirstColumn() != null && hierarchy.equals(this.getFirstColumn().getHierarchy())) {
            this.isUsingHierarchize = value;
        }
        for (AbstractOLAPRow row : this.rows) {
            if (!row.isCycle()) continue;
            ((OLAPRowCycle)row).setUsingHierarchize(hierarchy, value);
        }
    }

    public boolean containsDetailRows() {
        for (AbstractOLAPRow row : this.rows) {
            if (row.isCycle() || !((OLAPRow)row).isDetailRow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resetDone() {
        super.resetDone();
        for (AbstractOLAPRow row : this.rows) {
            row.resetDone();
        }
    }

    @Override
    public AbstractOLAPColumn findColumnById(Integer targetId) {
        AbstractOLAPColumn targetColumn = super.findColumnById(targetId);
        if (targetColumn != null) {
            return targetColumn;
        }
        for (AbstractOLAPRow row : this.rows) {
            targetColumn = row.findColumnById(targetId);
            if (targetColumn == null) continue;
            return targetColumn;
        }
        return null;
    }

    public void flagRenderedColumns(ITuple mappedTuple) {
        if (this.getFirstColumn() != null || mappedTuple == null) {
            this.getIterator().traceMappingTreeState();
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "this.getFirstColumn() != null || this.getMappedTuple() == null");
        }
        ArrayList<Integer> mappedColumnIds = new ArrayList<Integer>();
        IMember[] members = mappedTuple.getMembers();
        for (int i = 0; i < members.length; ++i) {
            if (members[i] == null) {
                this.getIterator().traceMappingTreeState();
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "members[i] == null");
            }
            if (!members[i].isContextMember()) continue;
            ContextMember aContextMember = (ContextMember)members[i];
            List<Integer> ids = aContextMember.getOlapEdgeMappingColumnIds();
            mappedColumnIds.addAll(ids);
        }
        List<Integer> pendingIds = null;
        for (Integer mappedColumnId : mappedColumnIds) {
            AbstractOLAPColumn aColumn;
            if (pendingIds != null && !pendingIds.contains(mappedColumnId) || (aColumn = this.findColumnById(mappedColumnId)) == null) continue;
            if (aColumn.getRulesType() == 4 || aColumn.getRulesType() == 7) {
                AbstractOLAPColumn contextColumn = aColumn.getParentRow().getParentRow().getFirstColumn();
                if (contextColumn == null && aColumn.getParentRow().getParentRow() != aColumn.getParentRow().getRootRowCycle()) {
                    this.getIterator().traceMappingTreeState();
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "flagRenderedColumns failed!");
                }
                if (contextColumn != null) {
                    contextColumn.setRendered(true);
                    contextColumn.getParentRow().setRemoved(false);
                }
            }
            pendingIds = aColumn.flagRenderedColumns(mappedColumnIds);
        }
    }

    @Override
    public AbstractOLAPEdgeElement copy(EdgeElementFactory edgeElementFactory, boolean setAbstractMDXSetProp) {
        OLAPRowCycle newOLAPRowCycle = (OLAPRowCycle)super.copy(edgeElementFactory, setAbstractMDXSetProp);
        if (newOLAPRowCycle.isCycle()) {
            newOLAPRowCycle.setRootRowCycle(this.getRootRowCycle());
        }
        for (AbstractOLAPRow row : this.rows) {
            newOLAPRowCycle.addRow((AbstractOLAPRow)row.copy(edgeElementFactory, setAbstractMDXSetProp), false);
        }
        if (this.calculatedMemberList != null) {
            newOLAPRowCycle.getCalculatedMemberMUNList().addAll(this.calculatedMemberList);
        }
        if (this.getFirstColumn() != null) {
            newOLAPRowCycle.setUsingHierarchize(this.getFirstColumn().getHierarchy(), this.isUsingHierarchize());
        }
        newOLAPRowCycle.setParentXNode(this.getParentXNode());
        return newOLAPRowCycle;
    }

    @Override
    public AbstractOLAPEdgeElement exactCopy(EdgeElementFactory edgeElementFactory) {
        OLAPRowCycle newOLAPRowCycle = (OLAPRowCycle)super.exactCopy(edgeElementFactory);
        for (AbstractOLAPRow row : this.rows) {
            newOLAPRowCycle.addRow((AbstractOLAPRow)row.exactCopy(edgeElementFactory), true);
        }
        if (this.calculatedMemberList != null) {
            newOLAPRowCycle.getCalculatedMemberMUNList().addAll(this.calculatedMemberList);
        }
        if (this.getFirstColumn() != null) {
            newOLAPRowCycle.setUsingHierarchize(this.getFirstColumn().getHierarchy(), this.isUsingHierarchize());
        }
        newOLAPRowCycle.setParentXNode(this.getParentXNode());
        return newOLAPRowCycle;
    }

    @Override
    public void updateMissingAbstractMDXSetProp(AbstractOLAPEdgeElement abstractOLAPEdgeElement) {
        if (abstractOLAPEdgeElement.isRow() && ((AbstractOLAPRow)abstractOLAPEdgeElement).isCycle()) {
            super.updateMissingAbstractMDXSetProp(abstractOLAPEdgeElement);
            int rowIndex = -1;
            for (AbstractOLAPRow row : this.rows) {
                row.updateMissingAbstractMDXSetProp(((OLAPRowCycle)abstractOLAPEdgeElement).getRow(++rowIndex));
            }
        }
    }

    @Override
    public void rebuildMUNRules(EdgeElementFactory edgeElementFactory) {
        super.rebuildMUNRules(edgeElementFactory);
        for (AbstractOLAPRow row : this.rows) {
            row.rebuildMUNRules(edgeElementFactory);
        }
    }

    @Override
    public void rebuildMUNRulesForPowerCubeRootAliases() {
        super.rebuildMUNRulesForPowerCubeRootAliases();
        for (AbstractOLAPRow row : this.rows) {
            row.rebuildMUNRulesForPowerCubeRootAliases();
        }
    }

    @Override
    public void rebuildMUNRulesForNoMember() {
        super.rebuildMUNRulesForNoMember();
        for (AbstractOLAPRow row : this.rows) {
            row.rebuildMUNRulesForNoMember();
        }
    }

    @Override
    public void rebuildMUNRulesForReplacedRootMember(BaseMember replacedRootMember, AbstractMDXMember replacement, ActionFactory actionFactory) {
        super.rebuildMUNRulesForReplacedRootMember(replacedRootMember, replacement, actionFactory);
        for (AbstractOLAPRow row : this.rows) {
            row.rebuildMUNRulesForReplacedRootMember(replacedRootMember, replacement, actionFactory);
        }
    }

    @Override
    public void cleanDeletedMemberDescriptors() {
        super.cleanDeletedMemberDescriptors();
        for (AbstractOLAPRow row : this.rows) {
            row.cleanDeletedMemberDescriptors();
        }
    }

    public boolean isLastRow(AbstractOLAPRow row) {
        if (this.rows.isEmpty()) {
            return false;
        }
        return this.rows.get(this.rows.size() - 1) == row;
    }

    public ICube getCube() {
        if (this.getFirstColumn() != null) {
            return this.getFirstColumn().getHierarchy().getDimension().getCube();
        }
        if (!this.rows.isEmpty()) {
            return this.getRow(0).getFirstColumn().getHierarchy().getDimension().getCube();
        }
        return null;
    }

    @Override
    public boolean isAncestorsQueryRequired() {
        if (this.getFirstColumn() != null && this.isNestingSameHierarchy && this.getFirstColumn().getHierarchy().isRagged()) {
            return true;
        }
        if (super.isAncestorsQueryRequired()) {
            return true;
        }
        for (AbstractOLAPRow row : this.rows) {
            if (!row.isAncestorsQueryRequired()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setIterator(XOLAPEdgeMapping.OLAPEdgeMappingIterator anIterator) {
        super.setIterator(anIterator);
        for (AbstractOLAPRow row : this.rows) {
            row.setIterator(anIterator);
        }
    }

    @Override
    public void addRemoveAction(EdgeElementFactory edgeElementFactory) {
        for (AbstractOLAPRow row : this.rows) {
            row.addRemoveAction(edgeElementFactory);
        }
    }

    @Override
    public void setHierarchyNormalization(boolean value) {
        super.setHierarchyNormalization(value);
        for (AbstractOLAPRow row : this.rows) {
            row.setHierarchyNormalization(value);
        }
    }

    public List<String> getCalculatedMemberMUNList() {
        if (this.calculatedMemberList == null) {
            this.calculatedMemberList = new ArrayList<String>();
        }
        return this.calculatedMemberList;
    }

    public void addCalculatedMemberMUN(String calcMUN) {
        if (!this.getCalculatedMemberMUNList().contains(calcMUN)) {
            this.calculatedMemberList.add(calcMUN);
        }
    }

    public List<AbstractOLAPColumn> getFirstPath(List<AbstractOLAPColumn> path) {
        path.add(this.getFirstColumn());
        AbstractOLAPRow row = this.getRow(0);
        if (row.isCycle()) {
            ((OLAPRowCycle)row).getFirstPath(path);
        } else {
            for (int i = 0; i < row.getNumberOfColumns(); ++i) {
                path.add(row.getColumn(i));
            }
        }
        return path;
    }

    public List<AbstractOLAPColumn> getLastPath(List<AbstractOLAPColumn> path) {
        path.add(this.getFirstColumn());
        AbstractOLAPRow row = this.getRow(this.getNumberOfRows() - 1);
        if (row.isCycle()) {
            ((OLAPRowCycle)row).getLastPath(path);
        } else {
            for (int i = 0; i < row.getNumberOfColumns(); ++i) {
                path.add(row.getColumn(i));
            }
        }
        return path;
    }

    @Override
    public void setRootRowCycle(OLAPRowCycle aRootRowCycle) {
        this.rootRowCycle = aRootRowCycle;
        for (AbstractOLAPRow row : this.rows) {
            row.setRootRowCycle(aRootRowCycle);
        }
    }

    public ITuple getUnbalancedTuple() {
        return this.stUnbalancedTuple;
    }

    protected void setUnbalancedTuple(ITuple aTuple) {
        this.stUnbalancedTuple = aTuple;
    }

    public ITuple getstPostponedInputForHandlingPrevUnbalanced() {
        return this.stPostponedInputForHandlingPrevUnbalanced;
    }

    public void setstPostponedInputForHandlingPrevUnbalanced(ITuple cachedInputTuple) {
        this.stPostponedInputForHandlingPrevUnbalanced = cachedInputTuple;
    }

    protected void clearUnbalancedTuple() {
        this.setUnbalancedTuple(null);
        for (AbstractOLAPRow row : this.rows) {
            if (!row.isCycle()) continue;
            ((OLAPRowCycle)row).clearUnbalancedTuple();
        }
    }

    @Override
    public int getMeasuresFinalTuplePosition() {
        int measureTuplePosition = -1;
        AbstractOLAPColumn contextColumn = this.getFirstColumn();
        if (contextColumn != null && (measureTuplePosition = contextColumn.getMeasuresFinalTuplePosition()) != -1) {
            return measureTuplePosition;
        }
        for (AbstractOLAPRow row : this.rows) {
            measureTuplePosition = row.getMeasuresFinalTuplePosition();
            if (measureTuplePosition == -1) continue;
            return measureTuplePosition;
        }
        return measureTuplePosition;
    }

    public AbstractOLAPRow getNextSiblingRow(AbstractOLAPRow abstractOLAPRow) {
        boolean isNext = false;
        for (AbstractOLAPRow row : this.rows) {
            if (isNext) {
                return row;
            }
            if (row != abstractOLAPRow) continue;
            isNext = true;
        }
        return null;
    }

    public AbstractOLAPRow getPreviousSiblingRow(AbstractOLAPRow abstractOLAPRow) {
        AbstractOLAPRow previousRow = null;
        for (AbstractOLAPRow row : this.rows) {
            if (row == abstractOLAPRow) {
                return previousRow;
            }
            previousRow = row;
        }
        return null;
    }

    public void resetNextMemberListIndexes(boolean skipContextColumnOfThis) {
        if (!skipContextColumnOfThis) {
            super.resetNextMemberListIndexes();
        }
        for (AbstractOLAPRow row : this.rows) {
            if (row.isCycle()) {
                ((OLAPRowCycle)row).resetNextMemberListIndexes(true);
                continue;
            }
            row.resetNextMemberListIndexes();
        }
    }

    @Override
    public void colleactMUNDescriptors(List<EdgeMappingRules.MemberDescriptor> munDescriptorList) {
        super.colleactMUNDescriptors(munDescriptorList);
        for (AbstractOLAPRow row : this.rows) {
            row.colleactMUNDescriptors(munDescriptorList);
        }
    }

    @Override
    public void removeCogMDXGroupFromAbstractOLAPColumns() {
        super.removeCogMDXGroupFromAbstractOLAPColumns();
        for (AbstractOLAPRow row : this.rows) {
            row.removeCogMDXGroupFromAbstractOLAPColumns();
        }
    }

    public void mapUnbalancedTuple(int numOfMembers) {
        for (Object currColumn : this.columns) {
            if (((AbstractOLAPColumn)currColumn).getCurrentMember() != null) continue;
            return;
        }
        IMember[] mappedMembers = null;
        mappedMembers = new IMember[numOfMembers];
        for (AbstractOLAPColumn currColumn : this.columns) {
            ContextMember aContextMember = currColumn.createContextMember();
            aContextMember = EdgeMappingUtils.applyRenamingActions(currColumn, aContextMember);
            mappedMembers[currColumn.getTuplePosition()] = aContextMember;
        }
        Tuple mappedTuple = new Tuple(mappedMembers);
        this.setUnbalancedTuple(mappedTuple);
    }

    public boolean isNestingAFillerTag() {
        for (AbstractOLAPRow currRow : this.rows) {
            if (currRow.isFillerTagRow() == 0) continue;
            return true;
        }
        return false;
    }

    public boolean areAllRowsRemoved() {
        if (this.doesActionTypeApplies(7)) {
            return true;
        }
        for (int index = 0; index < this.getNumberOfRows(); ++index) {
            AbstractOLAPRow currRow = this.getRow(index);
            if (!(currRow.isCycle() ? !((OLAPRowCycle)currRow).areAllRowsRemoved() : !currRow.doesActionTypeApplies(7))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearCurrentMembers() {
        super.clearCurrentMembers();
        for (int k = 0; k < this.getNumberOfRows(); ++k) {
            this.getRow(k).clearCurrentMembers();
        }
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        if (this.isNestingSameHierarchy()) {
            propertiesMap.put("isNestingSameHierarchy", Boolean.TRUE.toString());
        }
        if (this.isUsingHierarchize()) {
            propertiesMap.put("isUsingHierarchize", Boolean.TRUE.toString());
        }
        if (this.isRowsAddedBaseOnEdgePosition()) {
            propertiesMap.put("rowsAddedBaseOnEdgePosition", Boolean.TRUE.toString());
        }
        if (this.rows != null && !this.rows.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (AbstractOLAPRow row : this.rows) {
                sb.append(row.getClass().getSimpleName());
                sb.append(row.getCheckSumPropertiesMap().toString());
            }
            propertiesMap.put("rows", sb.toString());
        }
        return propertiesMap;
    }

    @Override
    public boolean isCycle() {
        return true;
    }

    private class NoMatchRowsForInTuple {
        protected ITuple inTuple = null;
        protected List<Integer> noMatchRows = new ArrayList<Integer>();

        private NoMatchRowsForInTuple() {
        }

        public void clear() {
            this.inTuple = null;
            this.noMatchRows.clear();
        }

        public void addRejectedRowForTuple(ITuple aTuple, Integer abstractOLAPRowId) {
            if (this.inTuple == null || aTuple == this.inTuple) {
                if (this.noMatchRows.contains(abstractOLAPRowId)) {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "this.noMatchRows.contains(abstractOLAPRowId)");
                }
                this.inTuple = aTuple;
                this.noMatchRows.add(abstractOLAPRowId);
                return;
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "inTuple != null && aTuple != inTuple");
        }

        public boolean hasRowBeenRejectedForTuple(ITuple aTuple, Integer abstractOLAPRowId) {
            if (this.inTuple == null) {
                return false;
            }
            if (aTuple == this.inTuple) {
                return this.noMatchRows.contains(abstractOLAPRowId);
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "aTuple != inTuple");
        }

        public int getNumberOfRejectedRows() {
            return this.noMatchRows.size();
        }
    }
}

