/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.mdx.parser.ASTMDXStatement;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXParserUtility;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.decoration.DecorationResultSet;
import com.cognos.xqe.runtree.olap.decoration.OLAPDecorationAxisIterator;
import com.cognos.xqe.runtree.olap.decoration.XOLAPEdgeDecoration;
import com.cognos.xqe.runtree.olap.decoration.exceptions_and_warnings.OLAPDecorationException;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPEdgeElement;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingRules;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ActionFactory;
import com.cognos.xqe.runtree.olap.edgemapping.actions.CrosstabSpacerDescriptor;
import com.cognos.xqe.runtree.olap.edgemapping.actions.InsertCrosstabSpacer;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.runtree.olap.querytemplates.AncestorQuery;
import com.cognos.xqe.runtree.olap.querytemplates.MissingMemberValidateQuery;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XOLAPEdgeMapping
extends XOLAPEdgeDecoration {
    private static final String ATTRIBUTE_EDGE_ORDINAL = "edgeOrdinal";
    private static final String ATTRIBUTE_CUBE = "cube";
    private static final String ATTRIBUTE_MUN_DESCRIPTOR_FIXED = "stMUNDescriptorsFixed";
    private static final String ATTRIBUTE_COG_MDX_GROUPS_REMOVED = "cogMDXGroupsRemoved";
    private static final String ATTRIBUTE_EDGE_HAS_MDX_NON_EMPTY = "edgeHasMDXNonEmpty";
    private static final String ATTRIBUTE_IS_LIST_REPORT = "isListReport";
    private static final String ELEMENT_ROOT_ROW_CYCYLE = "rootRowCycle";
    private static final String ELEMENT_ANCESTOR_QUERY = "ancestorQuery";
    private static final String ELEMENT_MISSING_MEMBER_QUERY = "missingMemberQuery";
    private static final String ELEMENT_MUN_DESCRIPTOR_LIST = "munDescriptorList";
    private static final String ELEMENT_EDGE_LEVEL_INFO = "edgeLevelInfo";
    private static final String ELEMENT_V5_HIERARCHIES = "v5Hierarchies";
    private static final String DELIMITER = " - ";
    private final boolean extendedCheckSum = false;
    private static final long serialVersionUID = -2440076583505987303L;
    public static final int INITIAL_ARRAY_CAPACITY = 2;
    public static final int UNKNOWN_INT_VALUE = -1;
    public static final String MISSINGMEMBERVALIDATEQUERYREQUIRED = "missingMemberValidateQueryRequired";
    private int edgeOrdinal = -1;
    private OLAPRowCycle rootRowCycle = null;
    private ICube cube = null;
    String interfaceId = null;
    private XMdx ancestorQuery = null;
    XMdx missingMemberQuery = null;
    private List<EdgeMappingRules.MemberDescriptor> munDescriptorList = null;
    private boolean stMUNDescriptorsFixed = false;
    private MDXLevelInfo edgeLevelInfo = null;
    private Set<IHierarchy> v5Hierarchies = null;
    private boolean cogMDXGroupsRemoved = false;
    private static final String[] LOLAP_ANCESTORSQUERY_PROVIDERS = new String[]{"BW", "DO", "EB"};
    private boolean edgeHasMDXNonEmpty = false;
    private boolean isListReport = false;
    private static final String[] LOLAP_QUERY_PROVIDERS = new String[]{"BW", "DO", "EB"};

    public boolean isListReport() {
        return this.isListReport;
    }

    public void setListReport(boolean value) {
        this.isListReport = value;
    }

    public static boolean isLolapAncestorQueryProviders(String providerId) {
        for (String currProvideId : LOLAP_ANCESTORSQUERY_PROVIDERS) {
            if (!currProvideId.equals(providerId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getType() {
        return 501144;
    }

    public boolean areCogMDXGroupRemoved() {
        return this.cogMDXGroupsRemoved;
    }

    public void setCogMDXGroupRemoved(boolean aCogMDXGroupRemoved) {
        this.cogMDXGroupsRemoved = aCogMDXGroupRemoved;
    }

    @Override
    public void setEdgeOrdinal(int anEdgeOrdinal) {
        this.edgeOrdinal = anEdgeOrdinal;
    }

    @Override
    public int getEdgeOrdinal() {
        if (this.edgeOrdinal == -1) {
            throw new IllegalStateException();
        }
        return this.edgeOrdinal;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        Attribute attribute = inputNode.attribute(ATTRIBUTE_EDGE_ORDINAL);
        if (attribute == null) {
            throw new IllegalStateException();
        }
        Integer anEdgeOrdinal = new Integer(attribute.getStringValue());
        this.setEdgeOrdinal(anEdgeOrdinal);
        attribute = inputNode.attribute("edgeName");
        if (attribute != null) {
            this.setEdgeName(attribute.getStringValue());
        }
        if ((attribute = inputNode.attribute("id")) != null) {
            this.setNodeId(XQEIntegerPool.getInteger(Integer.parseInt(attribute.getValue())));
        }
        List childList = inputNode.elements();
        ListIterator listIterator = childList.listIterator();
        XQENodeFactory nodeFactory = env.getNodeFactory();
        EdgeElementFactory edgeElementFactory = env.getEdgeElementFactory();
        this.createRootRowCycle(env);
        while (listIterator.hasNext()) {
            Element anElement = (Element)listIterator.next();
            String elementName = anElement.getName();
            AbstractOLAPEdgeElement row = edgeElementFactory.createEdgeElementByName(elementName);
            if (row != null) {
                if (row.isColumn()) {
                    throw new IllegalStateException();
                }
                row.capture(env, anElement, anEdgeOrdinal);
                this.addRow((AbstractOLAPRow)row, true);
                continue;
            }
            XNode xNode = (XNode)nodeFactory.createNodeByName(anElement.getName());
            if (xNode == null) continue;
            xNode.capture(env, anElement);
            this.addChild(xNode);
        }
    }

    @Override
    public void dump(XQETrace trace, boolean includeRuntimeSpecifics) {
        Integer nodeID = -1;
        if (includeRuntimeSpecifics) {
            nodeID = this.getId();
        }
        trace.beginElement(this.getNodeTypeName(), nodeID);
        this.dumpExtraInfo(trace, includeRuntimeSpecifics);
        if (this.rootRowCycle != null) {
            this.rootRowCycle.dump(trace);
        }
        if (this.getAncestorQuery() != null) {
            trace.beginElement(ELEMENT_ANCESTOR_QUERY);
            this.getAncestorQuery().dump(trace);
            trace.endElement();
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            this.getChild(i).dump(trace, includeRuntimeSpecifics);
        }
        trace.endElement();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        if (this.getEdgeName() != null) {
            trace.attribute("edgeName", this.getEdgeName());
        }
        if (this.getCube() != null) {
            trace.attribute(ATTRIBUTE_CUBE, this.getCube().getName());
        }
    }

    @Override
    protected CacheHints getCacheHints() {
        return CacheHints.cacheOneAxisNoCells(this.getEdgeOrdinal());
    }

    @Override
    protected DecorationResultSet executeImpl(XDataContext context, ICubeResultSet cubeResult) {
        return new EdgeMappingResultSet(context, cubeResult, this);
    }

    @Override
    public boolean isDecorationNode() {
        return true;
    }

    @Override
    public void release() {
        super.release();
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        propertiesMap.put(ATTRIBUTE_EDGE_ORDINAL, XQEIntegerPool.getInteger(this.getEdgeOrdinal()).toString());
        propertiesMap.put("edgeName", this.getEdgeName());
        return propertiesMap;
    }

    public void createRootRowCycle(PlanningEnvironment planningEnvironment) {
        EdgeElementFactory edgeElementFactory = planningEnvironment.getEdgeElementFactory();
        if (this.rootRowCycle == null) {
            this.rootRowCycle = (OLAPRowCycle)edgeElementFactory.createEdgeElementByType(1);
            this.rootRowCycle.setRootRowCycle(this.rootRowCycle);
            this.rootRowCycle.setParentXNode(this);
        }
    }

    public OLAPRowCycle getRootRowCycle() {
        return this.rootRowCycle;
    }

    public void addRow(AbstractOLAPRow aRow, boolean isCapture) {
        this.rootRowCycle.addRow(aRow, isCapture);
    }

    public void rebuildMUNRules(EdgeElementFactory edgeElementFactory) {
        if (this.rootRowCycle != null) {
            this.rootRowCycle.rebuildMUNRules(edgeElementFactory);
        }
    }

    public void rebuildMUNRulesForPowerCubeRootAliases() {
        if (this.rootRowCycle != null) {
            this.rootRowCycle.rebuildMUNRulesForPowerCubeRootAliases();
        }
    }

    public void rebuildMUNRulesForNoMember() {
        if (this.rootRowCycle != null) {
            this.rootRowCycle.rebuildMUNRulesForNoMember();
        }
    }

    public void rebuildMUNRulesForReplacedRootMember(BaseMember replacedRootMember, AbstractMDXMember replacement, ActionFactory actionFactory) {
        if (this.rootRowCycle != null) {
            this.rootRowCycle.rebuildMUNRulesForReplacedRootMember(replacedRootMember, replacement, actionFactory);
        }
    }

    public void cleanDeletedMemberDescriptors() {
        if (this.rootRowCycle != null) {
            this.rootRowCycle.cleanDeletedMemberDescriptors();
        }
    }

    public boolean isEmpty() {
        return this.rootRowCycle.getNumberOfRows() == 0;
    }

    public ICube getCube() {
        if (this.cube == null && this.rootRowCycle != null) {
            this.setCube(this.rootRowCycle.getCube());
        }
        return this.cube;
    }

    protected void setCube(ICube aCube) {
        this.cube = aCube;
    }

    public IModelDataSource getDataSource() {
        ICube aCube = this.getCube();
        if (aCube == null) {
            return null;
        }
        return aCube.getModelDataSource();
    }

    public String getInterfaceId() {
        if (this.getDataSource() == null) {
            return null;
        }
        if (this.interfaceId == null) {
            this.interfaceId = this.getDataSource().getInterface();
        }
        return this.interfaceId;
    }

    public XMdx getAncestorQuery() {
        return this.ancestorQuery;
    }

    public void setAncestorQuery(XMdx anAncestorQuery) {
        this.ancestorQuery = anAncestorQuery;
    }

    public XMdx getMissingMemberQuery() {
        return this.missingMemberQuery;
    }

    public void setMissingMemberQuery(XMdx aMissingMemberQuery) {
        this.missingMemberQuery = aMissingMemberQuery;
    }

    public MDXLevelInfo getEdgeLevelInfo() {
        return this.edgeLevelInfo;
    }

    public void setEdgeLevelInfo(MDXLevelInfo anEdgeLevelInfo) {
        this.edgeLevelInfo = anEdgeLevelInfo;
    }

    public Set<IHierarchy> getV5Hierarchies() {
        return this.v5Hierarchies;
    }

    public void setV5Hierarchies(Set<IHierarchy> aV5Hierarchies) {
        this.v5Hierarchies = aV5Hierarchies;
    }

    public boolean isAncestorsQueryRequired() {
        return this.ancestorQuery == null && this.rootRowCycle.isAncestorsQueryRequired();
    }

    public static boolean isLolapQueryProviders(String providerId) {
        for (String currProvideId : LOLAP_QUERY_PROVIDERS) {
            if (!currProvideId.equals(providerId)) continue;
            return true;
        }
        return false;
    }

    public boolean isMissingMemberValidateQueryRequired() {
        if (this.getMissingMemberQuery() != null) {
            return false;
        }
        if (this.munDescriptorList == null) {
            this.munDescriptorList = new ArrayList<EdgeMappingRules.MemberDescriptor>();
            this.rootRowCycle.colleactMUNDescriptors(this.munDescriptorList);
            return !this.munDescriptorList.isEmpty();
        }
        return !this.munDescriptorList.isEmpty();
    }

    @Override
    public String toString() {
        return EdgeMappingUtils.createNodeIdString(this.getClass().getSimpleName(), this.getId()).toString();
    }

    public boolean hasEdegeMDXNonEmpty() {
        return this.edgeHasMDXNonEmpty;
    }

    public void setEdgeHasMDXNonEmpty(boolean value) {
        this.edgeHasMDXNonEmpty = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCorrectMUN(IHybridResultSet queryResult, String mun) {
        XIterator membersIterator = queryResult.getAxisIterator(0);
        try {
            ITuple aTuple = (ITuple)membersIterator.next();
            if (aTuple == null) {
                String string = null;
                return string;
            }
            IMember aMember = aTuple.getMember(0);
            String aMUN = aMember.getUniqueName();
            if (!mun.equals(aMUN)) {
                String string = aMUN;
                return string;
            }
            String string = mun;
            return string;
        }
        finally {
            if (membersIterator != null) {
                membersIterator.release();
            }
        }
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_EDGE_ORDINAL, this.edgeOrdinal);
        ctx.property(ATTRIBUTE_CUBE, this.cube);
        ctx.property(ATTRIBUTE_MUN_DESCRIPTOR_FIXED, this.stMUNDescriptorsFixed);
        ctx.property(ATTRIBUTE_COG_MDX_GROUPS_REMOVED, this.cogMDXGroupsRemoved);
        ctx.property(ATTRIBUTE_EDGE_HAS_MDX_NON_EMPTY, this.edgeHasMDXNonEmpty);
        ctx.property(ATTRIBUTE_IS_LIST_REPORT, this.isListReport);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.rootRowCycle != null) {
            ctx.elementProperty(ELEMENT_ROOT_ROW_CYCYLE, this.rootRowCycle);
        }
        if (this.ancestorQuery != null) {
            ctx.elementProperty(ELEMENT_ANCESTOR_QUERY, this.ancestorQuery);
        }
        if (this.missingMemberQuery != null) {
            ctx.elementProperty(ELEMENT_MISSING_MEMBER_QUERY, this.missingMemberQuery);
        }
        if (this.munDescriptorList != null) {
            ctx.elementProperty(ELEMENT_MUN_DESCRIPTOR_LIST, this.munDescriptorList);
        }
        if (this.edgeLevelInfo != null) {
            ctx.elementProperty(ELEMENT_EDGE_LEVEL_INFO, this.edgeLevelInfo);
        }
        if (this.v5Hierarchies != null) {
            ctx.elementProperty(ELEMENT_V5_HIERARCHIES, this.v5Hierarchies);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_EDGE_ORDINAL)) {
            Object value = ctx.attributeValue(att);
            this.edgeOrdinal = (Integer)value;
        } else if (attname.equals(ATTRIBUTE_CUBE)) {
            Object value = ctx.attributeValue(att);
            this.cube = (ICube)value;
        } else if (attname.equals(ATTRIBUTE_MUN_DESCRIPTOR_FIXED)) {
            Object value = ctx.attributeValue(att);
            this.stMUNDescriptorsFixed = (Boolean)value;
        } else if (attname.equals(ATTRIBUTE_COG_MDX_GROUPS_REMOVED)) {
            Object value = ctx.attributeValue(att);
            this.cogMDXGroupsRemoved = (Boolean)value;
        } else if (attname.equals(ATTRIBUTE_EDGE_HAS_MDX_NON_EMPTY)) {
            Object value = ctx.attributeValue(att);
            this.edgeHasMDXNonEmpty = (Boolean)value;
        } else if (attname.equals(ATTRIBUTE_IS_LIST_REPORT)) {
            Object value = ctx.attributeValue(att);
            this.isListReport = (Boolean)value;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_ROOT_ROW_CYCYLE)) {
            Object value = ctx.elementValue(node);
            this.rootRowCycle = (OLAPRowCycle)value;
        } else if (pname.equals(ELEMENT_ANCESTOR_QUERY)) {
            Object value = ctx.elementValue(node);
            this.ancestorQuery = (XMdx)value;
        } else if (pname.equals(ELEMENT_MISSING_MEMBER_QUERY)) {
            Object value = ctx.elementValue(node);
            this.missingMemberQuery = (XMdx)value;
        } else if (pname.equals(ELEMENT_MUN_DESCRIPTOR_LIST)) {
            Object value = ctx.elementValue(node);
            this.munDescriptorList = (List)value;
        } else if (pname.equals(ELEMENT_EDGE_LEVEL_INFO)) {
            Object value = ctx.elementValue(node);
            this.edgeLevelInfo = (MDXLevelInfo)value;
        } else if (pname.equals(ELEMENT_V5_HIERARCHIES)) {
            Object value = ctx.elementValue(node);
            this.v5Hierarchies = (Set)value;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    public final class OLAPEdgeMappingIterator
    extends OLAPDecorationAxisIterator {
        private static final String UNKNOWN_SPACER_POSITION = "spacerPosition?";
        private EdgeMappingResultSet resultSet;
        public static final int MISSING = 0;
        public static final int FOR_LEVEL = 1;
        private int numAxes;
        private long[] axisSizes;
        private XCellIterator cellIterator;
        private ICell cachedCell;
        private OLAPRowCycle itRootRowCycle;
        private List<EdgeMappingRules.MemberDescriptor> itMUNDescriptorList;
        private int stIndexOfLastMappedMember;
        private int numOfV5Hierarchies;
        boolean endOfAxis;
        boolean retrySameTupleIn;
        AbstractOLAPRow stSpacerParent;
        AbstractOLAPRow stPendingSpacerParent;
        SpacerBuilder stSpacerBuilder;
        protected ITuple stOutputTupleForSpacer;
        protected ITuple stLastRenderedTuple;
        protected ITuple stCachedInputTuple;

        public boolean isEndOfAxis() {
            return this.endOfAxis;
        }

        public void setEndOfAxis(boolean value) {
            this.endOfAxis = value;
        }

        public boolean isRetrySameTupleIn() {
            return this.retrySameTupleIn;
        }

        public void setRetrySameTupleIn(boolean value) {
            this.retrySameTupleIn = value;
        }

        public ITuple getCachedInputTuple() {
            return this.stCachedInputTuple;
        }

        public void setCachedInputTuple(ITuple aTuple) {
            this.stCachedInputTuple = aTuple;
        }

        public AbstractOLAPRow getSpacerParent() {
            return this.stSpacerParent;
        }

        public void setSpacerParent(AbstractOLAPRow row) {
            this.stSpacerParent = row;
        }

        public AbstractOLAPRow getPendingSpacerParent() {
            return this.stPendingSpacerParent;
        }

        public void setPendingSpacerParent(AbstractOLAPRow row) {
            this.stPendingSpacerParent = row;
        }

        public SpacerBuilder getSpacerBuilder() {
            return this.stSpacerBuilder;
        }

        public void setSpacerBuilder(SpacerBuilder aSpacerBuilder) {
            this.stSpacerBuilder = aSpacerBuilder;
        }

        public ITuple getOutputTupleForSpacer() {
            return this.stOutputTupleForSpacer;
        }

        protected void setOutputTupleForSpacer(ITuple aTuple) {
            this.stOutputTupleForSpacer = aTuple;
        }

        public ITuple getLastRenderedTuple() {
            return this.stLastRenderedTuple;
        }

        public void setLastRenderedTuple(ITuple aTuple) {
            this.stLastRenderedTuple = aTuple;
        }

        public int getIndexOfLastMappedMember() {
            return this.stIndexOfLastMappedMember;
        }

        public void setIndexOfLastMappedMember(int index) {
            this.stIndexOfLastMappedMember = index;
        }

        private OLAPEdgeMappingIterator(int ordinal, XOLAPEdgeDecoration parent, DecorationResultSet aResultSet) {
            super(ordinal, parent, aResultSet, XOLAPEdgeMapping.this.getId());
            this.itRootRowCycle = null;
            this.itMUNDescriptorList = null;
            this.stIndexOfLastMappedMember = -1;
            this.numOfV5Hierarchies = -1;
            this.endOfAxis = false;
            this.retrySameTupleIn = false;
            this.stSpacerParent = null;
            this.stPendingSpacerParent = null;
            this.stSpacerBuilder = null;
            this.stOutputTupleForSpacer = null;
            this.stLastRenderedTuple = null;
            this.stCachedInputTuple = null;
            this.resultSet = (EdgeMappingResultSet)aResultSet;
            XOLAPEdgeMapping xOLAPEdgeMapping = this.getXParent();
            this.numOfV5Hierarchies = xOLAPEdgeMapping.getV5Hierarchies().size();
            EdgeElementFactory edgeElementFactory = new EdgeElementFactory();
            this.itRootRowCycle = (OLAPRowCycle)xOLAPEdgeMapping.getRootRowCycle().exactCopy(edgeElementFactory);
            this.itRootRowCycle.setIterator(this);
            this.itRootRowCycle.setRootRowCycle(this.itRootRowCycle);
            if (XOLAPEdgeMapping.this.munDescriptorList != null) {
                this.itMUNDescriptorList = new ArrayList<EdgeMappingRules.MemberDescriptor>();
                this.itRootRowCycle.colleactMUNDescriptors(this.itMUNDescriptorList);
            }
            try {
                ICubeResultSet baseResultSet = this.resultSet.getBaseResultSet();
                this.numAxes = baseResultSet.getNumAxes();
                this.axisSizes = new long[this.numAxes];
                for (int i = 0; i < ordinal; ++i) {
                    this.axisSizes[i] = baseResultSet.getAxisSize(i);
                }
                this.cellIterator = baseResultSet.getCellIterator();
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        public XCellIterator getSourceCellIterator() {
            return this.cellIterator;
        }

        public long getSourceCoordinate() {
            return this.oldCoordinate;
        }

        @Override
        public Object nextImpl() {
            this.openIteratorTrace(this.parentXNode, this.parentXNode.getEdgeOrdinal(), this.parentXNode.getEdgeName(), true);
            this.openNextImplTrace(++this.callId);
            ITuple tupleResult = null;
            try {
                tupleResult = this.nextTuple();
                this.setLastRenderedTuple(tupleResult);
                if (tupleResult != null) {
                    this.coordinateMap.map(++this.newCoordinate, this.oldCoordinate);
                }
                this.traceOutTuple(tupleResult, this.oldCoordinate, this.newCoordinate);
                this.closeNextImplTrace();
                if (tupleResult == null) {
                    this.traceCountOfSourceTuples(this.sourceTupleCount);
                    this.closeIteratorTrace();
                }
            }
            catch (XQERuntimeException rte) {
                this.closeNextImplTrace();
                this.traceCountOfSourceTuples(this.sourceTupleCount);
                this.closeIteratorTrace();
                this.setTraceOpen(false);
                throw rte;
            }
            catch (Throwable t) {
                this.closeNextImplTrace();
                this.traceCountOfSourceTuples(this.sourceTupleCount);
                this.closeIteratorTrace();
                this.setTraceOpen(false);
                StringBuilder sb = new StringBuilder(t.getClass().getSimpleName());
                sb.append(XOLAPEdgeMapping.DELIMITER);
                sb.append(t.getLocalizedMessage());
                this.getXParent().throwInternalError(sb.toString(), t);
            }
            return tupleResult;
        }

        protected ITuple nextTuple() {
            ITuple tupleOut = null;
            boolean getTuple = true;
            while (getTuple) {
                if (this.getOutputTupleForSpacer() != null && (tupleOut = this.handleSpacerRowAfterTheFirstTime()) != null) {
                    this.traceMappingTreeState();
                    return tupleOut;
                }
                ITuple tupleIn = this.nextFromBaseImpl();
                if (tupleIn == null && this.getSpacerBuilder() != null) {
                    this.setOutputTupleForSpacer(this.getLastRenderedTuple());
                    continue;
                }
                if (tupleIn == null && this.getPendingSpacerParent() != null) {
                    this.setSpacerParent(this.getPendingSpacerParent());
                    this.setPendingSpacerParent(null);
                    ITuple lastRenderedTuple = this.getLastRenderedTuple();
                    this.buildSpacerBuilder(lastRenderedTuple);
                    if (this.getSpacerBuilder() != null) {
                        this.setOutputTupleForSpacer(lastRenderedTuple);
                        continue;
                    }
                } else if (tupleIn != null && this.getSpacerBuilder() != null) {
                    boolean foundPendingAFTERSpacer = false;
                    if (tupleIn.getMembers().length == 1) {
                        ContextMember lastRenderedMember = (ContextMember)this.getLastRenderedTuple().getMember(0);
                        int columnId = lastRenderedMember.getOlapEdgeMappingColumnId();
                        AbstractOLAPRow spacerParentRow = this.getSpacerParent();
                        if (!spacerParentRow.isCycle()) {
                            foundPendingAFTERSpacer = spacerParentRow.getFirstColumn().getId() == columnId;
                        } else {
                            OLAPRowCycle spacerParentRowCycle = (OLAPRowCycle)spacerParentRow;
                            if (spacerParentRowCycle.getNextRowIndex() > 0) {
                                AbstractOLAPRow lastRenderedRow = spacerParentRowCycle.getRow(spacerParentRowCycle.getNextRowIndex() - 1);
                                if (lastRenderedRow.isDone()) {
                                    for (int j = 0; j < lastRenderedRow.getNumberOfColumns(); ++j) {
                                        if (lastRenderedRow.getColumn(j).getRulesType() == 2 || lastRenderedRow.getColumn(j).getId() != columnId) continue;
                                        foundPendingAFTERSpacer = true;
                                        break;
                                    }
                                }
                            } else if (spacerParentRowCycle.isNestingSameHierarchy() && this.getSpacerBuilder().getDescriptor().getPosition() == 0) {
                                IMember currentMember;
                                ContextMember previousMember = null;
                                while (lastRenderedMember.getContextMember() != null) {
                                    if (lastRenderedMember.getContextMember().getRowset() == null || lastRenderedMember.getContextMember().getRowset().getRowsetId() != spacerParentRowCycle.getFirstRowset().getRowsetId()) continue;
                                    previousMember = lastRenderedMember.getContextMember();
                                    break;
                                }
                                if ((currentMember = tupleIn.getMember(0)).getLevel().equals(previousMember.getLevel()) && !currentMember.getUniqueName().equals(previousMember.getUniqueName())) {
                                    foundPendingAFTERSpacer = true;
                                }
                            } else if (this.getSpacerBuilder().getDescriptor().getPosition() == 0 && spacerParentRowCycle.getFirstColumn() == null && lastRenderedMember.getContextMember() != null && !spacerParentRowCycle.getRow(0).isCycle() && spacerParentRowCycle.getRow(0).getNumberOfColumns() == 1 && spacerParentRowCycle.getRow(0).getFirstColumn().doesActionTypeApplies(2)) {
                                ContextMember previousOutMember = this.getSpacerBuilder().getTargetMember().getContextMember();
                                IMember currentInMember = tupleIn.getMember(0);
                                if (currentInMember.getParentLevelNumber() == previousOutMember.getLevel().getIndex() && !currentInMember.getParentUniqueName().equals(previousOutMember.getUniqueName())) {
                                    foundPendingAFTERSpacer = true;
                                }
                            }
                        }
                    } else {
                        int tuplePosition = this.getSpacerBuilder().getTuplePositionMatchingSpacerDescriptor();
                        if (tuplePosition == 0) {
                            if (this.getSpacerParent().getFirstColumn() != null && this.getSpacerParent().getFirstColumn().getTuplePosition() == tuplePosition && this.getSpacerParent().getMappedTuple() != null) {
                                IMember previousMember = this.getSpacerParent().getMappedTuple().getMember(tuplePosition);
                                IMember currentMember = tupleIn.getMember(tuplePosition);
                                if (!currentMember.getUniqueName().equals(previousMember.getUniqueName())) {
                                    foundPendingAFTERSpacer = true;
                                }
                            }
                        } else {
                            for (int i = 0; i < tuplePosition; ++i) {
                                IMember lastMember = ((ContextMember)this.getLastRenderedTuple().getMember(i)).getMember();
                                if (tupleIn.getMember(i) == lastMember) continue;
                                foundPendingAFTERSpacer = true;
                                break;
                            }
                        }
                    }
                    if (foundPendingAFTERSpacer) {
                        this.setCachedInputTuple(tupleIn);
                        tupleIn = null;
                        this.setOutputTupleForSpacer(this.getLastRenderedTuple());
                        continue;
                    }
                }
                if (tupleIn == null) {
                    this.sourceTupleCount = this.oldCoordinate--;
                    if (this.itRootRowCycle.getUnbalancedTuple() != null) {
                        tupleOut = this.itRootRowCycle.getUnbalancedTuple();
                        this.itRootRowCycle.clearUnbalancedTuple();
                        this.traceMappingTreeState();
                        XOLAPEdgeMapping.this.setSourceTupleCount(this.sourceTupleCount);
                        return tupleOut;
                    }
                    XOLAPEdgeMapping.this.setSourceTupleCount(this.sourceTupleCount);
                    this.itRootRowCycle.reset();
                    return tupleOut;
                }
                this.setIndexOfLastMappedMember(-1);
                boolean mapSuccess = this.itRootRowCycle.map(tupleIn);
                if (this.isRetrySameTupleIn()) {
                    this.setRetrySameTupleIn(false);
                    this.setIndexOfLastMappedMember(-1);
                    mapSuccess = this.itRootRowCycle.map(tupleIn);
                    this.setRetrySameTupleIn(false);
                }
                if (mapSuccess) {
                    tupleOut = this.itRootRowCycle.getMappedTuple();
                    if (tupleOut != null) {
                        if (this.itRootRowCycle.getstPostponedInputForHandlingPrevUnbalanced() != null) {
                            // empty if block
                        }
                        this.sourceTupleCount = --this.oldCoordinate;
                        getTuple = false;
                        this.itRootRowCycle.flagRenderedColumns(tupleOut);
                        if (this.getSpacerParent() != null) {
                            tupleOut = this.handleSpacerRowForTheFirstTime(tupleOut);
                        }
                    } else {
                        getTuple = true;
                        if (this.itRootRowCycle.wasSuppressed()) {
                            this.sourceTupleCount = this.oldCoordinate;
                        }
                    }
                }
                this.traceMappingTreeState();
                if (mapSuccess) continue;
                StringBuilder errorMsg = new StringBuilder("!mapSuccess");
                errorMsg.append(XOLAPEdgeMapping.DELIMITER);
                Object requestEnvironment = this.getResultSet().getDataContext().getEnvironment().getRequestEnvironment();
                String reportName = requestEnvironment.getReportName();
                if (reportName != null) {
                    errorMsg.append("reportName=");
                    errorMsg.append(reportName);
                    errorMsg.append(XOLAPEdgeMapping.DELIMITER);
                }
                if (this.getXParent().getEdgeName() != null) {
                    errorMsg.append("edgeName=");
                    errorMsg.append(this.getXParent().getEdgeName());
                    errorMsg.append(XOLAPEdgeMapping.DELIMITER);
                }
                errorMsg.append("edgeOrdinal=");
                errorMsg.append(this.getXParent().getEdgeOrdinal());
                errorMsg.append(XOLAPEdgeMapping.DELIMITER);
                if (tupleIn != null) {
                    errorMsg.append("tuple=");
                    errorMsg.append(tupleIn.toString());
                }
                errorMsg.append(".");
                mErrorLogger.log(errorMsg.toString());
                StringBuilder errorXInfo = new StringBuilder("\nTuple{");
                for (int i = 0; i < tupleIn.getMembers().length; ++i) {
                    if (tupleIn.getMember(i) != null) {
                        errorXInfo.append("\nMUN:");
                        errorXInfo.append(tupleIn.getMember(i).getUniqueName());
                        if (tupleIn.getMember(i).getLevel() != null) {
                            errorXInfo.append("\nLUN:");
                            errorXInfo.append(tupleIn.getMember(i).getLevel().getUniqueName());
                        }
                        if (tupleIn.getMember(i).getHierarchy() != null) {
                            errorXInfo.append("\nHUN:");
                            errorXInfo.append(tupleIn.getMember(i).getHierarchy().getUniqueName());
                        }
                    } else {
                        errorXInfo.append("null");
                    }
                    if (i >= tupleIn.getMembers().length - i) continue;
                    errorXInfo.append(",");
                }
                errorXInfo.append("}");
                errorXInfo.append("\nOLAPEdgeMappingIterator:\n");
                errorXInfo.append(this.itRootRowCycle.dumpToString());
                mErrorLogger.log(errorXInfo.toString());
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, errorMsg.toString());
            }
            return tupleOut;
        }

        protected ITuple nextFromBaseImpl() {
            ITuple tupleIn = null;
            if (this.getCachedInputTuple() != null) {
                tupleIn = this.getCachedInputTuple();
                this.setCachedInputTuple(null);
            } else if (this.itRootRowCycle.getstPostponedInputForHandlingPrevUnbalanced() != null) {
                tupleIn = this.itRootRowCycle.getstPostponedInputForHandlingPrevUnbalanced();
                this.itRootRowCycle.setstPostponedInputForHandlingPrevUnbalanced(null);
                ++this.oldCoordinate;
            } else {
                tupleIn = this.nextFromSourceIterator();
            }
            this.traceInTuple(tupleIn, this.oldCoordinate);
            return tupleIn;
        }

        private ITuple handleSpacerRowAfterTheFirstTime() {
            boolean afterCase;
            ITuple tupleOut = this.getOutputTupleForSpacer();
            int spacerPosition = -1;
            SpacerBuilder spacerBuilder = this.getSpacerBuilder();
            if (spacerBuilder != null) {
                spacerPosition = spacerBuilder.getSpacerPosition();
            }
            boolean bl = afterCase = spacerPosition == 21 || spacerPosition == 0;
            if (spacerBuilder != null && spacerBuilder.isMatchedByAGeneratedContextMember() && afterCase) {
                return null;
            }
            if (spacerBuilder == null) {
                this.buildSpacerBuilder(tupleOut);
                spacerBuilder = this.getSpacerBuilder();
                if (spacerBuilder == null) {
                    this.setSpacerParent(null);
                    this.setOutputTupleForSpacer(null);
                    if (this.isEndOfAxis() || this.getCachedInputTuple() != null) {
                        tupleOut = null;
                        this.setSpacerBuilder(null);
                    }
                } else {
                    spacerPosition = spacerBuilder.getSpacerPosition();
                    if (spacerPosition == 1 || spacerPosition == 22) {
                        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "CrosstabSpacerCoordinates.BEFORE");
                    }
                    if (this.isEndOfAxis() || this.getCachedInputTuple() != null) {
                        tupleOut = spacerBuilder.buildCrossTabSpacerTuple(tupleOut);
                        this.setSpacerBuilder(null);
                    } else {
                        tupleOut = null;
                        this.setOutputTupleForSpacer(null);
                    }
                }
            } else if (spacerPosition == 1 || spacerPosition == 22) {
                this.buildSpacerBuilder(tupleOut);
                spacerBuilder = this.getSpacerBuilder();
                if (spacerBuilder != null && spacerPosition != spacerBuilder.getSpacerPosition()) {
                    this.setSpacerBuilder(null);
                } else if (this.getSpacerBuilder() == null) {
                    tupleOut = this.getOutputTupleForSpacer();
                    this.setSpacerParent(null);
                    this.setOutputTupleForSpacer(null);
                } else {
                    tupleOut = this.getSpacerBuilder().buildCrossTabSpacerTuple(tupleOut);
                }
            } else if (spacerPosition == 21 || spacerPosition == 0) {
                this.buildSpacerBuilder(tupleOut);
                spacerBuilder = this.getSpacerBuilder();
                if (spacerBuilder != null && spacerPosition != spacerBuilder.getSpacerPosition()) {
                    this.setSpacerBuilder(null);
                    tupleOut = null;
                } else if (spacerBuilder == null) {
                    tupleOut = null;
                    InsertCrosstabSpacer insertCrosstabSpacer = (InsertCrosstabSpacer)this.getSpacerParent().getActionOfTypeForMUN(13, null);
                    insertCrosstabSpacer.resetCrosstabSpacerDescriptors();
                    this.setSpacerParent(null);
                    this.setOutputTupleForSpacer(null);
                } else if (this.isEndOfAxis() || this.getCachedInputTuple() != null) {
                    tupleOut = spacerBuilder.buildCrossTabSpacerTuple(tupleOut);
                    if (spacerPosition != 0) {
                        this.setSpacerBuilder(null);
                    }
                } else {
                    tupleOut = null;
                    this.setOutputTupleForSpacer(null);
                }
            } else {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, UNKNOWN_SPACER_POSITION);
            }
            return tupleOut;
        }

        private ITuple handleSpacerRowForTheFirstTime(ITuple tupleOut) {
            SpacerBuilder spacerBuilder = this.getSpacerBuilder();
            if (spacerBuilder != null && !spacerBuilder.getDescriptor().isApplied() && spacerBuilder.isMatchedByAGeneratedContextMember()) {
                ContextMember newTargetMember = (ContextMember)tupleOut.getMember(spacerBuilder.getTuplePositionMatchingSpacerDescriptor());
                ContextMember oldTargetMember = (ContextMember)this.getOutputTupleForSpacer().getMember(spacerBuilder.getTuplePositionMatchingSpacerDescriptor());
                boolean sameContext = oldTargetMember.getContextMember().getUniqueName().equals(newTargetMember.getContextMember().getUniqueName());
                while (sameContext && oldTargetMember.getContextMember() != null && newTargetMember.getContextMember() != null) {
                    sameContext = oldTargetMember.getContextMember().getUniqueName().equals(newTargetMember.getContextMember().getUniqueName());
                    if (!sameContext) continue;
                    oldTargetMember = oldTargetMember.getContextMember();
                    newTargetMember = newTargetMember.getContextMember();
                }
                if (!sameContext) {
                    ITuple tupleOutTemp = tupleOut;
                    tupleOut = spacerBuilder.buildCrossTabSpacerTuple(this.getOutputTupleForSpacer());
                    this.setOutputTupleForSpacer(tupleOutTemp);
                    this.setSpacerBuilder(null);
                    return tupleOut;
                }
            }
            this.buildSpacerBuilder(tupleOut);
            spacerBuilder = this.getSpacerBuilder();
            if (spacerBuilder == null) {
                return tupleOut;
            }
            int indexOfApplicableRowset = spacerBuilder.getDescriptor().getIndexOfApplicableRowset();
            if (indexOfApplicableRowset == 0) {
                this.setOutputTupleForSpacer(tupleOut);
                int spacerPosition = spacerBuilder.getSpacerPosition();
                if (spacerPosition == 1 || spacerPosition == 22 || spacerPosition == 3) {
                    tupleOut = spacerBuilder.buildCrossTabSpacerTuple(tupleOut);
                    if (spacerPosition == 3) {
                        this.setOutputTupleForSpacer(null);
                        this.setSpacerBuilder(null);
                        this.setSpacerParent(null);
                    }
                }
            } else {
                int spacerPosition = spacerBuilder.getSpacerPosition();
                if (spacerPosition == 1 || spacerPosition == 22 || spacerPosition == 3) {
                    this.setOutputTupleForSpacer(tupleOut);
                    tupleOut = spacerBuilder.buildCrossTabSpacerTuple(tupleOut);
                }
                if (spacerPosition == 4) {
                    tupleOut = spacerBuilder.buildCrossTabSpacerTuple(tupleOut);
                    this.setSpacerBuilder(null);
                }
            }
            return tupleOut;
        }

        private void buildSpacerBuilder(ITuple tupleOut) {
            InsertCrosstabSpacer insertCrosstabSpacer = (InsertCrosstabSpacer)this.getSpacerParent().getActionOfTypeForMUN(13, null);
            IMember[] members = tupleOut.getMembers();
            int index = -1;
            CrosstabSpacerDescriptor spacerDescriptor = null;
            for (IMember member : members) {
                ++index;
                ContextMember innerMember = (ContextMember)member;
                for (ContextMember outerMember = (ContextMember)member; outerMember != null; outerMember = outerMember.getContextMember()) {
                    RSAPIEdgeRowset rowSet = (RSAPIEdgeRowset)outerMember.getRowset();
                    if (rowSet != null && (spacerDescriptor = insertCrosstabSpacer.findSpacerForRSAPIRowset(rowSet, true)) != null) {
                        if (this.getSpacerBuilder() != null && spacerDescriptor == this.getSpacerBuilder().getDescriptor()) break;
                        ContextMember context = null;
                        if (innerMember != outerMember && !insertCrosstabSpacer.isMatchedByAGeneratedContextMember()) {
                            context = outerMember;
                        }
                        this.setSpacerBuilder(new SpacerBuilder(spacerDescriptor, innerMember, context, index, insertCrosstabSpacer.isMatchedByAGeneratedContextMember()));
                        break;
                    }
                    innerMember = outerMember;
                }
                if (spacerDescriptor == null) continue;
                int spacerContextTuplePosition = 0;
                AbstractOLAPColumn columnProvidingContextToSpacer = OLAPRow.getColumnProvidingContextToSpacer(this.getSpacerParent(), spacerDescriptor);
                if (columnProvidingContextToSpacer != null) {
                    spacerContextTuplePosition = columnProvidingContextToSpacer.getTuplePosition();
                }
                ContextMember targetMember = null;
                targetMember = index == spacerContextTuplePosition ? innerMember : (ContextMember)members[spacerContextTuplePosition];
                this.getSpacerBuilder().setTargetMember(targetMember);
                break;
            }
            if (spacerDescriptor == null) {
                this.setSpacerBuilder(null);
            }
        }

        private ITuple nextFromSourceIterator() {
            ITuple currTuple = null;
            if (this.isTraceOpen()) {
                try {
                    currTuple = (ITuple)this.sourceIterator.next();
                }
                catch (Exception t) {
                    throw XQERuntimeException.wrap(t);
                }
            } else {
                currTuple = (ITuple)this.sourceIterator.next();
            }
            if (currTuple == null && !this.isEndOfAxis()) {
                this.setEndOfAxis(true);
            }
            if (currTuple != null || this.getSpacerBuilder() == null) {
                ++this.oldCoordinate;
            }
            return currTuple;
        }

        protected void traceMappingTreeState() {
            if (this.isTraceOpen()) {
                try {
                    this.iteratorTrace.beginElement("mappingTreeState", -1);
                    this.itRootRowCycle.dump(this.iteratorTrace);
                    this.iteratorTrace.endElement();
                    this.iteratorTrace.flush();
                }
                catch (Throwable t) {
                    mErrorLogger.log(t);
                    this.setTraceOpen(false);
                }
            }
        }

        @Override
        public void release() {
            super.release();
            this.itRootRowCycle.reset();
            this.itRootRowCycle = null;
            this.itMUNDescriptorList.clear();
            this.itMUNDescriptorList = null;
            this.sourceTupleCount = 0L;
            this.cachedCell = null;
            if (this.cellIterator != null) {
                this.cellIterator.release();
                this.cellIterator = null;
            }
            this.stLastRenderedTuple = null;
            this.stCachedInputTuple = null;
            this.stPendingSpacerParent = null;
            this.stSpacerBuilder = null;
            this.stSpacerParent = null;
        }

        public EdgeMappingResultSet getResultSet() {
            return this.resultSet;
        }

        public Set<IMember> getMemberAncestry(IMember aMember, int tuplePosition, int lowesMostLevelNumber, int fetchType) {
            IMember parentMember;
            HashSet<IMember> ancestryList = new HashSet<IMember>();
            String parentUniqueName = aMember.getParentUniqueName();
            if (parentUniqueName == null) {
                return ancestryList;
            }
            Map<Object, Object> membersMap = new HashMap<String, IMember>();
            for (IMember ancestor = aMember.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                membersMap.put(ancestor.getUniqueName(), ancestor);
            }
            if (membersMap.isEmpty() && XOLAPEdgeMapping.this.getAncestorQuery() != null && ((membersMap = fetchType == 1 ? this.resultSet.getAncestorMembersMapForLevel(aMember.getLevel().getUniqueName()) : this.resultSet.getAncestorMembersMap()) == null || !membersMap.containsKey(parentUniqueName))) {
                membersMap = this.createAncestorsMap(aMember, tuplePosition, lowesMostLevelNumber, fetchType);
                if (fetchType == 1) {
                    this.resultSet.setAncestorMembersMapForLevel(aMember.getLevel().getUniqueName(), membersMap);
                } else {
                    for (Map.Entry<Object, Object> entry : membersMap.entrySet()) {
                        this.resultSet.addToAncestorMembersMap((String)entry.getKey(), (IMember)entry.getValue());
                    }
                }
            }
            while (parentUniqueName != null && (parentMember = (IMember)membersMap.get(parentUniqueName)) != null) {
                ancestryList.add(parentMember);
                parentUniqueName = parentMember.getParentUniqueName();
            }
            if (ancestryList.isEmpty()) {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "ancestryList.isEmpty()");
            }
            return ancestryList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, IMember> createAncestorsMap(IMember member, int tuplePosition, int lowesMostLevelNum, int fetchType) {
            HashMap<String, IMember> membersMap;
            boolean useParentUniqueName;
            Set<String> munsOfMembersAtHigherLevels = null;
            XOLAPEdgeMapping.this.getInterfaceId();
            AncestorQuery query = (AncestorQuery)XOLAPEdgeMapping.this.getAncestorQuery().getMDXQuery();
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            boolean isTM1102Compatible = false;
            if (config != null) {
                isTM1102Compatible = config.getBooleanProperty("TM1_102CompatibilityMode", false);
            }
            boolean bl = useParentUniqueName = isTM1102Compatible || !DataSourceTypeEnum.isTM(XOLAPEdgeMapping.this.getInterfaceId());
            if (fetchType == 0) {
                munsOfMembersAtHigherLevels = this.fetchMembersAtHigherLevels(tuplePosition, lowesMostLevelNum, useParentUniqueName);
            } else {
                if (fetchType != 1) {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "fetchType != FOR_LEVEL");
                }
                munsOfMembersAtHigherLevels = this.fetchParentMembersForGivenLevel(member.getLevel(), tuplePosition, useParentUniqueName);
            }
            query.setMemberNameList(munsOfMembersAtHigherLevels);
            String hierarchyName = member.getHierarchy().getUniqueName();
            if ("PC".equals(XOLAPEdgeMapping.this.interfaceId) || "TM".equals(XOLAPEdgeMapping.this.interfaceId)) {
                hierarchyName = StringSubstitutionEngine.unicodeEscapeString(hierarchyName);
            }
            query.setHierarchyName(hierarchyName);
            XOLAPEdgeMapping xParent = this.getXParent();
            List<MDXDimensionProperties> dimPropertiesForAncestorQuery = ((XMdx)xParent.getDescendantsOfCategory(501017, false).get(0)).getDimPropertiesForAncestorQuery();
            query.setDimensionProperties(dimPropertiesForAncestorQuery.get(xParent.getEdgeOrdinal()));
            if (XOLAPEdgeMapping.isLolapAncestorQueryProviders(XOLAPEdgeMapping.this.interfaceId)) {
                XOLAPEdgeMapping.this.setAncestorQuery(this.buildAncetorsQueryForLOLAP());
                query = (AncestorQuery)XOLAPEdgeMapping.this.getAncestorQuery().getMDXQuery();
            }
            IHybridResultSet queryResult = null;
            queryResult = query.execute(this.resultSet.getDataContext(), XOLAPEdgeMapping.this.getAncestorQuery());
            XIterator membersIterator = null;
            try {
                ITuple aTuple;
                membersIterator = queryResult.getAxisIterator(0);
                membersMap = new HashMap<String, IMember>();
                while ((aTuple = (ITuple)membersIterator.next()) != null) {
                    IMember aMember = aTuple.getMember(0);
                    membersMap.put(aMember.getUniqueName(), aMember);
                }
            }
            finally {
                if (membersIterator != null) {
                    membersIterator.release();
                }
                queryResult.release();
            }
            return membersMap;
        }

        private XMdxLocal buildAncetorsQueryForLOLAP() {
            ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)this.getResultSet().getDataContext().getEnvironment();
            PlanningEnvironment planningEnvironment = (PlanningEnvironment)XOLAPEdgeMapping.this.getAncestorQuery().getPlanningEnvironment();
            PlanningEnvironment subQueryEnvironment = V5SubQueryBuilder.createPlanningEnvironment(executionEnvironment, planningEnvironment);
            XMdxLocal newSecondaryQuery = (XMdxLocal)subQueryEnvironment.getNodeFactory().deepCopyNode(XOLAPEdgeMapping.this.getAncestorQuery());
            String mdx = newSecondaryQuery.getMDXQuery().getMDX();
            ASTMDXStatement mdxStatement = (ASTMDXStatement)MDXParserUtility.parseMDX(mdx, subQueryEnvironment, MDXParserUtility.ParseType.STATEMENT);
            subQueryEnvironment.getNodeIndex().addNode(newSecondaryQuery);
            IXQEQueryNode[] children = mdxStatement.getChildren();
            for (int i = 0; i < children.length; ++i) {
                IXQEQueryNode childNode = children[i];
                newSecondaryQuery.addChild(childNode.detach());
            }
            QueryPlanner.getInstance().plan(newSecondaryQuery, subQueryEnvironment);
            return newSecondaryQuery;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> fetchMembersAtHigherLevels(int tuplePosition, int lowesMostLevelNumber, boolean useParentUniqueName) {
            HashSet<String> missingParentsSet = new HashSet<String>();
            if (lowesMostLevelNumber == 0) {
                return missingParentsSet;
            }
            XIterator iterator = this.resultSet.getSourceIterator();
            try {
                ITuple aTuple = (ITuple)iterator.next();
                while (aTuple != null) {
                    int parentLevelNumber;
                    IMember aMember = aTuple.getMember(tuplePosition);
                    String parentUniqueName = aMember.getParentUniqueName();
                    if (parentUniqueName != null && (parentLevelNumber = aMember.getParentLevelNumber()) < lowesMostLevelNumber) {
                        if (!useParentUniqueName) {
                            parentUniqueName = aMember.getUniqueName();
                        }
                        missingParentsSet.add(parentUniqueName);
                    }
                    aTuple = (ITuple)iterator.next();
                }
            }
            finally {
                iterator.release();
            }
            return missingParentsSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> fetchParentMembersForGivenLevel(ILevel targetLevel, int tuplePosition, boolean useParentUniqueName) {
            if (targetLevel == null) {
                throw new OLAPDecorationException(XQEMessageKeys.DEC_InternalError_INTERNAL, "targetLevel == null");
            }
            HashSet<String> memberSet = new HashSet<String>();
            XIterator iterator = this.resultSet.getSourceIterator();
            try {
                IMember aMember = null;
                String memberUniqueName = null;
                String targetLUN = targetLevel.getUniqueName();
                ITuple aTuple = (ITuple)iterator.next();
                while (aTuple != null) {
                    aMember = aTuple.getMember(tuplePosition);
                    if (aMember.getLevel().getUniqueName().equals(targetLUN)) {
                        memberUniqueName = useParentUniqueName ? aMember.getParentUniqueName() : aMember.getUniqueName();
                        memberSet.add(memberUniqueName);
                    }
                    aTuple = (ITuple)iterator.next();
                }
            }
            finally {
                iterator.release();
            }
            return memberSet;
        }

        public ILevel getLowestProjectedLevel(IHierarchy hierarchy) {
            return XOLAPEdgeMapping.this.getEdgeLevelInfo().getLowestProjectedLevel(hierarchy);
        }

        public boolean isAncestorsQueryRequired() {
            return XOLAPEdgeMapping.this.getAncestorQuery() != null && this.itRootRowCycle.isAncestorsQueryRequired();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean fixMUNDescriptors(List<EdgeMappingRules.MemberDescriptor> descriptorList) {
            XOLAPEdgeMapping xOLAPEdgeMapping = this.getXParent();
            boolean success = false;
            if (this.getXParent().getMissingMemberQuery() == null) {
                return success;
            }
            MissingMemberValidateQuery missingMemberValidateQuery = (MissingMemberValidateQuery)this.getXParent().getMissingMemberQuery().getMDXQuery();
            if (missingMemberValidateQuery == null) {
                return success;
            }
            block5: for (EdgeMappingRules.MemberDescriptor descriptor : descriptorList) {
                String mun;
                if (descriptor.isFixed() || descriptor.isCalculation() || descriptor.wasSucessfullyUsed() || descriptor.isNoMember() || (mun = descriptor.getMUN()) == null) continue;
                missingMemberValidateQuery.setMemberName(mun);
                IReleasable queryResult = null;
                String correctMUN = null;
                try {
                    queryResult = missingMemberValidateQuery.execute(this.resultSet.getDataContext(), this.getXParent().getMissingMemberQuery());
                    correctMUN = XOLAPEdgeMapping.getCorrectMUN((IHybridResultSet)queryResult, mun);
                }
                catch (Throwable t) {}
                continue;
                finally {
                    if (queryResult == null) continue;
                    queryResult.release();
                    continue;
                }
                for (EdgeMappingRules.MemberDescriptor xDescriptor : xOLAPEdgeMapping.munDescriptorList) {
                    String xMun;
                    if (xDescriptor.isFixed() || xDescriptor.isCalculation() || xDescriptor.wasSucessfullyUsed() || xDescriptor.isNoMember() || (xMun = xDescriptor.getMUN()) == null || !xMun.equals(mun)) continue;
                    if (correctMUN != null && !mun.equals(correctMUN)) {
                        xDescriptor.setMUN(correctMUN);
                        descriptor.setMUN(correctMUN);
                        success = true;
                    }
                    xDescriptor.setFixed(true);
                    descriptor.setFixed(true);
                    continue block5;
                }
            }
            return success;
        }

        public ICell getCachedCell() {
            return this.cachedCell;
        }

        public void setCachedCell(ICell aCell) {
            this.cachedCell = aCell;
        }

        public int getNumAxes() {
            return this.numAxes;
        }

        public long[] getAxisSizes() {
            return this.axisSizes;
        }

        public XOLAPEdgeMapping getXParent() {
            return (XOLAPEdgeMapping)this.parentXNode;
        }

        public int getNumOfV5Hierarchies() {
            return this.numOfV5Hierarchies;
        }

        protected class SpacerBuilder {
            private CrosstabSpacerDescriptor descriptor = null;
            private ContextMember targetMember = null;
            private ContextMember nestingTargetMember = null;
            private int tuplePositionMatchingSpacerDescriptor = -1;
            private boolean matchingGeneratedContextMember = false;

            public boolean isMatchedByAGeneratedContextMember() {
                return this.matchingGeneratedContextMember;
            }

            public void setMatchedByAGeneratedContextMember(boolean value) {
                this.matchingGeneratedContextMember = value;
            }

            public SpacerBuilder(CrosstabSpacerDescriptor aDescriptor, ContextMember aTargetMember, ContextMember aNestingTargetMember, int aTuplePosition, boolean isMatchedByAGeneratedContextMember) {
                this.descriptor = aDescriptor;
                this.setTargetMember(aTargetMember);
                this.nestingTargetMember = aNestingTargetMember;
                this.setTuplePositionMatchingSpacerDescriptor(aTuplePosition);
                this.setMatchedByAGeneratedContextMember(isMatchedByAGeneratedContextMember);
            }

            protected ITuple buildCrossTabSpacerTuple(ITuple tupleOut) {
                IMember[] members = tupleOut.getMembers();
                IMember[] newMembers = new IMember[members.length];
                ContextMember spacerMember = this.getTargetMember();
                if (this.getSpacerPosition() == 3) {
                    newMembers = members;
                    for (int i = this.getTuplePositionMatchingSpacerDescriptor() - 1; i > -1 && (spacerMember = (ContextMember)members[i]).getRowset() == null; --i) {
                    }
                    int spacerPosition = this.getTuplePositionMatchingSpacerDescriptor() - 1;
                    if (this.getTuplePositionMatchingSpacerDescriptor() - 1 < 0) {
                        spacerPosition = this.getTuplePositionMatchingSpacerDescriptor();
                    }
                    ContextMember spacer = this.descriptor.buildSpacer(spacerMember, spacerPosition, this.getTuplePositionMatchingSpacerDescriptor());
                    spacer.setContextMember(spacerMember);
                    newMembers[spacerPosition] = spacer;
                } else {
                    int i;
                    int spacerMemberPosition = -1;
                    String spacerMUN = spacerMember.getUniqueName();
                    for (i = 0; i < members.length; ++i) {
                        if (!members[i].getUniqueName().equals(spacerMUN)) continue;
                        spacerMemberPosition = i;
                        break;
                    }
                    for (i = 0; i < members.length; ++i) {
                        RSAPIEdgeRowset rowSet;
                        if (spacerMemberPosition == -1 && i == this.getTuplePositionMatchingSpacerDescriptor() || spacerMemberPosition == i) continue;
                        newMembers[i] = (IMember)members[i].copy();
                        if (spacerMemberPosition == -1 && i > this.getTuplePositionMatchingSpacerDescriptor()) {
                            ((ContextMember)newMembers[i]).setRowset(null);
                        }
                        if (spacerMemberPosition > -1 && i > spacerMemberPosition) {
                            ((ContextMember)newMembers[i]).setRowset(null);
                        }
                        if ((rowSet = (RSAPIEdgeRowset)((ContextMember)newMembers[i]).getRowset()) != null && rowSet.getParentRowset() != null) continue;
                        ((ContextMember)newMembers[i]).setContextMember(null);
                    }
                    if (this.getTuplePositionMatchingSpacerDescriptor() > 0) {
                        spacerMember = spacerMemberPosition > -1 ? (ContextMember)spacerMember.copy() : (ContextMember)newMembers[this.getTuplePositionMatchingSpacerDescriptor() - 1];
                    }
                    ContextMember spacer = this.descriptor.buildSpacer(spacerMember, spacerMemberPosition, this.getTuplePositionMatchingSpacerDescriptor());
                    if (this.getSpacerPosition() == 4) {
                        this.getTargetMember().setContextMember(spacer);
                        newMembers[this.getTuplePositionMatchingSpacerDescriptor()] = this.getTargetMember();
                    } else if (this.nestingTargetMember == null) {
                        if (spacerMemberPosition == -1) {
                            newMembers[this.getTuplePositionMatchingSpacerDescriptor()] = spacer;
                        } else {
                            newMembers[spacerMemberPosition] = spacer;
                        }
                    } else {
                        ContextMember newNestingTargetMember = (ContextMember)this.nestingTargetMember.copy();
                        if (this.descriptor.getRSAPIEdgeRowset().getParentRowset() != null) {
                            spacer.setContextMember(newNestingTargetMember);
                        }
                        newMembers[this.getTuplePositionMatchingSpacerDescriptor()] = spacer;
                    }
                }
                Tuple newTupleOut = new Tuple(newMembers);
                return newTupleOut;
            }

            public int getSpacerPosition() {
                return this.descriptor.getPosition();
            }

            public CrosstabSpacerDescriptor getDescriptor() {
                return this.descriptor;
            }

            public int getTuplePositionMatchingSpacerDescriptor() {
                return this.tuplePositionMatchingSpacerDescriptor;
            }

            public void setTuplePositionMatchingSpacerDescriptor(int aTuplePosition) {
                this.tuplePositionMatchingSpacerDescriptor = aTuplePosition;
            }

            public ContextMember getTargetMember() {
                return this.targetMember;
            }

            public void setTargetMember(ContextMember aTargetMember) {
                this.targetMember = aTargetMember;
            }
        }
    }

    final class EdgeMappingResultSet
    extends DecorationResultSet {
        private Map<String, IMember> ancestorMembersMap;
        private Map<String, Map<String, IMember>> ancestorMembersMapForLevel;
        private int numberOfTabularMeasures;

        private EdgeMappingResultSet(XDataContext context, ICubeResultSet result, XOLAPEdgeDecoration owner) {
            super(context, result, owner);
            this.numberOfTabularMeasures = -1;
        }

        @Override
        public XIterator getAxisIterator(int axisNumber) {
            if (axisNumber == XOLAPEdgeMapping.this.getEdgeOrdinal()) {
                return new OLAPEdgeMappingIterator(axisNumber, this.parentNode, this);
            }
            return this.getBaseResultSet().getAxisIterator(axisNumber);
        }

        @Override
        public int getNumTabularMeasures() {
            if (this.numberOfTabularMeasures == -1) {
                this.numberOfTabularMeasures = super.getNumTabularMeasures();
                HashSet<RSAPIDataItem> tabularMeasures = new HashSet<RSAPIDataItem>();
                XOLAPEdgeMapping.this.rootRowCycle.getTabularMeasures(tabularMeasures);
                this.numberOfTabularMeasures += tabularMeasures.size();
            }
            return this.numberOfTabularMeasures;
        }

        @Override
        public int getNumDataItemForSummary(int rowsetId) {
            int numDataItems = this.mOlapResultSet.getNumDataItemForSummary(rowsetId);
            ArrayList<Integer> dataItemIdexes = new ArrayList<Integer>();
            XOLAPEdgeMapping.this.rootRowCycle.getDataItemIdexesForSummary(rowsetId, dataItemIdexes);
            return numDataItems += dataItemIdexes.size();
        }

        protected Map<String, IMember> getAncestorMembersMap() {
            return this.ancestorMembersMap;
        }

        protected void addToAncestorMembersMap(String parentUniqueName, IMember parent) {
            if (this.ancestorMembersMap == null) {
                this.ancestorMembersMap = new HashMap<String, IMember>();
            }
            this.ancestorMembersMap.put(parentUniqueName, parent);
        }

        protected Map<String, IMember> getAncestorMembersMapForLevel(String aLUN) {
            if (this.ancestorMembersMapForLevel == null) {
                return null;
            }
            return this.ancestorMembersMapForLevel.get(aLUN);
        }

        protected void setAncestorMembersMapForLevel(String aLUN, Map<String, IMember> ancestorMap) {
            if (this.ancestorMembersMapForLevel == null) {
                this.ancestorMembersMapForLevel = new HashMap<String, Map<String, IMember>>();
            }
            this.ancestorMembersMapForLevel.put(aLUN, ancestorMap);
        }

        protected XIterator getSourceIterator() {
            return this.getBaseResultSet().getAxisIterator(XOLAPEdgeMapping.this.getEdgeOrdinal());
        }

        @Override
        public void releaseImpl() {
            if (this.ancestorMembersMap != null) {
                this.ancestorMembersMap.clear();
            }
            if (this.ancestorMembersMapForLevel != null) {
                this.ancestorMembersMapForLevel.clear();
            }
            super.releaseImpl();
        }
    }
}

