/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping.actions;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.actions.AbstractAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class AddGroupbodyMeasureValue
extends AbstractAction {
    @Override
    public String getName() {
        return "AddGroupbodyMeasureValue";
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputAction, int edgeOrdinal) {
    }

    @Override
    public void dump(XQETrace trace) {
        this.validate();
        trace.beginElement(this.getName(), -1);
        trace.endElement();
    }

    @Override
    public void validate() {
    }

    @Override
    public int getPrecedence() {
        return 4;
    }

    @Override
    public IEdgeElementMappingAction copy(EdgeElementFactory edgeElementFactory) {
        AddGroupbodyMeasureValue newAction = (AddGroupbodyMeasureValue)super.copy(edgeElementFactory);
        return newAction;
    }

    @Override
    public IEdgeElementMappingAction exactCopy(EdgeElementFactory edgeElementFactory) {
        return this.copy(edgeElementFactory);
    }

    public void createContextValue(OLAPColumn fromColumn) {
        ICell aCell;
        XOLAPEdgeMapping.OLAPEdgeMappingIterator mappingIterator = fromColumn.getIterator();
        OLAPContextColumn contextColumn = (OLAPContextColumn)fromColumn.getParentRow().getParentRow().getFirstColumn();
        if (contextColumn == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "contextColumn == null");
        }
        ContextMember contextMember = contextColumn.createContextMember();
        if (contextMember == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "contextMember == null");
        }
        RSAPIEdgeRowset rowset = fromColumn.getRowset();
        if (rowset == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "rowset not found");
        }
        long cellOrdinal = 1L;
        long tupleOrdinal = mappingIterator.getSourceCoordinate();
        if (tupleOrdinal >= 0L) {
            for (int i = mappingIterator.getEdgeNumber() - 1; i >= 0; --i) {
                cellOrdinal *= mappingIterator.getAxisSizes()[i];
            }
            cellOrdinal *= tupleOrdinal;
        }
        if ((aCell = this.getCell(mappingIterator, cellOrdinal)) == null) {
            return;
        }
        ContextValue aContextValue = new ContextValue((IValue)aCell.getValue().copy());
        aContextValue.setDataItemIndex(fromColumn.getDataItemIndex());
        aContextValue.setRowset(rowset);
        aContextValue.setEdgeOrdinal(rowset.getEdge().getOrdinal());
        contextMember.addValueOfGroupBodyMeasure(aContextValue);
    }

    private ICell getCell(XOLAPEdgeMapping.OLAPEdgeMappingIterator mappingIterator, long cellOrdinal) {
        XCellIterator cellIterator = mappingIterator.getSourceCellIterator();
        ICell cellCache = mappingIterator.getCachedCell();
        if (cellCache == null && cellIterator.hasNext()) {
            cellCache = cellIterator.next();
        }
        while (cellCache != null && cellCache.getOrdinal() < cellOrdinal) {
            if (cellIterator.hasNext()) {
                cellCache = cellIterator.next();
                continue;
            }
            cellCache = null;
        }
        mappingIterator.setCachedCell(cellCache);
        if (cellCache == null) {
            return null;
        }
        if (cellCache.getOrdinal() == cellOrdinal) {
            return cellCache;
        }
        return null;
    }
}

