/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping.actions;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQEPersistCreate;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.actions.AbstractAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.GenerateContext;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class CopyContext
extends AbstractAction {
    private List<ContextSourceCoordidates> from = new ArrayList<ContextSourceCoordidates>();

    public List<ContextSourceCoordidates> getFrom() {
        return this.from;
    }

    public void setFrom(List<ContextSourceCoordidates> aFrom) {
        this.from = aFrom;
    }

    public void addContextSourceCoordidate(int anId, int aDepth) {
        this.from.add(0, new ContextSourceCoordidates(anId, aDepth));
    }

    @Override
    public String getName() {
        return "CopyContext";
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputAction, int edgeOrdinal) {
        Attribute attribute = inputAction.attribute("from");
        if (attribute == null) {
            throw new IllegalStateException();
        }
        String contextSourceCoordidatesList = attribute.getValue();
        if (contextSourceCoordidatesList == null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void dump(XQETrace trace) {
        this.validate();
        trace.beginElement(this.getName(), -1);
        trace.attribute("from", this.getFromAsString());
        trace.endElement();
    }

    @Override
    public void validate() {
        if (this.getFrom() == null || this.getFrom().isEmpty()) {
            EdgeMappingUtils.actionValidationError(this);
        }
    }

    @Override
    public int getPrecedence() {
        return 2;
    }

    public ContextMember getContextMember() {
        this.validate();
        AbstractOLAPColumn columnOwnerOfThis = (AbstractOLAPColumn)this.owner;
        OLAPRowCycle rootRowCycle = columnOwnerOfThis.getParentRow().getRootRowCycle();
        for (ContextSourceCoordidates aFrom : this.getFrom()) {
            IMember currentDetailMember;
            GenerateContext generateContext;
            AbstractOLAPColumn detailColumn = rootRowCycle.findColumnById((int)aFrom.elementId);
            if (!detailColumn.getParentRow().isCycle() && (generateContext = (GenerateContext)detailColumn.getActionOfTypeForMUN(2, null)) != null && generateContext.getNumberOfContextColumns() > aFrom.ancestorDepth) {
                OLAPRowCycle grandParentRow = (OLAPRowCycle)detailColumn.getParentRow().getParentRow();
                boolean foundDetailRow = false;
                for (int i = 0; i < grandParentRow.getNumberOfRows(); ++i) {
                    AbstractOLAPRow siblingRow = grandParentRow.getRow(i);
                    if (!foundDetailRow && siblingRow == detailColumn.getParentRow()) {
                        foundDetailRow = true;
                    }
                    if (!foundDetailRow || !siblingRow.isDone()) continue;
                    siblingRow.setDone(false);
                    for (int j = 0; j < siblingRow.getNumberOfColumns(); ++j) {
                        AbstractOLAPColumn currColumn = siblingRow.getColumn(j);
                        currColumn.setDone(false);
                    }
                    if (siblingRow == columnOwnerOfThis.getParentRow()) break;
                }
            }
            if ((currentDetailMember = detailColumn.getCurrentMember()) == null || !currentDetailMember.isContextMember()) continue;
            ContextMember contextToSet = (ContextMember)currentDetailMember;
            for (int i = 0; i < aFrom.ancestorDepth + 1; ++i) {
                contextToSet = contextToSet.getContextMember();
            }
            return contextToSet;
        }
        return null;
    }

    @Override
    public IEdgeElementMappingAction copy(EdgeElementFactory edgeElementFactory) {
        CopyContext newAction = (CopyContext)super.copy(edgeElementFactory);
        newAction.setFrom(this.getFrom());
        return newAction;
    }

    @Override
    public IEdgeElementMappingAction exactCopy(EdgeElementFactory edgeElementFactory) {
        return this.copy(edgeElementFactory);
    }

    public String getFromAsString() {
        StringBuilder buffer = new StringBuilder();
        if (this.from.size() > 1) {
            buffer.append("(");
        }
        for (int i = this.from.size() - 1; i > -1; --i) {
            buffer.append(this.from.get(i).toString());
            if (this.from.size() <= 1 || i <= 0) continue;
            buffer.append(", ");
        }
        if (this.from.size() > 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        propertiesMap.put("from", this.getFromAsString());
        return propertiesMap;
    }

    @Override
    public void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.from != null) {
            ctx.elementProperty("from", this.from);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals("from")) {
            Object val = ctx.elementValue(node, new CopyContextCreator());
            this.from = (List)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private class CopyContextCreator
    extends XQEPersistCreate {
        private CopyContextCreator() {
        }

        @Override
        public IXQEPersist create(XQERestoreContext ctx, Element inputNode) {
            IXQEPersist result = null;
            String nodeName = inputNode.getName();
            if (nodeName.equals("ContextSourceCoordidates")) {
                result = new ContextSourceCoordidates();
                result.restore(ctx, inputNode);
            } else {
                result = super.create(ctx, inputNode);
            }
            return result;
        }
    }

    public class ContextSourceCoordidates
    implements IXQEPersist {
        private static final String ATTRIBUTE_ELEMENT_ID = "elementId";
        private static final String ATTRIBUTE_ANCESTOR_DEPTH = "ancestorDepth";
        private Integer elementId = null;
        private Integer ancestorDepth = null;

        protected ContextSourceCoordidates(int anId, int aDepth) {
            this.elementId = XQEIntegerPool.getInteger(anId);
            this.ancestorDepth = XQEIntegerPool.getInteger(aDepth);
        }

        protected ContextSourceCoordidates() {
        }

        public Integer getElementId() {
            return this.elementId;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("(");
            buffer.append("Id=");
            buffer.append(this.elementId);
            buffer.append(", ");
            buffer.append("ancestorDepth=");
            buffer.append(this.ancestorDepth);
            buffer.append(")");
            return buffer.toString();
        }

        @Override
        public void persist(XQEPersistContext ctx, String optionalName) {
            if (ctx.beginElement(this, optionalName, -1)) {
                this.persistAttributeProperties(ctx);
                CopyContext.this.persistElementProperties(ctx);
                ctx.endElement();
            }
        }

        public void persistAttributeProperties(XQEPersistContext ctx) {
            ctx.property(ATTRIBUTE_ELEMENT_ID, this.elementId);
            ctx.property(ATTRIBUTE_ANCESTOR_DEPTH, this.ancestorDepth);
        }

        @Override
        public void restore(XQERestoreContext ctx, Element node) {
            this.restoreAttributes(ctx, node);
        }

        public void restoreAttributes(XQERestoreContext ctx, Element node) {
            int size = node.attributeCount();
            for (int i = 0; i < size; ++i) {
                Attribute att = node.attribute(i);
                this.restoreAttributeProperty(ctx, att, node);
            }
        }

        protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
            String attName = att.getName();
            if (attName.equals(ATTRIBUTE_ELEMENT_ID)) {
                Object val = ctx.attributeValue(att);
                this.elementId = (Integer)val;
            } else if (attName.equals(ATTRIBUTE_ANCESTOR_DEPTH)) {
                Object val = ctx.attributeValue(att);
                this.ancestorDepth = (Integer)val;
            }
        }
    }
}

