/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping.actions;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.Measure;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.actions.CrosstabSpacerCoordinates;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CrosstabSpacerDescriptor {
    public static final int INVALID_ROWSET_ID = -33;
    private static final String ROWSET_ID = "rowsetId";
    private static final String RSAPI_DATA_ITEM = "rsapiDataItem";
    RSAPIEdgeRowset rsapiRowset = null;
    CrosstabSpacerCoordinates coordinates = null;
    boolean applied = false;
    int indexOfApplicableRowset = -33;
    int position = -1;
    private int hashCode = Integer.MIN_VALUE;
    boolean isTopNode = false;

    public RSAPIEdgeRowset getRSAPIEdgeRowset() {
        return this.rsapiRowset;
    }

    public void setRSAPIEdgeRowset(RSAPIEdgeRowset anRsapiRowset) {
        this.rsapiRowset = anRsapiRowset;
    }

    public CrosstabSpacerCoordinates getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(int aPosition, List<RSAPIEdgeRowset> aNeighborList1, List<RSAPIEdgeRowset> aNeighborList2) {
        if (aPosition != 4 && aNeighborList1 == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "aNeighbor1 == null");
        }
        this.coordinates = new CrosstabSpacerCoordinates();
        this.coordinates.setPosition(aPosition);
        this.coordinates.setNeighborList1(aNeighborList1);
        this.coordinates.setNeighborList2(aNeighborList2);
    }

    public void dump(XQETrace trace) {
        trace.beginElement(this.getClass().getSimpleName(), -1);
        trace.attribute(RSAPI_DATA_ITEM, this.getRSAPIEdgeRowset().getRefDataItem());
        trace.attribute(ROWSET_ID, this.getRSAPIEdgeRowset().getRowsetId());
        this.coordinates.dump(trace);
        trace.endElement();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(");
        sb.append(RSAPI_DATA_ITEM);
        sb.append("=");
        sb.append(this.getRSAPIEdgeRowset().getRefDataItem().toString());
        sb.append(" ");
        sb.append(",");
        sb.append(ROWSET_ID);
        sb.append("=");
        sb.append(this.getRSAPIEdgeRowset().getRowsetId());
        sb.append(" ");
        sb.append(",");
        if (this.coordinates != null) {
            sb.append(this.coordinates.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean isApplied() {
        return this.applied;
    }

    public void setApplied(boolean value) {
        this.applied = value;
    }

    public boolean applies(RSAPIEdgeRowset rowset, boolean setIndexOfApplicableRowset) {
        if (rowset == null) {
            return false;
        }
        if (this.isApplied()) {
            return false;
        }
        if (this.coordinates.getPosition() == 4) {
            this.position = 4;
            return true;
        }
        List<RSAPIEdgeRowset> neighborList1 = this.coordinates.getNeighborList1();
        int rowsetIdIndex = -1;
        for (RSAPIEdgeRowset neighbor1 : neighborList1) {
            ++rowsetIdIndex;
            if (rowset.getRowsetId() != neighbor1.getRowsetId()) continue;
            this.position = this.coordinates.getPosition() == 2 ? 21 : this.coordinates.getPosition();
            if (setIndexOfApplicableRowset) {
                this.setIndexOfApplicableRowset(rowsetIdIndex);
            }
            return true;
        }
        if (this.coordinates.getPosition() == 2) {
            rowsetIdIndex = -1;
            List<RSAPIEdgeRowset> neighborList2 = this.coordinates.getNeighborList2();
            for (RSAPIEdgeRowset neighbor2 : neighborList2) {
                ++rowsetIdIndex;
                if (rowset.getRowsetId() != neighbor2.getRowsetId()) continue;
                this.position = 22;
                if (setIndexOfApplicableRowset) {
                    this.setIndexOfApplicableRowset(rowsetIdIndex);
                }
                return true;
            }
        }
        return false;
    }

    public int getIndexOfApplicableRowset() {
        return this.indexOfApplicableRowset;
    }

    public void setIndexOfApplicableRowset(int index) {
        this.indexOfApplicableRowset = index;
    }

    public boolean validate() {
        if (this.rsapiRowset == null || this.coordinates == null) {
            return false;
        }
        return this.coordinates.validate();
    }

    public CrosstabSpacerDescriptor copy() {
        CrosstabSpacerDescriptor newCrosstabSpacer = new CrosstabSpacerDescriptor();
        newCrosstabSpacer.setRSAPIEdgeRowset(this.getRSAPIEdgeRowset());
        newCrosstabSpacer.setCoordinates(this.coordinates.getPosition(), this.coordinates.getNeighborList1(), this.coordinates.getNeighborList2());
        newCrosstabSpacer.setIndexOfApplicableRowset(this.getIndexOfApplicableRowset());
        return newCrosstabSpacer;
    }

    public ContextMember buildSpacer(ContextMember spacerMember, int spacerMemberPosition, int sbTuplePosition) {
        if (this.getPosition() != 3) {
            this.setApplied(true);
        }
        ContextMember spacer = null;
        switch (this.getPosition()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 21: 
            case 22: {
                ContextMember spacerContext;
                RSAPIDataItem[] templateDataItems = null;
                if (spacerMember.getRowset() != null) {
                    templateDataItems = spacerMember.getRowset().getDataItems();
                }
                if (spacerMember.getContextMember() != null) {
                    if (spacerMemberPosition == sbTuplePosition) {
                        spacer = (ContextMember)spacerMember.getContextMember().copy();
                        if (spacerMember.getContextMember().getRowset() != null) {
                            templateDataItems = spacerMember.getContextMember().getRowset().getDataItems();
                        }
                        if (this.getRSAPIEdgeRowset().getParentRowset() == null) {
                            spacer.setContextMember(null);
                        } else {
                            spacerContext = (ContextMember)spacerMember.getContextMember().copy();
                            spacer.setContextMember(spacerContext);
                        }
                    } else {
                        spacer = (ContextMember)spacerMember.copy();
                        if (this.getRSAPIEdgeRowset().getParentRowset() == null) {
                            spacer.setContextMember(null);
                        } else {
                            spacerContext = (ContextMember)spacerMember.copy();
                            spacer.setContextMember(spacerContext);
                        }
                    }
                } else {
                    spacer = (ContextMember)spacerMember.copy();
                    if (!this.isTopNode) {
                        spacerContext = (ContextMember)spacerMember.copy();
                        if (this.getRSAPIEdgeRowset().getParentRowset() == null) {
                            spacer.setContextMember(null);
                        } else {
                            spacer.setContextMember(spacerContext);
                        }
                    }
                }
                RSAPIEdgeRowset spacerRowset = this.getRSAPIEdgeRowset();
                spacer.setRowset(spacerRowset);
                IMetadata modelReference = spacerRowset.getRefDataItem().getModelReference();
                if (modelReference instanceof MeasureWrapper && ((MeasureWrapper)modelReference).getWrapped() != null) {
                    spacer.setMember((IMeasure)((MeasureWrapper)modelReference).getWrapped().copy());
                } else if (modelReference instanceof Measure) {
                    spacer.setMember((IMeasure)((IMeasure)modelReference).copy());
                } else if (modelReference instanceof IMeasure && ((IMeasure)modelReference).isMFWMeasure()) {
                    spacer.setMember((IMember)((IMeasure)modelReference).copy());
                }
                RSAPIDataItem[] spacerDataItems = null;
                if (spacerRowset != null) {
                    spacerDataItems = spacerRowset.getDataItems();
                }
                if (templateDataItems != null && spacerDataItems != null) {
                    for (RSAPIDataItem templateDataItem : templateDataItems) {
                        if (!templateDataItem.isGroupbodyMeasure()) continue;
                        for (RSAPIDataItem spacerDataItem : spacerDataItems) {
                            if (!templateDataItem.getName().equals(spacerDataItem.getName())) continue;
                            spacerDataItem.setIsGroupbodyMeasure(true);
                        }
                    }
                }
                if (((RSAPIEdgeRowset)spacer.getRowset()).getParentRowset() == null) {
                    spacer.setContextMember(null);
                }
                spacer.setIsCrosstabSpacer(0);
                return spacer;
            }
        }
        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "position?");
    }

    public int getPosition() {
        if (this.position != -1) {
            return this.position;
        }
        return this.coordinates.getPosition();
    }

    public boolean isTopNode() {
        return this.isTopNode;
    }

    public void setTopNode(boolean value) {
        this.isTopNode = value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CrosstabSpacerDescriptor)) {
            return false;
        }
        CrosstabSpacerDescriptor otherDescriptor = (CrosstabSpacerDescriptor)other;
        EqualsBuilder eb = new EqualsBuilder();
        eb.append(this.getPosition(), otherDescriptor.getPosition());
        if (this.getRSAPIEdgeRowset() == null || otherDescriptor.getRSAPIEdgeRowset() == null) {
            return false;
        }
        eb.append(this.getRSAPIEdgeRowset().getRowsetId(), otherDescriptor.getRSAPIEdgeRowset().getRowsetId());
        eb.append(this.getCoordinates() != null, otherDescriptor.getCoordinates() != null);
        if (!eb.isEquals()) {
            return false;
        }
        return this.getCoordinates().equals(otherDescriptor.getCoordinates());
    }

    public int hashCode() {
        if (this.hashCode != Integer.MIN_VALUE) {
            return this.hashCode;
        }
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.getPosition());
        if (this.getRSAPIEdgeRowset() != null) {
            hcb.append(this.getRSAPIEdgeRowset().getRowsetId());
        }
        if (this.getCoordinates() != null) {
            hcb.append(this.getCoordinates().hashCode());
        }
        this.hashCode = hcb.toHashCode();
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = 0;
        }
        return this.hashCode;
    }
}

