/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping.actions;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.actions.AbstractAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.CrosstabSpacerDescriptor;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class InsertCrosstabSpacer
extends AbstractAction {
    private List<CrosstabSpacerDescriptor> spacerList = null;
    private boolean matchingGeneratedContextMember = false;
    private boolean generatedContextProvidesSpacerMember = false;
    IMember spacerMember = null;

    public boolean isMatchedByAGeneratedContextMember() {
        return this.matchingGeneratedContextMember;
    }

    public void setMatchedByAGeneratedContextMember(boolean value) {
        this.matchingGeneratedContextMember = value;
    }

    public boolean generatedContextProvidesSpacerMember() {
        return this.generatedContextProvidesSpacerMember;
    }

    public void setGeneratedContextProvidesSpacerMember(boolean value) {
        this.generatedContextProvidesSpacerMember = value;
    }

    @Override
    public String getName() {
        return "InsertCrosstabSpacer";
    }

    @Override
    public int getType() {
        return 13;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputAction, int edgeOrdinal) {
    }

    @Override
    public void dump(XQETrace trace) {
        this.validate();
        trace.beginElement(this.getName(), -1);
        if (this.generatedContextProvidesSpacerMember()) {
            trace.attribute("generatedContextProvidesSpacerMember", Boolean.TRUE);
        }
        if (this.isMatchedByAGeneratedContextMember()) {
            trace.attribute("matchedByAGeneratedContextMember", Boolean.TRUE);
        }
        if (this.getSpacerMember() != null) {
            trace.attribute("spacerMember", this.getSpacerMember().getUniqueName());
        }
        for (CrosstabSpacerDescriptor spacer : this.spacerList) {
            spacer.dump(trace);
        }
        trace.endElement();
    }

    @Override
    public void validate() {
        for (CrosstabSpacerDescriptor spacer : this.spacerList) {
            if (spacer.validate()) continue;
            EdgeMappingUtils.actionValidationError(this);
        }
    }

    @Override
    public int getPrecedence() {
        return 100;
    }

    public List<CrosstabSpacerDescriptor> getSpacerList() {
        return this.spacerList;
    }

    public void setSpacerList(List<CrosstabSpacerDescriptor> anSpacerList) {
        this.spacerList = anSpacerList;
    }

    public CrosstabSpacerDescriptor findSpacerForRSAPIRowset(RSAPIEdgeRowset rowset, boolean setIndexOfApplicableRowset) {
        for (CrosstabSpacerDescriptor spacer : this.spacerList) {
            if (!spacer.applies(rowset, setIndexOfApplicableRowset)) continue;
            return spacer;
        }
        return null;
    }

    @Override
    public IEdgeElementMappingAction copy(EdgeElementFactory edgeElementFactory) {
        InsertCrosstabSpacer newAction = (InsertCrosstabSpacer)super.copy(edgeElementFactory);
        ArrayList<CrosstabSpacerDescriptor> newSpacerList = new ArrayList<CrosstabSpacerDescriptor>();
        newAction.setSpacerList(newSpacerList);
        for (CrosstabSpacerDescriptor spacer : this.getSpacerList()) {
            newSpacerList.add(spacer.copy());
        }
        newAction.setGeneratedContextProvidesSpacerMember(this.generatedContextProvidesSpacerMember());
        return newAction;
    }

    @Override
    public void reset() {
        if (!this.generatedContextProvidesSpacerMember()) {
            return;
        }
        this.resetCrosstabSpacerDescriptors();
    }

    public void resetCrosstabSpacerDescriptors() {
        for (CrosstabSpacerDescriptor spacer : this.getSpacerList()) {
            spacer.setApplied(false);
        }
    }

    public IMember getSpacerMember() {
        return this.spacerMember;
    }

    public void setSpacerMember(IMember aMember) {
        this.spacerMember = aMember;
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        StringBuilder sb = new StringBuilder();
        if (this.generatedContextProvidesSpacerMember()) {
            propertiesMap.put("generatedContextProvidesSpacerMember", Boolean.TRUE.toString());
        }
        if (this.isMatchedByAGeneratedContextMember()) {
            propertiesMap.put("matchedByAGeneratedContextMember", Boolean.TRUE.toString());
        }
        if (this.getSpacerMember() != null) {
            propertiesMap.put("spacerMember", this.getSpacerMember().getUniqueName());
        }
        for (CrosstabSpacerDescriptor spacerDescriptor : this.spacerList) {
            sb.append(spacerDescriptor.toString());
        }
        propertiesMap.put("memberDescriptors", sb.toString());
        return propertiesMap;
    }

    @Override
    public void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
    }

    @Override
    public void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
    }
}

