/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping.actions;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingUtils;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.actions.AbstractAction;
import com.cognos.xqe.runtree.olap.edgemapping.actions.IEdgeElementMappingAction;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.SortedMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class RelocateNestedLevelCalculation
extends AbstractAction {
    private int from = -1;
    private int to = -1;
    boolean applied = false;

    public boolean isApplied() {
        return this.applied;
    }

    public void setApplied(boolean value) {
        this.applied = value;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputAction, int edgeOrdinal) {
        Attribute attribute = inputAction.attribute("from");
        if (attribute == null) {
            throw new IllegalStateException();
        }
        String sTuplePosition = attribute.getValue();
        if (sTuplePosition == null) {
            throw new IllegalStateException();
        }
        this.setFrom(Integer.parseInt(sTuplePosition));
        attribute = inputAction.attribute("to");
        if (attribute == null) {
            throw new IllegalStateException();
        }
        sTuplePosition = attribute.getValue();
        if (sTuplePosition == null) {
            throw new IllegalStateException();
        }
        this.setTo(Integer.parseInt(sTuplePosition));
    }

    @Override
    public void dump(XQETrace trace) {
        this.validate();
        trace.beginElement(this.getName(), -1);
        if (this.getFrom() == -1) {
            throw new IllegalStateException();
        }
        trace.attribute("from", XQEIntegerPool.getInteger(this.getFrom()));
        if (this.getTo() == -1) {
            throw new IllegalStateException();
        }
        trace.attribute("to", XQEIntegerPool.getInteger(this.getTo()));
        trace.endElement();
    }

    @Override
    public String getName() {
        return "RelocateNestedLevelCalculation";
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void validate() {
        if (this.getFrom() == -1 || this.getTo() == -1) {
            EdgeMappingUtils.actionValidationError(this);
        }
        if (this.getFrom() < this.getTo()) {
            EdgeMappingUtils.actionValidationError(this);
        }
    }

    @Override
    public int getPrecedence() {
        return 5;
    }

    public ITuple relocatedNestedLevelCalculationMember(ITuple mappedTuple) {
        OLAPRowCycle ownersRowCycle;
        if (this.isApplied()) {
            return mappedTuple;
        }
        this.validate();
        if (mappedTuple.size() <= this.getFrom()) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "mappedTuple.size() <= from");
        }
        AbstractOLAPColumn ownerColumn = (AbstractOLAPColumn)this.owner;
        OLAPRow ownersRow = (OLAPRow)ownerColumn.getParentRow();
        for (OLAPRowCycle aRowCycle = ownersRowCycle = (OLAPRowCycle)ownersRow.getParentRow(); aRowCycle != ownersRow.getRootRowCycle() && aRowCycle != null; aRowCycle = (OLAPRowCycle)aRowCycle.getParentRow()) {
            aRowCycle.setEverRendered(true);
        }
        IMember[] tupleMembers = mappedTuple.getMembers();
        ContextMember orgCalculatedMember = (ContextMember)tupleMembers[this.getFrom()];
        ContextMember newCalculatedMember = EdgeMappingUtils.replicateContextMember(orgCalculatedMember);
        Member newCalcBaseMember = (Member)newCalculatedMember.getBaseMember();
        ContextMember orgContextMember = (ContextMember)tupleMembers[this.getTo()];
        IMessageKey.Param1 mesgKey = XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL;
        if (orgContextMember == null) {
            int distance = tupleMembers.length - ownersRow.getNumberOfColumns() - this.getTo() - 1;
            OLAPRowCycle targetRowCycle = (OLAPRowCycle)ownersRow.getParentRow();
            for (int i = 0; i < distance; ++i) {
                targetRowCycle = (OLAPRowCycle)targetRowCycle.getParentRow();
            }
            targetRowCycle.addColumnWithPendingRelocNLCalc(ownerColumn);
            return mappedTuple;
        }
        int orgCalcColumnId = orgContextMember.getOlapEdgeMappingColumnId();
        AbstractOLAPColumn orgCalcColumn = ownersRow.getRootRowCycle().findColumnById(orgCalcColumnId);
        if (orgCalcColumn == null) {
            throw new OLAPEdgeMappingException(mesgKey, "orgCalcColumn == null");
        }
        if (orgCalcColumn.getCurrentMember() == null) {
            orgCalcColumn.setCurrentMember(orgContextMember);
        }
        orgCalcColumn.setRendered(true);
        int contextColumnId = -1;
        RSAPIRowset contextColumnRowset = null;
        int contextDataItemIndex = -1;
        if (ownersRowCycle != ownersRow.getRootRowCycle()) {
            AbstractOLAPColumn contextColumn = null;
            contextColumn = orgCalcColumn.isContext() && orgCalcColumn.getRulesType() != 4 ? orgCalcColumn : orgCalcColumn.getParentRow().getParentRow().findColumnOfTuplePosition(orgCalcColumn.getTuplePosition());
            if (contextColumn != null) {
                contextColumnId = contextColumn.getId();
                contextColumnRowset = contextColumn.getRowset();
                contextDataItemIndex = contextColumn.getDataItemIndex();
            } else if (ownerColumn.doesActionTypeApplies(12)) {
                orgContextMember = (ContextMember)orgCalcColumn.getCurrentMember();
                contextColumnId = orgContextMember.getOlapEdgeMappingColumnId();
                contextColumnRowset = orgContextMember.getRowset();
                contextDataItemIndex = orgContextMember.getDataItemIndex();
            }
        } else {
            if (ownerColumn.doesActionTypeApplies(12)) {
                orgContextMember = (ContextMember)orgCalcColumn.getCurrentMember();
            } else if (!ownerColumn.doesActionTypeApplies(2)) {
                boolean notFoundPreviousRowWithGenerateContextColumn = true;
                int precedingRowIndex = ownersRowCycle.indexOf(ownersRow);
                AbstractOLAPColumn contextColumn = null;
                while (notFoundPreviousRowWithGenerateContextColumn && precedingRowIndex > 0) {
                    AbstractOLAPRow precedingRow = ownersRowCycle.getRow(--precedingRowIndex);
                    contextColumn = precedingRow.findColumnOfTuplePosition(orgCalcColumn.getTuplePosition());
                    notFoundPreviousRowWithGenerateContextColumn = !ownerColumn.doesActionTypeApplies(2);
                }
                if (contextColumn == null) {
                    throw new OLAPEdgeMappingException(mesgKey, "contextColumn == null");
                }
                if (contextColumn.getCurrentMember() == null) {
                    throw new OLAPEdgeMappingException(mesgKey, "contextColumn.getCurrentMember() == null");
                }
                orgContextMember = ((ContextMember)contextColumn.getCurrentMember()).getContextMember();
            }
            contextColumnId = orgContextMember.getOlapEdgeMappingColumnId();
            contextColumnRowset = orgContextMember.getRowset();
            contextDataItemIndex = orgContextMember.getDataItemIndex();
        }
        ContextMember newContextMember = orgContextMember;
        if (contextColumnId != -1) {
            newContextMember.setOlapEdgeMappingColumnId(contextColumnId);
        }
        newContextMember.setRowset(contextColumnRowset);
        newContextMember.setDataItemIndex(contextDataItemIndex);
        newCalcBaseMember.setLevel(newContextMember.getHierarchy().getLevel(0));
        newCalculatedMember.setContextMember(newContextMember);
        if (orgCalculatedMember.isSummary()) {
            newCalculatedMember.setSummary(true);
            orgCalculatedMember.setSummary(false);
        }
        orgCalculatedMember.setQueryCalculation(false);
        tupleMembers[this.getTo()] = newCalculatedMember;
        IMember[] members = null;
        members = !ownerColumn.getRules().isReportHierarchy() ? new IMember[tupleMembers.length - 1] : new IMember[tupleMembers.length];
        int j = -1;
        for (int i = 0; i < tupleMembers.length; ++i) {
            if (!ownerColumn.getRules().isReportHierarchy() && i == this.getFrom()) continue;
            members[++j] = tupleMembers[i];
        }
        Tuple tuple = new Tuple(members);
        this.setApplied(true);
        return tuple;
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int aFrom) {
        this.from = aFrom;
    }

    public int getTo() {
        return this.to;
    }

    public void setTo(int aTo) {
        this.to = aTo;
    }

    @Override
    public IEdgeElementMappingAction copy(EdgeElementFactory edgeElementFactory) {
        RelocateNestedLevelCalculation newAction = (RelocateNestedLevelCalculation)super.copy(edgeElementFactory);
        newAction.setTo(this.getTo());
        newAction.setFrom(this.getFrom());
        return newAction;
    }

    @Override
    public IEdgeElementMappingAction exactCopy(EdgeElementFactory edgeElementFactory) {
        return this.copy(edgeElementFactory);
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        propertiesMap.put("from", XQEIntegerPool.getInteger(this.getFrom()).toString());
        propertiesMap.put("to", XQEIntegerPool.getInteger(this.getTo()).toString());
        return propertiesMap;
    }

    @Override
    public void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property("from", this.from);
        ctx.property("to", this.to);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals("from")) {
            Object val = ctx.attributeValue(att);
            this.from = (Integer)val;
        } else if (attName.equals("to")) {
            Object val = ctx.attributeValue(att);
            this.to = (Integer)val;
        } else {
            super.restoreAttributeProperty(ctx, att, node);
        }
    }
}

