/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory;

import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPEdgeElement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EdgeElementIndex {
    public static final int QUERYTREE_UNLIMITED_DEPTH = 0;
    private Map<Integer, AbstractOLAPEdgeElement> mIdMap = new HashMap<Integer, AbstractOLAPEdgeElement>();
    private Lock readLock;
    private Lock writeLock;

    public EdgeElementIndex() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public void removeElement(AbstractOLAPEdgeElement edgeElement) {
        Integer edgeElementId = edgeElement.getId();
        try {
            this.writeLock.lockInterruptibly();
            try {
                this.mIdMap.remove(edgeElementId);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }

    public void addElement(AbstractOLAPEdgeElement edgeElement) {
        Integer edgeElementId = edgeElement.getId();
        try {
            this.writeLock.lockInterruptibly();
            try {
                this.mIdMap.put(edgeElementId, edgeElement);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }

    public AbstractOLAPEdgeElement getElementByID(Integer edgeElementId) {
        try {
            this.readLock.lockInterruptibly();
            AbstractOLAPEdgeElement edgeElement = null;
            try {
                edgeElement = this.mIdMap.get(edgeElementId);
            }
            finally {
                this.readLock.unlock();
            }
            return edgeElement;
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }

    public boolean validateElementIsIndex(AbstractOLAPEdgeElement edgeElement) {
        boolean hasKey = false;
        try {
            this.readLock.lockInterruptibly();
            try {
                hasKey = this.mIdMap.containsKey(edgeElement.getId());
            }
            finally {
                this.readLock.unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
        return hasKey;
    }
}

