/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.mdx.parser.ASTAxisSpecification;
import com.cognos.xqe.ast.mdx.parser.ASTMDXNode;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.XMdxProperty;
import com.cognos.xqe.runtree.olap.mdx.XMdxSelect;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SelectQuery;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XMdxAxisSpecification
extends XMdxNode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_AXISNUMBER = "axisNumber";
    private static final String ATTRIBUTE_NONEMPTY = "nonEmpty";
    private static final String ATTRIBUTE_DIM_PROPS = "dimProps";
    private int axisNumber;
    private java.util.Set<IProperty> dimProps;
    private ReadWriteLock dimPropsLock = new ReentrantReadWriteLock();
    private boolean nonEmpty = false;

    @Override
    public int getType() {
        return 501054;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        InterpreterContext interpreterContext = context.getInterpreterContext();
        java.util.Set<IProperty> dimensionProperties = this.getDimensionProperties(context);
        if (dimensionProperties != null && !dimensionProperties.isEmpty()) {
            Map dimToProperties = MapCast.uncheckedCast((Map)context.getProperty("axesDimensionProperties"));
            if (dimToProperties == null) {
                dimToProperties = new HashMap();
            }
            IDimension dimension = null;
            HashSet<String> dimProperties = null;
            HashSet<String> nativeDimensionProperties = (HashSet<String>)dimToProperties.get("nativeProperties");
            if (nativeDimensionProperties == null) {
                nativeDimensionProperties = new HashSet<String>();
                dimToProperties.put("nativeProperties", nativeDimensionProperties);
            }
            for (IProperty property : dimensionProperties) {
                dimension = property.getDimension();
                if (dimension == null) {
                    nativeDimensionProperties.add(property.getName());
                    continue;
                }
                String dimensionUniqueName = dimension.getUniqueName();
                dimProperties = (HashSet<String>)dimToProperties.get(dimension.getUniqueName());
                if (dimProperties == null) {
                    dimProperties = new HashSet<String>();
                }
                dimProperties.add(property.getName());
                if (dimToProperties.containsKey(dimensionUniqueName)) continue;
                dimToProperties.put(dimensionUniqueName, dimProperties);
            }
            context.setProperty("axesDimensionProperties", dimToProperties);
        }
        try {
            Set set;
            Object result = this.executeXMdxChildNode(0, context);
            if (result == null) {
                set = new Set(new Tuple[0]);
            } else {
                Block block = (Block)result;
                ArrayList<Set> setsToUnion = new ArrayList<Set>();
                BlockIterator blockIter = block.iterator();
                while (blockIter.hasNext()) {
                    Object[] blockObjs = (Object[])blockIter.next();
                    Object blockObj = blockObjs[0];
                    Set nextSet = null;
                    if (blockObj instanceof Set) {
                        nextSet = (Set)blockObj;
                    } else if (blockObj instanceof IMember) {
                        nextSet = new Set(new Tuple((IMember)blockObj));
                    } else if (blockObj instanceof IDimension || blockObj instanceof IHierarchy || blockObj instanceof ILevel) {
                        nextSet = (Set)Caster.cast(blockObj, Set.class, interpreterContext);
                    } else if (blockObj instanceof Tuple) {
                        nextSet = new Set((Tuple)blockObj);
                    } else {
                        String className = XMdxAxisSpecification.getClassNameCode(blockObj.getClass().getSimpleName());
                        InterpreterException ie = new InterpreterException("X01461", new String[]{className, "CMP_TYPESET"});
                        String errorMessage = ie.getLocalizedMessage();
                        throw new MDXEngineException("X60002", new String[]{this.axisNumber + "", errorMessage});
                    }
                    setsToUnion.add(nextSet);
                }
                set = Set.union(setsToUnion.toArray(new Set[0]), true);
                if (!"Metadata".equals(interpreterContext.getXDataContext().getEnvironment().getRequestEnvironment().getOperationName())) {
                    set.removeInvalidTuples(interpreterContext.getCube(), null);
                }
            }
            try {
                XMdxSelect selectNode = (XMdxSelect)this.getParent();
                SelectQuery selectQuery = selectNode.getSelectQuery(context);
                selectQuery.setAxis(this.axisNumber, set);
                if (this.isNonEmpty()) {
                    selectQuery.setNonEmptyAxis(this.axisNumber);
                }
                if (!set.isEmpty() && !dimensionProperties.isEmpty()) {
                    ArrayList<IProperty> dimPropList = new ArrayList<IProperty>();
                    for (IProperty prop : dimensionProperties) {
                        ILevel l;
                        IDimension dim = prop.getDimension();
                        if (dim == null && (l = prop.getLevel()) != null) {
                            dim = l.getDimension();
                        }
                        if (dim != null && !set.contains(dim)) {
                            XMdxLocal localNode = (XMdxLocal)selectNode.getParent();
                            if (localNode.getMDXQuery() != null && localNode.getParent() == null) continue;
                            throw new MDXEngineException("X01458", new String[]{prop.getUniqueName()});
                        }
                        dimPropList.add(prop);
                    }
                    selectQuery.setPropertiesOnAxis(this.axisNumber, dimPropList);
                }
            }
            catch (InterpreterException e) {
                throw XMdxAxisSpecification.createAxisEvalErrorException(e, this.axisNumber);
            }
            if (set instanceof CrossJoinedSet) {
                set = ((CrossJoinedSet)set).removeNullMembersFromCrossJoinedSet();
            } else if (set instanceof Set) {
                set = set.removeNullMembers();
            }
        }
        catch (InterpreterException e) {
            throw new MDXEngineException(e);
        }
        return null;
    }

    protected static MDXEngineException createAxisEvalErrorException(InterpreterException e, int axisNumber) {
        return new MDXEngineException("X60002", (Throwable)e, new String[]{axisNumber + "", e.toString()});
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        this.axisNumber = Integer.parseInt(inputNode.attributeValue(ATTRIBUTE_AXISNUMBER));
        this.nonEmpty = Boolean.parseBoolean(inputNode.attributeValue(ATTRIBUTE_NONEMPTY));
        this.setPropertyValue(ATTRIBUTE_AXISNUMBER, inputNode.attributeValue(ATTRIBUTE_AXISNUMBER));
        this.setPropertyValue(ATTRIBUTE_NONEMPTY, new Boolean(this.nonEmpty));
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        this.dumpProperty(trace, ATTRIBUTE_AXISNUMBER);
        this.dumpProperty(trace, ATTRIBUTE_NONEMPTY);
    }

    @Override
    protected void processAddContextNode(MDXQueryNode contextNode) {
        if (contextNode instanceof ASTMDXNode) {
            this.axisNumber = ((ASTMDXNode)contextNode).getValue();
            this.setPropertyValue(ATTRIBUTE_AXISNUMBER, XQEIntegerPool.getInteger(this.axisNumber));
        }
    }

    @Override
    public void setParserNode(MDXQueryNode node) {
        super.setParserNode(node);
        ASTAxisSpecification axisSpec = (ASTAxisSpecification)node;
        this.nonEmpty = axisSpec.getNonEmpty();
        this.setPropertyValue(ATTRIBUTE_NONEMPTY, new Boolean(this.nonEmpty));
    }

    public int getAxisNumber() {
        return this.axisNumber;
    }

    private boolean isNonEmpty() {
        return this.nonEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private java.util.Set<IProperty> getDimensionProperties(XDataContext context) {
        try {
            this.dimPropsLock.readLock().lockInterruptibly();
            try {
                if (this.dimProps != null) {
                    java.util.Set<IProperty> set = this.dimProps;
                    return set;
                }
            }
            finally {
                this.dimPropsLock.readLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
        try {
            this.dimPropsLock.writeLock().lockInterruptibly();
            try {
                if (this.dimProps != null) {
                    java.util.Set<IProperty> ie = this.dimProps;
                    return ie;
                }
                this.dimProps = new HashSet<IProperty>();
                IXQEQueryNode[] axisChildren = this.getChildren();
                int i = 0;
                while (i < axisChildren.length) {
                    IProperty prop;
                    if (axisChildren[i] instanceof XMdxProperty && (prop = (IProperty)this.executeXMdxChildNode(i, context)) != null) {
                        this.dimProps.add(prop);
                    }
                    ++i;
                }
                return this.dimProps;
            }
            finally {
                this.dimPropsLock.writeLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new RequestCanceledException();
        }
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_AXISNUMBER, this.axisNumber);
        ctx.property(ATTRIBUTE_NONEMPTY, this.nonEmpty);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.dimProps != null) {
            ctx.elementProperty(ATTRIBUTE_DIM_PROPS, this.dimProps);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_AXISNUMBER)) {
            Object val = ctx.attributeValue(att);
            this.axisNumber = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_NONEMPTY)) {
            Object val = ctx.attributeValue(att);
            this.nonEmpty = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ATTRIBUTE_DIM_PROPS)) {
            Object val = ctx.elementValue(node);
            this.dimProps = (java.util.Set)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }
}

