/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.mdx.parser.ASTMDXNode;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxCreate;
import com.cognos.xqe.runtree.olap.mdx.XMdxDrop;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.XMdxSet;
import com.cognos.xqe.runtree.olap.mdx.XMdxUnsignedNumericLiteral;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.tree.DefaultAttribute;

public class XMdxCalculatedMember
extends XMdxNode {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_IDENTIFIER = "identifier";
    public static final String PROPERTY_SOLVE_ORDER = "solve_order";
    public static final String PROPERTY_CAPTION = "caption";
    public static final String PROPERTY_MEMBER_CAPTION = "member_caption";
    public static final String PROPERTY_LITERAL = "literal";
    private static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_SCOPE = "scope";
    public static final String PROPERTY_FORMAT = "FORMAT_STRING";
    private static final String SESSION_STRING = "SESSION";
    private static final String STATEMENT_STRING = "STATEMENT";
    public static final String PROPERTY_XQE_NULL_TAG = "nullTag";
    private static final String LEFT_BRACE = "[";
    private static final String RIGHT_BRACE = "]";
    private static final String DOT_LEFT_BRACE = ".[";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    public int getType() {
        return 501101;
    }

    @Override
    public void setParserNode(MDXQueryNode node) {
        super.setParserNode(node);
        IXQEQueryNode grandParentNode = node.getParent().getParent();
        if (grandParentNode instanceof XMdxCreate || grandParentNode instanceof XMdxDrop) {
            this.setPropertyValue(PROPERTY_SCOPE, new String(SESSION_STRING));
        } else {
            this.setPropertyValue(PROPERTY_SCOPE, new String(STATEMENT_STRING));
        }
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        this.captureProperties(env, inputNode);
    }

    private void captureProperties(PlanningEnvironment env, Element inputNode) {
        for (Object attr : inputNode.attributes()) {
            DefaultAttribute attribute = (DefaultAttribute)attr;
            if (attribute.getName().equalsIgnoreCase(PROPERTY_IDENTIFIER)) {
                String[] parts = null;
                try {
                    parts = UniqueNameParser.parse(attribute.getValue());
                    this.setPropertyValue(PROPERTY_IDENTIFIER, parts);
                }
                catch (UniqueNameParserException e) {
                    mErrorLogger.log(e);
                }
                continue;
            }
            this.setPropertyValue(attribute.getName(), attribute.getValue());
        }
    }

    @Override
    public void dumpProperties(XQETrace trace) {
        for (Map.Entry<String, Object> entry : this.getProperties().entrySet()) {
            if (entry.getKey().equalsIgnoreCase(PROPERTY_IDENTIFIER)) {
                StringBuilder sb = new StringBuilder();
                for (String identifier : (String[])this.getPropertyValue(PROPERTY_IDENTIFIER)) {
                    sb.append(LEFT_BRACE);
                    sb.append(identifier);
                    sb.append("].");
                }
                sb.deleteCharAt(sb.length() - 1);
                trace.attribute(PROPERTY_IDENTIFIER, sb.toString());
                continue;
            }
            trace.attribute(entry.getKey(), entry.getValue());
        }
    }

    public Object getValue() {
        Object o = this.getPropertyValue(PROPERTY_VALUE);
        if (o == null) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_ExecutionFailed);
        }
        return o;
    }

    @Override
    protected void processAddContextNode(MDXQueryNode contextNode) {
        if (contextNode instanceof ASTMDXNode) {
            String value = ((ASTMDXNode)contextNode).getText();
            value = CalculatedMember.unescapeCalculationString(value);
            StringValue v = DataValueFactory.createStringValue();
            ((Value)v).set(value);
            this.setPropertyValue(PROPERTY_VALUE, v);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected IValue executeImpl(XDataContext context) {
        CalculatedMember calcMem;
        int i;
        String[] origIdentifiers = (String[])this.getPropertyValue(PROPERTY_IDENTIFIER);
        String[] identifiers = new String[origIdentifiers.length];
        for (int idx = 0; idx < identifiers.length; ++idx) {
            identifiers[idx] = UniqueNameParser.undoEscapedSquareBracket(origIdentifiers[idx]);
        }
        ICube cube = null;
        int dimNameOffset = 0;
        InterpreterContext ic = context.getInterpreterContext();
        if (this.getPropertyValue(PROPERTY_SCOPE).equals(SESSION_STRING)) {
            try {
                cube = ic.getProvider().getCube(identifiers[0]);
                dimNameOffset = 1;
            }
            catch (ProviderException e) {
                throw new MDXEngineException("X01439", (Throwable)e, new String[]{identifiers[0]});
            }
        } else {
            cube = context.getInterpreterContext().getCube();
            if (cube.getName().equalsIgnoreCase(identifiers[0])) {
                ++dimNameOffset;
            }
        }
        IDimension d = cube.getDimension(identifiers[dimNameOffset]);
        if (d == null && dimNameOffset == 1) {
            d = cube.getDimension(identifiers[--dimNameOffset]);
        }
        if (d == null && identifiers.length == 1) {
            throw new MDXEngineException("X01439", new String[]{identifiers[0]});
        }
        IMember calcParent = null;
        IHierarchy h = null;
        int levelNameOffset = 0;
        boolean useHierarchyUN = false;
        if (d == null) {
            h = cube.getHierarchy(identifiers[dimNameOffset]);
            levelNameOffset = dimNameOffset;
            if (h == null) {
                calcParent = ((Cube)cube).findMember(identifiers[dimNameOffset]);
                if (calcParent == null) throw new MDXEngineException("X01810", new String[]{identifiers[0 + dimNameOffset]});
                d = calcParent.getDimension();
                h = calcParent.getHierarchy();
            } else {
                d = h.getDimension();
                useHierarchyUN = true;
            }
        } else {
            levelNameOffset = dimNameOffset + 1;
            h = (Hierarchy)d.getHierarchy(identifiers[levelNameOffset]);
        }
        ILevel calcLevel = null;
        if (calcParent == null) {
            if (h == null) {
                h = (Hierarchy)d.getDefaultHierarchy();
            } else {
                ++levelNameOffset;
            }
            calcLevel = d.getLevel(identifiers[levelNameOffset]);
            if (calcLevel != null) {
                ++levelNameOffset;
            }
        } else {
            ++levelNameOffset;
        }
        for (i = levelNameOffset; i < identifiers.length - 1; ++i) {
            try {
                if (calcParent == null) {
                    calcParent = d.getMember(identifiers[i]);
                    if (calcParent == null) {
                        calcParent = ((Dimension)d).findMember(identifiers[i]);
                    }
                    if (calcParent != null) continue;
                    throw new MDXEngineException("X01439", new String[]{identifiers[i]});
                }
                IMember tempCalcParent = calcParent.getChildMember(identifiers[i]);
                if (tempCalcParent == null) throw new MDXEngineException("X01439", new String[]{identifiers[i]});
                calcParent = tempCalcParent;
                continue;
            }
            catch (MetadataException e) {
                throw new MDXEngineException("X01427", (Throwable)e, new String[]{identifiers[i].toString()});
            }
        }
        if (calcParent != null && (calcLevel = calcParent.getLevel().getNextLevel()) == null) {
            throw new MDXEngineException("X01426", new String[]{"Null"});
        }
        IMember originalCalculatedMember = null;
        String originalV5Name = null;
        if (calcLevel == null) {
            String uniqueName = UniqueNameGenerator.createUniqueName(identifiers);
            originalV5Name = this.getOriginalV5UniqueName(uniqueName);
            originalCalculatedMember = d.isMeasuresDimension() ? this.getOriginalCalculatedMeasure(h, originalV5Name) : this.getOriginalCalculatedMember(cube, h, originalV5Name);
            if (originalCalculatedMember != null) {
                calcLevel = originalCalculatedMember.getLevel();
            }
        }
        if (calcLevel == null) {
            calcLevel = (Level)h.getLevel(0);
        }
        String calcName = identifiers[identifiers.length - 1];
        String literal = null;
        if (this.getPropertyValue(PROPERTY_LITERAL) != null) {
            literal = ((String)this.getPropertyValue(PROPERTY_LITERAL)).replaceAll("''", "'");
        }
        try {
            String format;
            calcMem = new CalculatedMember(calcName, calcLevel, literal, identifiers, this);
            if (originalV5Name != null) {
                calcMem.setOriginalV5Name(originalV5Name);
                if (originalCalculatedMember != null) {
                    calcMem.setCaption(originalCalculatedMember.getCaption());
                    calcMem.setOriginalCalculatedMember(originalCalculatedMember);
                    calcMem.setOriginalUniqueName(originalCalculatedMember.getUniqueName());
                    if (originalCalculatedMember instanceof CalculatedMember) {
                        calcMem.setFormatId(((CalculatedMember)originalCalculatedMember).getFormatId());
                    }
                    if (originalCalculatedMember instanceof IROLAPMember) {
                        calcMem.setLocalizedCaption(((IROLAPMember)originalCalculatedMember).getLocalizedCaption());
                    }
                }
            }
            if ((format = (String)this.getPropertyValue(PROPERTY_FORMAT)) != null) {
                try {
                    Short s = Short.parseShort(format);
                    FormatId formatId = FormatId.getInstance(s);
                    if (formatId != null) {
                        calcMem.setFormatId(formatId);
                    }
                }
                catch (NumberFormatException e) {
                    mErrorLogger.log(e);
                }
            }
            if (SESSION_STRING.equals(this.getPropertyValue(PROPERTY_SCOPE))) {
                Object o;
                InterpreterContext icontext;
                CrossJoinedSet contextSets;
                calcMem.setMemberId(((Cube)cube).getNextSessionCalculatedMemberID());
                Provider provider = ic.getProvider();
                try {
                    ((Cube)cube).initialize();
                    List<IHierarchy> cubeHierarchies = ((Cube)cube).getHierarchies();
                    IMember[] mems = new IMember[cubeHierarchies.size()];
                    for (int j = 0; j < cubeHierarchies.size(); ++j) {
                        IHierarchy hier = cubeHierarchies.get(j);
                        Dimension dim = (Dimension)hier.getDimension();
                        try {
                            mems[j] = dim.isAttributeDimension() ? dim.getDummyMember(hier) : hier.getDefaultMember();
                            if (mems[j] != null) continue;
                            XQEDebugLog.out.println("Hierarchy " + hier.getUniqueName() + " contains no default member. Creating empty initial context");
                            continue;
                        }
                        catch (MetadataException e) {
                            throw new MDXEngineException("X01408", (Throwable)e, new String[]{hier.getUniqueName()});
                        }
                    }
                    contextSets = new CrossJoinedSet(new Set[]{new Set(new Tuple(mems))});
                }
                catch (ProviderException e) {
                    throw new MDXEngineException("X01425", (Throwable)e, new String[]{cube.getName()});
                }
                IXQEQueryNode calcNode = this.getChild(0);
                if (calcNode instanceof XMdxUnsignedNumericLiteral) {
                    String calculationString = ((CubicsValue)((XMdxUnsignedNumericLiteral)calcNode).executeImpl(context)).getCubicsObject().toString();
                    calcMem.setCalculationString(calculationString);
                    calculationString = calcMem.getUnescapeCalculationString();
                    icontext = new InterpreterContext(provider, null);
                    icontext.setSession(ic.getSession());
                    icontext.setQueryContext(ic.getQueryContext());
                    try {
                        icontext.setCube(cube);
                    }
                    catch (InterpreterException e) {
                        throw new XQERuntimeException(XQEMessageKeys.MDX_ExecutionFailed, (Throwable)e);
                    }
                    icontext.setInitialContextSet(contextSets);
                    icontext.setRefCalcMember(calcMem);
                    icontext.setXDataContext(context);
                    context.setInterpreterContext(icontext);
                    o = this.executeXMdxChildNode(0, context);
                    if (o instanceof XMdxSet) {
                        throw new MDXEngineException("X01496", new String[]{o.toString()});
                    }
                } else {
                    if (calcNode instanceof XMdxSet) {
                        throw new MDXEngineException("X01496", new String[]{calcNode.toString()});
                    }
                    icontext = new InterpreterContext(provider, null);
                    icontext.setQueryContext(ic.getQueryContext());
                    try {
                        icontext.setCube(cube);
                    }
                    catch (InterpreterException e) {
                        throw new XQERuntimeException(XQEMessageKeys.MDX_ExecutionFailed, (Throwable)e);
                    }
                    icontext.setInitialContextSet(contextSets);
                    icontext.setRefCalcMember(calcMem);
                    icontext.setXDataContext(context);
                    context.setInterpreterContext(icontext);
                    o = this.executeXMdxChildNode(0, context);
                    if (o instanceof XMdxSet) {
                        throw new MDXEngineException("X01496", new String[]{o.toString()});
                    }
                }
            } else {
                IMember originalCalcMem = calcMem.getOriginalCalculatedMember();
                if (originalCalcMem != null && originalCalcMem instanceof ROLAPCalculatedMember) {
                    calcMem.setMemberId(((ROLAPCalculatedMember)originalCalcMem).getMemberId());
                } else {
                    calcMem.setMemberId(context.getInterpreterContext().getCalculationEngine().getNextCalculatedMemberID());
                }
            }
            if (calcParent != null) {
                calcMem.setParentMember(calcParent);
            } else if (originalCalculatedMember != null) {
                calcMem.setParentMember(originalCalculatedMember.getParent());
                calcMem.setParentLevelNumber(originalCalculatedMember.getParentLevelNumber());
            }
            if (STATEMENT_STRING.equals(this.getPropertyValue(PROPERTY_SCOPE))) {
                if (originalCalculatedMember != null) {
                    calcMem.setType(MemberTypeEnum.GLOBAL_CALCULATION);
                } else {
                    calcMem.setType(MemberTypeEnum.QUERY_CALCULATION);
                }
            } else if (SESSION_STRING.equals(this.getPropertyValue(PROPERTY_SCOPE))) {
                calcMem.setType(MemberTypeEnum.SESSION_CALCULATION);
            }
            StringBuilder givenName = new StringBuilder();
            int jstart = 0;
            if (SESSION_STRING.equals(this.getPropertyValue(PROPERTY_SCOPE))) {
                jstart = 1;
            }
            for (int j = jstart; j < identifiers.length; ++j) {
                String string = identifiers[j];
                givenName.append(LEFT_BRACE);
                givenName.append(string);
                givenName.append(RIGHT_BRACE);
                if (j >= identifiers.length - 1) continue;
                givenName.append(".");
            }
            calcMem.setProperty("DefinitionUniqueName", givenName.toString());
            if (calcParent != null) {
                calcMem.setUniqueName(calcParent.getUniqueName() + DOT_LEFT_BRACE + calcName + RIGHT_BRACE);
            } else if (useHierarchyUN || cube instanceof IROLAPCube || cube instanceof LOLAPTM1Cube && ((LOLAPTM1Cube)cube).getDatasourceType().equals("TMR")) {
                calcMem.setUniqueName(h.getUniqueName() + DOT_LEFT_BRACE + calcName + RIGHT_BRACE);
            } else {
                calcMem.setUniqueName(d.getUniqueName() + DOT_LEFT_BRACE + calcName + RIGHT_BRACE);
            }
        }
        catch (MetadataException e) {
            throw new MDXEngineException("X01439", (Throwable)e, new String[]{identifiers[i].toString()});
        }
        int childCount = this.getNumberChildren();
        for (int j = 0; j < childCount; ++j) {
            XMdxNode childNode = (XMdxNode)this.getChild(j);
            String propName = (String)childNode.getPropertyValue(PROPERTY_NAME);
            if (propName == null) continue;
            Object propValue = this.executeXMdxChildNode(j, context);
            if (propName == null || propValue == null) continue;
            calcMem.setProperty(propName, propValue);
        }
        for (Map.Entry<String, Object> entry : this.getProperties().entrySet()) {
            if (entry.getKey().equalsIgnoreCase(PROPERTY_SOLVE_ORDER)) {
                calcMem.setSolveOrder(Integer.parseInt((String)entry.getValue()));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase(PROPERTY_CAPTION) || entry.getKey().equalsIgnoreCase(PROPERTY_MEMBER_CAPTION)) {
                if (calcMem.getType() == MemberTypeEnum.GLOBAL_CALCULATION) continue;
                calcMem.setCaption((String)entry.getValue());
                continue;
            }
            calcMem.setProperty(entry.getKey(), entry.getValue());
        }
        return new CubicsValue(calcMem);
    }

    private String getOriginalV5UniqueName(String uniqueName) {
        String originalName = null;
        XMdxLocal xMdxLocal = (XMdxLocal)this.getAncestorOfType(501053);
        HashMap<String, String> calculatedMemberMap = xMdxLocal.getCalculatedMemberUniqueNameMap();
        if (calculatedMemberMap != null) {
            originalName = calculatedMemberMap.get(uniqueName);
        }
        return originalName;
    }

    private CalculatedMember getOriginalCalculatedMember(ICube cube, IHierarchy hier, String originalV5Name) {
        if (originalV5Name != null && hier instanceof IROLAPHierarchy) {
            return ((IROLAPHierarchy)hier).getOriginalCalculatedMember((IROLAPCube)((Object)cube), originalV5Name);
        }
        return null;
    }

    private IMember getOriginalCalculatedMeasure(IHierarchy hier, String originalV5Name) {
        if (hier.getDimension().isMeasuresDimension() && hier instanceof IROLAPHierarchy) {
            return ((IROLAPHierarchy)hier).getOriginalCalculatedMeasure(originalV5Name);
        }
        return null;
    }
}

