/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxDropMemberStatement;
import com.cognos.xqe.runtree.olap.mdx.XMdxDropSetStatement;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Session;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XMdxDrop
extends XMdxNode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_CUBENAME = "cubeName";
    private static final String CLOSE_SQUARE_BRACKET = "]";
    private static final String OPEN_SQUARE_BRACKET = "[";
    private static final String PERIOD = ".";

    @Override
    public int getType() {
        return 501123;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        Metadata result = null;
        int childCount = this.getNumberChildren();
        if (childCount == 0) {
            throw new MDXEngineException("X01425", new String[]{""});
        }
        InterpreterContext interpreterContext = context.getInterpreterContext();
        interpreterContext.setXDataContext(context);
        Session session = interpreterContext.getSession();
        if (!(this.getParent() instanceof XMdxLocal)) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_ExecutionFailed);
        }
        if (childCount > 0) {
            XMdxNode dropMemberOrSetStatement = (XMdxNode)this.getChild(0);
            if (dropMemberOrSetStatement instanceof XMdxDropMemberStatement) {
                childCount = dropMemberOrSetStatement.getNumberChildren();
                for (int j = 0; j < childCount; ++j) {
                    Cube cube;
                    Object obj = dropMemberOrSetStatement.executeXMdxChildNode(j, context);
                    if (!(obj instanceof String[])) continue;
                    String[] memberName = (String[])obj;
                    String dropSessionObjectWithName = "";
                    try {
                        cube = interpreterContext.getProvider().getCube(memberName[0]);
                    }
                    catch (ProviderException e) {
                        throw new MDXEngineException("X01439", (Throwable)e, new String[]{memberName[0]});
                    }
                    try {
                        interpreterContext.setCube(cube);
                    }
                    catch (InterpreterException e) {
                        throw new XQERuntimeException(XQEMessageKeys.MDX_ExecutionFailed, (Throwable)e);
                    }
                    int calcNameOffset = memberName.length - 1;
                    ICalculationEngine calculationEngine = interpreterContext.getCalculationEngine();
                    CalculatedMember calcMem = calculationEngine.findCalculatedMember(memberName[calcNameOffset]);
                    if (calcMem == null) {
                        throw new MDXEngineException("X01405", new String[]{memberName[calcNameOffset]});
                    }
                    dropSessionObjectWithName = OPEN_SQUARE_BRACKET + cube + CLOSE_SQUARE_BRACKET + PERIOD + calcMem.getUniqueName();
                    result = session.getSessionObjects().get(dropSessionObjectWithName);
                    session.dropSessionMember(dropSessionObjectWithName);
                }
            } else if (dropMemberOrSetStatement instanceof XMdxDropSetStatement) {
                childCount = dropMemberOrSetStatement.getNumberChildren();
                for (int j = 0; j < childCount; ++j) {
                    Block sessionSetB = (Block)dropMemberOrSetStatement.executeXMdxChildNode(j, context);
                    NamedSet sessionSet = sessionSetB.getNamedSet();
                    String dropSessionObjectWithName = null;
                    if (!(sessionSet instanceof NamedSet)) {
                        String classCode = XMdxDrop.getClassNameCode(sessionSet.getClass().getSimpleName());
                        throw new MDXEngineException("X01461", new String[]{classCode, "CMP_TYPENAMEDSET, CMP_TYPECALCMEMBER, CMP_TYPESTRING"});
                    }
                    dropSessionObjectWithName = OPEN_SQUARE_BRACKET + sessionSet.getCubeName() + CLOSE_SQUARE_BRACKET + PERIOD + sessionSet.getUniqueName();
                    if (dropSessionObjectWithName == null) continue;
                    result = sessionSet;
                    session.dropSessionSet(dropSessionObjectWithName);
                }
            }
        }
        interpreterContext.setSession(session);
        context.setInterpreterContext(interpreterContext);
        return new CubicsValue(result);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        this.setPropertyValue(ATTRIBUTE_CUBENAME, inputNode.attributeValue(ATTRIBUTE_CUBENAME));
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        this.dumpProperty(trace, ATTRIBUTE_CUBENAME);
    }

    public String getCubeName() {
        return (String)this.getPropertyValue(ATTRIBUTE_CUBENAME);
    }
}

