/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.ast.mdx.parser.ASTExpression;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XMdxExpression
extends XMdxNode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_INLINESET = "inlineSet";
    private static final String INLINE_IDENTIFIER = "InlineIdentifier";

    public XMdxExpression() {
        this.setPropertyValue(ATTRIBUTE_INLINESET, Boolean.FALSE);
    }

    @Override
    public int getType() {
        return 501060;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        String inlineSet = inputNode.attributeValue(ATTRIBUTE_INLINESET);
        if (inlineSet == null) {
            this.setPropertyValue(ATTRIBUTE_INLINESET, Boolean.TRUE);
        } else {
            this.setPropertyValue(ATTRIBUTE_INLINESET, new Boolean(inlineSet));
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        this.dumpProperty(trace, ATTRIBUTE_INLINESET);
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        if (this.getNumberChildren() <= 0) {
            return null;
        }
        Object result = this.executeXMdxChildNode(0, context);
        try {
            if (this.isInlineSet()) {
                this.setParameterObject(INLINE_IDENTIFIER, Boolean.TRUE, context);
                InterpreterContext interpreterContext = context.getInterpreterContext();
                Block setNameB = (Block)this.executeXMdxChildNode(1, context);
                String setName = ((Value)setNameB.first()).getString();
                Block setB = (Block)result;
                setB = Caster.cast(setB, Set.class, interpreterContext);
                NamedSet namedSet = new NamedSet(setName, setB, true, interpreterContext);
                ICalculationEngine calculationEngine = interpreterContext.getCalculationEngine();
                calculationEngine.addNamedSet(namedSet);
                this.setParameterObject(INLINE_IDENTIFIER, Boolean.FALSE, context);
            }
        }
        catch (InterpreterException e) {
            throw new MDXEngineException(e);
        }
        return new CubicsValue(result);
    }

    @Override
    public void setParserNode(MDXQueryNode node) {
        super.setParserNode(node);
        ASTExpression expression = (ASTExpression)node;
        String keyword = expression.getKeyword();
        if ("InlineSet".equals(keyword)) {
            this.setPropertyValue(ATTRIBUTE_INLINESET, Boolean.TRUE);
        } else {
            this.setPropertyValue(ATTRIBUTE_INLINESET, Boolean.FALSE);
        }
    }

    public boolean isInlineSet() {
        return (Boolean)this.getPropertyValue(ATTRIBUTE_INLINESET);
    }

    public boolean isInlineIdentifier(XDataContext context) {
        Object o = this.getParameterObject(INLINE_IDENTIFIER, context);
        if (o != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }
}

