/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.mdx.parser.ASTSet;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxElement;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Caster;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XMdxSet
extends XMdxNode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_KEYWORD = "keyword";
    private static final String PROPERTY_SETELEMENT = "setElement";
    public static final String STRING_ELEMENTSET = "elementSet";

    @Override
    public int getType() {
        return 501070;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        String setElement;
        super.capture(env, inputNode);
        String keyword = inputNode.attributeValue(ATTRIBUTE_KEYWORD);
        if (keyword != null) {
            this.setPropertyValue(ATTRIBUTE_KEYWORD, keyword);
        }
        if ((setElement = inputNode.attributeValue(PROPERTY_SETELEMENT)) != null) {
            this.setPropertyValue(PROPERTY_SETELEMENT, Boolean.parseBoolean(setElement));
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        if (this.getPropertyValue(ATTRIBUTE_KEYWORD) != null) {
            this.dumpProperty(trace, ATTRIBUTE_KEYWORD);
        }
        if (this.getPropertyValue(PROPERTY_SETELEMENT) != null) {
            this.dumpProperty(trace, PROPERTY_SETELEMENT);
        }
    }

    @Override
    public void setParserNode(MDXQueryNode node) {
        super.setParserNode(node);
        ASTSet set = (ASTSet)node;
        String keyword = set.getKeyword();
        if (keyword != null) {
            this.setPropertyValue(ATTRIBUTE_KEYWORD, keyword);
        }
        boolean setElementValue = false;
        String setElement = set.getParameter(PROPERTY_SETELEMENT);
        if (setElement != null && setElement.equals("true")) {
            setElementValue = true;
        }
        this.setPropertyValue(PROPERTY_SETELEMENT, setElementValue);
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        Object result = null;
        int childCount = this.getNumberChildren();
        if (childCount == 0) {
            result = new Block(context.getInterpreterContext(), new Set(new Tuple[0]));
            ((Block)result).removeInvalidTuples();
            return new CubicsValue(result);
        }
        int elementCount = 0;
        for (int j = 0; j < childCount; ++j) {
            if (!(this.getChild(j) instanceof XMdxElement)) continue;
            ++elementCount;
        }
        if ("Set".equals(this.getKeyword())) {
            try {
                result = this.processSetKeyword(context);
            }
            catch (InterpreterException e) {
                throw new MDXEngineException(e);
            }
        } else {
            result = this.executeXMdxChildNode(0, context);
        }
        if (elementCount > 0) {
            if (this.isElementSet()) {
                if (this.getParameterObject(STRING_ELEMENTSET, context) == null) {
                    this.setParameterObject(STRING_ELEMENTSET, result, context);
                } else {
                    this.setParameterObject(STRING_ELEMENTSET, null, context);
                }
            }
            IXQEQueryNode[] children = this.getChildren();
            this.setParameterObject("elementContext", result, context);
            for (int j = 0; j < childCount; ++j) {
                ((XMdxNode)children[j]).setParameterObject("lastCompositePart", j == children.length - 1, context);
                result = this.executeXMdxChildNode(j, context);
                this.setParameterObject("elementContext", result, context);
            }
            this.setParameterObject("elementContext", null, context);
        }
        ((Block)result).removeInvalidTuples();
        return new CubicsValue(result);
    }

    private Object processSetKeyword(XDataContext context) throws InterpreterException {
        InterpreterContext interpreterContext = context.getInterpreterContext();
        int childCount = this.getNumberChildren();
        int nonElemNodesCount = 0;
        for (int j = 0; j < childCount; ++j) {
            if (this.getChild(j) instanceof XMdxElement) continue;
            ++nonElemNodesCount;
        }
        if (nonElemNodesCount == 0) {
            Block retBlock = new Block(interpreterContext, new Set(new Tuple[0]));
            return retBlock;
        }
        Block[] setBlock = new Block[nonElemNodesCount];
        int numNulls = 0;
        for (int i = 0; i < nonElemNodesCount; ++i) {
            Block block = (Block)this.executeXMdxChildNode(i, context);
            if (block.isEmpty()) {
                ++numNulls;
                continue;
            }
            int adjustedIdx = i - numNulls;
            setBlock[adjustedIdx] = block;
            try {
                setBlock[adjustedIdx] = Caster.cast(setBlock[adjustedIdx], Set.class, interpreterContext);
                continue;
            }
            catch (Exception e) {
                String className = "null";
                if (setBlock[adjustedIdx].first() != null) {
                    className = XMdxSet.getClassNameCode(setBlock[adjustedIdx].first().getClass().getSimpleName());
                }
                throw new MDXEngineException("X01433", (Throwable)e, new String[]{className, "CMP_TYPEHIERARCHY, CMP_TYPEDIMENSION, CMP_TYPEMEMBER, CMP_TYPESET, CMP_TYPETUPLE"});
            }
        }
        if (numNulls > 0) {
            Block[] tmpBlock = new Block[nonElemNodesCount - numNulls];
            for (int i = 0; i < tmpBlock.length; ++i) {
                tmpBlock[i] = setBlock[i];
            }
            setBlock = tmpBlock;
        }
        Block retBlock = new Block(interpreterContext, setBlock);
        if (setBlock.length > 0) {
            BlockIterator blockIter = new BlockIterator(setBlock);
            while (blockIter.hasNext()) {
                Object[] blockObj = (Object[])blockIter.next();
                Set[] sets = new Set[blockObj.length];
                for (int i = 0; i < blockObj.length; ++i) {
                    sets[i] = (Set)blockObj[i];
                }
                Set unionSet = Set.union(sets, true);
                if (interpreterContext.getCube() instanceof DMRCube) {
                    unionSet = unionSet.removeNullMembers();
                }
                retBlock.add(blockIter, (Object)unionSet);
            }
            if (retBlock.cellSetSize() == 0) {
                retBlock = new Block(interpreterContext, new Set(new Tuple[0]));
                return retBlock;
            }
        }
        return retBlock;
    }

    public String getKeyword() {
        return (String)this.getPropertyValue(ATTRIBUTE_KEYWORD);
    }

    public boolean isElementSet() {
        Object o = this.getPropertyValue(PROPERTY_SETELEMENT);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }
}

