/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BlockIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;

public class XMdxStringValueExpression
extends XMdxNode {
    private static final long serialVersionUID = 1L;
    public static final String ESCAPED_SINGLE_QUOTE = "'";

    @Override
    public int getType() {
        return 501072;
    }

    public static String unescapeQuotes(String input, char quote) {
        StringBuilder buff = new StringBuilder();
        boolean justSeenQuote = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == quote) {
                if (!justSeenQuote) {
                    buff.append(c);
                    justSeenQuote = true;
                    continue;
                }
                justSeenQuote = false;
                continue;
            }
            buff.append(c);
            justSeenQuote = false;
        }
        return buff.toString();
    }

    public static String unescapeQuotes(String input) {
        StringBuilder buff = new StringBuilder();
        boolean justSeenQuote = false;
        boolean justSeenDoubleQuote = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\'') {
                if (!justSeenQuote) {
                    buff.append(c);
                    justSeenQuote = true;
                    continue;
                }
                justSeenQuote = false;
                continue;
            }
            if (c == '\"') {
                if (!justSeenDoubleQuote) {
                    buff.append(c);
                    justSeenDoubleQuote = true;
                    continue;
                }
                justSeenDoubleQuote = false;
                continue;
            }
            buff.append(c);
            justSeenDoubleQuote = false;
            justSeenQuote = false;
        }
        return buff.toString();
    }

    public static String unescapeQuotes2(String input) {
        StringBuilder buff = new StringBuilder();
        boolean justSeenQuote = false;
        boolean justSeenDoubleQuote = false;
        boolean emptyString = false;
        int roundBracketSeen = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\'') {
                if (!justSeenQuote || i == 1) {
                    buff.append(c);
                    justSeenQuote = true;
                    continue;
                }
                justSeenQuote = false;
                continue;
            }
            if (c == '\"') {
                if (!justSeenDoubleQuote) {
                    buff.append(c);
                    justSeenDoubleQuote = true;
                    emptyString = true;
                } else {
                    justSeenDoubleQuote = false;
                    if (roundBracketSeen > 0) {
                        buff.append(c);
                        emptyString = false;
                    }
                }
                if (!justSeenQuote) continue;
                justSeenQuote = false;
                continue;
            }
            if (c == '(') {
                ++roundBracketSeen;
            } else if (c == ')') {
                --roundBracketSeen;
            }
            emptyString = false;
            buff.append(c);
            justSeenDoubleQuote = false;
            justSeenQuote = false;
        }
        return buff.toString();
    }

    public static String unescapeQuotesInString(String input) {
        String resultStr = input;
        if (!input.trim().startsWith(ESCAPED_SINGLE_QUOTE) || !input.trim().endsWith(ESCAPED_SINGLE_QUOTE)) {
            resultStr = XMdxStringValueExpression.unescapeQuotes(resultStr);
        } else if (input.trim().startsWith(ESCAPED_SINGLE_QUOTE) || input.trim().endsWith(ESCAPED_SINGLE_QUOTE) && input.length() > 2) {
            resultStr = XMdxStringValueExpression.unescapeQuotes2(resultStr);
        }
        return resultStr;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        InterpreterContext interpreterContext = context.getInterpreterContext();
        if (interpreterContext == null) {
            Object strExp = this.executeXMdxChildNode(0, context);
            if (strExp instanceof String) {
                strExp = XMdxStringValueExpression.unescapeQuotesInString((String)strExp);
            } else if (strExp instanceof Value) {
                Value v = (Value)strExp;
                String s = v.getString();
                s = XMdxStringValueExpression.unescapeQuotesInString(s);
                v.set(s);
                strExp = v;
            }
            return new CubicsValue(strExp);
        }
        Block strExpB = (Block)this.executeXMdxChildNode(0, context);
        Block retBlock = new Block(interpreterContext, new Block[]{strExpB});
        BlockIterator blockIter = strExpB.iterator();
        while (blockIter.hasNext()) {
            Object[] blockObj = (Object[])blockIter.next();
            Object strExp = blockObj[0];
            retBlock.add(blockIter, strExp);
        }
        return new CubicsValue(retBlock);
    }

    protected IValue executeImpl1(XDataContext context) {
        Object result = this.executeXMdxChildNode(0, context);
        if (result instanceof String) {
            result = XMdxStringValueExpression.unescapeQuotesInString((String)result);
        }
        return new CubicsValue(result);
    }
}

