/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.data.cache;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.cache.ICacheListener;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XCellIteratorAdaptor;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XIteratorAdaptor;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.olap.mdx.CubeResultScrollableIteratorWrapper;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICachedCubeResultSet;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.data.cache.IResultSetCacheKeyMaker;
import com.cognos.xqe.runtree.olap.mdx.data.cache.IResultSetCacheVisitor;
import com.cognos.xqe.runtree.olap.mdx.functions.Utilities;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LinkedStack;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractCubeResultSetCache
implements ICubeResultSetCache {
    private static final long MIN_CACHE_SIZE = 128L;
    private static final long DEFAULT_MAX_CACHE_SIZE = 524288000L;
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine.ResultSetCache", LogLevel.TRACE);
    private final String mCubeName;
    private final IResultSetCacheKeyMaker mKeyMaker;
    private long mMaxCacheSize = 524288000L;
    private volatile long mCurrentCacheSize = 0L;
    private final ConcurrentMap<Object, CacheRecord> mRecords = new ConcurrentHashMap<Object, CacheRecord>();
    private final ConcurrentLinkedQueue<CacheRecord> mRecordTrashBin = new ConcurrentLinkedQueue();
    private final AtomicBoolean mMainentanceInProgress = new AtomicBoolean(false);
    private final AtomicBoolean mReleased = new AtomicBoolean(false);
    private final ConcurrentLinkedQueue<ICacheListener> mListeners = new ConcurrentLinkedQueue();

    public AbstractCubeResultSetCache(String name, IResultSetCacheKeyMaker keyMaker) {
        this.mCubeName = name;
        this.mKeyMaker = keyMaker;
    }

    public void registerListener(ICacheListener listener) {
        this.mListeners.add(listener);
    }

    public void deregisterListener(ICacheListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public final long getMaxCacheSize() {
        return this.mMaxCacheSize;
    }

    @Override
    public final void setMaxCacheSize(long size) {
        if (size < 128L) {
            throw new IllegalArgumentException("Cache size too small. Minimum is 128 bytes.");
        }
        this.mMaxCacheSize = size;
    }

    @Override
    public final long getCurrentCacheSize() {
        return this.mCurrentCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void visit(IResultSetCacheVisitor visitor) {
        Iterator iter = this.mRecords.entrySet().iterator();
        boolean keepWalking = true;
        while (keepWalking && iter.hasNext()) {
            Map.Entry entry = iter.next();
            CacheRecord record = (CacheRecord)entry.getValue();
            boolean expire = false;
            CacheRecord cacheRecord = record;
            synchronized (cacheRecord) {
                if (record.isReusable()) {
                    IResultSetCacheVisitor.VisitorAction action = visitor.visit(record.getCacheKey(), record.getCachedResultSet(), record.getCreationTimestamp(), record.getLastAccessTimestamp(), record.getRefCount());
                    switch (action) {
                        case CONTINUE: {
                            keepWalking = true;
                            expire = false;
                            break;
                        }
                        case EXPIRE_AND_CONTINUE: {
                            keepWalking = true;
                            expire = true;
                            break;
                        }
                        case EXPIRE_AND_STOP: {
                            keepWalking = false;
                            expire = true;
                            break;
                        }
                        case STOP: {
                            keepWalking = false;
                            expire = false;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected state: " + (Object)((Object)action));
                        }
                    }
                    if (expire) {
                        record.setNotReusable();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICubeResultSet getResultSet(MDXQuery mdxQuery, XDataContext dataContext, Integer nodeId) {
        ICube cube;
        Object cacheKey;
        ICubeResultSet resultSet;
        block16: {
            resultSet = null;
            cacheKey = null;
            cube = mdxQuery.getMDXFrom().getCube();
            boolean needToRemoveCubeName = false;
            try {
                needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cube.getName());
                cacheKey = this.mKeyMaker.makeKey(cube, mdxQuery, dataContext);
                CacheRecord cacheRecord = (CacheRecord)this.mRecords.get(cacheKey);
                if (null == cacheRecord) break block16;
                CacheRecord cacheRecord2 = cacheRecord;
                synchronized (cacheRecord2) {
                    if (cacheRecord.isReusable() && cacheRecord.validate()) {
                        cacheRecord.incrementRefCount();
                        cacheRecord.updateLastAccessTimestamp();
                        resultSet = cacheRecord.wrapResultSet(dataContext, nodeId);
                    }
                }
            }
            catch (Throwable ex) {
                TRACE_LOGGER.log(LogLevel.ERROR, ex);
            }
            finally {
                ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
            }
        }
        if (TRACE_LOGGER.isOn(LogLevel.INFO)) {
            if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
                if (null != resultSet) {
                    TRACE_LOGGER.log(String.format("Cache hit on result set for cube %s with key %s for report %s.", cube.getName(), cacheKey, Utilities.getReportName()));
                } else {
                    TRACE_LOGGER.log(String.format("Cache miss on result set for cube %s with key %s.", cube.getName(), cacheKey));
                }
            } else {
                TRACE_LOGGER.log(LogLevel.INFO, String.format("Cache hit on result set for cube %s for report %s.", cube.getName(), Utilities.getReportName()));
            }
        }
        for (ICacheListener listener : this.mListeners) {
            if (resultSet != null) {
                listener.incrementHits();
                continue;
            }
            listener.incrementMisses();
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICubeResultSet storeResultSet(MDXQuery mdxQuery, XDataContext dataContext, Integer nodeId, ICubeResultSet resultSet) {
        ICube cube = mdxQuery.getMDXFrom().getCube();
        boolean needToRemoveCubeName = false;
        try {
            needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cube.getName());
            Object cacheKey = this.mKeyMaker.makeKey(cube, mdxQuery, dataContext);
            if (TRACE_LOGGER.isOn()) {
                TRACE_LOGGER.log(String.format("Storing result set in cache for cube %s with key %s.", cube.getName(), cacheKey));
            }
            CacheRecord cacheRecord = null;
            block9: do {
                if (null == (cacheRecord = (CacheRecord)this.mRecords.get(cacheKey))) {
                    CacheRecord existingCacheRecord;
                    ICachedCubeResultSet cachedResultSet = this.createCachedResultSet(cacheKey, resultSet);
                    cacheRecord = new CacheRecord(cacheKey, cachedResultSet);
                    cacheRecord.incrementRefCount();
                    while (null != (existingCacheRecord = this.mRecords.putIfAbsent(cacheKey, cacheRecord))) {
                        boolean existingRecordAcquired = false;
                        CacheRecord cacheRecord2 = existingCacheRecord;
                        synchronized (cacheRecord2) {
                            if (existingCacheRecord.isReusable()) {
                                existingCacheRecord.incrementRefCount();
                                existingCacheRecord.updateLastAccessTimestamp();
                                existingRecordAcquired = true;
                            }
                        }
                        if (existingRecordAcquired) {
                            cacheRecord.decrementRefCount();
                            cacheRecord.setNotReusable();
                            if (!cacheRecord.destroyIfUnreferenced()) {
                                throw new IllegalStateException("Expected record to be unreferenced.");
                            }
                            existingCacheRecord.incrementRefCount();
                            cacheRecord = existingCacheRecord;
                            continue block9;
                        }
                        if (!this.mRecords.replace(cacheKey, existingCacheRecord, cacheRecord)) continue;
                        this.mRecordTrashBin.add(existingCacheRecord);
                        continue block9;
                    }
                    continue;
                }
                boolean existingRecordAcquired = false;
                CacheRecord cacheRecord3 = cacheRecord;
                synchronized (cacheRecord3) {
                    if (cacheRecord.isReusable()) {
                        cacheRecord.incrementRefCount();
                        cacheRecord.updateLastAccessTimestamp();
                        existingRecordAcquired = true;
                    }
                }
                if (existingRecordAcquired) break;
                if (this.mRecords.remove(cacheKey, cacheRecord)) {
                    this.mRecordTrashBin.add(cacheRecord);
                }
                cacheRecord = null;
            } while (null == cacheRecord);
            this.runMaintenance();
            ICubeResultSet iCubeResultSet = cacheRecord.wrapResultSet(dataContext, nodeId);
            return iCubeResultSet;
        }
        finally {
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
        }
    }

    protected abstract ICachedCubeResultSet createCachedResultSet(Object var1, ICubeResultSet var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void release() {
        if (this.mReleased.compareAndSet(false, true)) {
            if (TRACE_LOGGER.isOn()) {
                TRACE_LOGGER.log(String.format("Releasing cache for cube %s.", this.mCubeName));
            }
            try {
                for (CacheRecord record : this.mRecords.values()) {
                    try {
                        record.setNotReusable();
                        record.destroyIfUnreferenced();
                    }
                    catch (Exception ex) {
                        TRACE_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
                    }
                }
            }
            finally {
                this.mRecords.clear();
                this.releaseImpl();
            }
        }
    }

    protected abstract void releaseImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runMaintenance() {
        if (!this.mMainentanceInProgress.compareAndSet(false, true)) {
            return;
        }
        this.maintenanceBegin();
        boolean terminateMaintenance = false;
        int maintenanceCount = 0;
        TreeSet<CacheRecord> expirationCandidates = new TreeSet<CacheRecord>(new Comparator<CacheRecord>(){

            @Override
            public int compare(CacheRecord lhs, CacheRecord rhs) {
                if (lhs.getLastAccessTimestamp() < rhs.getLastAccessTimestamp()) {
                    return -1;
                }
                if (lhs.getLastAccessTimestamp() > rhs.getLastAccessTimestamp()) {
                    return 1;
                }
                return 0;
            }
        });
        try {
            while (!terminateMaintenance) {
                long countedCacheSize = 0L;
                expirationCandidates.clear();
                Iterator entryIter = this.mRecords.entrySet().iterator();
                while (entryIter.hasNext()) {
                    Map.Entry entry = entryIter.next();
                    CacheRecord cacheRecord = (CacheRecord)entry.getValue();
                    boolean trashIt = false;
                    boolean canExpire = false;
                    CacheRecord cacheRecord2 = cacheRecord;
                    synchronized (cacheRecord2) {
                        if (!cacheRecord.isReusable() || !this.isValid(entry.getKey())) {
                            cacheRecord.setNotReusable();
                            trashIt = true;
                        }
                        if (cacheRecord.getRefCount() == 0) {
                            canExpire = true;
                        }
                    }
                    if (trashIt) {
                        entryIter.remove();
                        this.mRecordTrashBin.add(cacheRecord);
                        continue;
                    }
                    countedCacheSize += cacheRecord.getCacheSize();
                    if (!canExpire) continue;
                    expirationCandidates.add(cacheRecord);
                }
                this.mCurrentCacheSize = countedCacheSize;
                Iterator<CacheRecord> trashIter = this.mRecordTrashBin.iterator();
                while (trashIter.hasNext()) {
                    CacheRecord record = trashIter.next();
                    if (!record.destroyIfUnreferenced()) continue;
                    if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
                        TRACE_LOGGER.log(LogLevel.TRACE, String.format("Reclaimed %d bytes of cache memory for cube %s.", record.getCacheSize(), this.mCubeName));
                    }
                    trashIter.remove();
                }
                long excessCacheSize = this.mCurrentCacheSize - this.mMaxCacheSize;
                if (excessCacheSize > 0L) {
                    if (TRACE_LOGGER.isOn(LogLevel.WARN)) {
                        TRACE_LOGGER.log(LogLevel.WARN, String.format("Cache size (%d bytes) exceeds maximum size (%d bytes) for cube %s. Attempting to reclaim unused memory.", this.mCurrentCacheSize, this.mMaxCacheSize, this.mCubeName));
                    }
                    for (CacheRecord record : expirationCandidates) {
                        boolean canReclaim = false;
                        CacheRecord cacheRecord = record;
                        synchronized (cacheRecord) {
                            if (!record.isReusable() || record.getRefCount() == 0) {
                                record.setNotReusable();
                                canReclaim = true;
                            }
                        }
                        if (!canReclaim || (excessCacheSize -= record.getCacheSize()) > 0L) continue;
                        if (TRACE_LOGGER.isOn(LogLevel.INFO)) {
                            TRACE_LOGGER.log(LogLevel.INFO, String.format("Cache size quota (%d bytes) has been met for cube %s.", this.mMaxCacheSize, this.mCubeName));
                        }
                        break;
                    }
                } else {
                    terminateMaintenance = true;
                }
                if (++maintenanceCount <= 2) continue;
                terminateMaintenance = true;
                TRACE_LOGGER.log(LogLevel.WARN, String.format("Failed to reclaim cache memory for cube %s - in excess of %d bytes.", this.mCubeName, excessCacheSize));
            }
        }
        finally {
            this.mMainentanceInProgress.set(false);
        }
    }

    protected void maintenanceBegin() {
    }

    protected boolean isValid(Object cacheKey) {
        return true;
    }

    private final class CacheRecord {
        private final Object mCacheKey;
        private final ICachedCubeResultSet mCachedResultSet;
        private final long mCreationTimestamp;
        private long mLastAccessTimestamp;
        private volatile boolean mReusable = true;
        private volatile boolean mDestroyed = false;
        private final AtomicInteger mRefCount = new AtomicInteger(0);

        private CacheRecord(Object cacheKey, ICachedCubeResultSet cachedResultSet) {
            this.mCacheKey = cacheKey;
            this.mCachedResultSet = cachedResultSet;
            this.mLastAccessTimestamp = this.mCreationTimestamp = System.currentTimeMillis();
        }

        private Object getCacheKey() {
            return this.mCacheKey;
        }

        private ICachedCubeResultSet getCachedResultSet() {
            return this.mCachedResultSet;
        }

        private long getCacheSize() {
            return this.mCachedResultSet.getCacheSize();
        }

        private long getCreationTimestamp() {
            return this.mCreationTimestamp;
        }

        private long getLastAccessTimestamp() {
            return this.mLastAccessTimestamp;
        }

        private void updateLastAccessTimestamp() {
            this.mLastAccessTimestamp = System.currentTimeMillis();
        }

        private boolean isReusable() {
            return this.mReusable;
        }

        private void setNotReusable() {
            this.mReusable = false;
        }

        private boolean validate() {
            if (this.mCachedResultSet.isValid()) {
                return true;
            }
            this.setNotReusable();
            return false;
        }

        private synchronized boolean destroyIfUnreferenced() {
            if (this.mReusable) {
                throw new IllegalStateException("Record was still reusable.");
            }
            if (this.mRefCount.get() == 0) {
                if (!this.mDestroyed) {
                    this.mCachedResultSet.destroyCache();
                    this.mDestroyed = true;
                }
                return true;
            }
            return false;
        }

        private int getRefCount() {
            return this.mRefCount.get();
        }

        private int incrementRefCount() {
            return this.mRefCount.incrementAndGet();
        }

        private int decrementRefCount() {
            return this.mRefCount.decrementAndGet();
        }

        private ICubeResultSet wrapResultSet(XDataContext dataContext, Integer nodeId) {
            return new CubeResultSetWrapper(dataContext, nodeId);
        }

        private final class CubeResultSetWrapper
        extends XResultSetBase
        implements ICubeResultSet {
            CubeResultSetWrapper(XDataContext dataContext, Integer nodeId) {
                super(dataContext, nodeId);
            }

            @Override
            public XIterator getAxisIterator(int axisNumber) {
                XIteratorAdaptor iter = new XIteratorAdaptor(this.getDataContext(), CacheRecord.this.mCachedResultSet.getAxisIterator(axisNumber), this.getDataContext().getNodeId());
                iter.setEdgeNumber(axisNumber);
                return iter;
            }

            @Override
            public long getAxisSize(int axisNumber) {
                return CacheRecord.this.mCachedResultSet.getAxisSize(axisNumber);
            }

            @Override
            public XCellIterator getCellIterator() {
                return new XCellIteratorAdaptor(this.getDataContext(), CacheRecord.this.mCachedResultSet.getCellIterator(), this.getDataContext().getNodeId());
            }

            @Override
            public IDimension[] getDimensions(int axisNumber) {
                return CacheRecord.this.mCachedResultSet.getDimensions(axisNumber);
            }

            @Override
            public int getNumAxes() {
                return CacheRecord.this.mCachedResultSet.getNumAxes();
            }

            @Override
            public int getNumDataItemForSummary(int rowsetId) {
                return 0;
            }

            @Override
            public int getNumTabularMeasures() {
                return 0;
            }

            @Override
            public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
                return new CubeResultScrollableIteratorWrapper(this.getDataContext(), this.nodeId, CacheRecord.this.mCachedResultSet.getScrollableAxisIterator(axisNumber));
            }

            @Override
            public XScrollableCellIterator getScrollableCellIterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ITuple getSlicer() {
                return CacheRecord.this.mCachedResultSet.getSlicer();
            }

            @Override
            public boolean isCaching() {
                return true;
            }

            @Override
            public void optimizeCache(LinkedStack<CacheHints> hints) {
            }

            @Override
            public void releaseImpl() {
                if (0 == CacheRecord.this.decrementRefCount()) {
                    if (TRACE_LOGGER.isOn()) {
                        TRACE_LOGGER.log(String.format("CubeResultSetWrapper refCount reached 0 for cache key %s.", CacheRecord.this.mCacheKey));
                    }
                    AbstractCubeResultSetCache.this.runMaintenance();
                }
            }
        }
    }
}

