/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.data.cache;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.runtree.olap.mdx.data.cache.DiskBackedCubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.data.cache.IResultSetCacheKeyMaker;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPResultSetCacheKey;
import com.cognos.xqe.util.pool.DirectByteBufferPool;
import java.io.File;
import java.io.IOException;

public class IncrementAwareDiskBackedResultSetCache
extends DiskBackedCubeResultSetCache {
    protected int oldestValidIncrementId = 0;

    public IncrementAwareDiskBackedResultSetCache(ICube cube, IResultSetCacheKeyMaker keyMaker, File rootDirectory, boolean useEncryption, DirectByteBufferPool bufferPool) throws IOException {
        super(cube, keyMaker, rootDirectory, useEncryption, bufferPool);
    }

    @Override
    protected void maintenanceBegin() {
        if (this.mCube instanceof ROLAPCube) {
            try {
                this.oldestValidIncrementId = ((ROLAPCube)this.mCube).getOldestPossibleIncrementId();
            }
            catch (OperationCanceledException e) {
                this.oldestValidIncrementId = 0;
            }
        }
        super.maintenanceBegin();
    }

    @Override
    protected boolean isValid(Object cacheKey) {
        if (this.oldestValidIncrementId != 0) {
            return ((ROLAPResultSetCacheKey)cacheKey).getIncrementId() >= this.oldestValidIncrementId;
        }
        return super.isValid(cacheKey);
    }
}

