/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.data.values.MemberRSAPIValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.LoadDMRCubeSingleV5Query;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderCompoundKeyMapping;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DMRCompoundKeyMapping
extends V5ProviderCompoundKeyMapping {
    private static final int SELECTION_FILTER_THRESHOLD = 20;
    private static final int FILTER_LEVEL_SIZE = 2000;
    private static final int MAXIMUM_CELL_FETCHING_RATIO = 100;
    private final List<String> projectedColumns = new ArrayList<String>();
    private final Map<String, DMRLevel> projectedColumnToLevel = new HashMap<String, DMRLevel>();
    private final Map<DMRLevel, Set<IMember>> levelToQualifingMembers = new HashMap<DMRLevel, Set<IMember>>();
    private int columnOffsetInQuery = -1;
    private List<ILevel> levelsAddedByOptimization = new ArrayList<ILevel>();

    public Map<DMRLevel, Set<IMember>> getLevelToQualifyingMembers() {
        return this.levelToQualifingMembers;
    }

    @Override
    public <T> IMember getMemberForRowResult(List<T> row) {
        return this.getMemberForRowResult(row, false);
    }

    public <T> IMember getMemberForRowResult(List<T> row, boolean bReturnPreMember) {
        int columnCount = this.projectedColumns.size();
        IMember member = null;
        IMember preMember = null;
        DMRLevel level = this.projectedColumnToLevel.get(this.projectedColumns.get(this.projectedColumns.size() - 1));
        if (level.getIndex() == 1) {
            member = level.getPreviousLevel().getMembers().get(0);
        }
        for (int i = this.columnOffsetInQuery; i < this.columnOffsetInQuery + columnCount; ++i) {
            Value v = (Value)row.get(i);
            if (v instanceof MemberRSAPIValue) {
                v = ((MemberRSAPIValue)v).getBusinessKeyValue();
            }
            preMember = member;
            if (member == null) {
                String keyComponent = "";
                if (v != null && !v.isNull()) {
                    keyComponent = ((Value)row.get(i)).getV5formattedString();
                }
                member = level.getMember(keyComponent);
            } else {
                member = ((IDMRMember)member).searchChildMemberAsPerBusinessKeyValue(v);
            }
            if (member == null) break;
        }
        if (member == null && bReturnPreMember) {
            return preMember;
        }
        return member;
    }

    @Override
    public void addMemberSelection(IMember member) {
        DMRLevel level = (DMRLevel)member.getLevel();
        if (level.isMappedToRelationalColumn()) {
            Set<IMember> qualifyingMembers;
            String businessKeyItem = level.getQueryItemExpressionForKey();
            if (!this.projectedColumnToLevel.containsKey(businessKeyItem)) {
                this.projectedColumns.add(businessKeyItem);
                this.projectedColumnToLevel.put(businessKeyItem, level);
            }
            if ((qualifyingMembers = this.levelToQualifingMembers.get(level)) == null) {
                qualifyingMembers = new TreeSet<IMember>();
                this.levelToQualifingMembers.put(level, qualifyingMembers);
            }
            qualifyingMembers.add(member);
            IMember parent = member.getParent();
            if (parent != null) {
                this.addMemberSelection(parent);
            }
        }
    }

    public void addToQuery(V5QueryOverTabularStream subject) {
        if (this.projectedColumns.isEmpty()) {
            return;
        }
        this.columnOffsetInQuery = subject.getColumnCount();
        for (int i = this.projectedColumns.size() - 1; i >= 0; --i) {
            String column = this.projectedColumns.get(i);
            DMRLevel level = this.projectedColumnToLevel.get(column);
            subject.addColumn(level);
            Set<IMember> memberSelections = this.levelToQualifingMembers.get(level);
            boolean addIndividualMemberFilter = true;
            boolean addRangeMemberFilter = false;
            int numberOfMembers = level.getMemberCount();
            int selectionCount = 0;
            if (memberSelections != null) {
                selectionCount = memberSelections.size();
            }
            if (!subject.isV5QueryForDMRExternalAggregate()) {
                if (level.hasGotAllMembers() && selectionCount == numberOfMembers) {
                    addIndividualMemberFilter = false;
                } else if (selectionCount > 20) {
                    int levelSize = 2000;
                    if (level.hasGotAllMembers()) {
                        levelSize = numberOfMembers;
                    }
                    if (selectionCount > levelSize / 2) {
                        addIndividualMemberFilter = false;
                    } else if (selectionCount > 2000) {
                        addRangeMemberFilter = false;
                    }
                }
            }
            if (selectionCount == 0) continue;
            if (addRangeMemberFilter) {
                throw new IllegalArgumentException();
            }
            if (!addIndividualMemberFilter) continue;
            int maxAllowed = ((DMRCube)level.getHierarchy().getDimension().getCube()).getMaxMembersInSubQueryDetailFilter();
            if (memberSelections.size() <= maxAllowed) {
                subject.addFilteringMembers(memberSelections);
                continue;
            }
            LoadDMRCubeSingleV5Query.logSingleLoading(level.getName(), " 's members are not added when loading cells because the size exceeds ", Integer.toString(maxAllowed));
        }
        subject.getCompoundKeyMappings().add(this);
    }

    @Override
    public void addToQuery(V5ProviderQuery subject) {
    }

    public void adjustProjectedLevelsToLowestLevel(List<List<ILevel>> listofLevels, MDXLevelInfo levelInfo, DMRLevel scopeLevel, DMRQueryStrategy queryStrategy) {
        IHierarchy hierarchy = scopeLevel.getHierarchy();
        if (levelInfo == null || !levelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
            return;
        }
        if (queryStrategy.getInfoData().getDMRQuerySummaryOptimizationLevel() <= 0 || !queryStrategy.getInfoData().isDMR() || queryStrategy.getPushDownMode()) {
            return;
        }
        DMRCube dmrCube = (DMRCube)hierarchy.getDimension().getCube();
        DMRLevel lowestLevel = (DMRLevel)dmrCube.getWrapper(levelInfo.getLowestProjectedLevel(hierarchy));
        if (lowestLevel == null || lowestLevel.getPreviousLevel() == null || lowestLevel.getIndex() > scopeLevel.getIndex() || !lowestLevel.isMappedToRelationalColumn() || lowestLevel.hasGotAllMembers() && lowestLevel.getMembersOrderedMap().size() == 0 || dmrCube.getOptimizationInfo().getFilteredLevels().contains(lowestLevel)) {
            return;
        }
        Set<Object> qualifyingMembersAtLowestLevel = null;
        if (!this.projectedColumns.isEmpty()) {
            DMRLevel projectedLowestLevel = this.projectedColumnToLevel.get(this.projectedColumns.get(0));
            qualifyingMembersAtLowestLevel = this.levelToQualifingMembers.get(projectedLowestLevel);
        } else {
            qualifyingMembersAtLowestLevel = Collections.emptySet();
        }
        long qualifyingMembersCount = 1L;
        if (!qualifyingMembersAtLowestLevel.isEmpty()) {
            qualifyingMembersCount = qualifyingMembersAtLowestLevel.size();
        }
        List<Object> levelsToBeAdded = null;
        for (List<ILevel> aList : listofLevels) {
            if (!aList.get(0).getHierarchy().equals(hierarchy)) continue;
            levelsToBeAdded = aList;
            break;
        }
        if (levelsToBeAdded == null) {
            levelsToBeAdded = new ArrayList();
            listofLevels.add(levelsToBeAdded);
        }
        String businessKeyItem = lowestLevel.getQueryItemExpressionForKey();
        boolean bIsLowestLevel = true;
        while (!this.projectedColumnToLevel.containsKey(businessKeyItem)) {
            if (!lowestLevel.hasGotAllMembers() && lowestLevel.getMemberCount() == 0) {
                lowestLevel.getMember(0);
            }
            if (bIsLowestLevel) {
                long ratio;
                long memberCountAtLowestLevel = 0L;
                for (IMember iMember : qualifyingMembersAtLowestLevel) {
                    memberCountAtLowestLevel += (long)((IMemberCubics)iMember).getDescendants(lowestLevel).size();
                }
                if (memberCountAtLowestLevel == 0L) {
                    memberCountAtLowestLevel = lowestLevel.getMemberCount();
                }
                if ((ratio = memberCountAtLowestLevel / qualifyingMembersCount) > 100L) break;
            }
            this.levelsAddedByOptimization.add(lowestLevel);
            for (int i = 0; i <= this.projectedColumns.size(); ++i) {
                if (i == this.projectedColumns.size()) {
                    this.projectedColumns.add(businessKeyItem);
                    break;
                }
                DMRLevel aLevel = this.projectedColumnToLevel.get(this.projectedColumns.get(i));
                if (aLevel.getIndex() >= lowestLevel.getIndex()) continue;
                this.projectedColumns.add(i, businessKeyItem);
                break;
            }
            this.projectedColumnToLevel.put(businessKeyItem, lowestLevel);
            if (!levelsToBeAdded.contains(lowestLevel)) {
                levelsToBeAdded.add(lowestLevel);
            }
            if ((lowestLevel = (DMRLevel)lowestLevel.getPreviousLevel()).getPreviousLevel() == null) break;
            businessKeyItem = lowestLevel.getQueryItemExpressionForKey();
            bIsLowestLevel = false;
        }
    }

    public void removeUnusedProjectedLevels(List<Map<IMember, List<ILevel>>> listofMeasureAggregationLevels) {
        if (this.getLowestLevelAddedByOptimization() == null) {
            return;
        }
        Iterator<String> it = this.projectedColumns.iterator();
        while (it.hasNext()) {
            String columnKey = it.next();
            DMRLevel aProjecedLevel = this.projectedColumnToLevel.get(columnKey);
            boolean bUsedInAggregation = false;
            for (Map<IMember, List<ILevel>> aMeasureAggregationLevels : listofMeasureAggregationLevels) {
                for (List<ILevel> aLevelList : aMeasureAggregationLevels.values()) {
                    if (!aLevelList.contains(aProjecedLevel)) continue;
                    bUsedInAggregation = true;
                    break;
                }
                if (!bUsedInAggregation) continue;
                break;
            }
            if (!bUsedInAggregation) {
                it.remove();
                this.projectedColumnToLevel.remove(columnKey);
                this.levelsAddedByOptimization.remove(aProjecedLevel);
                continue;
            }
            return;
        }
    }

    public ILevel getLowestLevelAddedByOptimization() {
        if (this.levelsAddedByOptimization.isEmpty()) {
            return null;
        }
        return this.levelsAddedByOptimization.get(0);
    }
}

