/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IContextable;
import com.cognos.xqe.query.engine.MultiRequestReference;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryOptimizationInfo;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategyPreCellLoading;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.LoadDMRCubeSingleV5Query;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.LoadDMRCubeV5Query;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.PreciseCubeLoadInfo;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleStorage;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.CubeReuseLogger;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContext;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.DimensionCacheManager;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AdaptiveCubeletStorageManager;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DMRCube
extends Cube
implements IContextable {
    public static final int NUMBER_2K = 2000;
    protected final ICube modelCube;
    private String modelName = null;
    private IRestrictions cubeRestrictions = null;
    private final List<CogMDXDetailFilter> detailFilters = new ArrayList<CogMDXDetailFilter>();
    private List<IMeasure> referencedMeasures = null;
    private Map<IXQEQueryNode, MDXLevelInfo> aggregationLevelInfo = null;
    private MDXLevelInfo queryLevelInformation = null;
    private Map<IMetadata, List<String>> levelPropertiesLoadedWithMembers = null;
    private Map<IMetadata, List<String>> projectedLevelProperties = null;
    private Map<HashSet<IMember>[], List<TupleValue>> selectionsToResults = new HashMap<HashSet<IMember>[], List<TupleValue>>();
    private Map<IMetadata, IMetadata> wrappedToDMRMetadataMap;
    private Map<IMetadata, IMetadata> wrappedToDMRMetadataMapReverseLookup;
    private Lock wrappedToDMRMetadataReadLock;
    private Lock wrappedToDMRMetadataWriteLock;
    private boolean locked = false;
    private boolean isQueryListReport = false;
    private String dataSourceType;
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    private AdaptiveCubeletStorageManager localCubelet = null;
    protected CubeContext cubeContext = null;
    private boolean isReusableCube = false;
    private final MultiRequestReference<DMRQueryOptimizationInfo> optimizationInfo = new MultiRequestReference();
    public static final int DEFAULT_LEVELS_THRESHOLD = 3;
    public static final int DEFAULT_RESTRICTION_MEMBERS_COUNT_THRESHOLD = 1000;
    private int levelCountThreshold;
    private int restrictionMembersCountThreshold;
    private static final int LENGTH = 3;
    private IncrementalMemberLoading incrementalMemberLoading = IncrementalMemberLoading.NONE;
    private boolean resultSetCacheEnabled = false;
    private boolean blockingSameCellsFetching = false;
    private boolean blockingSameMDXExecution = false;
    private boolean bExecuteForValidate = false;
    private int nPreLoadCellCountThreshold = 0;
    private DMRQueryStrategyPreCellLoading.LoadType loadTypeAfterPreLoading = DMRQueryStrategyPreCellLoading.LoadType.OVERLOAD;
    private List<PreciseCubeLoadInfo> preciseFactDrivenLoadInfo = null;
    private boolean bPreciseLoaded = false;
    private int maxMembersInSubQueryDetailFilter = 2000;
    private boolean bDecomposeCalculatedMeasure = false;

    protected DMRCube(String theName, String theCatalogName, String theModelName, MetadataConnection theConnection, ICube theModelCube, CubeContext cContext) throws ProviderException {
        super(theName, theCatalogName, System.currentTimeMillis());
        this.setConnection(theConnection);
        this.modelName = theModelName;
        this.modelCube = theModelCube;
        this.cubeContext = cContext;
        this.wrappedToDMRMetadataMap = new HashMap<IMetadata, IMetadata>();
        this.wrappedToDMRMetadataMapReverseLookup = new HashMap<IMetadata, IMetadata>();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.wrappedToDMRMetadataReadLock = lock.readLock();
        this.wrappedToDMRMetadataWriteLock = lock.writeLock();
        this.initialiseDimensions();
        this.initialiseDetailFilter();
    }

    public DMRCube(ICatalog theCatalog, ICube theModelCube, CubeContext cContext) throws ProviderException {
        this(theModelCube.getName(), theCatalog.getName(), theCatalog.getName(), theModelCube.getConnection(), theModelCube, cContext);
    }

    protected DMRCube(String theName, String theCatalogName, String theModelName, MetadataConnection theConnection, DimensionCacheManager cContext, ICube theModelCube, ExecutionEnvironment exeEnvironment) throws ProviderException {
        super(theName, theCatalogName, System.currentTimeMillis());
        this.setConnection(theConnection);
        this.modelName = theModelName;
        this.modelCube = theModelCube;
        this.cubeContext = null;
        this.wrappedToDMRMetadataMap = new HashMap<IMetadata, IMetadata>();
        this.wrappedToDMRMetadataMapReverseLookup = new HashMap<IMetadata, IMetadata>();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.wrappedToDMRMetadataReadLock = lock.readLock();
        this.wrappedToDMRMetadataWriteLock = lock.writeLock();
        this.initialiseDimensions(cContext, exeEnvironment);
        this.initialiseDetailFilter();
    }

    public DMRCube(ICatalog theCatalog, DimensionCacheManager cContext, ICube theModelCube, ExecutionEnvironment exeEnvironment) throws ProviderException {
        this(theModelCube.getName(), theCatalog.getName(), theCatalog.getName(), theModelCube.getConnection(), cContext, theModelCube, exeEnvironment);
    }

    @Override
    public void lock() {
        if (!this.locked) {
            this.selectionsToResults = new HashMap<HashSet<IMember>[], List<TupleValue>>();
            this.locked = true;
        }
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    public Map<HashSet<IMember>[], List<TupleValue>> getSelectionsToResults() {
        return this.selectionsToResults;
    }

    protected void initialiseDimensions() {
        this.initialiseDimensions(null, null);
    }

    protected void initialiseDimensions(DimensionCacheManager dimCache, ExecutionEnvironment exeEnvironment) {
        if (this.modelCube != null) {
            List<IDimension> otherDims = this.modelCube.getDimensions();
            for (int i = 0; i < otherDims.size(); ++i) {
                IDimension dim = otherDims.get(i);
                DMRDimension d = null;
                if (dimCache != null) {
                    d = dimCache.getDimension(this, dim, exeEnvironment);
                }
                if (d == null) {
                    d = new DMRDimension(dim.getName(), this, dim);
                }
                this.addDMRMetadataObject(dim, d);
            }
        }
    }

    protected void initialiseDetailFilter() {
        if (!(this.modelCube instanceof CubeWrapper)) {
            return;
        }
        for (CogMDXDetailFilter filter : ((CubeWrapper)this.modelCube).getDetailFilters()) {
            this.detailFilters.add(filter);
        }
    }

    @Override
    public long getCacheUpdateInterval() {
        long result = -1L;
        String cacheOn = "true";
        if (cacheOn != null && cacheOn.equals("false")) {
            result = 0L;
        }
        return result;
    }

    protected TupleStorage createTupleStorage() throws ProviderException {
        return null;
    }

    @Override
    protected IBlockTupleStorage createBlockTupleStorage() throws ProviderException {
        return null;
    }

    @Override
    public void addMeasuresDimension() throws ProviderException {
    }

    @Override
    public IMember getMeasure(String measureName) throws MetadataException {
        IMember[] measures;
        for (IMember m : measures = this.getMeasures()) {
            if (!m.getName().equals(measureName)) continue;
            return m;
        }
        return null;
    }

    @Override
    public int getMemberIndex(IMember member) {
        return ((IMemberCubics)member).getIndex();
    }

    @Override
    public List<IVariable> getVariables() {
        return null;
    }

    public void setMDXQueryInfo(MDXLevelInfo levelInfo) {
        this.queryLevelInformation = levelInfo;
    }

    public void setLevelPropertiesLoadedWithMembers(Map<IMetadata, List<String>> levelProperties) {
        this.levelPropertiesLoadedWithMembers = levelProperties;
    }

    public List<String> getLevelPropertiesLoadedWithMembers(IMetadata dmrLevel) {
        if (this.levelPropertiesLoadedWithMembers == null || !this.levelPropertiesLoadedWithMembers.containsKey(dmrLevel)) {
            return null;
        }
        return this.levelPropertiesLoadedWithMembers.get(dmrLevel);
    }

    public void removeLevelPropertiesLoadedWithMembers(IMetadata dmrLevel) {
        if (this.levelPropertiesLoadedWithMembers != null && this.levelPropertiesLoadedWithMembers.containsKey(dmrLevel)) {
            this.levelPropertiesLoadedWithMembers.remove(dmrLevel);
            if (this.levelPropertiesLoadedWithMembers.isEmpty()) {
                this.levelPropertiesLoadedWithMembers = null;
            }
        }
    }

    public void setMeasureInfo(List<IMeasure> measures) {
        this.referencedMeasures = measures;
    }

    public List<DMRMeasure> getMeasureInfo() {
        ArrayList<DMRMeasure> dmrMeasures = new ArrayList<DMRMeasure>();
        List<IMeasure> measuresInfo = this.referencedMeasures;
        for (IMeasure measure : measuresInfo) {
            DMRMeasure dmrMeasure = (DMRMeasure)this.getMeasuresHierarchy().getMember(measure.getName());
            dmrMeasures.add(dmrMeasure);
        }
        return dmrMeasures;
    }

    public void setAggregationLevelInfo(Map<IXQEQueryNode, MDXLevelInfo> mapLevelInfo) {
        this.aggregationLevelInfo = mapLevelInfo;
    }

    public Map<IXQEQueryNode, MDXLevelInfo> getAggregationLevelInfo() {
        if (this.aggregationLevelInfo != null) {
            return this.aggregationLevelInfo;
        }
        return Collections.emptyMap();
    }

    public DMRQueryOptimizationInfo getOptimizationInfo() {
        return this.optimizationInfo.get();
    }

    public void setOptimizationInfo(DMRQueryOptimizationInfo info) {
        this.optimizationInfo.set(info);
    }

    public DMRLevel getLowestProjectedLevel(DMRLevel dmrLevel) {
        int requestedLevelIdx;
        DMRLevel queryDmrLevel;
        IHierarchy hierarchy = dmrLevel.getHierarchy();
        ILevel lowestLevel = null;
        if (this.queryLevelInformation != null) {
            for (IHierarchy infoHierarchy : this.queryLevelInformation.getHierarchyInfo().getProjectedHierarchies()) {
                if (infoHierarchy.getUniqueName().compareTo(hierarchy.getUniqueName()) != 0) continue;
                lowestLevel = this.queryLevelInformation.getLowestProjectedLevelsSkipCalculation(infoHierarchy);
                break;
            }
        }
        if (lowestLevel == null) {
            return null;
        }
        if (lowestLevel instanceof MDXLevelInfo.LevelInfo) {
            lowestLevel = ((MDXLevelInfo.LevelInfo)lowestLevel).getLevel();
        }
        if ((queryDmrLevel = (DMRLevel)this.getWrapper(lowestLevel)) == null) {
            return null;
        }
        int queryLowestLevelIdx = hierarchy.getLevelIndex(queryDmrLevel);
        if (queryLowestLevelIdx < (requestedLevelIdx = hierarchy.getLevelIndex(dmrLevel))) {
            return null;
        }
        return queryDmrLevel;
    }

    public ILevel getNthLevelFromGivenHierarchy(IHierarchy hierarchy, int levelNumber, int levelThreshold, ILevel lowestProjLevel) {
        int levelCnt = levelThreshold - 1;
        int maxProjectedLevel = 0;
        List<ILevel> levels = hierarchy.getLevels();
        if (levels.isEmpty()) {
            return null;
        }
        if (lowestProjLevel == null) {
            return null;
        }
        maxProjectedLevel = lowestProjLevel.getIndex();
        if (levels.size() - 1 >= levelNumber + levelCnt) {
            if (levelNumber + levelCnt >= maxProjectedLevel) {
                return levels.get(maxProjectedLevel);
            }
            return levels.get(levelNumber + levelCnt);
        }
        return levels.get(maxProjectedLevel);
    }

    public DMRLevel getNLevelsFromHierarchy(DMRLevel dmrLevel, int levelThreshold) {
        int requestedLevelIdx;
        DMRLevel queryDmrLevel;
        IHierarchy hierarchy = dmrLevel.getHierarchy();
        ILevel lowestLevel = null;
        if (this.queryLevelInformation != null) {
            for (IHierarchy infoHierarchy : this.queryLevelInformation.getHierarchyInfo().getProjectedHierarchies()) {
                if (infoHierarchy.getUniqueName().compareTo(hierarchy.getUniqueName()) != 0) continue;
                int levelNumber = infoHierarchy.getLevel(dmrLevel.getUniqueName()).getIndex();
                ILevel lowestProjLevel = this.queryLevelInformation.getLowestProjectedLevelsSkipCalculation(infoHierarchy);
                lowestLevel = this.getNthLevelFromGivenHierarchy(infoHierarchy, levelNumber, levelThreshold, lowestProjLevel);
                break;
            }
        }
        if (lowestLevel == null) {
            return null;
        }
        if (lowestLevel instanceof MDXLevelInfo.LevelInfo) {
            lowestLevel = ((MDXLevelInfo.LevelInfo)lowestLevel).getLevel();
        }
        if ((queryDmrLevel = (DMRLevel)this.getWrapper(lowestLevel)) == null) {
            return null;
        }
        int queryLowestLevelIdx = hierarchy.getLevelIndex(queryDmrLevel);
        if (queryLowestLevelIdx < (requestedLevelIdx = hierarchy.getLevelIndex(dmrLevel))) {
            return null;
        }
        return queryDmrLevel;
    }

    public DMRLevel getLowestProjectedLevel(IHierarchy hierarchy) {
        ILevel lowestLevel = null;
        for (IHierarchy infoHierarchy : this.queryLevelInformation.getHierarchyInfo().getProjectedHierarchies()) {
            if (infoHierarchy.getUniqueName().compareTo(hierarchy.getUniqueName()) != 0) continue;
            lowestLevel = this.queryLevelInformation.getLowestProjectedLevelsSkipCalculation(infoHierarchy);
            if (lowestLevel instanceof MDXLevelInfo.LevelInfo) {
                lowestLevel = ((MDXLevelInfo.LevelInfo)lowestLevel).getLevel();
            }
            return (DMRLevel)this.getWrapper(lowestLevel);
        }
        return null;
    }

    public List<CogMDXDetailFilter> getDetailFilters() {
        return this.detailFilters;
    }

    public void addDetailFilter(CogMDXDetailFilter theDetailFilter) {
        this.detailFilters.add(theDetailFilter);
    }

    protected void addDMRMetadataObject(IMetadata wrapped, IMetadata dmrMetadata) {
        this.wrappedToDMRMetadataWriteLock.lock();
        try {
            this.wrappedToDMRMetadataMap.put(wrapped, dmrMetadata);
            this.wrappedToDMRMetadataMapReverseLookup.put(dmrMetadata, wrapped);
        }
        finally {
            this.wrappedToDMRMetadataWriteLock.unlock();
        }
    }

    public IMetadata getWrapper(IMetadata wrapped) {
        IMetadata wrapper = null;
        this.wrappedToDMRMetadataReadLock.lock();
        try {
            wrapper = this.wrappedToDMRMetadataMap.get(wrapped);
        }
        finally {
            this.wrappedToDMRMetadataReadLock.unlock();
        }
        if (wrapper != null) {
            return wrapper;
        }
        MetadataType type = wrapped.getObjectType();
        switch (type) {
            case HIERARCHY: {
                IHierarchy hierarchy = (IHierarchy)wrapped;
                DMRDimension dmrDim = (DMRDimension)this.getWrapper(hierarchy.getDimension());
                if (dmrDim == null) {
                    return null;
                }
                for (IHierarchy dmrHier : dmrDim.getHierarchies()) {
                    if (!dmrHier.getUniqueName().equals(hierarchy.getUniqueName())) continue;
                    this.addDMRMetadataObject(wrapped, dmrHier);
                    return dmrHier;
                }
                break;
            }
            case LEVEL: {
                ILevel level = (ILevel)wrapped;
                DMRDimension dmrDimension = (DMRDimension)this.getWrapper(level.getDimension());
                if (dmrDimension == null) {
                    return null;
                }
                for (ILevel dmrLevel : dmrDimension.getLevels()) {
                    if (!dmrLevel.getUniqueName().equals(level.getUniqueName())) continue;
                    this.addDMRMetadataObject(wrapped, dmrLevel);
                    return dmrLevel;
                }
                break;
            }
            case MEMBER: {
                if (!(wrapped instanceof IMeasure)) break;
                IMeasure meausre = (IMeasure)wrapped;
                DMRLevel dmrMeasureLevel = (DMRLevel)this.getWrapper(meausre.getLevel());
                if (dmrMeasureLevel == null) {
                    return null;
                }
                for (IMetadata dmrChild : dmrMeasureLevel.getChildMetadataObjects()) {
                    if (!(dmrChild instanceof IMeasure) || !dmrChild.getUniqueName().equals(wrapped.getUniqueName())) continue;
                    this.addDMRMetadataObject(wrapped, dmrChild);
                    return dmrChild;
                }
                break;
            }
        }
        return null;
    }

    public IMetadata getWrapper(String wrapperName) {
        try {
            String[] parts = UniqueNameParser.parse(wrapperName);
            if (parts.length != 3) {
                return null;
            }
            IDimension dimension = this.getDimension(parts[0]);
            IHierarchy hierarchy = dimension.getHierarchy(parts[1]);
            IMetadata level = null;
            if (dimension.isMeasuresDimension()) {
                level = hierarchy.getLevels().get(0);
                return ((DMRLevel)level).getMember(parts[2]);
            }
            level = hierarchy.getLevel(parts[2]);
            return level;
        }
        catch (UniqueNameParserException uniqueNameParserException) {
            return null;
        }
    }

    public IHierarchy getDMRHierarchy(String hierUName) {
        try {
            String[] parts = UniqueNameParser.parse(hierUName);
            if (parts.length != 2) {
                return null;
            }
            IDimension dimension = this.getDimension(parts[0]);
            return dimension.getHierarchy(parts[1]);
        }
        catch (UniqueNameParserException uniqueNameParserException) {
            return null;
        }
    }

    public IMetadata getWrapped(IMetadata dmrMetadata) {
        if (dmrMetadata.getObjectType() == MetadataType.CUBE) {
            return this.modelCube;
        }
        this.wrappedToDMRMetadataReadLock.lock();
        try {
            IMetadata iMetadata = this.wrappedToDMRMetadataMapReverseLookup.get(dmrMetadata);
            return iMetadata;
        }
        finally {
            this.wrappedToDMRMetadataReadLock.unlock();
        }
    }

    public void setQueryListReport(boolean isListReport) {
        this.isQueryListReport = isListReport;
    }

    public boolean isQueryListReport() {
        return this.isQueryListReport;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getDatasourceType() {
        return this.dataSourceType;
    }

    public void setDatasourceType(String dsType) {
        this.dataSourceType = dsType;
    }

    @Override
    public void addDimension(IDimension dim) {
        this.dimensions.put(dim);
    }

    @Override
    public void close() throws CacheException {
        if (this.isClosed.compareAndSet(false, true)) {
            ICacheEngine cacheEngine = this.getMetadataStorage();
            if (cacheEngine != null) {
                cacheEngine.clear();
            }
            File f = new File(this.getCubePath());
            f.delete();
        }
    }

    public CubeWrapper getModelCube() {
        return (CubeWrapper)this.getWrapped(this);
    }

    @Override
    public boolean isDMR() {
        return true;
    }

    private synchronized void initCubeRestrictions() {
        if (this.cubeRestrictions == null) {
            MetadataRestriction restrictions = new MetadataRestriction();
            restrictions.add(RestrictionType.CUBE_OBJECT, this);
            this.cubeRestrictions = restrictions;
        }
    }

    protected IRestrictions getCubeRestrictions() {
        if (this.cubeRestrictions == null) {
            this.initCubeRestrictions();
        }
        return this.cubeRestrictions;
    }

    public boolean memberStorageEnabled() {
        return false;
    }

    @Override
    public void release() {
        try {
            this.close();
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    @Override
    public boolean isSessionScope() {
        return false;
    }

    public AdaptiveCubeletStorageManager getLocalCubelet() {
        if (this.localCubelet == null) {
            this.localCubelet = new AdaptiveCubeletStorageManager(this);
        }
        return this.localCubelet;
    }

    public AdaptiveCubeletStorageManager getGlobalCubelet() {
        if (this.getCubeContext() == null) {
            return null;
        }
        return this.getCubeContext().getCubeletStorageManager();
    }

    public AdaptiveCubeletStorageManager getCubeletStorage() {
        if (this.isReusableCube) {
            AdaptiveCubeletStorageManager globalCubelet = this.getGlobalCubelet();
            if (globalCubelet == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Can't locate global cubelet storage for reused DMRCube.");
            }
            CubeReuseLogger.getLogger().getCubeContextLogger().log("getCubeletStorage returns global cubelet storage because the DMRCube is set to be reused.");
            return globalCubelet;
        }
        CubeReuseLogger.getLogger().getCubeContextLogger().log("getCubeletStorage returns local cubelet storage because the DMRCube is set not to be reused.");
        return this.getLocalCubelet();
    }

    public CubeContext getCubeContext() {
        return this.cubeContext;
    }

    public boolean isReusedCube() {
        return this.isReusableCube;
    }

    public void setReusableCube(boolean bValue) {
        this.isReusableCube = bValue;
    }

    public IncrementalMemberLoading getIncrementalMemberLoading() {
        return this.incrementalMemberLoading;
    }

    public void setIncrementalMemberLoading(IncrementalMemberLoading value) {
        this.incrementalMemberLoading = value;
    }

    public boolean isResultSetCacheEnabled() {
        return this.resultSetCacheEnabled;
    }

    public void setResultSetCacheEnabled(boolean value) {
        this.resultSetCacheEnabled = value;
    }

    public int getDefaultCubeLevelThreshold() {
        return 3;
    }

    public int getDefaultRestrictionMembersCountThreshold() {
        return 1000;
    }

    public void setLevelCountThreshold(int levelCount) {
        this.levelCountThreshold = levelCount;
    }

    public int getLevelCountThreshold() {
        return this.levelCountThreshold;
    }

    public void setRestrictionMembersCountThreshold(int memberCountPerLevel) {
        this.restrictionMembersCountThreshold = memberCountPerLevel;
    }

    public int getRestrictionMembersCountThreshold() {
        return this.restrictionMembersCountThreshold;
    }

    public DMRLevel getNextNLevelMembers(DMRLevel currentLevel, DMRLevel childLevel) {
        Map.Entry<ILevel, List<BaseMember>> restriction = this.getRestrictionMembersForHierarchy(childLevel.getHierarchy());
        if (restriction != null && restriction.getKey().getIndex() >= childLevel.getIndex()) {
            return (DMRLevel)this.getWrapper(restriction.getKey());
        }
        int levelThreshold = this.getLevelCountThreshold();
        if (levelThreshold > 0) {
            DMRLevel loadLevel = this.getNLevelsFromHierarchy(childLevel, levelThreshold);
            return loadLevel;
        }
        return null;
    }

    public Map.Entry<ILevel, List<BaseMember>> getRestrictionMembersForHierarchy(IHierarchy hierarchy) {
        Map<ILevel, List<BaseMember>> restrictions = this.getOptimizationInfo().getLevelRestrictions();
        for (Map.Entry<ILevel, List<BaseMember>> entry : restrictions.entrySet()) {
            if (!entry.getKey().getHierarchy().equals(hierarchy)) continue;
            return entry;
        }
        return null;
    }

    public List<BaseMember> getProjectedMembers() {
        return this.getOptimizationInfo().getProjectedMembers();
    }

    public void loadFromTabularStream(XMdxLocal xmdxlocal) {
        if (LoadDMRCubeSingleV5Query.checkLoadCubeFromSingleV5Query(this)) {
            if (this.preciseFactDrivenLoadInfo != null && !this.preciseFactDrivenLoadInfo.isEmpty()) {
                ArrayList<LoadDMRCubeV5Query> allQueries = new ArrayList<LoadDMRCubeV5Query>();
                ArrayList<DMRLevel> allLevels = new ArrayList<DMRLevel>();
                int sz = this.preciseFactDrivenLoadInfo.size();
                boolean bNeedSort = true;
                if (sz > 1) {
                    bNeedSort = false;
                }
                for (int i = 0; i < sz; ++i) {
                    LoadDMRCubeV5Query loader = new LoadDMRCubeV5Query(this, this.preciseFactDrivenLoadInfo.get(i), bNeedSort);
                    loader.loadCube();
                    loader.updateAllLevels(allLevels);
                    if (i == sz - 1) {
                        if (!bNeedSort) {
                            loader.sortAllLevelMembers(allLevels, null);
                        } else {
                            this.setLevelsGotAllMembers(allLevels);
                        }
                    }
                    allQueries.add(loader);
                }
                if (sz > 1) {
                    for (LoadDMRCubeV5Query aQuery : allQueries) {
                        aQuery.fillMissingCellsWithNULLs();
                    }
                }
                this.bPreciseLoaded = true;
            } else {
                LoadDMRCubeSingleV5Query loader = new LoadDMRCubeSingleV5Query(this);
                loader.loadCube();
            }
        }
    }

    protected void setLevelsGotAllMembers(ArrayList<DMRLevel> allLevels) {
        for (int i = 0; i < allLevels.size(); ++i) {
            if (allLevels.get(i) == null) continue;
            DMRLevel aLevel = allLevels.get(i);
            List<DMRLevel> levels = aLevel.getParentLevelToQueryWith();
            Collections.reverse(levels);
            for (ILevel iLevel : levels) {
                ((DMRLevel)iLevel).setGotAllMembers();
            }
        }
    }

    public List<String> getProjectedLevelProperties(IMetadata dmrLevel) {
        if (this.projectedLevelProperties == null || !this.projectedLevelProperties.containsKey(dmrLevel)) {
            return null;
        }
        return this.projectedLevelProperties.get(dmrLevel);
    }

    public void setProjectedLevelProperties(Map<IMetadata, List<String>> levelProperties) {
        this.projectedLevelProperties = levelProperties;
    }

    public ICubeResultSetCache getResultSetCache() {
        return null;
    }

    public void setBlockingFetchingSameCells(boolean blockingFetching) {
        this.blockingSameCellsFetching = blockingFetching;
    }

    public boolean getBlockingFetchingSameCells() {
        return this.blockingSameCellsFetching;
    }

    public boolean getBlockingSameMDXExecution() {
        return this.blockingSameMDXExecution;
    }

    public void setBlockingSameMDXExecution(boolean blockingMDXExecution) {
        this.blockingSameMDXExecution = blockingMDXExecution;
    }

    public void setIncrementalMemberLoadingFromSetting(IDataSource dataSource) {
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        String incrementalMemberLoadingSetting = capabilities.getStringValue("enableIncrementalMemberLoading", "");
        if (incrementalMemberLoadingSetting.isEmpty() || "false".equalsIgnoreCase(incrementalMemberLoadingSetting)) {
            this.incrementalMemberLoading = IncrementalMemberLoading.NONE;
        } else if ("merge".equalsIgnoreCase(incrementalMemberLoadingSetting)) {
            this.incrementalMemberLoading = !this.isReusableCube ? IncrementalMemberLoading.SQL_SORT : IncrementalMemberLoading.TREE_MERGE;
        } else if ("true".equalsIgnoreCase(incrementalMemberLoadingSetting)) {
            this.incrementalMemberLoading = IncrementalMemberLoading.SQL_SORT;
        }
    }

    public void setExecuteForValidate(boolean b) {
        this.bExecuteForValidate = b;
    }

    public boolean getExecuteForValidate() {
        return this.bExecuteForValidate;
    }

    public void setPreLoadCellCountThreshold(int preLoadCellThreshold) {
        this.nPreLoadCellCountThreshold = preLoadCellThreshold;
    }

    public int getPreLoadCellCountThreshold() {
        return this.nPreLoadCellCountThreshold;
    }

    public void setLoadingTypeAfterPreLoading(DMRQueryStrategyPreCellLoading.LoadType ltp) {
        this.loadTypeAfterPreLoading = ltp;
    }

    public DMRQueryStrategyPreCellLoading.LoadType getLoadingTypeAfterPreLoading() {
        return this.loadTypeAfterPreLoading;
    }

    @Override
    public ICube.CubeTypeEnum getType() {
        return ICube.CubeTypeEnum.DMR;
    }

    public void setPreciseLoadInfo(List<PreciseCubeLoadInfo> preciseLoadInfo) {
        this.preciseFactDrivenLoadInfo = preciseLoadInfo;
    }

    public boolean cellPreciselyLoaded() {
        return this.bPreciseLoaded;
    }

    public boolean dimensionHasEmbeddedFilter(IDimension dim) {
        if (dim.isMeasuresDimension()) {
            return false;
        }
        for (CogMDXDetailFilter astDetailFilter : this.getDetailFilters()) {
            IMetadata filterOwner;
            IDimension dimension = astDetailFilter.getDimensionFromModel();
            if (dimension == null || dimension.isMeasuresDimension() || (filterOwner = astDetailFilter.getFilterOwner()) != null && dimension != filterOwner || !dimension.getV5UniqueName().equals(dim.getV5UniqueName())) continue;
            return true;
        }
        return false;
    }

    public int getMaxMembersInSubQueryDetailFilter() {
        return this.maxMembersInSubQueryDetailFilter;
    }

    public void setMaxMembersInSubQueryDetailFilter(int maxMembers) {
        this.maxMembersInSubQueryDetailFilter = maxMembers;
    }

    public boolean getDecomposeCalculatedMeasure() {
        return this.bDecomposeCalculatedMeasure;
    }

    public void setDecomposeCalculatedMeasure(boolean b) {
        this.bDecomposeCalculatedMeasure = b;
    }

    @Override
    public String getCubeCurrentPeriod() {
        return null;
    }

    public static enum IncrementalMemberLoading {
        NONE,
        SQL_SORT,
        TREE_MERGE;

    }
}

