/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.wrapper.AbstractDimensionWrapper;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRHierarchy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.DimensionContext;
import com.cognos.xqe.util.OrderedMap;
import java.util.Collections;
import java.util.List;

public class DMRDimension
extends Dimension
implements IAccessedViaShortcut {
    protected IDimension fmDimension;
    protected DimensionContext storage = null;

    public DMRDimension(String s, Cube cube, IDimension dim) {
        super(s, cube);
        this.fmDimension = dim;
        this.setType(dim.getType());
        this.setConnection(cube.getConnection());
        this.initialiseHierarchies();
    }

    protected void initialiseHierarchies() {
        if (this.getWrappedDimension().isMeasuresDimension()) {
            new DMRHierarchy("Measures", (Dimension)this, null);
        } else {
            int hierarchyCount = this.getWrappedDimension().getHierarchyCount();
            for (int i = 0; i < hierarchyCount; ++i) {
                IHierarchy fmHierarchy = this.getWrappedDimension().getHierarchy(i);
                new DMRHierarchy(fmHierarchy.getName(), (Dimension)this, fmHierarchy);
            }
        }
    }

    public boolean isMeasureDimension() {
        return this.getType() == DimensionTypeEnum.MEASURE;
    }

    protected OrderedMap<IMember> fetchMeasures() throws MetadataException, ProviderException {
        OrderedMap<IMember> result = new OrderedMap<IMember>();
        if (this.isMeasureDimension()) {
            DMRLevel level = (DMRLevel)this.getLevel(0);
            List<IMetadata> childObjects = this.getWrappedDimension().getChildMetadataObjects();
            for (int i = 0; i < childObjects.size(); ++i) {
                IMetadata maybeMeasure = childObjects.get(i);
                if (!(maybeMeasure instanceof IMeasure)) continue;
                IMeasure measure = (IMeasure)maybeMeasure;
                String name = measure.getName();
                DMRMeasure dmrMeasure = new DMRMeasure(name, level, measure);
                ((DMRCube)this.getCube()).addDMRMetadataObject(measure, dmrMeasure);
                result.put(dmrMeasure);
            }
        }
        return result;
    }

    @Override
    public boolean isShell() {
        return false;
    }

    public boolean isDefiningMFWDimension(String dimUniqueName) {
        if (this.getWrappedDimension() instanceof AbstractDimensionWrapper) {
            AbstractDimensionWrapper dim = (AbstractDimensionWrapper)this.getWrappedDimension();
            return dim.isDefiningMFWDimension(dimUniqueName);
        }
        return false;
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            this.v5UniqueName = this.getWrappedDimension().getV5UniqueName();
        }
        return this.v5UniqueName;
    }

    @Override
    public boolean isDMR() {
        return true;
    }

    @Override
    public boolean isShareable() {
        return false;
    }

    public IDimension getWrappedDimension() {
        return this.fmDimension;
    }

    @Override
    public List<IEmbeddedFilter> getFilters() {
        if (this.fmDimension == null) {
            return Collections.emptyList();
        }
        return this.fmDimension.getFilters();
    }

    @Override
    public IShortcut getShortcut() {
        if (!(this.fmDimension instanceof IAccessedViaShortcut)) {
            return null;
        }
        return ((IAccessedViaShortcut)((Object)this.fmDimension)).getShortcut();
    }

    @Override
    public boolean isAccessedViaShortcut() {
        if (!(this.fmDimension instanceof IAccessedViaShortcut)) {
            return false;
        }
        return ((IAccessedViaShortcut)((Object)this.fmDimension)).isAccessedViaShortcut();
    }

    @Override
    public void setShortcut(IShortcut scObj) {
        if (!(this.fmDimension instanceof IAccessedViaShortcut)) {
            return;
        }
        ((IAccessedViaShortcut)((Object)this.fmDimension)).setShortcut(scObj);
    }

    @Override
    public double getOrderOfMagnitude() {
        return this.fmDimension.getOrderOfMagnitude();
    }

    public DimensionContext getStorage() {
        return this.storage;
    }

    public void setStorage(DimensionContext s) {
        this.storage = s;
    }
}

