/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.data.values.MemberRSAPIValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.virtual.VirtualMember;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCompoundKeyMapping;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRProvider;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategyPreCellLoading;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryGroup;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateCombination;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Combination;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.CrossJoinedSetDecomposer;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ExternalAggregateStrategyException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.CrossJoinTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SingleHierarchySimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.DMRPushdownAdapter;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.MultiValueMap;

public class DMRExternalAggregateStrategy
extends DMRQueryStrategy
implements IExternalAggregateStrategy {
    private static final String DMR_EXTERNAL_AGGREGATE_STRATEGY_FAILURE = "DMRExternalAggregateStrategy failure";
    private static final int NUM_OF_QUERIES_TO_EXECUTE_AT_A_TIME = 100;
    private final DMRCube cube;
    private HashSet<ILevel> aggregateLevels = new HashSet();

    public DMRExternalAggregateStrategy(ICube c) {
        this.cube = (DMRCube)c;
    }

    @Override
    public ICube getCube() {
        return this.cube;
    }

    private com.cognos.xqe.runtree.olap.mdx.interpreter.Set adjustAggregateSetScope(com.cognos.xqe.runtree.olap.mdx.interpreter.Set aggregateSet, InterpreterContext interpreterContext) {
        IHierarchy measuresHier = interpreterContext.getCube().getMeasuresHierarchy();
        IMember[] measures = aggregateSet.getMembers(measuresHier);
        if (measures.length == 0) {
            measures = interpreterContext.getContextSet().getMembers(measuresHier);
        }
        if (measures.length > 1) {
            return aggregateSet;
        }
        IMeasure theMeasure = (IMeasure)measures[0];
        IHierarchy[] hierarchies = aggregateSet.getHierarchies();
        ArrayList<ITupleList> childTupleList = new ArrayList<ITupleList>();
        for (int h = 0; h < hierarchies.length; ++h) {
            IHierarchy hier = hierarchies[h];
            IMember[] members = aggregateSet.getMembers(hier);
            if (hier.getDimension().isMeasuresDimension()) {
                childTupleList.add(SingleHierarchySimpleTupleList.construct(members));
                continue;
            }
            for (int i = 0; i < members.length; ++i) {
                IMember mem = members[i];
                DMRLevel level = (DMRLevel)mem.getLevel();
                DMRLevel scopeLevel = V5QueryOverTabularStream.getLowestLevelFromScope(theMeasure, level);
                if (scopeLevel == null) {
                    scopeLevel = (DMRLevel)level.getDimension().getLevel(0);
                }
                IMember scopeMember = mem;
                while (scopeMember.getLevel().getIndex() > scopeLevel.getIndex()) {
                    scopeMember = scopeMember.getParent();
                }
                members[i] = scopeMember;
            }
            childTupleList.add(SingleHierarchySimpleTupleList.construct(members));
        }
        return new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(CrossJoinTupleList.construct(childTupleList));
    }

    private com.cognos.xqe.runtree.olap.mdx.interpreter.Set collapseToAggregateMembers(com.cognos.xqe.runtree.olap.mdx.interpreter.Set aggregateSet) throws ExternalAggregateStrategyException {
        if (this.aggregateLevels.isEmpty()) {
            return aggregateSet;
        }
        ArrayList<ITuple> resultTuples = new ArrayList<ITuple>();
        HashSet<IDimension> aggregateDimensions = new HashSet<IDimension>();
        for (ILevel l : this.aggregateLevels) {
            aggregateDimensions.add(l.getDimension());
        }
        IIterator setIter = aggregateSet.iterator();
        while (setIter.hasNext()) {
            ITuple tuple = (ITuple)setIter.next();
            for (IDimension d : aggregateDimensions) {
                IMember parent;
                int idx = aggregateSet.getDimensionIndex(d);
                IMember m = tuple.getMember(d);
                while (this.aggregateLevels.contains(m.getLevel()) && (parent = m.getParent()) != null) {
                    ((Tuple)tuple).replaceMember(idx, parent);
                    m = parent;
                }
            }
            if (resultTuples.contains(tuple)) continue;
            resultTuples.add(tuple);
        }
        return new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(resultTuples.toArray(new ITuple[resultTuples.size()]));
    }

    private void getAggregateLevels(com.cognos.xqe.runtree.olap.mdx.interpreter.Set aggregateSet) {
        Dimension measuresDim = (Dimension)this.cube.getMeasuresHierarchy().getDimension();
        this.aggregateLevels.addAll(AggregationUtils.getAggregateLevels(aggregateSet));
        HashSet<ILevel> scopeAggregateLevels = new HashSet<ILevel>();
        IMember measure = aggregateSet.getTuple(0L).getMember(measuresDim);
        if (!measure.isCalculatedMember()) {
            for (ILevel level : this.aggregateLevels) {
                DMRLevel scopeLevel = V5QueryOverTabularStream.getLowestLevelFromScope((IMeasure)measure, level);
                IDimension dimension = level.getDimension();
                int index = scopeLevel.getIndex();
                while (index < level.getIndex()) {
                    scopeAggregateLevels.add(dimension.getLevel(index++));
                }
            }
        }
        if (!scopeAggregateLevels.isEmpty()) {
            this.aggregateLevels.addAll(scopeAggregateLevels);
        }
        HashSet<IDimension> aggregateDimensions = new HashSet<IDimension>();
        for (ILevel l : this.aggregateLevels) {
            aggregateDimensions.add(l.getDimension());
        }
        for (IDimension d : aggregateDimensions) {
            HashSet<IMember> members = new HashSet<IMember>(Arrays.asList(aggregateSet.getMembers(d)));
            HashSet<IMember> parents = this.getParents(members);
            while (parents.size() > 1) {
                for (IMember parent : parents) {
                    this.aggregateLevels.add(parent.getLevel());
                }
                parents = this.getParents(parents);
            }
        }
    }

    private HashSet<IMember> getParents(HashSet<IMember> members) {
        HashSet<IMember> parents = new HashSet<IMember>();
        for (IMember member : members) {
            IMember parent = member.getParent();
            if (parent == null) continue;
            parents.add(parent);
        }
        return parents;
    }

    @Override
    public Value[] execute(InterpreterContext interpreterContext, IHierarchy[] aggHiers, com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] aggSets) throws ExternalAggregateStrategyException {
        Value[] aggValues = new Value[aggSets.length];
        try {
            int i;
            for (i = 0; i < aggSets.length; ++i) {
                com.cognos.xqe.runtree.olap.mdx.interpreter.Set collapsedSet = aggSets[i].collapseToRollupMembers();
                if (collapsedSet != null) {
                    aggSets[i] = collapsedSet;
                }
                aggSets[i] = this.collapseToFirstLastMember(aggSets[i], interpreterContext);
            }
            AggregationUtils.executeCalculationSet(interpreterContext, aggSets, aggValues);
            if (((DMRProvider)interpreterContext.getProvider()).isInProcessOfPreCellLoading()) {
                for (i = 0; i < aggValues.length; ++i) {
                    if (aggValues[i] != null) continue;
                    aggValues[i] = DMRQueryStrategyPreCellLoading.ZERO_VALUE;
                }
                return aggValues;
            }
            for (i = 0; i < aggSets.length; ++i) {
                if (aggSets[i] == null) continue;
                this.getAggregateLevels(aggSets[i]);
                aggSets[i] = this.adjustAggregateSetScope(aggSets[i], interpreterContext);
            }
            HashMap<com.cognos.xqe.runtree.olap.mdx.interpreter.Set, List<List<Tuple>>> executionSets = AggregationUtils.getExecutionSets(aggSets, aggHiers);
            if (executionSets != null) {
                for (int i2 = 0; i2 < aggSets.length; ++i2) {
                    if (aggSets[i2] == null) continue;
                    aggSets[i2] = this.collapseToAggregateMembers(aggSets[i2]);
                }
                for (com.cognos.xqe.runtree.olap.mdx.interpreter.Set anAggSet : executionSets.keySet()) {
                    List<List<Tuple>> contextSets = executionSets.get(anAggSet);
                    for (List<Tuple> aContextSet : contextSets) {
                        com.cognos.xqe.runtree.olap.mdx.interpreter.Set contextSet = new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(SimpleTupleList.construct(aContextSet.toArray(new Tuple[0])));
                        this.executeAggregateByContextSet(interpreterContext, anAggSet, contextSet, aggSets, aggValues);
                    }
                }
            } else {
                this.executeBaseSet(aggSets, aggValues);
            }
        }
        catch (InterpreterException ie) {
            throw new ExternalAggregateStrategyException(DMR_EXTERNAL_AGGREGATE_STRATEGY_FAILURE, ie);
        }
        return aggValues;
    }

    private void executeBaseSet(com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] aggSets, Value[] aggValues) throws ExternalAggregateStrategyException {
        try {
            DMRCube dmrCube = (DMRCube)this.getCube();
            List<IHierarchy> hierarchies = dmrCube.getHierarchies();
            MultiValueMap combinationToSetIndex = new MultiValueMap();
            List<List<Object>> combinations = AggregationUtils.getSelectionCombinations(aggSets, this.aggregateLevels, hierarchies, combinationToSetIndex);
            V5QueryGroup groupQuery = this.buildExternalAggregateQuery(combinations);
            for (int i = 0; i < aggSets.length; ++i) {
                if (aggSets[i] == null) continue;
                aggSets[i] = this.collapseToAggregateMembers(aggSets[i]);
            }
            this.executeExternalAggregateQuery(groupQuery, aggSets, aggValues, combinationToSetIndex);
        }
        catch (InterpreterException ie) {
            throw new ExternalAggregateStrategyException(DMR_EXTERNAL_AGGREGATE_STRATEGY_FAILURE, ie);
        }
    }

    private V5QueryGroup buildExternalAggregateQuery(CrossJoinedSet cjs) {
        List<IHierarchy> hiers = this.cube.getHierarchies(false);
        IHierarchy[] cubeHiers = hiers.toArray(new IHierarchy[hiers.size()]);
        IMember[][] selections = cjs.getMembers(cubeHiers);
        ArrayList<List<Object>> combinations = new ArrayList<List<Object>>();
        List<IDimension> dimensions = this.cube.getDimensions();
        CrossJoinedSetDecomposer cb = null;
        cb = new CrossJoinedSetDecomposer(dimensions);
        for (int i = 0; i < dimensions.size(); ++i) {
            IDimension dimension = dimensions.get(i);
            cb.addToSelectionsByDimension(dimension, selections[i], i);
        }
        cb.buildDimIndexToMemberGroups();
        cb.setOneMeasurePerSubquery(true);
        List<Combination> combinationList = cb.getCombinationObjects();
        for (Combination combination : combinationList) {
            combinations.add(combination.getSelectionList());
        }
        V5QueryGroup groupQuery = this.buildExternalAggregateQuery(combinations);
        return groupQuery;
    }

    private V5QueryGroup buildExternalAggregateQuery(List<List<Object>> combinations) {
        V5QueryGroup groupQuery = new V5QueryGroup();
        for (int i = 0; i < combinations.size(); ++i) {
            IMetadata[] projColumns;
            List<Object> combination = combinations.get(i);
            V5QueryOverTabularStream query = this.combinationToV5Query(i + 1, combination);
            if (this.checkTagForCompleteTuple(combination)) {
                query.setIgnoreSlicerWhenFetchingCompleteTuple();
            }
            ArrayList<ILevel> levels = new ArrayList<ILevel>();
            for (int idx = 0; idx < combination.size(); ++idx) {
                IMetadata[] memberOrList = combination.get(idx);
                Object memberList = null;
                IMember mem = null;
                if (memberOrList instanceof List) {
                    memberList = CollectionCast.uncheckedCast((List)memberOrList);
                    mem = (IMember)memberList.get(0);
                } else {
                    mem = (IMember)memberOrList;
                }
                IDimension dim = mem.getDimension();
                if (dim.isMeasuresDimension()) continue;
                ILevel level = mem.getLevel();
                levels.add(level);
            }
            for (IMetadata projColumn : projColumns = query.getProjectedColumns()) {
                if (!(projColumn instanceof ILevel) || !this.aggregateLevels.contains(projColumn)) continue;
                query.removeColumn(projColumn);
                levels.remove(projColumn);
            }
            ArrayList<Map<IMember, List<ILevel>>> listOfMeasuresByLevel = new ArrayList<Map<IMember, List<ILevel>>>();
            for (IMember measure : query.getMeasuresSelections()) {
                Hashtable<IMember, ArrayList<ILevel>> measureEntry = new Hashtable<IMember, ArrayList<ILevel>>();
                measureEntry.put(measure, levels);
                listOfMeasuresByLevel.add(measureEntry);
            }
            query.setMeasuresByLevels(listOfMeasuresByLevel);
            List<IMember> measuresSel = query.getMeasuresSelections();
            query.setMeasuresOffset(query.getProjectedColumns().length - measuresSel.size());
            groupQuery.addQuery(query);
        }
        return groupQuery;
    }

    private boolean checkTagForCompleteTuple(List<Object> combination) {
        for (int idx = 0; idx < combination.size(); ++idx) {
            Object memberOrList = combination.get(idx);
            if (memberOrList instanceof List) {
                List<IMember> memberList = CollectionCast.uncheckedCast((List)memberOrList);
                for (IMember member : memberList) {
                    if (!this.isCompleteTupleTag(member)) continue;
                    return true;
                }
                continue;
            }
            if (!this.isCompleteTupleTag((IMember)memberOrList)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void executeExternalAggregateQuery(V5QueryGroup groupQuery, com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] aggSets, Value[] aggValues, MultiValueMap combinationToSetIndex) {
        queryCount = groupQuery.queryCount();
        beginning = 0;
        end = queryCount - 1;
        if (queryCount > 100) {
            end = 100;
        }
        while (beginning < queryCount) {
            groupQuery.resetV5QueryResult();
            result = groupQuery.execute(beginning, end);
lbl9:
            // 2 sources

            try {
                for (i = beginning; i <= end; ++i) {
                    block10: {
                        query = groupQuery.getQuery(i);
                        queryResult = groupQuery.getResultAsValueArray(query.getName());
                        if (queryResult == null) break block10;
                        results = new ArrayList<TupleValue>();
                        this.populateTupleValues(queryResult, query, results);
                        indexes = CollectionCast.uncheckedCast((List)combinationToSetIndex.get((Object)i));
                        if (results.size() == 1 && indexes.size() == 1) {
                            aggValues[((Integer)indexes.get((int)0)).intValue()] = (Value)((TupleValue)results.get(0)).getCell().getObjectValue();
                            continue;
                        }
                        block5: for (s = 0; s < indexes.size(); ++s) {
                            for (v = 0; v < results.size(); ++v) {
                                if (aggSets[(Integer)indexes.get(s)] == null || aggValues[(Integer)indexes.get(s)] != null || !aggSets[(Integer)indexes.get(s)].getTuple(0L).contains(((TupleValue)results.get(v)).getTuple())) continue;
                                aggValues[((Integer)indexes.get((int)s)).intValue()] = (Value)((TupleValue)results.get(v)).getCell().getObjectValue();
                                continue block5;
                            }
                        }
                        ** GOTO lbl9
                    }
                    XQELog.logConsole("No external aggregate result for query " + query.getName());
                }
            }
            finally {
                result.release();
            }
            beginning = end + 1;
            if (end >= queryCount - 1 || (end += 100) < queryCount) continue;
            end = queryCount - 1;
        }
    }

    private V5QueryOverTabularStream combinationToV5Query(int index, List<Object> selections) {
        ILevel level;
        IDimension dim;
        IMember mem;
        List memberList;
        Object memberOrList;
        int i;
        List<IDimension> dimensions = this.getCube().getDimensions();
        IMember[] outputTuple = new IMember[dimensions.size()];
        Map<IDimension, Integer> dimToIndexMap = this.getDimToIndexMap();
        List<IMember> measuresSelections = null;
        int measuresIndex = -1;
        DMRCube dmrCube = (DMRCube)this.getCube();
        StringBuilder sb = new StringBuilder(DMRUtilities.SubqueryType.FETCH_CELL_VALUES.toString());
        sb.append(index);
        String queryName = sb.toString();
        V5QueryOverTabularStream result = new V5QueryOverTabularStream(dmrCube, DMRUtilities.SubqueryType.FETCH_CELL_VALUES, String.valueOf(index), queryName);
        result.setV5QueryToLoadmembers(false);
        result.setV5QueryForDMRExternalAggregate(true);
        HashMap<IDimension, ILevel> levelInfo = new HashMap<IDimension, ILevel>();
        for (i = 0; i < selections.size(); ++i) {
            memberOrList = selections.get(i);
            memberList = null;
            mem = null;
            if (memberOrList instanceof List) {
                memberList = CollectionCast.uncheckedCast((List)memberOrList);
                mem = (IMember)memberList.get(0);
            } else {
                mem = (IMember)memberOrList;
            }
            dim = mem.getDimension();
            if (dim.isMeasuresDimension()) continue;
            level = mem.getLevel();
            levelInfo.put(dim, level);
        }
        for (i = 0; i < selections.size(); ++i) {
            memberOrList = selections.get(i);
            memberList = null;
            mem = null;
            if (memberOrList instanceof List) {
                memberList = CollectionCast.uncheckedCast((List)memberOrList);
                mem = (IMember)memberList.get(0);
            } else {
                mem = (IMember)memberOrList;
            }
            dim = mem.getDimension();
            if (!dim.isMeasuresDimension()) continue;
            measuresIndex = i;
        }
        for (i = 0; i < selections.size(); ++i) {
            IMember scopeMember;
            memberOrList = selections.get(i);
            IMember mem2 = null;
            List memberList2 = null;
            if (memberOrList instanceof ArrayList) {
                memberList2 = CollectionCast.uncheckedCast((List)memberOrList);
                mem2 = (IMember)memberList2.get(0);
            } else {
                outputTuple[dimToIndexMap.get((Object)mem2.getDimension()).intValue()] = mem2 = (IMember)memberOrList;
            }
            dim = mem2.getDimension();
            if (dim.isMeasuresDimension()) continue;
            level = (DMRLevel)mem2.getLevel();
            if (((DMRLevel)level).isMappedToRelationalColumn()) {
                DMRCompoundKeyMapping keyMapping = new DMRCompoundKeyMapping();
                if (memberList2 != null) {
                    for (int idx = 0; idx < memberList2.size(); ++idx) {
                        IMember scopeMember2 = (IMember)memberList2.get(idx);
                        keyMapping.addMemberSelection(scopeMember2);
                    }
                } else {
                    IMember scopeMember3 = mem2;
                    keyMapping.addMemberSelection(scopeMember3);
                }
                keyMapping.addToQuery(result);
            }
            if (!((DMRLevel)level).isMappedToRelationalColumn()) continue;
            outputTuple[dimToIndexMap.get((Object)scopeMember.getDimension()).intValue()] = scopeMember = mem2;
            this.queryNameToScopeMember.put((Object)queryName, (Object)scopeMember);
        }
        if (measuresIndex > -1) {
            Object measuresSels = selections.get(measuresIndex);
            if (measuresSels instanceof List) {
                measuresSelections = CollectionCast.uncheckedCast((List)measuresSels);
            } else {
                measuresSelections = new ArrayList();
                measuresSelections.add((IMember)measuresSels);
            }
        } else {
            measuresSelections = new ArrayList<IMember>();
        }
        result.setMeasuresSelections(measuresSelections);
        result.setSelections(selections);
        result.setOutputTuple(outputTuple);
        result.setMeasuresOffset(result.getColumnCount());
        for (int i2 = 0; i2 < measuresSelections.size(); ++i2) {
            DMRMeasure measure = (DMRMeasure)measuresSelections.get(i2);
            result.addColumn(measure);
        }
        return result;
    }

    private void executeAggregateByContextSet(InterpreterContext interpreterContext, com.cognos.xqe.runtree.olap.mdx.interpreter.Set aggSet, com.cognos.xqe.runtree.olap.mdx.interpreter.Set contextSet, com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] aggSets, Value[] aggValues) throws ExternalAggregateStrategyException {
        VirtualMember customSetQuery = null;
        if (aggSet.size() == 1L) {
            ITuple aggSetsTuple = null;
            for (int i = 0; i < aggSets.length; ++i) {
                com.cognos.xqe.runtree.olap.mdx.interpreter.Set set = aggSets[i];
                if (set == null) continue;
                aggSetsTuple = set.getTuple(0L);
                break;
            }
            for (IMember member : aggSetsTuple.getMembers()) {
                if (!(member instanceof VirtualMember) || ((VirtualMember)member).getV5Query() == null) continue;
                customSetQuery = (VirtualMember)member;
                break;
            }
        }
        V5QueryGroup groupQuery = null;
        if (customSetQuery != null) {
            groupQuery = this.buildExternalAggregateQueryWithCustomSetQuery(customSetQuery, contextSet);
            for (int index = 0; index < aggSets.length; ++index) {
                ArrayList<ITuple> resultTuples = new ArrayList<ITuple>();
                IIterator setIter = aggSets[index].iterator();
                while (setIter.hasNext()) {
                    ITuple tuple = (ITuple)setIter.next();
                    IMember[] members = tuple.getMembers();
                    for (int i = 0; i < members.length; ++i) {
                        IMember member = members[i];
                        if (!(member instanceof VirtualMember)) continue;
                        ((Tuple)tuple).replaceMember(i, member.getHierarchy().getDefaultMember());
                        break;
                    }
                    resultTuples.add(tuple);
                }
                aggSets[index] = new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(resultTuples.toArray(new ITuple[resultTuples.size()]));
            }
        } else {
            CrossJoinedSet cjs = new CrossJoinedSet(new com.cognos.xqe.runtree.olap.mdx.interpreter.Set[]{aggSet, contextSet});
            groupQuery = this.buildExternalAggregateQuery(cjs);
        }
        MultiValueMap combinationToSetIndex = new MultiValueMap();
        for (int i = 0; i < groupQuery.queryCount(); ++i) {
            for (int j = 0; j < aggSets.length; ++j) {
                if (aggSets[j] == null || aggValues[j] != null) continue;
                combinationToSetIndex.put((Object)i, (Object)j);
            }
            if (combinationToSetIndex.get((Object)i) != null) continue;
            groupQuery.getQueries().remove(i);
        }
        this.executeExternalAggregateQuery(groupQuery, aggSets, aggValues, combinationToSetIndex);
    }

    private IMember resolveFirstLastMember(IMember member, DMRLevel scopeLevel, IAggregateRule rule) {
        int scopeLevelIndex = scopeLevel.getIndex();
        int memberLevelIndex = member.getLevel().getIndex();
        int currentLevelIndex = Math.min(scopeLevelIndex, memberLevelIndex);
        IMember childMember = member;
        int lowestLevelIndex = member.getHierarchy().getLevelCount();
        if (lowestLevelIndex - 1 > currentLevelIndex) {
            while (childMember.getLevel().getIndex() > scopeLevelIndex) {
                childMember = childMember.getParent();
            }
            while (currentLevelIndex < lowestLevelIndex - 1) {
                List<IMember> children = childMember.getChildren();
                if (childMember.getChildren().size() == 0) break;
                childMember = rule.getAggregate() == AggregateTypeEnum.LAST ? children.get(children.size() - 1) : children.get(0);
                ++currentLevelIndex;
            }
        }
        return childMember;
    }

    private void populateTuple(IMetadata[] projectedColumns, List<DMRCompoundKeyMapping> compoundKeyMappings, List<Value> outputRow, IMember[] outputTuple) {
        IDMRMember member = null;
        Level level = null;
        for (int j = 0; j < compoundKeyMappings.size(); ++j) {
            DMRCompoundKeyMapping mapping = compoundKeyMappings.get(j);
            Set<DMRLevel> mappingLevels = mapping.getLevelToQualifyingMembers().keySet();
            int columnCount = projectedColumns.length;
            for (int i = 0; i < columnCount; ++i) {
                Value v;
                if (!(projectedColumns[i] instanceof ILevel) || !mappingLevels.contains(projectedColumns[i])) continue;
                if ((level == null || level.getHierarchy() != ((DMRLevel)projectedColumns[i]).getHierarchy()) && (level = (DMRLevel)projectedColumns[i]).getIndex() == 1) {
                    member = (IDMRMember)level.getHierarchy().getDefaultMember();
                }
                if ((v = outputRow.get(i)) instanceof MemberRSAPIValue) {
                    v = ((MemberRSAPIValue)v).getBusinessKeyValue();
                }
                if (member == null) {
                    String keyComponent = "";
                    if (v != null && !v.isNull()) {
                        keyComponent = outputRow.get(i).getV5formattedString();
                    }
                    member = (IDMRMember)((DMRLevel)level).getMember(keyComponent);
                } else {
                    member = (IDMRMember)member.getChildMemberAsPerBusinessKeyValue(v);
                }
                if (member == null) continue;
                IDimension dim = member.getDimension();
                outputTuple[this.getDimToIndexMap().get((Object)dim).intValue()] = member;
            }
        }
    }

    public void populateTupleValues(List<Value[]> thisResult, V5QueryOverTabularStream query, List<TupleValue> allResults) {
        IMember[] outputTuple = query.getOutputTuple();
        for (int i = 1; i < thisResult.size(); ++i) {
            Value[] resultRow = thisResult.get(i);
            ArrayList<Value> outputRow = new ArrayList<Value>();
            for (int k = 0; k < resultRow.length; ++k) {
                outputRow.add(resultRow[k]);
            }
            List<IMember> measuresSelections = query.getMeasuresSelections();
            List<DMRCompoundKeyMapping> compoundKeyMappings = query.getCompoundKeyMappings();
            IMetadata[] projColumns = query.getProjectedColumns();
            this.populateTuple(projColumns, compoundKeyMappings, outputRow, outputTuple);
            for (int k = 0; k < measuresSelections.size(); ++k) {
                int t;
                IMember measure = measuresSelections.get(k);
                int currentMeasureOffset = query.getMeasuresOffset();
                outputTuple[this.getDimToIndexMap().get((Object)measure.getDimension()).intValue()] = measure;
                if (currentMeasureOffset >= outputRow.size()) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, " Error Index =" + currentMeasureOffset + " of row " + outputRow);
                }
                Value measureValue = (Value)outputRow.get(currentMeasureOffset + k);
                if (measureValue == null) continue;
                FormatId formatId = null;
                String measureFormat = (String)measure.getProperty("format");
                formatId = measureFormat == null && measureValue.isNumeric() ? FormatId.DEFAULT_NUMBER_FORMAT_FID : FormatService.getInstance().registerV5Format(measureFormat, null);
                measureValue.setFormatId(formatId);
                ArrayList<Object> selections = new ArrayList<Object>();
                List scopeMembers = CollectionCast.uncheckedCast((List)this.queryNameToScopeMember.get((Object)query.getName()));
                if (scopeMembers == null) {
                    scopeMembers = new ArrayList();
                }
                for (int t2 = 0; t2 < outputTuple.length; ++t2) {
                    if (outputTuple[t2] == null || this.aggregateLevels.contains(outputTuple[t2].getLevel())) continue;
                    if (!scopeMembers.contains(outputTuple[t2])) {
                        selections.add(outputTuple[t2]);
                        continue;
                    }
                    Object memberOrList = query.getSelections().get(t2);
                    if (memberOrList instanceof IMember) {
                        selections.add(memberOrList);
                        continue;
                    }
                    List memberList = CollectionCast.uncheckedCast((List)memberOrList);
                    ILevel memberLevel = ((IMember)memberList.get(0)).getLevel();
                    DMRLevel scopeLevel = V5QueryOverTabularStream.getLowestLevelFromScope((IMeasure)measure, memberLevel);
                    ArrayList scopeMembersList = new ArrayList();
                    for (int idx = 0; idx < memberList.size(); ++idx) {
                        IMember scopeMember = (IMember)memberList.get(idx);
                        int scopeMemberLevelIndex = scopeMember.getLevel().getIndex();
                        int scopeLevelIndex = scopeLevel.getIndex();
                        while (scopeMemberLevelIndex > scopeLevelIndex) {
                            scopeMember = scopeMember.getParent();
                            scopeMemberLevelIndex = scopeMember.getLevel().getIndex();
                        }
                        if (outputTuple[t2] != scopeMember) continue;
                        scopeMembersList.add(memberList.get(idx));
                    }
                    selections.add(scopeMembersList);
                }
                ArrayList<Tuple> tupleList = new ArrayList<Tuple>();
                ArrayList<IMember> memberList = new ArrayList<IMember>();
                Tuple tuple = new Tuple();
                for (t = 0; t < selections.size(); ++t) {
                    if (selections.get(t) instanceof IMember) {
                        memberList.add((IMember)selections.get(t));
                        continue;
                    }
                    if (!(selections.get(t) instanceof List) || CollectionCast.uncheckedCast((List)selections.get(t)).size() <= 0) continue;
                    memberList.add((IMember)CollectionCast.uncheckedCast((List)selections.get(t)).get(0));
                }
                tuple = new Tuple(memberList.toArray(new IMember[memberList.size()]));
                tupleList.add(tuple);
                for (t = 0; t < selections.size(); ++t) {
                    if (!(selections.get(t) instanceof List)) continue;
                    List selection = CollectionCast.uncheckedCast((List)selections.get(t));
                    for (int j = 1; j < selection.size(); ++j) {
                        Tuple tup = (Tuple)tuple.copy();
                        IMember member = (IMember)selection.get(j);
                        tup.replaceMember(t, member);
                        tupleList.add(tup);
                    }
                }
                for (int j = 0; j < tupleList.size(); ++j) {
                    allResults.add(new TupleValue((ITuple)tupleList.get(j), new Cell(measureValue)));
                }
            }
        }
    }

    private com.cognos.xqe.runtree.olap.mdx.interpreter.Set collapseToFirstLastMember(com.cognos.xqe.runtree.olap.mdx.interpreter.Set aggSet, InterpreterContext interpreterContext) throws ExternalAggregateStrategyException {
        IAggregateRule[] rules;
        if (aggSet == null || aggSet.size() < 1L) {
            return aggSet;
        }
        IDimension[] setDimensions = aggSet.getDimensions();
        Dimension measuresDim = (Dimension)interpreterContext.getCube().getMeasuresHierarchy().getDimension();
        IMember[] measures = aggSet.getMembers(measuresDim);
        if (measures.length > 1) {
            return aggSet;
        }
        IMember theMeasure = measures[0];
        HashMap<IDimension, IAggregateRule> firstLastAggrRuleDimensions = new HashMap<IDimension, IAggregateRule>();
        HashMap<IDimension, ILevel> levelInfo = new HashMap<IDimension, ILevel>();
        for (int i = 0; i < setDimensions.length; ++i) {
            IAggregateRule[] dimension = setDimensions[i];
            if (dimension.isMeasuresDimension()) continue;
            IMember mem = aggSet.getTuple(0L).getMember((IDimension)dimension);
            levelInfo.put((IDimension)dimension, mem.getLevel());
        }
        for (IAggregateRule rule : rules = theMeasure.getAggregateRules()) {
            if (rule.getAggregate() != AggregateTypeEnum.FIRST && rule.getAggregate() != AggregateTypeEnum.LAST) continue;
            firstLastAggrRuleDimensions.put(DMRExternalAggregateStrategy.getLowestDimensionInContext(levelInfo, this.cube.getDimensions(), rule), rule);
        }
        if (firstLastAggrRuleDimensions.size() == 0) {
            return aggSet;
        }
        ArrayList<IMember> firstLastMembers = new ArrayList<IMember>();
        ArrayList<IDimension> firstLastDimensions = new ArrayList<IDimension>();
        for (int d = 0; d < setDimensions.length; ++d) {
            IAggregateRule rule;
            rule = (IAggregateRule)firstLastAggrRuleDimensions.get(setDimensions[d]);
            if (rule == null) continue;
            firstLastDimensions.add(setDimensions[d]);
            IMember[] members = aggSet.getMembers(setDimensions[d]);
            List<IMember> membersWithRuleInSlicerContext = AggregateCombination.applySlicerToMembersWithRule(Arrays.asList(members), rule);
            DMRLevel level = (DMRLevel)membersWithRuleInSlicerContext.get(0).getLevel();
            DMRLevel scopeLevel = V5QueryOverTabularStream.getLowestLevelFromScope((IMeasure)theMeasure, level);
            if (scopeLevel == null) {
                scopeLevel = (DMRLevel)level.getDimension().getLevel(0);
            }
            com.cognos.xqe.runtree.olap.mdx.interpreter.Set sortedSet = new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(Tuple.createTupleList(membersWithRuleInSlicerContext.toArray(new IMember[0])));
            sortedSet = sortedSet.hierarchize();
            if (rule.getAggregate() == AggregateTypeEnum.LAST) {
                long last = sortedSet.size() - 1L;
                IMember lastMember = sortedSet.getTuple(last).getMember(setDimensions[d]);
                lastMember = this.resolveFirstLastMember(lastMember, scopeLevel, rule);
                firstLastMembers.add(lastMember);
                continue;
            }
            IMember firstMember = sortedSet.getTuple(0L).getMember(setDimensions[d]);
            firstMember = this.resolveFirstLastMember(firstMember, scopeLevel, rule);
            firstLastMembers.add(firstMember);
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        IIterator it = aggSet.iterator();
        while (it.hasNext()) {
            Tuple tuple = (Tuple)it.next();
            boolean delete = false;
            Iterator itDim = firstLastDimensions.iterator();
            int next = -1;
            while (itDim.hasNext()) {
                IDimension dim = (IDimension)itDim.next();
                IMember member = tuple.getMember(dim);
                if (((IMember)firstLastMembers.get(++next)).getUniqueName().startsWith(member.getUniqueName())) continue;
                delete = true;
                break;
            }
            if (delete) continue;
            Tuple newTuple = (Tuple)tuple.copy();
            for (IMember firstLastMember : firstLastMembers) {
                IDimension dim = firstLastMember.getDimension();
                int dimPosition = newTuple.getDimensionIndex(dim);
                newTuple.replaceMember(dimPosition, firstLastMember);
            }
            tuples.add(newTuple);
        }
        aggSet = new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(tuples.toArray(new Tuple[tuples.size()]));
        return aggSet;
    }

    private V5QueryGroup buildExternalAggregateQueryWithCustomSetQuery(VirtualMember customSetQuery, com.cognos.xqe.runtree.olap.mdx.interpreter.Set contextSet) {
        V5QueryGroup queryGroup = null;
        com.cognos.xqe.runtree.olap.mdx.interpreter.Set aggSet = new com.cognos.xqe.runtree.olap.mdx.interpreter.Set(new Tuple(customSetQuery.getLevel().getHierarchy().getDefaultMember()));
        CrossJoinedSet cjs = new CrossJoinedSet(new com.cognos.xqe.runtree.olap.mdx.interpreter.Set[]{aggSet, contextSet});
        queryGroup = this.buildExternalAggregateQuery(cjs);
        V5QuerySet subQueries = customSetQuery.getV5Query();
        queryGroup.getQuery(0).setSubQueries(subQueries.getChildrenOfType(101006));
        HashMap<String, String> expressionToNameMap = new HashMap<String, String>();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)subQueries.getFirstChildByType(101055);
        V5Query refQuery = qrd.getV5Query();
        IXQEQueryNode[] sortItems = qrd.getDescendantsOfType(101056, false);
        for (IXQEQueryNode sortItem : sortItems) {
            String diName = ((V5SortItem)sortItem).getRefDataItem();
            V5DataItem di = refQuery.getDataItemByName(diName);
            V5Expression expression = (V5Expression)di.getFirstChildByType(101004);
            String strExpr = (String)expression.getPropertyValue("expression");
            try {
                String[] parts;
                while (strExpr.startsWith("[") && (parts = UniqueNameParser.parse(strExpr)).length == 2) {
                    di = DMRPushdownAdapter.getDataItemReference(subQueries, parts);
                    expression = (V5Expression)di.getFirstChildByType(101004);
                    strExpr = (String)expression.getPropertyValue("expression");
                }
            }
            catch (Exception e) {
                throw new MDXEngineException("X01433", strExpr + " is an invalid data item reference.");
            }
            expressionToNameMap.put(strExpr, diName);
        }
        for (IMetadata column : queryGroup.getQuery(0).getProjectedColumns()) {
            DMRLevel level;
            String filterExpression;
            if (column.getObjectType() != MetadataType.LEVEL || (filterExpression = DMRExternalAggregateStrategy.buildFilterExpressionString(level = (DMRLevel)column, expressionToNameMap, refQuery)) == null) continue;
            queryGroup.getQuery(0).addAdditionalFilterExpressions(filterExpression);
        }
        DMRLevel customSetLevel = (DMRLevel)customSetQuery.getLevel();
        String filterExpression = DMRExternalAggregateStrategy.buildFilterExpressionString(customSetLevel, expressionToNameMap, refQuery);
        if (filterExpression != null) {
            queryGroup.getQuery(0).addAdditionalFilterExpressions(filterExpression);
        }
        return queryGroup;
    }

    private static String buildFilterExpressionString(DMRLevel level, HashMap<String, String> expressionToNameMap, V5Query refQuery) {
        String levelKey = level.getQueryItemExpressionForKey();
        String subQueryDiName = expressionToNameMap.get(levelKey);
        if (subQueryDiName == null) {
            return null;
        }
        subQueryDiName = UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createSingleNamePart(refQuery.getV5QueryName()), subQueryDiName);
        String filterExpression = levelKey + " IN (" + subQueryDiName + ")";
        return filterExpression;
    }
}

