/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRProperty;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.util.INullPlacement;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqemoser.MoserHierarchy;
import com.cognos.xqemoser.MoserLevel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DMRMember
extends Member
implements INullPlacement,
IDMRMember {
    public static final String PROPERTY_MEMBER_LEVEL_SAME_NAME = "_memberLevelSameName";
    private Map<Value, IDMRMember> indexedChildren = null;
    public static final String PROPERTY_V5_MEMBER_NAME = "_v5MemberName";
    public static final Value DEFAULT_BUSINESSKEY = DataValueFactory.createNullValue();
    public static final String DMR_INTERNAL_EMPTY_MEMBER_NAME = "";
    private Value businessKey;
    protected Value memberCaptionValue;
    private String v5Name = null;
    private String nativeMUN = null;
    private String nativePUN = null;
    private FormatId childrenFormatId = null;
    protected byte hierarchyMemberType = 0;

    public DMRMember(Value objectName, Value businessKeyObj, Level level) {
        super(objectName.getV5formattedString(), level);
        this.businessKey = businessKeyObj != null ? businessKeyObj : DEFAULT_BUSINESSKEY;
        Value[] rtBusinessKey = new Value[]{null};
        this.name = DMRMember.convertBusinessKeyToDMRMemberName(this.businessKey, rtBusinessKey);
        if (rtBusinessKey[0] != null) {
            this.businessKey = rtBusinessKey[0];
        }
        if (this.businessKey.isNull()) {
            this.setV5Name(DMR_INTERNAL_EMPTY_MEMBER_NAME);
        }
        this.memberCaptionValue = objectName;
        this.caption = objectName.getV5formattedString();
        DMRDimension dimension = (DMRDimension)level.getDimension();
        this.setMemberId(dimension.getmaxMemberId());
        this.setConnection(level.getDimension().getCube().getConnection());
    }

    public DMRMember(String objectName, String captionStr, Value captionValue, Value businessKeyObj, Level level) {
        super(objectName, level);
        this.businessKey = businessKeyObj != null ? businessKeyObj : DEFAULT_BUSINESSKEY;
        this.name = objectName;
        if (this.businessKey.isNull()) {
            this.setV5Name(DMR_INTERNAL_EMPTY_MEMBER_NAME);
        }
        this.memberCaptionValue = captionValue;
        this.caption = captionStr;
        DMRDimension dimension = (DMRDimension)level.getDimension();
        this.setMemberId(dimension.getmaxMemberId());
        this.setConnection(level.getDimension().getCube().getConnection());
    }

    public static String convertBusinessKeyToDMRMemberName(Value businessKey, Value[] rtValue) {
        return DMRMember.convertBusinessKeyToDMRMemberName(businessKey, businessKey.getFormatId(), rtValue);
    }

    public static String convertBusinessKeyToDMRMemberName(Value businessKey, FormatId formatId, Value[] rtValue) {
        String nameKey;
        if (businessKey == null) {
            businessKey = DEFAULT_BUSINESSKEY;
        }
        if (!businessKey.isNull()) {
            nameKey = businessKey.getV5formattedString(formatId);
        } else {
            nameKey = DMR_INTERNAL_EMPTY_MEMBER_NAME;
            if (rtValue != null && rtValue.length > 0) {
                rtValue[0] = DEFAULT_BUSINESSKEY;
            }
        }
        return nameKey;
    }

    @Override
    @Deprecated
    public Object getBusinessKey() {
        if (this.businessKey.isNull()) {
            return DMR_INTERNAL_EMPTY_MEMBER_NAME;
        }
        return this.businessKey.getV5formattedString();
    }

    @Override
    public Value getBusinessKeyValue() {
        return this.businessKey;
    }

    @Override
    public Value getCaptionValue() {
        return this.memberCaptionValue;
    }

    protected void setParentMember(Member parent) {
        super.setParentMember(parent);
        super.setParentLevelNumber(parent.getLevel().getIndex());
    }

    protected OrderedMap<IMember> createOrderedMap() {
        if (this.getLevel() instanceof DMRLevel) {
            return ((DMRLevel)this.getLevel()).createOrderedMap();
        }
        return new OrderedMap<IMember>();
    }

    @Override
    public boolean isPopulateChildrenRequired() {
        DMRCube cube = (DMRCube)this.getLevel().getDimension().getCube();
        if (cube.getIncrementalMemberLoading() == DMRCube.IncrementalMemberLoading.NONE) {
            return !this.hasGotAllChildren();
        }
        if (this.hasGotAllChildren()) {
            return false;
        }
        if (((Level)this.getLevel()).getPushdownManager() != null) {
            return this.getChildrenOrderedMapSize() == 0;
        }
        DMRCube dmrCube = (DMRCube)this.getLevel().getDimension().getCube();
        Map.Entry<ILevel, List<BaseMember>> restriction = dmrCube.getRestrictionMembersForHierarchy(this.getHierarchy());
        if (restriction == null || restriction.getValue().isEmpty()) {
            return true;
        }
        int highestRestrictionLevel = Integer.MAX_VALUE;
        for (BaseMember restrictionMember : restriction.getValue()) {
            int restrictionMemberLevel = restrictionMember.getLevel().getIndex();
            if (highestRestrictionLevel <= restrictionMemberLevel) continue;
            highestRestrictionLevel = restrictionMemberLevel;
        }
        if (highestRestrictionLevel < this.getLevel().getIndex()) {
            return true;
        }
        if (highestRestrictionLevel == this.getLevel().getIndex()) {
            for (BaseMember restrictionMember : restriction.getValue()) {
                if (!restrictionMember.getExternalName().equals(this.getUniqueName())) continue;
                return this.getChildrenOrderedMapSize() == 0;
            }
            return true;
        }
        return this.getChildrenOrderedMapSize() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateChildren() {
        block15: {
            if (!this.gotAllChildren) {
                ILevel childLevel = this.getLevel().getNextLevel();
                if (childLevel == null) {
                    this.setGotAllChildren();
                } else {
                    try {
                        if (((Level)childLevel).hasGotAllMembers()) {
                            List<IMember> mems = childLevel.getMembers();
                            DMRMember dMRMember = this;
                            synchronized (dMRMember) {
                                if (!this.gotAllChildren) {
                                    this.children = this.createOrderedMap();
                                    for (IMember mem : mems) {
                                        if (mem.getParent() != this) continue;
                                        this.children.put(mem);
                                    }
                                    this.gotAllChildren = true;
                                }
                                break block15;
                            }
                        }
                        IOrderedMap<IMember> childMembers = this.fetchChildMembers();
                        DMRMember dMRMember = this;
                        synchronized (dMRMember) {
                            if (!this.gotAllChildren) {
                                this.children = childMembers;
                            }
                        }
                    }
                    catch (ProviderException e) {
                        throw new MetadataException("X01493", new String[]{this.getName(), e.toString()}, e);
                    }
                }
            }
        }
    }

    @Override
    public IOrderedMap<IMember> fetchChildMembers() throws MetadataException, ProviderException {
        IOrderedMap<IMember> result = new OrderedMap<IMember>();
        if (((Level)this.getLevel()).isBottomLevel()) {
            return result;
        }
        DMRLevel currentLevel = (DMRLevel)this.getLevel();
        DMRLevel childLevel = (DMRLevel)this.getLevel().getNextLevel();
        DMRCube dmrCube = (DMRCube)this.getHierarchy().getDimension().getCube();
        DMRLevel loadLevel = dmrCube.getNextNLevelMembers(currentLevel, childLevel);
        if (loadLevel != null) {
            DMRLevel.dmrLoadLevelMembers(loadLevel);
            return this.getChildrenOrderedMap();
        }
        Pair loadCaptionAndProperties = new Pair();
        List<Value[]> v5result = childLevel.runV5QueryForChildren(this, loadCaptionAndProperties);
        if (v5result == null) {
            return result;
        }
        DMRLevel.createMemberFromV5Result(1, v5result, childLevel, this, loadCaptionAndProperties);
        this.setGotAllChildren();
        result = this.getChildrenOrderedMap();
        if (result.size() < 1 && ((DMRLevel)this.getLevel()).isMappedToRelationalColumn()) {
            Value theBusinessKey = DEFAULT_BUSINESSKEY;
            StringValue theMemberName = DataValueFactory.createStringValue();
            ((Value)theMemberName).set(DMR_INTERNAL_EMPTY_MEMBER_NAME);
            DMRMember currentMember = new DMRMember(theMemberName, theBusinessKey, childLevel);
            this.addMemberToChildrenOrderedMap(currentMember);
            currentMember.setParentMember(this);
        }
        return result;
    }

    @Override
    public void addChildToBusinessKeyMap(IDMRMember child) {
        if (this.childrenFormatId == null) {
            this.childrenFormatId = child.getBusinessKeyValue().getFormatId();
        }
        if (child.getName().equals(DMR_INTERNAL_EMPTY_MEMBER_NAME)) {
            Value value = child.getBusinessKeyValue();
            if (this.indexedChildren == null) {
                this.indexedChildren = new HashMap<Value, IDMRMember>(2);
            }
            this.indexedChildren.put(value, child);
        }
    }

    @Override
    public String getDescription() {
        Value descriptionValue = this.getDescriptionValue();
        if (descriptionValue != null) {
            return descriptionValue.getString();
        }
        return null;
    }

    @Override
    public Value getDescriptionValue() {
        String descriptionPropertyName = ((DMRLevel)this.getLevel()).getMemberDescriptionProperty();
        if (descriptionPropertyName != null) {
            return (Value)this.getProperty(descriptionPropertyName);
        }
        return null;
    }

    @Override
    public void setProperty(String propertyName, Object value) {
        if (this.getExistingPropertyValue(propertyName) == null) {
            super.setProperty(propertyName, value);
        }
    }

    private Object getExistingPropertyValue(String propertyName) {
        Object property = null;
        DMRProperty dmrProperty = (DMRProperty)this.getLevel().getMemberProperty(propertyName);
        if (dmrProperty != null) {
            if (dmrProperty.isBusinessKey()) {
                property = this.getBusinessKeyValue();
            } else if (dmrProperty.isMemberCaption()) {
                property = this.getCaptionValue();
            } else {
                propertyName = dmrProperty.getUniqueName();
            }
        }
        if (property == null && propertyName != null) {
            property = super.getProperty(propertyName);
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String propertyProviderUniqueName) {
        Object property = this.getExistingPropertyValue(propertyProviderUniqueName);
        if (property == null) {
            DMRProperty dmrProperty = (DMRProperty)this.getLevel().getMemberProperty(propertyProviderUniqueName);
            if (dmrProperty != null) {
                propertyProviderUniqueName = dmrProperty.getUniqueName();
            }
            DMRMember dMRMember = this;
            synchronized (dMRMember) {
                ((DMRLevel)this.getLevel()).dmrLoadLevelMembersProperty(propertyProviderUniqueName);
            }
            property = this.getExistingPropertyValue(propertyProviderUniqueName);
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            DMRMember dMRMember = this;
            synchronized (dMRMember) {
                this.v5UniqueName = DMRMember.createMemberV5UniqueName(this);
            }
        }
        return this.v5UniqueName;
    }

    protected static String createMemberV5UniqueName(IDMRMember member) {
        String rt = DMRMember.createSimplerMemberV5UniqueName(member);
        if (rt != null) {
            return rt;
        }
        return DMRMember.joinModelPhysicalParts(UniqueNameGenerator.createMemberV5ModelPart(member.getLevel()), DMRMember.buildMemberPath(member));
    }

    private static String buildMemberPath(IDMRMember member) {
        StringBuilder strBuf = new StringBuilder("[");
        strBuf.append(UniqueNameParser.escapeSquareBrackets(member.getV5Name()));
        strBuf.append("]");
        for (IMember parentMember = member.getParent(); parentMember != null; parentMember = parentMember.getParent()) {
            strBuf.insert(0, ".");
            strBuf.insert(0, "]");
            strBuf.insert(0, UniqueNameParser.escapeSquareBrackets(((IDMRMember)parentMember).getV5Name()));
            strBuf.insert(0, "[");
        }
        return strBuf.toString();
    }

    private static String createSimplerMemberV5UniqueName(IDMRMember member) {
        ILevel aLevel = member.getLevel();
        if (!(aLevel instanceof DMRLevel)) {
            return null;
        }
        DMRLevel dmrLevel = (DMRLevel)aLevel;
        ILevel lvl = dmrLevel.getFMLevel();
        if (!(lvl instanceof LevelWrapper)) {
            return null;
        }
        ILevel realLvl = ((LevelWrapper)lvl).getWrappedLevel();
        if (!(realLvl instanceof MoserLevel)) {
            return null;
        }
        MoserHierarchy moserHier = (MoserHierarchy)realLvl.getHierarchy();
        StringBuilder sb = new StringBuilder(moserHier.getSimpleV5UniqueName());
        sb.append("->");
        if (lvl.isRootLevel()) {
            sb.append("all");
        } else {
            IMember parentParentMember;
            StringBuilder strBuf = new StringBuilder("[");
            strBuf.append(UniqueNameParser.escapeSquareBrackets(member.getV5Name()));
            strBuf.append("]");
            IMember parentMember = member.getParent();
            while (parentMember != null && (parentParentMember = parentMember.getParent()) != null) {
                strBuf.insert(0, ".");
                strBuf.insert(0, "]");
                strBuf.insert(0, UniqueNameParser.escapeSquareBrackets(((IDMRMember)parentMember).getV5Name()));
                strBuf.insert(0, "[");
                parentMember = parentParentMember;
            }
            sb.append((CharSequence)strBuf);
        }
        return sb.toString();
    }

    private static String joinModelPhysicalParts(String model, String physical) {
        StringBuilder munBuf = new StringBuilder();
        munBuf.append(model);
        munBuf.append("->");
        munBuf.append(physical);
        return munBuf.toString();
    }

    @Override
    public IOrderedMap<IMember> getChildrenOrderedMap() {
        this.initChildrenOrderedMap();
        return this.children;
    }

    @Override
    public IMember getChildMemberAsPerBusinessKeyValue(Value theBusinessKey) {
        if (this.childrenFormatId == null) {
            return null;
        }
        IMember childMember = null;
        Value[] rtBusinessKey = new Value[]{null};
        String childMemberName = DMRMember.convertBusinessKeyToDMRMemberName(theBusinessKey, this.childrenFormatId, rtBusinessKey);
        if (rtBusinessKey[0] != null) {
            theBusinessKey = rtBusinessKey[0];
        }
        if (childMemberName.equals(DMR_INTERNAL_EMPTY_MEMBER_NAME)) {
            if (this.indexedChildren != null) {
                childMember = this.indexedChildren.get(theBusinessKey);
            }
        } else {
            childMember = this.getChildMember(childMemberName);
        }
        return childMember;
    }

    @Override
    public IMember searchChildMemberAsPerBusinessKeyValue(Value theBusinessKey) {
        if (this.childrenFormatId == null) {
            return null;
        }
        IMember childMember = null;
        Value[] rtBusinessKey = new Value[]{null};
        String childMemberName = DMRMember.convertBusinessKeyToDMRMemberName(theBusinessKey, this.childrenFormatId, rtBusinessKey);
        if (rtBusinessKey[0] != null) {
            theBusinessKey = rtBusinessKey[0];
        }
        if (childMemberName.equals(DMR_INTERNAL_EMPTY_MEMBER_NAME)) {
            if (this.indexedChildren != null) {
                childMember = this.indexedChildren.get(theBusinessKey);
            }
        } else {
            childMember = this.searchChildrenOrderedMap(childMemberName);
        }
        return childMember;
    }

    @Override
    public boolean isRelational() {
        return true;
    }

    @Override
    public boolean isNullPlacement() {
        String caption = this.getCaption();
        return caption == null || caption.length() == 0;
    }

    @Override
    public String getV5Name() {
        if (this.v5Name != null) {
            return this.v5Name;
        }
        return this.getName();
    }

    @Override
    public synchronized void setV5Name(String name) {
        this.v5Name = name;
    }

    public static String wrapNamePart(String identifier) {
        StringBuilder sb = new StringBuilder(identifier);
        sb.insert(0, "___");
        sb.append("__MEMBER_");
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    @Override
    public boolean isDMR() {
        return true;
    }

    public String getNativeMUN() {
        return this.nativeMUN;
    }

    public String getNativePUN() {
        return this.nativePUN;
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public int hashCode() {
        return (int)this.getMemberId();
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof DMRMember)) {
            return -1;
        }
        if (this.equals(o)) {
            return 0;
        }
        DMRMember other = (DMRMember)o;
        if (this.getDimension() == other.getDimension()) {
            return this.compareInt((int)this.getMemberId(), (int)other.getMemberId());
        }
        return this.compareInt(this.getDimension().getIndex(), other.getDimension().getIndex());
    }

    private int compareInt(int a, int b) {
        if (a == b) {
            return 0;
        }
        if (a > b) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean hasProperty(String propertyName) {
        Object property = super.getProperty(propertyName);
        return property != null;
    }

    @Override
    public void addMemberToChildrenOrderedMap(IMember childMember) {
        super.addMemberToChildrenOrderedMap(childMember);
        ((DMRMember)childMember).setParentLevelNumber(this.getLevel().getIndex());
    }

    @Override
    public String getUniqueName() {
        if (this.isFillerMember()) {
            return super.getUniqueName();
        }
        if (this.uniqueName == null) {
            IMember parent = this.getParent();
            this.uniqueName = parent == null ? UniqueNameGenerator.appendUniqueName(this.getHierarchy().getUniqueName(), this.getName()) : UniqueNameGenerator.appendUniqueName(parent.getUniqueName(), this.getName());
        }
        return this.uniqueName;
    }

    public IMember getMemberFromDynamicProperty(String dynamicPropName) {
        DMRLevel theDMRLevel = (DMRLevel)this.getLevel();
        theDMRLevel.loadDynamicProperty();
        IMember rt = (IMember)this.getExistingPropertyValue(dynamicPropName);
        if (rt == null) {
            rt = theDMRLevel.returnNullMemberFromSecondaryLevel(dynamicPropName);
        }
        return rt;
    }

    public byte getHierarchyMemberType() {
        return this.hierarchyMemberType;
    }

    public void setHierarchyMemberType(byte t) {
        this.hierarchyMemberType = t;
    }

    @Override
    public void setIndexInParentsChildren(int index) {
        this.indexInParentsChildrenList = index;
    }
}

