/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelAttributeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Property;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import java.util.ArrayList;
import java.util.List;

public class DMRProperty
extends Property {
    IProperty fmProperty;

    public DMRProperty(String name, Level level, IProperty property) {
        super(name, level);
        this.setConnection(level.getConnection());
        this.fmProperty = property;
        this.setDataType(property.getDataType());
    }

    public String getQueryItemExpressionForKey(PlanningEnvironment environment) {
        String expr = ((IQueryItem)((Object)this.fmProperty)).getExpression();
        if (expr == null) {
            expr = (String)((IQueryItem)((Object)this.fmProperty)).getProperty("ID");
        }
        return MetadataUtil.extractExpressionFromModelString(expr, environment);
    }

    public String getQueryItemExpressionForKey() {
        String expr = ((IQueryItem)((Object)this.fmProperty)).getExpression();
        if (expr == null) {
            expr = (String)((IQueryItem)((Object)this.fmProperty)).getProperty("ID");
        }
        return MetadataUtil.extractExpressionFromModelString(expr);
    }

    @Override
    public synchronized Object getProperty(String propertyName) {
        return this.fmProperty.getProperty(propertyName);
    }

    public SetOfTables getInvolvedTables() {
        DMRCube dmrCube = (DMRCube)this.getDimension().getCube();
        CubeWrapper cubeWrapper = dmrCube.getModelCube();
        RQPPrePlan prePlan = cubeWrapper.getRQPPrePlanQuery();
        if (prePlan == null) {
            return new SetOfTables();
        }
        ArrayList<IMetadata> queryItems = new ArrayList<IMetadata>();
        queryItems.add(this.fmProperty);
        return PrePlanUtilities.getInvolvedTables(prePlan, queryItems, true);
    }

    public boolean isBusinessKey() {
        List<String> roles = this.fmProperty.getRoles();
        return roles != null && roles.contains(DMRLevel.BUSINESS_KEY);
    }

    public boolean isMemberCaption() {
        List<String> roles = this.fmProperty.getRoles();
        return roles != null && roles.contains(DMRLevel.MEMBER_CAPTION);
    }

    public boolean isV5LevelPropertyWrapper() {
        return this.fmProperty instanceof V5DataItemToLevelAttributeWrapper;
    }

    public IXQEQueryNode getBinaryExpression() {
        if (this.fmProperty instanceof V5DataItemToLevelAttributeWrapper) {
            return ((V5DataItemToLevelAttributeWrapper)this.fmProperty).getBinaryExpression();
        }
        return null;
    }

    public boolean isDynamicProperty() {
        return this.fmProperty instanceof LevelWrapper.DynamicPropertyWrapper;
    }
}

