/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultsets.md.CubicsDimensionalResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRPreloadCellsLogger;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategyPreCellLoading;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SelectQuery;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContext;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DMRProvider
extends Provider {
    private MDXLevelInfo queryLevelInformation = null;
    private List<IMeasure> referencedMeasures = null;
    private List<CogMDXDetailFilter> detailFilters = new ArrayList<CogMDXDetailFilter>();
    private MetadataConnection modelProvider = null;
    private DMRCube cube = null;
    protected DMRQueryStrategyPreCellLoading dummyQueryStrategey = new DMRQueryStrategyPreCellLoading();

    public MetadataConnection getModelProvider() {
        return this.modelProvider;
    }

    public void setModelProvider(MetadataConnection theModelProvider) {
        this.modelProvider = theModelProvider;
    }

    @Override
    public void connect() throws ProviderException {
    }

    @Override
    public String[] getCatalogs() throws ProviderException {
        String[] result = new String[]{};
        ArrayList<String> resultList = new ArrayList<String>();
        if (this.cube != null) {
            resultList.add(this.cube.getCatalogName());
        }
        result = resultList.toArray(new String[resultList.size()]);
        return result;
    }

    @Override
    public String[] getCubeNames(String catalogName) throws ProviderException {
        String[] result = new String[]{};
        ArrayList<String> resultList = new ArrayList<String>();
        if (this.cube != null && (catalogName == null || catalogName.length() == 0 || this.cube.getCatalogName().equals(catalogName))) {
            resultList.add(this.cube.getName());
        }
        result = resultList.toArray(new String[resultList.size()]);
        return result;
    }

    @Override
    public Cube getCube(String cubeName) throws ProviderException {
        if (this.cube != null && this.cube.getName().equals(cubeName)) {
            return this.cube;
        }
        return null;
    }

    @Override
    public Cube retrieveCube(String catalogName, String cubeName) throws ProviderException {
        if (this.cube != null && this.cube.getName().equals(cubeName) && this.cube.getCatalogName().equals(catalogName)) {
            return this.cube;
        }
        return null;
    }

    public void setCube(DMRCube dmrCube) {
        this.cube = dmrCube;
    }

    @Override
    public QueryStrategy getQueryStrategy() {
        if (this.dummyQueryStrategey.getInProcessOfPreCellLoading()) {
            return this.dummyQueryStrategey;
        }
        DMRQueryStrategy qs = new DMRQueryStrategy();
        qs.setPreLoadingStrategy(this.dummyQueryStrategey);
        return qs;
    }

    @Override
    public IExternalAggregateStrategy getExternalAggregateStrategy() {
        return new DMRExternalAggregateStrategy(this.cube);
    }

    public void setMDXQueryInfo(MDXLevelInfo levelInfo) {
        this.queryLevelInformation = levelInfo;
    }

    public MDXLevelInfo getMDXQueryInfo() {
        return this.queryLevelInformation;
    }

    public void setMeasureInfo(List<IMeasure> measures) {
        this.referencedMeasures = measures;
    }

    public List<IMeasure> getMeasureInfo() {
        return this.referencedMeasures;
    }

    public void setDetailFilters(List<CogMDXDetailFilter> theDetailFilters) {
        this.detailFilters = theDetailFilters;
    }

    public List<CogMDXDetailFilter> getDetailFilters() {
        return this.detailFilters;
    }

    @Override
    public boolean isResultSetCacheEnabled(ICube dmrCube) {
        return ((DMRCube)dmrCube).isResultSetCacheEnabled();
    }

    @Override
    public boolean isResultSetCacheable(MDXQuery mdxQuery, XDataContext dataContext, ICubeResultSet executedResultSet, long elapsedQueryTime) {
        if (executedResultSet instanceof CubicsDimensionalResultSet) {
            CubeContext context = this.cube.getCubeContext();
            if (context == null) {
                return false;
            }
            if (!context.checkParametersForResultCache(mdxQuery, dataContext)) {
                return false;
            }
            return !((CubicsDimensionalResultSet)executedResultSet).getResultSet().isEmpty();
        }
        return false;
    }

    @Override
    public ICubeResultSetCache getResultSetCache(ICube dmrCube) {
        return ((DMRCube)dmrCube).getResultSetCache();
    }

    @Override
    public Object getKeyBlockingSameMDXExecution(ICube theCube, MDXQuery mdxQuery, XDataContext dataContext) {
        if (!((DMRCube)theCube).getBlockingSameMDXExecution()) {
            return null;
        }
        CubeContext context = ((DMRCube)theCube).getCubeContext();
        if (context == null) {
            return null;
        }
        return context.makeCacheKey(theCube, mdxQuery, dataContext);
    }

    @Override
    public CountDownLatch getExistingGate(ICube theCube, Object cacheKey, CountDownLatch newGate) {
        CubeContext context = ((DMRCube)theCube).getCubeContext();
        if (context == null) {
            return null;
        }
        return context.getExistingGate(cacheKey, newGate);
    }

    @Override
    public boolean waitForCompleteOrTimeout(CountDownLatch gate) {
        boolean good = false;
        try {
            good = gate.await(2L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            good = false;
        }
        return good;
    }

    @Override
    public boolean isInProcessOfPreCellLoading() {
        return this.dummyQueryStrategey.getInProcessOfPreCellLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preLoadCellValues(SelectQuery query, InterpreterContext interpreterContext, MDXQuery mdxQuery) {
        DMRQueryStrategyPreCellLoading.log(mdxQuery, " check if preload is applicable.");
        int nSetting = DMRQueryStrategyPreCellLoading.getPreLoadCellsThreshold(this.cube, query, mdxQuery);
        if (nSetting <= 0) {
            DMRQueryStrategyPreCellLoading.log(mdxQuery, " preload is not applicable.");
            return;
        }
        List<CrossJoinedSet> allCJS = null;
        DMRQueryStrategyPreCellLoading.log(mdxQuery, " preload starts to collect tuples.");
        IExecutionEnvironment env = ExecutionEnvironmentContext.getExecutionEnvironment();
        XDataContext context = env.pushDataContext();
        try {
            this.enterPreCellLoading(nSetting);
            InterpreterContext clonedContext = new InterpreterContext(interpreterContext);
            clonedContext.setXDataContext(context);
            context.setInterpreterContext(clonedContext);
            clonedContext.setCalculationCache(new CalculationCache());
            clonedContext.setQueryStrategy(this.dummyQueryStrategey);
            ((CalculationEngine)clonedContext.getCalculationEngine()).setQueryStrategy(this.dummyQueryStrategey);
            SelectQuery clonedQuery = new SelectQuery(query, clonedContext.getCalculationEngine());
            clonedQuery.execute(clonedContext);
            allCJS = this.dummyQueryStrategey.getCrossJoinedSet();
        }
        catch (InterpreterException clonedContext) {
        }
        catch (OperationCanceledException clonedContext) {
        }
        catch (RequestCanceledException clonedContext) {
        }
        catch (RuntimeException clonedContext) {
        }
        finally {
            this.exitPreCellLoading();
            env.popDataContext(context);
        }
        if (allCJS == null) {
            DMRQueryStrategyPreCellLoading.log(mdxQuery, " preload fails to collect tuples.");
            return;
        }
        DMRQueryStrategy qs = null;
        try {
            qs = (DMRQueryStrategy)interpreterContext.getCalculationEngine().getQueryStrategy();
            if (qs != null) {
                DMRQueryStrategyPreCellLoading.logWithReportName(mdxQuery, " preload starts to load cells: ");
                this.dummyQueryStrategey.setPreloading(true);
                this.dummyQueryStrategey.setLoadLowestLevel(false);
                Governors governors = this.cube.getModelCube().getGovernors();
                Governors.DMRPreloadCellsExecutionMode executionMode = governors.getDMRPreloadCellsExecutionMode();
                RequestEnvironment requestEnvironment = (RequestEnvironment)env.getRequestEnvironment();
                int maxSeverityLevel = requestEnvironment.getMaxSeverityLevel();
                if (DMRPreloadCellsLogger.isPreloadLoggerOnAtInfoLevel() || maxSeverityLevel == 3) {
                    IMessageKey.Param1 messageKey = XQEMessageKeys.EXE_PreloadCellsGovernorValue;
                    Locale productLocale = XQEMessages.getCurrProductLocale();
                    String executionModeString = executionMode.toString();
                    String governorValueLogMessage = XQEMessages.getMessage(messageKey, productLocale, executionModeString);
                    if (DMRPreloadCellsLogger.isPreloadLoggerOnAtInfoLevel()) {
                        DMRPreloadCellsLogger.logToXQELog(governorValueLogMessage);
                    }
                    if (maxSeverityLevel == 3) {
                        ResponseMessage.ResponseMessageType msgType = ResponseMessage.ResponseMessageType.DMR_NODE_TYPE_INT;
                        ResponseMessage message = new ResponseMessage(msgType, governorValueLogMessage);
                        ResponseMessageFolder folder = requestEnvironment.getResponseMessageFolder();
                        folder.appendExecutionResponseMessage(message);
                    }
                }
                if (executionMode.equals((Object)Governors.DMRPreloadCellsExecutionMode.CONCURRENTLY)) {
                    qs.preloadCellValuesConcurrently(allCJS);
                } else {
                    for (CrossJoinedSet aCJS : allCJS) {
                        qs.execute(aCJS, null);
                    }
                }
                this.dummyQueryStrategey.setIsPreLoaded();
            }
            DMRQueryStrategyPreCellLoading.logWithReportName(mdxQuery, " preload finishes loading cells: ");
        }
        catch (InterpreterException e1) {
            DMRPreloadCellsLogger.logERRORToXQELog(e1);
            if (e1.getCause() != null) {
                DMRPreloadCellsLogger.logERRORToXQELog(e1.getCause());
            }
        }
        catch (OperationCanceledException oce1) {
            DMRPreloadCellsLogger.logERRORToXQELog(oce1);
            if (oce1.getCause() != null) {
                DMRPreloadCellsLogger.logERRORToXQELog(oce1.getCause());
            }
        }
        catch (RequestCanceledException rce1) {
            DMRPreloadCellsLogger.logERRORToXQELog(rce1);
            if (rce1.getCause() != null) {
                DMRPreloadCellsLogger.logERRORToXQELog(rce1.getCause());
            }
        }
        catch (RuntimeException re1) {
            DMRPreloadCellsLogger.logERRORToXQELog(re1);
            if (re1.getCause() != null) {
                DMRPreloadCellsLogger.logERRORToXQELog(re1.getCause());
            }
        }
        finally {
            this.dummyQueryStrategey.setLoadLowestLevel(true);
            this.dummyQueryStrategey.setPreloading(false);
        }
    }

    private void enterPreCellLoading(int limit) {
        this.dummyQueryStrategey.setLimit(limit);
        this.dummyQueryStrategey.setInProcessOfPreCellLoading(true);
    }

    private void exitPreCellLoading() {
        this.dummyQueryStrategey.setInProcessOfPreCellLoading(false);
        this.dummyQueryStrategey.clear();
    }
}

