/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueRuntimeException;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.function.ArgumentList;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.function.operator.Add;
import com.cognos.xqe.function.operator.Divide;
import com.cognos.xqe.function.operator.Multiply;
import com.cognos.xqe.function.operator.Negate;
import com.cognos.xqe.function.operator.Subtract;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.functions.IMDXFunctionProcessor;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;

public class MDXMathOperatorProcessorRelationalOperator
implements IMDXFunctionProcessor {
    protected Value[] values;
    protected int opCode;

    @Override
    public void setFunctionCode(int op, int parameterSize) {
        this.opCode = op;
        this.values = new Value[parameterSize];
        for (int i = 0; i < parameterSize; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public Object addParameter(InterpreterContext interpreterContext, Object value) {
        if (this.values[0] == null) {
            this.values[0] = (Value)value;
        } else {
            this.values[1] = (Value)value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getResult(InterpreterContext interpreterContext) {
        IDataType[] oDataTypes = new IDataType[this.values.length];
        oDataTypes[0] = this.values[0].getDataType();
        if (this.values.length > 1) {
            oDataTypes[1] = this.values[1].getDataType();
        }
        IDataType retType = null;
        ArgumentList args = new ArgumentList();
        args.set(this.values);
        ScalarFunction op = null;
        if (this.opCode == 20) {
            op = new Add();
        } else if (this.opCode == 22) {
            op = new Subtract();
        } else if (this.opCode == 26) {
            op = new Multiply();
        } else if (this.opCode == 24) {
            op = new Divide();
        } else if (this.opCode == -1) {
            op = new Negate();
        }
        if (!op.validArgumentTypes(oDataTypes)) {
            return TextValue.ERROR_VALUE;
        }
        retType = op.getResultDataType(oDataTypes);
        if (retType == null) {
            return TextValue.ERROR_VALUE;
        }
        XDataContext context = interpreterContext.getXDataContext().getEnvironment().pushDataContext();
        IValue v = retType.createValue();
        try {
            op.execute(context, (IParameterEvaluator)args, v);
        }
        catch (ValueRuntimeException e) {
            IMessageKey k = e.getMessageKey();
            if (k == XQEMessageKeys.DAT_DivisionByZero) {
                ((Value)v).setState(ValueState.DIV_BY_ZERO);
            } else if (k == XQEMessageKeys.DAT_DecimalOverflowError) {
                ((Value)v).setState(ValueState.OVERFLOW);
            } else {
                v = TextValue.ERROR_VALUE;
            }
        }
        finally {
            if (null != context) {
                interpreterContext.getXDataContext().getEnvironment().popDataContext(context);
            }
        }
        return v;
    }
}

