/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRProperty;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.RelationalCrosstabCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.DMRLevelMemberLoader;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RelationalCrosstabRowHandler
implements RSAPIRowCallback {
    private static final String ROLLUPSCOPE = "externalRollUpScopes";
    private List<Level> lowestLevelInDimension;
    private List<IMember> measures;
    private IMember[] currentMembers;
    private Map<IMetadata, Integer> columnMap = new HashMap<IMetadata, Integer>();
    private IMember[] scopeMembers;
    private Map<IMember, Integer> measureToColumn = new HashMap<IMember, Integer>();
    private int countOfRun = 1;
    private boolean hasRollUp = false;
    private int currentRowNum = 0;
    private boolean hasCells = false;
    private List<Tuple> allTuples = null;
    private List<List<Value>> allValues = null;
    private RelationalCrosstabCube parentCube = null;
    private HashMap<ILevel, HashMap<ArrayList<Value>, DMRMember>> cahcedDMRMembers = null;
    private HashMap<IHierarchy, List<ILevel>> dummyRollUps = null;
    private HashMap<IHierarchy, Integer> tempHierSet = null;
    private ArrayList<ILevel> tempBaseLevels = null;
    private ArrayList<ILevel> tempCurrentLevels = null;
    private ArrayList<ILevel> tempRollUpLevels = null;

    public RelationalCrosstabRowHandler(XMdxLocal xmdxlocal, RelationalCrosstabCube cube, List<Level> lowestLevels, List<IMember> measuresList, HashMap<ILevel, HashMap<ArrayList<Value>, DMRMember>> cachedMember) {
        this.cahcedDMRMembers = cachedMember;
        this.parentCube = cube;
        this.lowestLevelInDimension = lowestLevels;
        this.measures = measuresList;
        this.currentMembers = new IMember[lowestLevels.size()];
        this.initializeRootMembers();
        this.initializeColumnMappings();
        for (IMember measure : this.measures) {
            String column = (String)measure.getProperty("expression");
            if (column != null) {
                this.measureToColumn.put(measure, Integer.parseInt(column));
                this.hasCells = true;
            }
            if (measure.getProperty(ROLLUPSCOPE) == null) continue;
            this.hasRollUp = true;
            this.hasCells = true;
        }
        this.scopeMembers = new IMember[this.currentMembers.length];
        if (this.parentCube.getStorageType() == 1 && this.hasCells) {
            this.allTuples = new ArrayList<Tuple>();
            if (!this.hasRollUp) {
                this.allValues = new ArrayList<List<Value>>();
            }
        }
        this.initializeLevelsForDummyRollups(xmdxlocal);
    }

    private void initializeColumnMappings() {
        for (int i = 0; i < this.lowestLevelInDimension.size(); ++i) {
            Level aLevel;
            if (i == this.parentCube.getMeasureDimensionIndex()) continue;
            for (Level currentLevel = aLevel = this.lowestLevelInDimension.get(i); currentLevel != null; currentLevel = (Level)currentLevel.getPreviousLevel()) {
                String columnStr = (String)currentLevel.getProperty("expression");
                if (columnStr != null) {
                    this.columnMap.put(currentLevel, Integer.parseInt(columnStr));
                }
                List<IProperty> memberProperties = currentLevel.getMemberProperties();
                for (IProperty property : memberProperties) {
                    columnStr = (String)property.getProperty("expression");
                    this.columnMap.put(property, Integer.parseInt(columnStr));
                }
            }
        }
    }

    private void initializeRootMembers() {
        for (int i = 0; i < this.lowestLevelInDimension.size(); ++i) {
            if (i == this.parentCube.getMeasureDimensionIndex()) continue;
            Level lowestLevel = this.lowestLevelInDimension.get(i);
            Level rootLevel = lowestLevel.getIndex() == 0 ? lowestLevel : (Level)lowestLevel.getHierarchy().getLevel(0);
            DMRMember rootMember = (DMRMember)rootLevel.getMember(0);
            rootMember.setGotAllChildren();
            this.currentMembers[i] = rootMember;
        }
    }

    private void initializeLevelsForDummyRollups(XMdxLocal xmdxlocal) {
        IXQEQueryNode[] edges;
        if (this.parentCube == null) {
            return;
        }
        if (xmdxlocal == null) {
            return;
        }
        MDXQuery mq = xmdxlocal.getMDXQuery();
        if (mq == null) {
            return;
        }
        for (IXQEQueryNode e : edges = mq.getChildrenOfType(1006)) {
            List<ILevel> lst;
            List<ILevel> levels;
            IHierarchy lastHier;
            MDXHierInfo hier;
            List<IHierarchy> projHiers;
            MDXEdge mdxEdge = (MDXEdge)e;
            if (!mdxEdge.getMDXNonEmptyProperty() || (projHiers = (hier = mdxEdge.getHierarchyInfo()).getProjectedHierarchies()).size() < 2 || (lastHier = projHiers.get(projHiers.size() - 1)).getDimension().isMeasuresDimension() || (levels = lastHier.getLevels()).size() <= 2) continue;
            if (this.dummyRollUps == null) {
                this.dummyRollUps = new HashMap();
            }
            if ((lst = this.dummyRollUps.get(lastHier)) == null) {
                lst = new ArrayList<ILevel>();
                this.dummyRollUps.put(lastHier, lst);
            }
            for (int i = 1; i < levels.size() - 1; ++i) {
                lst.add(levels.get(i));
            }
        }
        if (this.dummyRollUps != null) {
            this.tempHierSet = new HashMap();
            this.tempBaseLevels = new ArrayList();
            this.tempCurrentLevels = new ArrayList();
            this.tempRollUpLevels = new ArrayList();
        }
    }

    @Override
    public boolean reRun() {
        this.currentRowNum = 0;
        if (this.countOfRun == 1) {
            int i = 0;
            for (i = 0; i < this.lowestLevelInDimension.size(); ++i) {
                Level currentLevel;
                if (i == this.parentCube.getMeasureDimensionIndex()) continue;
                Level level = this.lowestLevelInDimension.get(i);
                Level rootLevel = currentLevel = (Level)level.getHierarchy().getLevel(0);
                int nLevels = 0;
                while (currentLevel != null) {
                    currentLevel.setGotAllMembers();
                    currentLevel = (DMRLevel)currentLevel.getNextLevel();
                    ++nLevels;
                }
                if (nLevels <= 2) continue;
                DMRLevelMemberLoader.sortMembersInHierarchyOrder(rootLevel, null);
            }
            if (this.parentCube.getStorageType() != 1) {
                return false;
            }
            this.parentCube.buildDimensionMemberSize();
            if (!this.hasRollUp) {
                this.buildInMemoryCellMap();
                this.parentCube.fixStorage();
                return false;
            }
            this.parentCube.createSortedMembers();
            ++this.countOfRun;
            return true;
        }
        this.parentCube.fixStorage();
        this.allTuples.clear();
        return false;
    }

    @Override
    public boolean needReIterateRows() {
        if (this.parentCube.getStorageType() != 1) {
            return false;
        }
        return this.hasRollUp;
    }

    protected void buildInMemoryCellMap() {
        if (!this.hasCells) {
            return;
        }
        ArrayList<IMember> requiredMeasures = new ArrayList<IMember>();
        for (IMember measure : this.measures) {
            if (!this.measureToColumn.containsKey(measure)) continue;
            requiredMeasures.add(measure);
        }
        for (int i = 0; i < this.allTuples.size(); ++i) {
            Tuple t = this.allTuples.get(i);
            List<Value> values = this.allValues.get(i);
            for (int j = 0; j < requiredMeasures.size(); ++j) {
                Value v = values.get(j);
                if (v == null) continue;
                IMember[] members = t.getMembers();
                members[this.parentCube.getMeasureDimensionIndex()] = (IMember)requiredMeasures.get(j);
                this.parentCube.addValueToCellMap(members, v, false);
            }
        }
        this.allTuples.clear();
        this.allValues.clear();
    }

    @Override
    public void consumeRow(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIDs) {
        if (this.countOfRun == 1) {
            this.firstRun(row, columns, formatIDs);
        } else {
            this.secondRun(row, columns, formatIDs);
        }
        ++this.currentRowNum;
    }

    protected void firstRun(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIDs) {
        Value v = null;
        for (int i = 0; i < this.lowestLevelInDimension.size(); ++i) {
            Level aLevel;
            Integer columnNum;
            if (i == this.parentCube.getMeasureDimensionIndex() || (columnNum = this.columnMap.get(aLevel = this.lowestLevelInDimension.get(i))) == null) continue;
            IHierarchy hierarchy = aLevel.getHierarchy();
            List<ILevel> allLevels = hierarchy.getLevels();
            IMember parentMember = null;
            for (ILevel level : allLevels) {
                if (parentMember == null) {
                    parentMember = ((Level)level).getMember(0);
                    continue;
                }
                columnNum = this.columnMap.get(level);
                v = (Value)row.getColumn(columnNum);
                v.setFormatId(formatIDs[columnNum]);
                parentMember = this.addNewMember(v, (Level)level, parentMember);
                List<IProperty> memberProperties = level.getMemberProperties();
                for (IProperty property : memberProperties) {
                    columnNum = this.columnMap.get(property);
                    v = (Value)row.getColumn(columnNum);
                    v.setFormatId(formatIDs[columnNum]);
                    ((DMRMember)parentMember).setProperty(property.getUniqueName(), v.copy());
                    IDataType propDT = property.getDataType();
                    if (propDT != null || v.getDataType() == null) continue;
                    ((DMRProperty)property).setDataType(v.getDataType());
                }
            }
            this.currentMembers[i] = parentMember;
        }
        List<Value> measureValues = null;
        if (this.parentCube.getStorageType() != 1 || !this.hasRollUp) {
            measureValues = this.loadCellValuesToMemory(row, columns, formatIDs);
        }
        if (this.parentCube.getStorageType() == 1 && this.hasCells) {
            if (!this.hasRollUp) {
                this.allValues.add(measureValues);
            }
            IMember[] nm = new IMember[this.currentMembers.length];
            System.arraycopy(this.currentMembers, 0, nm, 0, this.currentMembers.length);
            nm[this.parentCube.getMeasureDimensionIndex()] = null;
            this.allTuples.add(new Tuple(nm, false));
        }
    }

    protected List<Value> loadCellValuesToMemory(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIDs) {
        ArrayList<Value> measureValuesRtn = null;
        Value v = null;
        if (this.parentCube.getStorageType() == 1 && !this.hasRollUp) {
            measureValuesRtn = new ArrayList<Value>();
        }
        for (IMember measure : this.measures) {
            if (this.measureToColumn.containsKey(measure)) {
                int measureColumn = this.measureToColumn.get(measure);
                v = (Value)row.getColumn(measureColumn);
                if (v == null || v.isNull()) {
                    boolean hasNullFormatting = this.hasNullFormatting(formatIDs, measureColumn);
                    if (v == null || !hasNullFormatting) {
                        if (this.parentCube.getStorageType() != 1 || this.hasRollUp) continue;
                        measureValuesRtn.add(null);
                        continue;
                    }
                }
                v.setFormatId(formatIDs[measureColumn]);
                this.currentMembers[this.parentCube.getMeasureDimensionIndex()] = measure;
                if (this.parentCube.getStorageType() == 0) {
                    IMember[] nm = new IMember[this.currentMembers.length];
                    System.arraycopy(this.currentMembers, 0, nm, 0, this.currentMembers.length);
                    Value nv = (Value)v.copy();
                    this.parentCube.getAllCells().add(new TupleValue(new Tuple(nm), new Cell(nv)));
                    continue;
                }
                if (this.parentCube.getStorageType() != 1 || this.hasRollUp) continue;
                measureValuesRtn.add((Value)v.copy());
                continue;
            }
            this.currentMembers[this.parentCube.getMeasureDimensionIndex()] = measure;
        }
        return measureValuesRtn;
    }

    private boolean hasNullFormatting(FormatId[] formatIDs, int measureColumn) {
        boolean hasNullFormatting = false;
        FormatId formatId = formatIDs[measureColumn];
        FormatService formatService = FormatService.getInstance();
        String format = formatService.retrieveFormatString(formatId);
        if (format != null && format.contains("whenMissing")) {
            hasNullFormatting = true;
        }
        return hasNullFormatting;
    }

    protected void secondRun(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIDs) {
        Value v = null;
        for (IMember measure : this.measures) {
            int colPos;
            HashMap rollUp;
            Tuple t = this.allTuples.get(this.currentRowNum);
            IMember[] members = null;
            if (this.measureToColumn.containsKey(measure)) {
                int measureColumn = this.measureToColumn.get(measure);
                v = (Value)row.getColumn(measureColumn);
                if (v == null || v.isNull()) {
                    boolean hasNullFormatting = this.hasNullFormatting(formatIDs, measureColumn);
                    if (v == null || !hasNullFormatting) continue;
                }
                v.setFormatId(formatIDs[measureColumn]);
                Value nv = (Value)v.copy();
                members = t.getMembers();
                members[this.parentCube.getMeasureDimensionIndex()] = measure;
                this.parentCube.addValueToCellMap(members, nv, false);
            }
            if ((rollUp = (HashMap)measure.getProperty(ROLLUPSCOPE)) == null) continue;
            members = t.getMembers();
            System.arraycopy(members, 0, this.currentMembers, 0, members.length);
            this.currentMembers[this.parentCube.getMeasureDimensionIndex()] = measure;
            for (Map.Entry e : rollUp.entrySet()) {
                Tuple tp;
                colPos = Integer.parseInt((String)e.getValue());
                v = (Value)row.getColumn(colPos);
                if (v == null || v.isNull()) {
                    boolean hasNullFormatting = this.hasNullFormatting(formatIDs, colPos);
                    if (v == null || !hasNullFormatting) continue;
                }
                if ((tp = this.getRollUpTuple((ArrayList)e.getKey())) == null || this.parentCube.tupleExist(tp.getMembers())) continue;
                v.setFormatId(formatIDs[colPos]);
                Value nv = (Value)v.copy();
                IMember[] membersInScope = tp.getMembers();
                this.parentCube.addValueToCellMap(membersInScope, nv, true);
            }
            if (this.dummyRollUps == null) continue;
            for (Map.Entry e : rollUp.entrySet()) {
                colPos = Integer.parseInt((String)e.getValue());
                v = (Value)row.getColumn(colPos);
                if (v == null || v.isNull()) continue;
                this.doDummyRollUps((ArrayList)e.getKey());
            }
        }
    }

    private void doDummyRollUps(ArrayList<ILevel> scope) {
        this.tempHierSet.clear();
        for (int i = 0; i < scope.size(); ++i) {
            IHierarchy h = scope.get(i).getHierarchy();
            if (!this.dummyRollUps.containsKey(h)) continue;
            this.tempHierSet.put(h, i);
        }
        if (this.tempHierSet.isEmpty()) {
            return;
        }
        this.tempBaseLevels.clear();
        this.tempBaseLevels.addAll(scope);
        for (Map.Entry<IHierarchy, Integer> e : this.tempHierSet.entrySet()) {
            int pos = e.getValue();
            this.tempCurrentLevels.clear();
            this.tempCurrentLevels.addAll(this.tempBaseLevels);
            this.tempRollUpLevels.clear();
            for (ILevel rollLevel : this.dummyRollUps.get(e.getKey())) {
                if (rollLevel.getIndex() >= scope.get(pos).getIndex()) continue;
                this.tempRollUpLevels.add(rollLevel);
            }
            for (ILevel rollLvl : this.tempRollUpLevels) {
                this.tempCurrentLevels.set(pos, rollLvl);
                Tuple tp = this.getRollUpTuple(this.tempCurrentLevels);
                if (tp == null || this.parentCube.tupleExist(tp.getMembers())) continue;
                IMember[] membersInScope = tp.getMembers();
                this.parentCube.addValueToCellMap(membersInScope, IntegerValue.ONE, true);
            }
        }
    }

    protected Tuple getRollUpTuple(ArrayList<ILevel> scope) {
        for (int i = 0; i < this.currentMembers.length; ++i) {
            if (i == this.parentCube.getMeasureDimensionIndex()) {
                this.scopeMembers[i] = this.currentMembers[i];
                continue;
            }
            IMember scopeMemebr = null;
            IMember currentMember = null;
            ILevel scopeLevel = this.getScopeLevel(scope, this.currentMembers[i].getLevel().getHierarchy());
            if (scopeLevel == null) {
                currentMember = this.currentMembers[i];
                while (currentMember.getParent() != null) {
                    currentMember = currentMember.getParent();
                }
                scopeMemebr = currentMember;
            } else {
                currentMember = this.currentMembers[i];
                while (!currentMember.getLevel().equals(scopeLevel)) {
                    if ((currentMember = currentMember.getParent()) != null) continue;
                    return null;
                }
                scopeMemebr = currentMember;
            }
            this.scopeMembers[i] = scopeMemebr;
        }
        return new Tuple(this.scopeMembers);
    }

    protected ILevel getScopeLevel(ArrayList<ILevel> scope, IHierarchy hier) {
        for (ILevel level : scope) {
            if (!level.getHierarchy().equals(hier)) continue;
            return level;
        }
        return null;
    }

    private DMRMember addNewMember(Value v, Level level, IMember parentMember) {
        HashMap<Object, Object> mp;
        DMRMember member;
        Value keyValueCopy = (Value)v.copy();
        keyValueCopy.setFormatId(FormatId.INVALID_FORMAT_FID);
        String businessKeyText = keyValueCopy.getV5formattedString();
        if (keyValueCopy.isNull()) {
            businessKeyText = "";
        }
        if ((member = (DMRMember)parentMember.getChildMember(businessKeyText)) != null) {
            return member;
        }
        Value captionValue = (Value)v.copy();
        ILevel lvl = null;
        ArrayList<Value> k = null;
        if (this.cahcedDMRMembers != null && (lvl = (ILevel)this.parentCube.getWrapped(level)) != null && this.cahcedDMRMembers.containsKey(lvl)) {
            k = new ArrayList<Value>();
            k.add(keyValueCopy);
            this.getKeyValues(k, parentMember);
            mp = this.cahcedDMRMembers.get(lvl);
            if (mp.containsKey(k)) {
                DMRMember existM = (DMRMember)mp.get(k);
                member = new DMRMember(existM.getName(), existM.getCaption(), existM.getCaptionValue(), existM.getBusinessKeyValue(), level);
            }
        }
        if (member == null) {
            member = new DMRMember(captionValue, keyValueCopy, level);
            if (lvl != null) {
                if (k == null) {
                    k = new ArrayList();
                    k.add(keyValueCopy);
                    this.getKeyValues(k, parentMember);
                }
                mp = null;
                if (this.cahcedDMRMembers.containsKey(lvl)) {
                    mp = this.cahcedDMRMembers.get(lvl);
                } else {
                    mp = new HashMap();
                    this.cahcedDMRMembers.put(lvl, mp);
                }
                mp.put(k, member);
            }
        }
        member.setGotAllChildren();
        ((DMRMember)parentMember).addMemberToChildrenOrderedMap(member);
        member.setParentMember(parentMember);
        level.addMember(member);
        return member;
    }

    private void getKeyValues(ArrayList k, IMember parentMember) {
        DMRMember m = (DMRMember)parentMember;
        boolean pos = true;
        while (m.getParent() != null) {
            k.add(m.getBusinessKeyValue());
            m = (DMRMember)m.getParent();
        }
    }
}

