/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.data.values.MemberRSAPIValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIQueryResult;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.LoadDMRCubeSingleV5Query;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.IOrderedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DMRSecondaryLevelMemberLoader {
    private static final String DYNAMIC = "dynamic";
    private DMRLevel primaryDMRLevel;
    private List<DMRLevel> primaryDMRLevels = new ArrayList<DMRLevel>();

    public DMRSecondaryLevelMemberLoader(DMRLevel levelToLoad) {
        this.primaryDMRLevel = levelToLoad;
    }

    public IMember generateDummyMember() {
        IMemberCubics root = (IMemberCubics)this.primaryDMRLevel.getHierarchy().getLevel(0).getMembers().get(0);
        for (DMRLevel aLevel = this.primaryDMRLevel; aLevel != null && !aLevel.isRootLevel(); aLevel = (DMRLevel)aLevel.getPreviousLevel()) {
            this.primaryDMRLevels.add(aLevel);
        }
        Collections.reverse(this.primaryDMRLevels);
        IMemberCubics currentParent = root;
        IMemberCubics currentMember = null;
        for (DMRLevel currentLevel : this.primaryDMRLevels) {
            Value businessKey = DMRMember.DEFAULT_BUSINESSKEY;
            Value memberName = DMRMember.DEFAULT_BUSINESSKEY;
            currentMember = (IMemberCubics)currentParent.searchChildrenOrderedMap("");
            if (currentMember == null) {
                currentMember = new DMRMember(memberName, (Value)businessKey.copy(), currentLevel);
                currentParent.addMemberToChildrenOrderedMap(currentMember);
                if (currentParent instanceof IDMRMember) {
                    ((IDMRMember)currentParent).addChildToBusinessKeyMap((IDMRMember)currentMember);
                }
                currentMember.setParentMember(currentParent);
            }
            currentParent = currentMember;
        }
        return (DMRMember)currentMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        DMRSecondaryMemberLoadQuery query = new DMRSecondaryMemberLoadQuery();
        for (DMRLevel currentLevel = this.primaryDMRLevel; currentLevel != null && !currentLevel.isRootLevel(); currentLevel = (DMRLevel)currentLevel.getPreviousLevel()) {
            this.primaryDMRLevels.add(currentLevel);
        }
        Collections.reverse(this.primaryDMRLevels);
        for (ILevel iLevel : this.primaryDMRLevels) {
            query.addColumn(iLevel);
        }
        query.dynamicStarting = this.primaryDMRLevels.size();
        V5ProviderQueryResult v5Result = query.execute(null);
        RSAPIQueryResult rSAPIQueryResult = v5Result.getRSAPIQueryResult();
        try {
            MembersResultHandler resultHandler = new MembersResultHandler(query);
            rSAPIQueryResult.iterateResult(resultHandler);
        }
        finally {
            rSAPIQueryResult.release();
            v5Result = null;
        }
    }

    private final class MembersResultHandler
    implements RSAPIRowCallback {
        private DMRSecondaryMemberLoadQuery loadQuery;

        private MembersResultHandler(DMRSecondaryMemberLoadQuery query) {
            this.loadQuery = query;
        }

        @Override
        public boolean reRun() {
            return false;
        }

        @Override
        public boolean needReIterateRows() {
            return false;
        }

        @Override
        public void consumeRow(RSAPIRow row, RSAPIColumn[] columns, FormatId[] formatIds) {
            DMRMember primaryMember = this.getExistingPrimaryMember(row, formatIds);
            if (primaryMember != null) {
                int[] starting = new int[]{this.loadQuery.dynamicStarting};
                for (int i = 0; i < this.loadQuery.dynamicProps.size(); ++i) {
                    DMRMember secondaryMember = this.getSecondaryMember(starting, row, formatIds, (List)this.loadQuery.dynamicLevelGroups.get(i), (IMemberCubics)this.loadQuery.roots.get(i));
                    if (secondaryMember == null) continue;
                    primaryMember.setProperty((String)this.loadQuery.dynamicProps.get(i), secondaryMember);
                }
            }
        }

        private Value normalizeBKValue(Value value, FormatId idModel, FormatId idResult, String[] rtName) {
            if (value == null) {
                value = DMRMember.DEFAULT_BUSINESSKEY;
            }
            if (idModel != null) {
                value.setFormatId(idModel);
            }
            if (value.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                value.setFormatId(idResult);
            }
            Value[] rtBusinessKey = new Value[]{null};
            rtName[0] = DMRMember.convertBusinessKeyToDMRMemberName(value, rtBusinessKey);
            if (rtBusinessKey[0] != null) {
                value = rtBusinessKey[0];
            }
            if (value instanceof MemberRSAPIValue) {
                rtName[0] = DMRMember.convertBusinessKeyToDMRMemberName(((MemberRSAPIValue)value).getBusinessKeyValue(), null);
            }
            return value;
        }

        private DMRMember getExistingPrimaryMember(RSAPIRow row, FormatId[] formatIds) {
            IMemberCubics currentParent = this.loadQuery.rootMember;
            IMemberCubics currentMember = null;
            for (int j = 0; j < DMRSecondaryLevelMemberLoader.this.primaryDMRLevels.size(); ++j) {
                String[] memberNameKey = new String[]{null};
                this.normalizeBKValue((Value)row.getColumn(j), ((DMRLevel)DMRSecondaryLevelMemberLoader.this.primaryDMRLevels.get(j)).getBusinessKeyFormatId(), formatIds[j], memberNameKey);
                currentMember = (IMemberCubics)currentParent.searchChildrenOrderedMap(memberNameKey[0]);
                if (currentMember == null) {
                    return null;
                }
                currentParent = currentMember;
            }
            return (DMRMember)currentMember;
        }

        private DMRMember getSecondaryMember(int[] st, RSAPIRow row, FormatId[] formatIds, List<DMRLevel> lvls, IMemberCubics rt) {
            IMemberCubics currentParent = rt;
            IMemberCubics currentMember = null;
            for (int j = 0; j < lvls.size(); ++j) {
                DMRLevel currentLevel = lvls.get(j);
                String[] memberNameKey = new String[]{null};
                Value businessKey = this.normalizeBKValue((Value)row.getColumn(st[0]), currentLevel.getBusinessKeyFormatId(), formatIds[st[0]], memberNameKey);
                st[0] = st[0] + 1;
                Value memberName = null;
                if (currentLevel.needCaptionWhenLoadMembers()) {
                    memberName = (Value)row.getColumn(st[0]);
                    FormatId captionId = currentLevel.getCaptionFormatId();
                    if (captionId != null) {
                        memberName.setFormatId(captionId);
                    }
                    if (memberName.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                        memberName.setFormatId(formatIds[st[0]]);
                    }
                    st[0] = st[0] + 1;
                } else {
                    memberName = (Value)businessKey.copy();
                    memberName.setFormatId(businessKey.getFormatId());
                }
                currentMember = (IMemberCubics)currentParent.searchChildrenOrderedMap(memberNameKey[0]);
                if (currentMember == null) {
                    memberName = (Value)memberName.copy();
                    currentMember = new DMRMember(memberName, (Value)businessKey.copy(), currentLevel);
                    currentParent.addMemberToChildrenOrderedMap(currentMember);
                    if (currentParent instanceof IDMRMember) {
                        ((IDMRMember)currentParent).addChildToBusinessKeyMap((IDMRMember)currentMember);
                    }
                    currentMember.setParentMember(currentParent);
                }
                currentParent = currentMember;
            }
            return (DMRMember)currentMember;
        }
    }

    private final class DMRSecondaryMemberLoadQuery
    extends V5QueryOverTabularStream {
        private IMemberCubics rootMember;
        private int dynamicStarting;
        private List<String> dynamicProps;
        private List<List<DMRLevel>> dynamicLevelGroups;
        private List<IMemberCubics> roots;
        private int columnIdx;

        private DMRSecondaryMemberLoadQuery() {
            super((DMRCube)DMRSecondaryLevelMemberLoader.this.primaryDMRLevel.getDimension().getCube(), DMRUtilities.SubqueryType.LOAD_LEVELS, "LoadSecondaryLevels_" + DMRUtilities.getMetadataNameForLog(DMRSecondaryLevelMemberLoader.this.primaryDMRLevel), DMRUtilities.SubqueryType.LOAD_LEVELS.toString());
            this.dynamicStarting = 0;
            this.dynamicProps = new ArrayList<String>();
            this.dynamicLevelGroups = new ArrayList<List<DMRLevel>>();
            this.roots = new ArrayList<IMemberCubics>();
            this.columnIdx = 0;
            this.rootMember = this.getRootMember(DMRSecondaryLevelMemberLoader.this.primaryDMRLevel);
        }

        private IMemberCubics getRootMember(DMRLevel lvl) {
            return (IMemberCubics)lvl.getHierarchy().getLevel(0).getMembers().get(0);
        }

        @Override
        protected boolean needLoadCaption(DMRLevel level) {
            return false;
        }

        @Override
        protected boolean loadDynamicProperty(XQENodeFactory nodeFactory, DMRLevel level, IXQEQueryNode selection, IXQEQueryNode groupBody) {
            if (!level.equals(DMRSecondaryLevelMemberLoader.this.primaryDMRLevel)) {
                return true;
            }
            List<IProperty> props = DMRSecondaryLevelMemberLoader.this.primaryDMRLevel.getFMLevel().getMemberProperties();
            for (IProperty p : props) {
                if (!(p instanceof LevelWrapper.DynamicPropertyWrapper)) continue;
                ILevel secondaryLevel = ((LevelWrapper.DynamicPropertyWrapper)p).getWrappedLevel();
                this.dynamicProps.add(p.getUniqueName());
                ArrayList<DMRLevel> lvlGrp = new ArrayList<DMRLevel>();
                this.dynamicLevelGroups.add(lvlGrp);
                ArrayList<ILevel> levels = new ArrayList<ILevel>();
                ILevel currentLevel = secondaryLevel;
                while (!currentLevel.isRootLevel()) {
                    levels.add(currentLevel);
                    currentLevel = currentLevel.getPreviousLevel();
                }
                Collections.reverse(levels);
                IMemberCubics rt = null;
                for (ILevel lvl : levels) {
                    DMRLevel dmrLevel = (DMRLevel)this.cube.getWrapper(lvl);
                    lvlGrp.add(dmrLevel);
                    this.addDataItem(nodeFactory, dmrLevel, selection, groupBody, dmrLevel.getQueryItemExpressionForKey());
                    if (dmrLevel.needCaptionWhenLoadMembers()) {
                        this.addDataItem(nodeFactory, dmrLevel, selection, groupBody, dmrLevel.getQueryItemExpressionForCaption());
                    }
                    if (rt != null) continue;
                    rt = this.getRootMember(dmrLevel);
                }
                this.roots.add(rt);
            }
            return true;
        }

        private void addDataItem(XQENodeFactory nodeFactory, DMRLevel level, IXQEQueryNode selection, IXQEQueryNode groupBody, String sExpr) {
            IXQEQueryNode dataItem = nodeFactory.createNode(101003);
            dataItem.setPropertyValue("aggregate", "minimum");
            String dataItemName = DMRSecondaryLevelMemberLoader.DYNAMIC + this.columnIdx++;
            dataItem.setPropertyValue("name", dataItemName);
            selection.addChild(dataItem);
            IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", dataItemName);
            groupBody.addChild(dataItemRef);
            IXQEQueryNode expression = nodeFactory.createNode(101004);
            expression.setPropertyValue("expression", sExpr);
            MetadataContext c = level.getMetadataContext();
            if (c != null) {
                expression.setPropertyValue("metadataContext", c);
            }
            dataItem.addChild(expression);
            dataItem.setPropertyValue("lookup", Boolean.TRUE);
        }

        @Override
        protected void generateFilters(IXQEQueryNode query, PlanningEnvironment planningEnv, XQENodeFactory nodeFactory) {
            AbstractV5BooleanExpression filterExpr = null;
            IOrderedMap<IMember> existMembers = DMRSecondaryLevelMemberLoader.this.primaryDMRLevel.getMembersNoBlock();
            int maxMmembersAllowed = ((DMRCube)DMRSecondaryLevelMemberLoader.this.primaryDMRLevel.getDimension().getCube()).getMaxMembersInSubQueryDetailFilter();
            if (existMembers.size() > maxMmembersAllowed) {
                LoadDMRCubeSingleV5Query.logSingleLoading(DMRSecondaryLevelMemberLoader.this.primaryDMRLevel.getName(), " 's members are not added when loading secondary memebrs because the size exceeds ", Integer.toString(maxMmembersAllowed));
                return;
            }
            filterExpr = DMRUtilities.createINExpressionForMembers(planningEnv, existMembers.toArrayList());
            if (filterExpr != null) {
                V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
                detailFilter.setPostAutoAggregation(false);
                detailFilter.addChild(filterExpr);
                query.addChild(detailFilter);
            }
        }
    }
}

