/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5;

import com.cognos.xqe.runtree.olap.mdx.interpreter.XQEInfoData;
import com.cognos.xqe.util.StringSubstitutionEngine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class V5ConnectionInfo
extends XQEInfoData {
    private final String passport;
    private List<String> connectionParameters;

    public static V5ConnectionInfo getNewInstance(Locale locale) {
        return new V5ConnectionInfo(locale);
    }

    private V5ConnectionInfo(Locale theLocale) {
        this.locale = theLocale;
        this.passport = "";
        this.connectionParameters = null;
    }

    public void addConnectionParameter(String name, String value) {
        if (this.connectionParameters == null) {
            this.connectionParameters = new ArrayList<String>();
        }
        String escapedValue = StringSubstitutionEngine.escapeString(value);
        this.connectionParameters.add("<" + name + " value=\"" + escapedValue + "\"/>");
    }

    public void addConnectionParameter(String xml) {
        if (this.connectionParameters == null) {
            this.connectionParameters = new ArrayList<String>();
        }
        this.connectionParameters.add(xml);
    }

    public void clearConnectionParameters() {
        this.connectionParameters = null;
    }

    public String getConnectionParametersXML() {
        StringBuilder xmlBuffer = new StringBuilder();
        if (this.connectionParameters != null) {
            Iterator<String> it = this.connectionParameters.iterator();
            while (it.hasNext()) {
                xmlBuffer.append(it.next());
            }
        }
        return xmlBuffer.toString();
    }

    public String getCAMPassport() {
        return this.passport;
    }
}

