/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateCombinationRule;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateSelection;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Combination;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Selection;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SingleHierarchySimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AggregateCombination
extends Combination {
    private static final int LEVEL_1_POSITION = 3;

    public IMeasure getMeasure() {
        List<IMember> measures = this.getMeasures();
        if (measures.isEmpty()) {
            return null;
        }
        return (IMeasure)measures.get(0);
    }

    private IMember getResolvedMember(AggregateCombinationRule rule, IMember mem) {
        DMRLevel scopeLevel = V5QueryOverTabularStream.getLowestLevelFromScope(this.getMeasure(), mem.getLevel());
        int scopeLevelIdx = scopeLevel.getIndex();
        IMember childMember = mem;
        for (int currentLevelIdx = mem.getLevel().getIndex(); currentLevelIdx < scopeLevelIdx; ++currentLevelIdx) {
            List<IMember> children = childMember.getChildren();
            if (children.isEmpty()) {
                return null;
            }
            childMember = rule.getRuleAggregate() == AggregateTypeEnum.LAST ? children.get(children.size() - 1) : children.get(0);
        }
        return childMember;
    }

    public List<List<IMember>> getPerHierarchyMemberList() {
        ArrayList<List<IMember>> perHierarchyMemberList = new ArrayList<List<IMember>>();
        for (Selection sel : this.getSelections()) {
            if (!(sel instanceof AggregateSelection)) continue;
            ArrayList<IMember> resolvedFLMembers = new ArrayList<IMember>();
            List<IMember> membersWithRuleInSlicerContext = AggregateCombination.applySlicerToMembersWithRule(((AggregateSelection)sel).getMembersList(), ((AggregateSelection)sel).getRule().getRule());
            for (IMember member : membersWithRuleInSlicerContext) {
                IMember resolvedMember = this.getResolvedMember(((AggregateSelection)sel).getRule(), member);
                if (null == resolvedMember) continue;
                resolvedFLMembers.add(resolvedMember);
            }
            perHierarchyMemberList.add(resolvedFLMembers);
        }
        return perHierarchyMemberList;
    }

    /*
     * WARNING - void declaration
     */
    public static List<IMember> applySlicerToMembersWithRule(List<IMember> membersWithRule, IAggregateRule rule) {
        void var9_12;
        if (membersWithRule == null || membersWithRule.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IMember> membersWithRuleInSlicerContext = new ArrayList<IMember>();
        DMRCube cube = (DMRCube)membersWithRule.get(0).getDimension().getCube();
        List<CogMDXDetailFilter> detailFilters = cube.getDetailFilters();
        IDimension dimension = membersWithRule.get(0).getDimension();
        ArrayList<Object> slicerMembersPerSlicer = new ArrayList<Object>();
        ILevel lowestSlicerMemberLevel = null;
        for (CogMDXDetailFilter cogMDXDetailFilter : detailFilters) {
            V5SetFunction v5SetFunction;
            IDimension slicerDimension;
            if (cogMDXDetailFilter.getPropertyValue("dmrSlicer") != Boolean.TRUE || !dimension.equals(slicerDimension = ((V5BoundMemberUniqueName)(v5SetFunction = (V5SetFunction)cogMDXDetailFilter.getPropertyValue("dmrSlicerSet")).getChild(0)).getLevel().getDimension())) continue;
            ArrayList slicerMembers2 = new ArrayList();
            for (IXQEQueryNode slicerMember : v5SetFunction.getChildren()) {
                String slicerMemberUniqueName = ((V5BoundMemberUniqueName)slicerMember).getExternalMemberUniqueName();
                String[] nameParts = null;
                try {
                    nameParts = UniqueNameParser.parse(slicerMemberUniqueName, -1);
                }
                catch (UniqueNameParserException e) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_ParsingException, (Throwable)e, slicerMemberUniqueName);
                }
                String slicerMemberDimensionName = ((V5BoundMemberUniqueName)slicerMember).getLevel().getDimension().getName();
                String slicerMemberHierarchyName = ((V5BoundMemberUniqueName)slicerMember).getLevel().getHierarchy().getName();
                String slicerMemberLevelName = ((V5BoundMemberUniqueName)slicerMember).getLevel().getName();
                IDimension slicerMemberDimension = cube.getDimension(slicerMemberDimensionName);
                ILevel slicerMemberLevel = slicerMemberDimension.getLevel(slicerMemberLevelName);
                if (lowestSlicerMemberLevel == null || lowestSlicerMemberLevel.getIndex() < slicerMemberLevel.getIndex()) {
                    lowestSlicerMemberLevel = slicerMemberLevel;
                }
                IHierarchy slicerHierarchy = slicerMemberDimension.getHierarchy(slicerMemberHierarchyName);
                IMember runtimeSlicerMember = ((DMRLevel)slicerHierarchy.getLevel(0)).getMember(0);
                for (int i = 3; i < nameParts.length; ++i) {
                    if (runtimeSlicerMember == null) continue;
                    runtimeSlicerMember = runtimeSlicerMember.getChildMember(nameParts[i]);
                }
                if (runtimeSlicerMember == null) continue;
                slicerMembers2.add(runtimeSlicerMember);
            }
            if (slicerMembers2.isEmpty()) continue;
            slicerMembersPerSlicer.add(slicerMembers2);
        }
        if (slicerMembersPerSlicer.isEmpty()) {
            return membersWithRule;
        }
        ArrayList<Set> memberSetPerSlicer = new ArrayList<Set>();
        for (List list : slicerMembersPerSlicer) {
            ArrayList<IMember> lowestLevelSlicerMembers = new ArrayList<IMember>();
            for (IMember slicerMember : list) {
                lowestLevelSlicerMembers.addAll(((IMemberCubics)slicerMember).getDescendants(lowestSlicerMemberLevel));
            }
            ITupleList slicerTupleList = SingleHierarchySimpleTupleList.construct(lowestLevelSlicerMembers.toArray(new IMember[0]));
            memberSetPerSlicer.add(new Set(slicerTupleList));
        }
        Object var9_11 = null;
        for (Set slicerMemberSet : memberSetPerSlicer) {
            if (var9_12 == null) {
                Set set = slicerMemberSet;
                continue;
            }
            try {
                Set set = var9_12.intersect(slicerMemberSet, false);
            }
            catch (InterpreterException e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Failed to intersect two slicer member set.");
            }
        }
        IMember[] iMemberArray = var9_12.getTupleList().getMembers(dimension);
        for (IMember aMemberWithRule : membersWithRule) {
            String memberWithRuleUniqueName = aMemberWithRule.getUniqueName();
            ArrayList<IMember> slicingResult = new ArrayList<IMember>();
            for (IMember slicerMember : iMemberArray) {
                String slicerMemberUniqueName = slicerMember.getUniqueName();
                if (memberWithRuleUniqueName.equals(slicerMemberUniqueName) || memberWithRuleUniqueName.startsWith(slicerMemberUniqueName)) {
                    slicingResult.add(aMemberWithRule);
                    continue;
                }
                if (!slicerMemberUniqueName.startsWith(memberWithRuleUniqueName)) continue;
                slicingResult.add(slicerMember);
            }
            if (slicingResult.isEmpty()) continue;
            if (slicingResult.size() > 1) {
                Comparator<IMember> memberComparator = new Comparator<IMember>(){

                    @Override
                    public int compare(IMember o1, IMember o2) {
                        int o2LevelIndex;
                        int o1LevelIndex = o1.getLevel().getIndex();
                        if (o1LevelIndex != (o2LevelIndex = o2.getLevel().getIndex())) {
                            return o1LevelIndex - o2LevelIndex;
                        }
                        IOrderedMap<IMember> levelMembers = ((Level)o1.getLevel()).getMembersOrderedMap();
                        int o1MemberIndex = levelMembers.indexOf(o1);
                        int o2MemberIndex = levelMembers.indexOf(o2);
                        return o1MemberIndex - o2MemberIndex;
                    }
                };
                Collections.sort(slicingResult, memberComparator);
            }
            if (rule.getAggregate() == AggregateTypeEnum.LAST) {
                membersWithRuleInSlicerContext.add((IMember)slicingResult.get(slicingResult.size() - 1));
                continue;
            }
            membersWithRuleInSlicerContext.add((IMember)slicingResult.get(0));
        }
        return membersWithRuleInSlicerContext;
    }
}

