/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateCombination;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateCombinationRule;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateSelection;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Combination;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.CombinationBuilder;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.CrossJoinedSetDecomposer;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.MeasureSelection;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Selection;
import java.util.ArrayList;
import java.util.List;

public class AggregateCombinationBuilder
extends CombinationBuilder {
    private List<AggregateCombinationRule> rules;

    AggregateCombinationBuilder(CrossJoinedSetDecomposer b, List<AggregateCombinationRule> rulesPerMeasure) {
        super(b);
        this.rules = rulesPerMeasure;
    }

    @Override
    public List<Combination> getCombinationObjects() {
        if (this.combinations != null) {
            return this.combinations;
        }
        this.buildLevelCombinations();
        this.combinations = new ArrayList();
        for (Combination combination : this.getInitialCombinations()) {
            this.combinations.addAll(this.buildCombinations(combination));
        }
        return this.combinations;
    }

    private Combination buildReducedCombination(Combination baseCombination) {
        Combination reducedCombination = new Combination();
        for (Selection selection : baseCombination.getSelections()) {
            if (selection instanceof MeasureSelection) {
                ArrayList<IMember> mems = new ArrayList<IMember>();
                for (IMember m : selection.getMembersList()) {
                    if (this.getBuilder().measureHasAggregateRule(m)) continue;
                    mems.add(m);
                }
                if (mems.isEmpty()) {
                    return null;
                }
                MeasureSelection measure = new MeasureSelection(mems, this.getBuilder().measureToscope, this.getBuilder().isOneMeasurePerSubquery());
                reducedCombination.addSelection(measure);
                continue;
            }
            reducedCombination.addSelection(selection);
        }
        return reducedCombination;
    }

    private Combination buildAggregateCombinations(Combination baseCombination) {
        ArrayList<Selection> resultSelections = new ArrayList<Selection>();
        boolean hasAggregateSelection = false;
        for (Selection sel : baseCombination.getSelections()) {
            if (sel instanceof AggregateSelection) {
                AggregateCombinationRule rule = null;
                IDimension selectionDim = sel.getFirstMember().getDimension();
                for (AggregateCombinationRule aRule : this.rules) {
                    for (IDimension aRefDim : aRule.getDimensions()) {
                        if (!aRefDim.equals(selectionDim)) continue;
                        rule = aRule;
                        break;
                    }
                    if (rule == null) continue;
                    break;
                }
                if (rule == null) {
                    resultSelections.add(new Selection(sel.getMembersList()));
                    continue;
                }
                List<Selection> decomposedSelections = ((AggregateSelection)sel).decomposeSelection(rule);
                if (decomposedSelections.size() == 1 && sel.getFirstMember().getLevel().isLeafLevel()) {
                    resultSelections.addAll(decomposedSelections);
                    continue;
                }
                ((AggregateSelection)sel).setRule(rule);
                resultSelections.add(sel);
                hasAggregateSelection = true;
                continue;
            }
            if (sel instanceof MeasureSelection) {
                List<Selection> measureSelectionsOfTheRule = sel.decomposeSelection(this.rules.get(0));
                ArrayList<IMember> measures = new ArrayList<IMember>();
                for (Selection aMeasureSelection : measureSelectionsOfTheRule) {
                    measures.addAll(aMeasureSelection.getMembersList());
                }
                MeasureSelection resultMeasureSelection = new MeasureSelection(measures, this.getBuilder().measureToscope, false);
                resultSelections.add(resultMeasureSelection);
                continue;
            }
            resultSelections.addAll(sel.decomposeSelection(null));
        }
        Combination resultCombination = null;
        resultCombination = hasAggregateSelection ? new AggregateCombination() : new Combination();
        for (Selection sel : resultSelections) {
            resultCombination.addSelection(sel);
        }
        return resultCombination;
    }

    private List<Combination> buildCombinations(Combination baseCombination) {
        ArrayList<Combination> aggregatedCombinations = new ArrayList<Combination>();
        Combination reducedCombination = this.buildReducedCombination(baseCombination);
        if (reducedCombination != null) {
            ArrayList<Combination> newCombinations = new ArrayList<Combination>();
            newCombinations.add(reducedCombination);
            aggregatedCombinations.addAll(this.recursiveSelection(reducedCombination, 0, newCombinations));
        }
        aggregatedCombinations.add(this.buildAggregateCombinations(baseCombination));
        return aggregatedCombinations;
    }
}

