/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination;

import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.MeasureSelection;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Selection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Combination {
    private List<Selection> selections;
    private Map<IDimension, ILevel> dimensionToLevelMap;
    private MDXLevelInfo lowestAggregationLevelInfo;

    Combination() {
        this.selections = new ArrayList<Selection>();
    }

    Combination(List<Selection> sels) {
        this.selections = sels;
    }

    public Combination copy() {
        Combination copy = new Combination();
        for (Selection sel : this.selections) {
            copy.addSelection(sel);
        }
        return copy;
    }

    public void addSelection(Selection selection) {
        this.selections.add(selection);
    }

    public List<Object> getSelectionList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Selection sel : this.selections) {
            list.add(sel.getMembers());
        }
        return list;
    }

    public List<Object> getSelectionListWithSummary() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Selection sel : this.selections) {
            list.add(sel.getMembersWithSummary());
        }
        return list;
    }

    public List<Selection> getSelections() {
        return this.selections;
    }

    public String toString() {
        return this.selections.toString();
    }

    List<Combination> decomposeCombination(Selection s) {
        int i;
        List<Selection> selFromSplit = s.decomposeSelection();
        int combCount = selFromSplit.size();
        ArrayList<Combination> toReturn = new ArrayList<Combination>(combCount);
        if (combCount == 1) {
            toReturn.add(this);
            return toReturn;
        }
        for (i = 0; i < combCount; ++i) {
            toReturn.add(this.copy());
        }
        for (i = 0; i < selFromSplit.size(); ++i) {
            Combination combination = (Combination)toReturn.get(i);
            combination.replaceSelection(s, selFromSplit.get(i));
        }
        return toReturn;
    }

    private void replaceSelection(Selection s, Selection replacement) {
        int index = this.selections.indexOf(s);
        this.selections.remove(index);
        this.selections.add(index, replacement);
    }

    public List<IMember> getMeasures() {
        for (Selection sel : this.getSelections()) {
            if (!(sel instanceof MeasureSelection)) continue;
            return sel.getMembersList();
        }
        return new ArrayList<IMember>();
    }

    public boolean hasMeasures() {
        for (Selection sel : this.getSelections()) {
            if (!(sel instanceof MeasureSelection)) continue;
            return true;
        }
        return false;
    }

    public MeasureSelection getMeasureSelection() {
        for (Selection sel : this.getSelections()) {
            if (!(sel instanceof MeasureSelection)) continue;
            return (MeasureSelection)sel;
        }
        return null;
    }

    public Map<IDimension, ILevel> getDimensionToLevelMap() {
        if (this.dimensionToLevelMap != null) {
            return this.dimensionToLevelMap;
        }
        this.dimensionToLevelMap = new HashMap<IDimension, ILevel>();
        for (Selection sel : this.getSelections()) {
            IMember mem = sel.getFirstMember();
            IDimension dim = sel.getDimension();
            if (dim.isMeasuresDimension()) continue;
            ILevel level = mem.getLevel();
            this.dimensionToLevelMap.put(dim, level);
        }
        return this.dimensionToLevelMap;
    }

    public MDXLevelInfo getLowestAggregationLevelInfo() {
        return this.lowestAggregationLevelInfo;
    }

    public void setLowestAggregationLevelInfo(MDXLevelInfo levelInfo) {
        this.lowestAggregationLevelInfo = levelInfo;
    }

    public IMember[][] getSelectionAsArray(IHierarchy[] cubeHiers) {
        IMember[][] selectionsOfTheCombination = new IMember[cubeHiers.length][];
        int i = 0;
        for (Selection aSelection : this.getSelections()) {
            List<IMember> aSelectionMemberSet = aSelection.getMembersList();
            selectionsOfTheCombination[i] = aSelectionMemberSet.toArray(new IMember[aSelectionMemberSet.size()]);
            ++i;
        }
        return selectionsOfTheCombination;
    }
}

