/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.AggregateSelection;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Combination;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.CrossJoinedSetDecomposer;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.MeasureSelection;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.combination.Selection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CombinationBuilder {
    private List<Combination> initialCombinations = new ArrayList<Combination>();
    protected List<Combination> combinations;
    private CrossJoinedSetDecomposer builder;

    public CombinationBuilder(CrossJoinedSetDecomposer bBuilder) {
        this.builder = bBuilder;
    }

    public List<Combination> getCombinationObjects() {
        if (this.combinations != null) {
            return this.combinations;
        }
        this.buildLevelCombinations();
        this.combinations = new ArrayList<Combination>();
        for (Combination combination : this.initialCombinations) {
            ArrayList<Combination> newCombinations = new ArrayList<Combination>();
            newCombinations.add(combination);
            this.combinations.addAll(this.recursiveSelection(combination, 0, newCombinations));
        }
        return this.combinations;
    }

    protected void buildLevelCombinations() {
        int[] groupIndexes = new int[this.builder.getDimCount()];
        int[] groupCount = new int[this.builder.getDimCount()];
        Object[][] dimIndexToKeyArray = new Object[this.builder.getDimCount()][];
        for (int i = 0; i < this.builder.getDimCount(); ++i) {
            groupIndexes[i] = 0;
            groupCount[i] = this.builder.getDimensionIndexToMemberGroups()[i].size();
            Set<String> keys = this.builder.getDimensionIndexToMemberGroups()[i].keySet();
            ArrayList<String> list = new ArrayList<String>(keys);
            Collections.sort(list);
            Collections.reverse(list);
            dimIndexToKeyArray[i] = list.toArray();
        }
        boolean notDone = true;
        while (notDone) {
            int dimIdx;
            Combination comb = new Combination();
            for (dimIdx = 0; dimIdx < this.builder.getDimCount(); ++dimIdx) {
                Map<String, List<IMember>> dimIndexToMemberGroup = this.builder.getDimensionIndexToMemberGroups()[dimIdx];
                if (dimIndexToMemberGroup.isEmpty()) continue;
                List<IMember> dimSels = dimIndexToMemberGroup.get(dimIndexToKeyArray[dimIdx][groupIndexes[dimIdx]]);
                comb.addSelection(this.getSelection(dimSels));
            }
            for (dimIdx = this.builder.getDimCount() - 1; dimIdx >= 0; --dimIdx) {
                int n = dimIdx;
                groupIndexes[n] = groupIndexes[n] + 1;
                if (groupIndexes[dimIdx] != groupCount[dimIdx]) break;
                if (dimIdx == 0) {
                    notDone = false;
                }
                groupIndexes[dimIdx] = 0;
            }
            this.initialCombinations.add(comb);
        }
    }

    private Selection getSelection(List<IMember> members) {
        IDimension dimension = members.get(0).getLevel().getDimension();
        if (dimension.isMeasuresDimension()) {
            return new MeasureSelection(members, this.builder.measureToscope, this.builder.isOneMeasurePerSubquery());
        }
        if (this.builder.getFirstLastAggregatesDimensions().contains(dimension)) {
            return new AggregateSelection(members, dimension);
        }
        return new Selection(members);
    }

    protected CrossJoinedSetDecomposer getBuilder() {
        return this.builder;
    }

    protected List<Combination> getInitialCombinations() {
        return this.initialCombinations;
    }

    protected List<Combination> recursiveSelection(Combination baseCombination, int index, List<Combination> allCombinations) {
        ArrayList<Combination> newCombinations = new ArrayList<Combination>();
        List<Selection> originalSelection = baseCombination.getSelections();
        Selection currentSelection = originalSelection.get(index);
        for (Combination currentComb : allCombinations) {
            newCombinations.addAll(currentComb.decomposeCombination(currentSelection));
        }
        int i = ++index;
        if (originalSelection.size() == i) {
            return newCombinations;
        }
        ArrayList<Combination> results = new ArrayList<Combination>(this.recursiveSelection(baseCombination, i, newCombinations));
        return results;
    }
}

